@extends('layouts.app')

@section('title')
All Assets
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li>
            <a href="{{route('home')}}">
            <i class="fa fa-dashboard"></i> 
            Home
        </a>
        </li>

        <li class="active">
             Assets
        </li>
    </ol>
@stop
@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
 <style type="text/css">
     .reassign_form
     {
        display: none;
     }
 </style>
@stop
@section('content')
  <div class="container-fluid">
  <div class="row">
                    
    <div class="col-sm-12">
    <div class="white-box">

    <h3 style="text-align: right;" class="box-title m-b-0">
        <span style="float: left;">Assets List</span>
        @permission('fixed-assets')
        <a class="btn btn-info btn-sm" href="{{ route('item.fixed.assets.add') }}">Add New Asset</a>
        @endpermission
      
    </h3>

    <div class="table-responsive">

    @if(Session::has('success'))   
        <div id="successMessage" class="alert alert-success" role="alert">
            {{ Session::get('success') }}
        </div>
    @endif

    <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
    <thead>
    <tr role="row">

    <th class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 20px;">Asset Tag</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Name </th>

     <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Brand</th>

      <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Status</th>

       <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Asset Type</th>

        <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Depreciation Policy</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Depreciation Rate</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Action</th>

    </tr>
    </thead>
    <tbody>



    @foreach( $fixed_asset_types as $list )
   
    <tr class="active">
  
    
    <td ><a data-toggle="tooltip" data-placement="top"  title="View" style="margin-left: 1rem;"  href="{{ route('item.fixed.assets.view' , [$list->id]) }}" >{{$list->asset_tag }} </a></td>
    <td >{{ $list->name  }} </td>
    <td >{{$list->item?$list->item->manufacture->name:''}}</td>
    <td >{{ str_replace('_' , ' ' , Ucfirst($list->status) ) }} </td>
    <td >{{$list->asset_type->name}}</td>
    <td >{{str_replace('_' , ' ' , Ucfirst($list->asset_type->depreciation_policy))}}</td>
    <td >{{$list->asset_type->depreciation_rate}}%</td>
  
    <td style="text-align:center;"> 

@if($list->physical_status == 'in_use')

    <a data-toggle="tooltip" data-placement="top"  title="View" style="margin-left: 1rem; color: #e8b600"  href="{{ route('item.fixed.assets.view' , [$list->id]) }}" >
    <i class="fa fa-eye" aria-hidden="true"></i>
    </a>


    @php
    $is_exist = \App\AssetRelease::where('asset_id' , $list->id)->count();
    if($is_exist > 0 && $list->status != 'in_storage')
    {
    @endphp
        <a data-toggle="tooltip" data-placement="top"  title="Re Assign To" style="margin-left: 1rem; color: #e8b600"  href="#" onclick="return showReAssignModal(this , '{{$list->id}}')">
            <i class="fa fa-refresh" aria-hidden="true"></i>
        </a>
    @php
    }
    else
    {
    @endphp
        <a data-toggle="tooltip" data-placement="top"  title="Assign To" style="margin-left: 1rem; color: #e8b600"  href="#" onclick="return showAssignModal(this , '{{$list->id}}')">
            <i class="fa fa-user-plus" aria-hidden="true"></i>
        </a>
    @php
    }
    @endphp

    <a data-toggle="tooltip" data-placement="top" title="Edit"   style="margin-left: 1rem;"  href="{{ route('fixed.assets.edit' , [$list->id]) }}"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>

    <a  style="margin-left: 1rem;"  href="{{ route('item.fixed.assets.delete' , [$list->id]) }}" data-toggle="confirmation" data-title="Are you sure to delete?" >
        <i style="color: red;" class="fa fa-trash" aria-hidden="true"></i>
    </a>
   
@else

<span style="font-size: 1.5rem;
    background: #f96700;
    color: white;
    padding: 1px 15px 2px 15px;
    border-radius: 15px;">Sold</span>

@endif
    </td>
    </tr>
    @endforeach   


    </tbody>
    </table>

    </div>
    </div>
    </div>
    </div>


    </div>

    </div>
    </div>

    <!----------------assignOrReassignModal----------------->


    <div class="modal fade" id="assignOrReassignModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
    <div class="modal-content" id="modl" >
    
   
  
    
    </div>
    </div>
    </div>
@stop



@section('js')  

<script type="text/javascript">
   
let type = false;

let in_storage = true;

function changeStatus(self) 
{

if ($(self).val() == 're_assign') 
{
   in_storage = false;
   $('.reassign_form').show()
}

if ($(self).val() == 'in_storage') 
{
     in_storage = true;
     $('.reassign_form').hide()
}

}

function showReAssignModal(self , id) {
   
  in_storage = true;

  $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });

        $.ajax({
        url:"{{ route('get_assign_employee') }}",
        method:'POST',
        dataType:'json',
        data:{id :id},
        success:function(data)
        {
            if (data.response == 'yes')
             {
                $table_data_rows = '<div class="modal-header"  ><button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button><h4 class="modal-title" id="myModalLabel">Re Assign Asset</h4></div> <div class="modal-body" ><div class="row" > <div class="col-md-6" style="margin-bottom:1rem;">Re-assign : <input type="radio" name="new_status" value="re_assign" onchange="return changeStatus(this)" ></div> <div class="col-md-6" style="margin-bottom:1rem;">In Storage : <input type="radio" checked name="new_status" value="in_storage" onchange="return changeStatus(this)"></div> </div>';

                $table_data_rows += '<form method="POST"  onsubmit="return re_assign('+id+')"><label class="reassign_form">From</label><input  type="text" class="form-control reassign_form" value="'+data.name+'" readonly><input type="hidden"  value="'+data.employee_id+'" id="employ_id_to_assign"><label class="reassign_form" style="margin-top: 2rem;">To</label><select class="form-control chosen-select reassign_form" id="employee_id">';
                $.each(data.output, function(k, v)
                {

                $table_data_rows += '<option value="'+v.id+'">'+v.name +'</option> ';

                });

                $table_data_rows += '</select><div class="modal-footer"><button type="button" class="btn btn-default" data-dismiss="modal">Close</button><button type="submit" class="btn btn-primary" id="assign_btn">Save</button></form></div>';

                $('#modl').html($table_data_rows)
             }
        }
        })

    $('#assignOrReassignModal').modal('show')
}


function re_assign(id) 
{

    $('#assign_btn').html('Processing....')
    $('#assign_btn').prop('disabled' , true)

    var employ_id_to_assign = $('#employ_id_to_assign').val();
    var employee_id = $('#employee_id').val();

  $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });

        $.ajax({
        url:"{{ route('update_re_asset_with_employee') }}",
        method:'POST',
        data:{employ_id_to_assign:employ_id_to_assign , asset_id:id , employee_id:employee_id , in_storage:in_storage},
        success:function(data)
        {
            if (data == 'ok') 
            {
               alert('SuccessFully Assigned!');
               location.reload(true)
            }
        }

        })
    return false;
}


function showAssignModal(self , id) 
{


    in_storage = true;

     $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });

        $.ajax({
        url:"{{ route('get_employees') }}",
        method:'POST',
        dataType:'json',
        success:function(data)
        {
            if (data.response == 'yes')
             {
                $table_data_rows = '<div class="modal-header"  ><button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button><h4 class="modal-title" id="myModalLabel">Assign Asset</h4></div> <div class="modal-body" >';

                $table_data_rows += '<form method="POST" onsubmit="return assign('+id+')"><select class="form-control chosen-select" id="employee_id">';
                $.each(data.output, function(k, v)
                 {

                  $table_data_rows += '<option value="'+v.id+'">'+v.name +'</option> ';

                });

                 $table_data_rows += '</select><div class="modal-footer"><button type="button" class="btn btn-default" data-dismiss="modal">Close</button><button type="submit" class="btn btn-primary" id="assign_btn">Save</button></form></div>';

                 $('#modl').html($table_data_rows)
             }
        }
        })


    $('#assignOrReassignModal').modal('show')
}

function assign(id) 
{

    $('#assign_btn').html('Processing....')
    $('#assign_btn').prop('disabled' , true)

    var employee_id = $('#employee_id').val();

  $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });

        $.ajax({
        url:"{{ route('update_asset_with_employee') }}",
        method:'POST',
        data:{employee_id:employee_id , asset_id:id },
        success:function(data)
        {
            if (data == 'ok') 
            {
               alert('SuccessFully Assigned!');
               location.reload(true)
            }
        }

        })
    return false;
}


    $('input:radio[name="type"]').change(
    function(){
        var name = '{{ucfirst(Auth::user()->name)}}';

        if ($(this).is(':checked') && $(this).val() == 'release') 
        {
            $('#column_type').html('Release Qty')
            $('#release_by').html('Released By')
            $('#release_date').html('Releasing Date')
            $('#Modal_Title').html('Release Item(s)')
            $('#releaser_name').val(name)
            $('#releaser_name').prop('readonly', true);
            $('#receiver_name').prop('readonly', false);
            $('#receiver_name').val('')
            type = false;
        }

         if ($(this).is(':checked') && $(this).val() == 'return')
          {
            $('#column_type').html('Return Qty')
            $('#release_by').html('Return By')
            $('#release_date').html('Return Date')
            $('#Modal_Title').html('Return Item(s)')
            $('#receiver_name').val(name)
            $('#releaser_name').prop('readonly', false);
            $('#receiver_name').prop('readonly', true);
            $('#releaser_name').val('')
            type = true;
          }

    });


    function showSelectOption(self) {
       
      if($(self).val() == 'with_pr') 
      {
        $('#check_type').val('with_pr');
        $('#data').html("");
        $('#release_with_pr').show('slow')
        $('#thisBtn').show('slow');
        $('#select_pr').show('slow')
        $('#select_project').hide('slow')
        $('#c_r_quantity_th').show('slow')
        $('#demand_quantity_th').show('slow')
        $('#without_pr_department').hide('slow')
        $('#with_pr_department').show('slow')
        $('#item_release_modal').find('.with_pr_table').show('slow');
      }
       else if($(self).val() == 'without_pr') 
       {
         $('#check_type').val('without_pr');
        $('#data').html("");
        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        $.ajax({
        url:"{{ route('item.get-item-for-releasing') }}",
        method:'GET',
        dataType:'json',
        success:function(data)
        {
            if (data.response == 'yes') 
            {
            
            $table_data_rows = '';
            $.each(data.output, function(k, v) {

            $table_data_rows += '<tr> <td>'+v.category.category_name +'</td>  <td>'+v.item_code +'</td> <td>'+v.item_name+' - '+v.manufacture.name+' </td>  <td>'+v.quantity+'</td> <td id="item_'+v.id+'" class="release_quantity"><input class="item_id" value = "'+v.id+'" type="hidden" /> <input type="number" style="width: 100%;background: transparent;border: none;" value="release_qty[]" class="release_qty" /></td></tr>';
            });

             $('#data').html($table_data_rows);
            }
            else if(data.response == 'empty')
            {
                $('#data').html('<tr><td>No Item Found For Release</td></tr>');
            }
            else
            {
                alert("Something went wrong!")
                location.reload(true)
            }

            $('#c_r_quantity_th').hide('slow')
            $('#demand_quantity_th').hide('slow')
            $('#release_with_pr').show('slow')
            $('#thisBtn').show('slow');
            $('#select_pr').hide('slow')
            $('#select_project').show('slow')
            $('#without_pr_department').show('slow')
            $('#with_pr_department').hide('slow')
            $('#item_release_modal').find('.with_pr_table').show('slow');
        }
        })

       }
       else
       {
         $('#check_type').html("");
         $('#data').html("");
         $('#release_with_pr').hide('slow')
         $('#thisBtn').hide('slow');
         $('#item_release_modal').find('.with_pr_table').hide('slow');
       }
       
        return false;
    }


       function getDepartment(self) {
      
        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        $.ajax({
        url:"{{ route('purchase-requests.get-department') }}",
        method:'POST',
        dataType:'json',
        data: {pr_id:$(self).val()},
        success:function(data)
        {
            $table_data_rows = '';
            $.each(data.items, function(k, v) 
            {

              $table_data_rows += '<tr> <td>'+v.category +'</td>  <td>'+v.item_code +'</td> <td>'+v.item_name+'  - '+v.brand+'</td>  <td>'+v.quantity+'</td> <td>'+v.demand_quantity+'</td>  <td>'+v.current_releasing+'</td>    <td id="item_'+v.id+'" class="release_quantity" > <input class="item_id" value = "'+v.id+'" type="hidden" /><input type="number" style="width: 100%;background: transparent;border: none;" value="release_qty[]" class="release_qty" /></td></tr>';
            });

            $('#data').html($table_data_rows);

            $('#department_name').val(data.department_name)
            $('#department_id').val(data.department_id)
        }
        })
        return false;
    }


    function confirmReleasing(self) {
     var items = [];
     var releaser_name = $('#releaser_name').val();
     var date = $('#date').val();
     var receiver_name = $('#receiver_name').val();

    if ($('#check_type').val() == 'with_pr')
    {
         var department = $('#department_id').val();
         var purchase_requests_id = $('#purchase_requests_id option:selected').val();
    }

    if ($('#check_type').val() == 'without_pr')
    {
            var department = $('#department_select_id').val();
            var purchase_requests_id = '0';
    }

     $(self).html('Processing...')
     $(self).prop('disabled' , true);

    $('.release_quantity').each(function()
    {

    items.push({'item_id':$(this).find(".item_id").val() ,'releasing_quantity': $('#item_'+$(this).find(".item_id").val() ).find('.release_qty').val() });
    });


      $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
        });

        $.ajax({
        url:"{{ route('item.releasing') }}",
        method:'POST',
        dataType:'json',
        data: {items:items , releaser_name:releaser_name ,receiver_name:receiver_name , date:date , purchase_requests_id:purchase_requests_id , department : department , type:type},
        success:function(data)
        {
         if(data.response)
         {
            $('#errorMessage2').html(data.message);
            $('#errorMessage2').show();
            $(self).html('Confirm')
            $(self).prop('disabled' , false);
            setTimeout(function(){  $('#errorMessage2').hide();}, 5000);
         }

          if(data.result)
         {
            $('#succeessMessage2').html(data.message);
            $('#succeessMessage2').show();
            setTimeout(function(){ location.reload(true) }, 5000);
         }

        }
        })



        return false;
    }


    function addItems() 
    {
      var checkedNum = $('input[name="items[]"]:checked').length;

        if (!checkedNum) 
        {
          $('#item_release_btn').hide();
        }
        else
        {
          $('#item_release_btn').show();
        }
    }
 
</script>

@stop