@extends('layouts.app')

@section('title')
Asset Detail 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
       
        <li class="active">Asset Detail</li>
      </ol>
@stop
@section('content')
            <div class="container-fluid">

                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">Asset Information</h3>
                            <hr>
                                    <div class="table-responsive">
                                        <table class="table ">
                                            <tbody>
                                               
                                                
                                                <tr>
                                                    <td><b>Asset tag</b></td>
                                                    <td>
                                                        {{$fixed_asset->asset_tag}}
                                                        @php
                                                        $generator = new Picqer\Barcode\BarcodeGeneratorHTML();
                                                        @endphp

                                                        {!! $generator->getBarcode($fixed_asset->asset_tag, $generator::TYPE_CODE_128) !!}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td><b>Name</b></td>
                                                    <td>{{$fixed_asset->name}}</td>
                                                </tr>
                                             
                                              <tr>
                                                    <td><b>Brand</b></td>
                                                    <td>{{$fixed_asset->item->manufacture->name}}</td>
                                                </tr>
                                                <tr>
                                                    <td><b>Status</b></td>
                                                    <td>{{ str_replace('_' , ' ' , $fixed_asset->status ) }}</td>
                                                </tr>

                                                 <tr>
                                                    <td><b>Cost</b></td>
                                                    <td>{{ number_format($fixed_asset->cost , 2 ) }}</td>
                                                </tr>



                                                  <tr>
                                                    <td><b>Asset Type</b></td>
                                                    <td>{{$fixed_asset->asset_type->name}}</td>
                                                </tr>
                                                <tr>
                                                    <td><b>Depreciation Policy</b></td>
                                                    <td>{{str_replace('_' , ' ' , $fixed_asset->asset_type->depreciation_policy)}}</td>
                                                </tr>
                                             
                                                <tr>
                                                    <td><b>Depreciation Rate</b></td>
                                                    <td>{{$fixed_asset->asset_type->depreciation_rate}}%</td>
                                                </tr>

                        
                                            </tbody>
                                        </table>
                                    </div>

                        </div>



                         <div class="white-box">
                            <h3 class="box-title">Assigning History</h3>
                            <hr>
                                    <div class="table-responsive">
                                       
                <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                <thead>
                <tr role="row">


                <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Name </th>

                <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Assign Date</th>

                <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Till</th>

                </tr>
                </thead>
                <tbody>



                @foreach( $assignees as $list )

                <tr class="active">


                <td >{{ \App\HrmEmployee::find($list->employee_id)->name }}</td>
                <td >{{ date('d-F-Y' , strtotime($list->assign_date)) }}</td>
                <td >{{ $list->till_date ? date('d-F-Y' , strtotime( $list->till_date)) : 'Curent Assigned'  }}</td>

                </tr>
                @endforeach   


                </tbody>
                </table>

                         </div>

                    </div>


                </div>
            </div>

                <!-- /.row -->
      </div>
            <!-- /.container-fluid -->

@stop