@extends('layouts.app')

@section('title')
All Inventory
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li>
            <a href="{{route('home')}}">
                <i class="fa fa-dashboard"></i> 
            Home
        </a>
        </li>

        <li class="active">
             Inventory
        </li>
    </ol>
@stop
@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
@stop
@section('content')
  <div class="container-fluid">
  <div class="row">
                    
    <div class="col-sm-12">
    <div class="white-box">

    <h3 style="text-align: right;" class="box-title m-b-0">
        <span style="float: left;">Inventory List</span>

  
        <a class="btn btn-info btn-sm" href="{{ route('purchase-requests.add.cash') }}"> Cash Pr</a>
       

        @permission('create-item')
        <a class="btn btn-info btn-sm" href="{{ route('item.add') }}">Add Inventory</a>
        @endpermission

        @permission(['releasing-item' , 'return-item','store-keeper' , 'manage-procurement-dashboard'])
        <div style="display: inline;">
            <button class="btn btn-success btn-sm" data-toggle="modal" data-target="#item_release_modal" id="item_release_btn" type="button" >
                 Release / Return Inventory
            </button>
        </div>
        @endpermission

    </h3>

    <div class="table-responsive">

    @if(Session::has('success'))   
        <div id="successMessage" class="alert alert-success" role="alert">
            {{ Session::get('success') }}
        </div>
    @endif

    <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
    <thead>
    <tr role="row">

    <th class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 20px;">Code</th>

    <th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Category </th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 250px;">Name  - Brand</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Type</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 50px;">Unit</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Min - Max</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Current Qty</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Action</th>

    </tr>
    </thead>
    <tbody>

    @if( $itemList->count() > 0 )

    @foreach( $itemList as $list )
   
    @if($list->quantity  < $list->minqty  && $list->quantity > 0)
    <tr class="warning closest-tr" >
    @elseif($list->quantity == 0)
    <tr class="danger" >
  
    @else
    <tr class="active closest-tr">
      
    @endif
    
    <td class="item_code">{{$list->item_code }}</td>
    <td class="item_category">
    {{ $list->category->category_name  }}
    </td>
    <td class="item_name">
    {{$list->item_name}} - {{!empty($list->manufacture)?$list->manufacture->name:''}}
    <?= ($list->risk_type == 'critical') ? '<span class="critical">Critical</span>' : '<span class="non_critical">Non Critical</span>' ?>
    </td>
    <td>
        @if($list->type == 'consumable')
        {{'Consumable'}}
        @elseif($list->type == 'tools') 
        {{'Tool'}}
        @else if($list->type == 'direct_material') 
        {{'Direct Material'}}
        @endif
    </td>

    <td>{{ $list->unit }}</td>
    <td>{{ $list->minqty.' - '.$list->maxqty }}</td>
    <td class="item_qty">{{number_format($list->quantity , 2)}}</td>
    <td>

   @permission('view-item')
   <a  href="{{ route('item.view',[$list->id])}}" data-toggle="tooltip" data-placement="top" title="View" >
    <button class="btn btn-link btn-xs" style=" color: #e8b600">
        <i class="fa fa-eye" aria-hidden="true"></i>
    </button>
    </a>
    {{-- <a data-toggle="tooltip" data-placement="top" title="View" style="margin-left: 1rem; color: #e8b600"  href="{{ route('item.view' , [$list->id]) }}"><i class="fa fa-eye" aria-hidden="true"></i></a> --}}

    @endpermission

    @permission('edit-item')

    <a  href="{{ route('item.edit' , [$list->id])}}" data-toggle="tooltip" data-placement="top" title="Edit">
        <button class="btn btn-link btn-xs">
            <i class="fa fa-pencil-square-o" aria-hidden="true"></i>
        </button>
        </a>
    {{-- <a data-toggle="tooltip" data-placement="top" title="Edit"   style="margin-left: 1rem;"  href="{{ route('item.edit' , [$list->id]) }}"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a> --}}
    @endpermission

    @permission('delete-item')

    <form action="{{route('item.delete', [$list->id] )  }}" method="post" style='display: inline;'>
        @method('DELETE')
        @csrf                                       
        <button  class="btn btn-link btn-s" style="color:red;"  type="submit" name="action" value="delete" data-toggle="confirmation" data-title="Are you sure to delete?">
            <i class="fa fa-trash-o" aria-hidden="true"></i>
        </button>                                                  
     </form>

     {{-- <a style="color:red;margin-left: 1rem;" href="{{ route('item.delete', [$list->id] ) }}" data-toggle="confirmation" data-title="Are you sure to delete?" ><i class="fa fa-trash-o" aria-hidden="true"></i></a> --}}
     @endpermission

    </td>
    </tr>
    @endforeach   
    @endif

    </tbody>
    </table>

    </div>
    </div>
    </div>
    </div>


    </div>

    </div>
    </div>

                        <!----------------Releaseing----------------->


                            <div class="modal fade" id="item_release_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel1">
                            <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                            <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title" id="Modal_Title">
                            Release Inventory
                            </h4></div>
                            <div class="modal-body">

                            <div class="row">
                                <div class="col-md-6">
                                <select class="form-control" onchange="return showSelectOption(this)" id="showSelectOption">
                                 <option value="nothing">Select releasing option</option>
                                 <option value="with_pr">With MIR</option>
                                 <option value="without_pr">Without MIR</option>
                                </select>
                            </div>

                            <div class="col-md-6">
                              <div class="row" style="margin-top: 1rem;">
                                  <div class="col-md-6">
                                      Release : <input type="radio" value="release" checked name="type">
                                  </div>

                                  <div class="col-md-6">
                                      Return : <input type="radio" value="return" name="type">
                                  </div>
                              </div>
                            </div>

                            </div>
                            
                            <div class="row" id="release_with_pr" style="display: none; margin-top: 3rem;">
                            <div class="col-md-3">
                            <label><span id="release_by">Released By</span> <b style="color:red;">*</b></label>
                            <input type="text" id="releaser_name" value="{{ucfirst(Auth::user()->name)}}" readonly placeholder="Please Enter Name..." class="form-control" name="">

                            </div>

                            <div class="col-md-3">
                            <label>Received By <b style="color:red;">*</b></label>
                            <input type="text"   id="receiver_name" placeholder="Please Enter Name..." class="form-control" name="">

                            </div>


                            <div class="" id="us_releasing_date">
                                <label>
                                    <span id="release_date">
                                        Releasing Date 
                                    </span>
                                    <b style="color:red;margin-right: 1rem;">*</b>
                                </label>
                                <span id="invalid_date_errorMessage" style="display:none; color: red;margin-left: 1rem;"></span>
                                <input type="date" id="date" min="{{date('Y-m-d')}}" class="form-control">
                            </div>

                            <div class="col-md-6" id="select_pr" style="margin-top: 1rem;">
                            <label >Select MIR <b style="color:red;margin-right: 1rem;">*</b></label>

                            <div id="mirs_list">
                                
                            <select class="form-control chosen-select"  name="purchase_requests_id" onchange="return getDepartment(this);"  id="purchase_requests_id">
                            <option value="">Select Mir</option> 
                            @if($mirs->count() > 0  )
                            @foreach($mirs as $list)

                            @if($approvalCount[$list->id] == 0 && $cancelCount[$list->id] == 0)
                            <option value="{{ $list->id }}">MIR- {{ $list->id  }}</option>
                            @endif

                            @endforeach
                            @endif
                            </select>

                             </div>

                            </div>




                            <div class="col-md-6" id="with_pr_department" style="margin-top: 1rem;">
                            <label >Department <b style="color:red;margin-right: 1rem;">*</b></label>
                             <input type="hidden" readonly="readonly" id="department_id" name="">
                            <input type="text" class="form-control" id="department_name" readonly="readonly"  value="">
                            </div>
                           

                            <div class="col-md-3" id="without_pr_department" style="display: none;">
                            <label >Departments <b style="color:red;margin-right: 1rem;">*</b></label>

                            <select class="form-control chosen-select"  name="department_select_id" id="department_select_id">
                            
                            @if($departments->count() > 0  )
                            @foreach($departments as $department)
                            <option value="{{ $department->id }}">{{ $department->department_name  }}</option>                             
                            @endforeach
                            @endif
                            </select>
                            </div>


                            </div>

                            <input type="hidden" id="check_type" name="">



                            <table id="myTable" style="display: none;" class="table table-striped dataTable no-footer with_pr_table" role="grid" aria-describedby="myTable_info">
                            <thead>
                            <tr role="row">

                           <th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 50px;">Category</th>

                            <th class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 50px;">Code</th>


                            <th class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 150px;">Name</th>



                            <th class="sorting" tabindex="0" id="demand_quantity_th" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Request Qty</th>


                            <th class="sorting" tabindex="0" id="total_receive_th" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Total Receive</th>


                            <th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">InStock Qty</th>


                            <th class="sorting" tabindex="0" id="c_r_quantity_th" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Current Release</th>


                            <th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 203px; text-align: center;" id="column_type">Demand Qty</th>
                            </tr>

                            </thead>
                            <tbody id="data"> </tbody>
                            </table>

                            </div>
                            <div class="modal-footer">

                                <div class="alert alert-success" role="alert" style="display:none;text-align: left;"  id="succeessMessage2">
                           
                            </div>

                            <div class="alert alert-danger" role="alert" style="display:none;text-align: left;"  id="errorMessage2"></div>


                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" style="display: none;" onclick="return confirmReleasing(this)" class="btn btn-primary"  id="thisBtn" >Confirm</button>
                            </form>
                            </div>
                            </div>
                            </div>
@stop



@section('js')  

<script type="text/javascript">
    let type = false;

    $('input:radio[name="type"]').change(
    function(){
        var name = '{{ucfirst(Auth::user()->name)}}';

        if ($('#showSelectOption').val() == 'with_pr') 
        {
           $('#data').html(''); 
        }
        

        if ($(this).is(':checked') && $(this).val() == 'release') 
        {


        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        $.ajax({
        url:"{{ route('purchase-requests.return.or.reles.mir') }}",
        method:'POST',
        dataType:'json',
        data:{type: 'release'},
        success:function(data)
        {

            if ($('#showSelectOption').val() == 'with_pr') 
        {
            
            $option_data_rows = '';

            $option_data_rows +='<select class="form-control chosen-select"  name="purchase_requests_id" onchange="return getDepartment(this);"  id="purchase_requests_id"><option value="">Select Mir</option>';
            $.each(data.output, function(k, v) 
            {
             $option_data_rows += '<option value="'+v.id+'">MIR-'+v.id+'</option>';
            });

             $option_data_rows += '</select>';

             $('#mirs_list').html($option_data_rows);

         }

            
            $('#column_type').html('Release Qty')
            $('#release_by').html('Released By')
            $('#release_date').html('Releasing Date')
            $('#Modal_Title').html('Release Inventory')
            $('#releaser_name').val(name)
            $('#releaser_name').prop('readonly', true);
            $('#receiver_name').prop('readonly', false);
            $('#receiver_name').val('')
            type = false;

        }
        })

        }

         if ($(this).is(':checked') && $(this).val() == 'return')
          {
            

        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        $.ajax({
        url:"{{ route('purchase-requests.return.or.reles.mir') }}",
        method:'POST',
        dataType:'json',
        data:{type: 'return'},
        success:function(data)
        {

            if ($('#showSelectOption').val() == 'with_pr') 
            {

                $option_data_rows = '';

                $option_data_rows +='<select class="form-control chosen-select"  name="purchase_requests_id" onchange="return getDepartment(this);"  id="purchase_requests_id"><option value="">Select Mir</option>';
                $.each(data.output, function(k, v) 
                {
                 $option_data_rows += '<option value="'+v.id+'">MIR-'+v.id+'</option>';
                });

                 $option_data_rows +='</select>';

                 $('#mirs_list').html($option_data_rows);

             }
           
            
            $('#column_type').html('Return Qty')
            $('#release_by').html('Return By')
            $('#release_date').html('Return Date')
            $('#Modal_Title').html('Return Inventory(s)')
            $('#receiver_name').val(name)
            $('#releaser_name').prop('readonly', false);
            $('#receiver_name').prop('readonly', true);
            $('#releaser_name').val('')
            type = true;

        }
        })

          }

    });



    function showSelectOption(self) {
       
      if($(self).val() == 'with_pr') 
      {
        $('#check_type').val('with_pr');
        $('#data').html("");
        $('#release_with_pr').show('slow')
        $('#thisBtn').show('slow');
        $('#select_pr').show('slow')
        $('#select_project').hide('slow')
        $('#c_r_quantity_th').show('slow')
        $('#demand_quantity_th').show('slow')
        $('#total_receive_th').show('slow')
        $('#without_pr_department').hide('slow')
        $('#with_pr_department').show('slow')
        $('#item_release_modal').find('.with_pr_table').show('slow');
        $('#us_releasing_date').addClass('col-md-6')
        $('#us_releasing_date').removeClass('col-md-3')
      }
       else if($(self).val() == 'without_pr') 
       {
        $('#us_releasing_date').removeClass('col-md-6')
        $('#us_releasing_date').addClass('col-md-3')
        $('#check_type').val('without_pr');
        $('#data').html("");
        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        $.ajax({
        url:"{{ route('item.get-item-for-releasing') }}",
        method:'GET',
        dataType:'json',
        success:function(data)
        {
            if (data.response == 'yes') 
            {
            
            $table_data_rows = '';
            $.each(data.output, function(k, v) {

            $table_data_rows += '<tr> <td>'+v.category.category_name +'</td>  <td>'+v.item_code +'</td> <td>'+v.item_name+' - '+v.manufacture.name+' </td>  <td>'+v.quantity+'</td> <td id="item_'+v.id+'" class="release_quantity"><input class="item_id" value = "'+v.id+'" type="hidden" /> <input type="number" style="width: 100%;background: transparent;border: none;" value="release_qty[]" class="release_qty" /></td></tr>';
            });

             $('#data').html($table_data_rows);
            }
            else if(data.response == 'empty')
            {
                $('#data').html('<tr><td>No Item Found For Release</td></tr>');
            }
            else
            {
                alert("Something went wrong!")
                location.reload(true)
            }

            $('#c_r_quantity_th').hide('slow')
            $('#demand_quantity_th').hide('slow')
            $('#total_receive_th').hide('slow')
            $('#release_with_pr').show('slow')
            $('#thisBtn').show('slow');
            $('#select_pr').hide('slow')
            $('#select_project').show('slow')
            $('#without_pr_department').show('slow')
            $('#with_pr_department').hide('slow')
            $('#item_release_modal').find('.with_pr_table').show('slow');
        }
        })

       }
       else
       {
         $('#check_type').html("");
         $('#data').html("");
         $('#release_with_pr').hide('slow')
         $('#thisBtn').hide('slow');
         $('#item_release_modal').find('.with_pr_table').hide('slow');
       }
       
        return false;
    }


       function getDepartment(self) {
      
        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        $.ajax({
        url:"{{ route('purchase-requests.get-department') }}",
        method:'POST',
        dataType:'json',
        data: {mir_id:$(self).val()},
        success:function(data)
        {
            $table_data_rows = '';
            $request_quantity = '';
            $.each(data.items, function(k, v) 
            {
               if (type == false) 
               {
                  $request_quantity = v.requesting_quantity; 
               }

                $table_data_rows += '<tr> <td>'+v.category +'</td>  <td>'+v.item_code +'</td> <td>'+v.item_name+' - '+v.brand+'</td>   <td>'+v.demand_quantity+'</td> <td class="receveive">'+v.total_receive_items+'</td> <td>'+v.quantity+'</td> <td>'+v.current_releasing+'</td>    <td id="item_'+v.id+'" class="release_quantity" > <input class="item_id" value = "'+v.id+'" type="hidden" /><input type="number" max="'+$request_quantity+'"  style="width: 100%;background: transparent;border: none;" value="'+$request_quantity+'" class="release_qty" /></td></tr>';
            });

            $('#data').html($table_data_rows);

            if (data.response_type == 'without_pr') 
            {
                $('#total_receive_th').hide()
                $('.receveive').hide()
            }
            else
            {
                $('#total_receive_th').show() 
                $('.receveive').show()
            }

            $('#department_name').val(data.department_name)
            $('#department_id').val(data.department_id)
        }
        })
        return false;
    }


    function confirmReleasing(self) {
     var items = [];
     var releaser_name = $('#releaser_name').val();
     var date = $('#date').val();
     var receiver_name = $('#receiver_name').val();

    if ($('#check_type').val() == 'with_pr')
    {
         var department = $('#department_id').val();
         var purchase_requests_id = $('#purchase_requests_id option:selected').val();
    }

    if ($('#check_type').val() == 'without_pr')
    {
            var department = $('#department_select_id').val();
            var purchase_requests_id = '0';
    }

     // $(self).html('Processing...')
     // $(self).prop('disabled' , true);

    $('.release_quantity').each(function()
    {

    items.push({'item_id':$(this).find(".item_id").val() ,'releasing_quantity': $('#item_'+$(this).find(".item_id").val() ).find('.release_qty').val() });
    });


      $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
        });

        $.ajax({
        url:"{{ route('item.releasing') }}",
        method:'POST',
        dataType:'json',
        data: {items:items , releaser_name:releaser_name ,receiver_name:receiver_name , date:date , mir_id:purchase_requests_id , department : department , type:type},
        success:function(data)
        {
         if(data.response)
         {
            $('#errorMessage2').html(data.message);
            $('#errorMessage2').show();
            $(self).html('Confirm')
            $(self).prop('disabled' , false);
            setTimeout(function(){  $('#errorMessage2').hide();}, 5000);
         }

          if(data.result)
         {
            $('#succeessMessage2').html(data.message);
            $('#succeessMessage2').show();
            setTimeout(function(){ location.reload(true) }, 5000);
         }

        }
        })



        return false;
    }


    function addItems() 
    {
      var checkedNum = $('input[name="items[]"]:checked').length;

        if (!checkedNum) 
        {
          $('#item_release_btn').hide();
        }
        else
        {
          $('#item_release_btn').show();
        }
    }

 
</script>

@stop