@extends('layouts.app')

@section('title')
All Inventory Returnings
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Inventory Returnings</li>
      </ol>
@stop
@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
@stop
@section('content')
  <div class="container-fluid">
  <div class="row">
                    
    <div class="col-sm-12">
                        <div class="white-box">

                    <h3  class="box-title m-b-0">
                    <span >Inventory Returning List</span>
                    </h3>

                           
                            <div class="table-responsive">
                             
                            @if(Session::has('success'))   
                            <div id="successMessage" class="alert alert-success" role="alert">
                            {{ Session::get('success') }}
                            </div>
                            @endif

                            <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                                    <thead>
                                        <tr role="row">
                                        <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 10px;">MIR</th>

                                        <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Release For</th>

                                      
                                        <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Department</th>

                                        <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Return By</th>

                                        <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Return Date</th>


                                        <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Received By</th>


                                        <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Action </th>

                                        </tr>
                                    </thead>
                        <tbody>
                        @foreach( $item_releasings as $list )
                        @php
                        $total = 0;
                        foreach($list->releasing_items as $quantity)
                        $total ++;
                        @endphp
                        <tr role="row" class="odd">

                          <td>
                          {{$list->mir_id > 0  ?  'MIR-'.$list->mir_id : '-' }} 
                        </td>


                        <td>
                        @if($list->purchase_request_id > 0)
                        @permission('view-purchase-request')
                        <a target="_blank" href="{{route('purchase-requests.view' , [$list->purchase_request_id])}}">PR-{{$list->purchase_request_id }} </a>
                        @else
                        PR-{{$list->purchase_request_id }}
                        @endpermission
                        @else
                         Department
                        @endif
                        </td>


                        <td>
                          {{!empty($list->department)?$list->department->department_name:''}}
                        </td>

                        <td>
                          {{$list->returning_name}}
                        </td>

                        <td>
                          {{ date('d-F-Y' , strtotime($list->return_date))}}
                        </td>

                        <td>
                          {{$list->receiver_name}}
                        </td>

                        

                        <td>
                       
                          <a href="{{route('item.returning-details' , [$list->id])}}"><i style="margin-left: 1rem;" class="fa fa-eye" aria-hidden="true"></i></a>
                        
                        </td>
                
                       </tr>
                      @endforeach   
               

                                      
                                </tbody>
                                </table>
                                
                            </div>
                            </div>
                        </div>
                    </div>


    </div>

      </div>
@stop
