@extends('layouts.app')

@section('title')
Inventory Return
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Inventory Return</li>
      </ol>
@stop
@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
@stop
@section('content')
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        <div class="white-box " id="printableSection">


							<h3 class="box-title" style="margin-bottom: 3rem;text-align: right;"><span style="float: left;"><b style="font-size: 2.2rem;color: gray;">Inventory Return  / </b>
							@if($purchase_request_id == 0 ) {{'Department'}} @else MIR-{{$item_releasings->mir_id}} @endif
							</span> 
							<a class="btn btn-warning avoid-this" id="print" href="#">
							Print
							</a>
							</h3>

                              
							
                                <div class="">  
                           
                               
								<h3 class="box-title"><b style="color: gray;">Return Inventory  Request Details</b></h3>

								<div class="row">

								<div class="col-md-3 col-xs-3 div-border" style="margin-top: 2rem;">
								<span style="color:black;" class="font-weight-bold">Company</span>
								<span style="margin-left: 5px;font-weight: 400;">
								{{ env('APP_NAME')}}
								</span>
								</div>



								<div class="col-md-3 col-xs-3 div-border" style="margin-top: 2rem;">
								<span style="color:black;" class="font-weight-bold">Contact</span>
								<span style="margin-left: 5px;font-weight: 400;">
								{{env('APP_CONTACT')}}
								</span>
								</div>


								<div class="col-md-6 col-md-6 div-border" style="margin-top: 2rem;">
								<span style="color:black;" class="font-weight-bold">Address</span>
								<span style="margin-left: 5px;font-weight: 400;">
								{{env('APP_ADDRESS')}}
								</span>
								</div>


								<div class="col-md-3 col-xs-3 div-border" style="margin-top: 2rem;">
								<span style="color:black;" class="font-weight-bold">Department</span>
								<span style="margin-left: 5px;font-weight: 400;">
								{{ !empty($item_releasings->department)?$item_releasings->department->department_name:''}}
								</span>
								</div>

								<div class="col-md-3 col-xs-3 div-border" style="margin-top: 2rem;">
								<span style="color:black;" class="font-weight-bold">Return By</span>
								<span style="margin-left: 5px;font-weight: 400;">
								{{ ucfirst($item_releasings->returning_name) }}
								</span>
								</div>


								<div class="col-md-3 col-xs-3 div-border" style="margin-top: 2rem;">
								<span style="color:black;" class="font-weight-bold">Returning Date</span>
								<span style="margin-left: 5px;font-weight: 400;">
								{{ date('d-F-Y' , strtotime($item_releasings->return_date) )}}
								</span>
								</div>


								<div class="col-md-3 col-xs-3 div-border" style="margin-top: 2rem;">
								<span style="color:black;" class="font-weight-bold">Received By</span>
								<span style="margin-left: 5px;font-weight: 400;">
								{{ $item_releasings->receiver_name}}
								</span>
								</div>


							
								</div>



                             <h3 class="box-title" style="margin-top: 5rem;"><b style="color: gray;"> Inventory List</b></h3>

							

                              <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
	                            <thead>
								<tr role="row">

								<th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Code</th>
								

								<th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Inventory</th>

							
								<th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">
								Return Quantity
							    </th>


								</tr>

	                            </thead>
                                <tbody>
								
								<?php  $count = 0; $amount = 0;  $quantity = 0; 
								$vendor_item_price = 0; ?>

								@foreach( $item_releasings->releasing_items as $item_list )
                                @php
                                $item = \App\Item::withTrashed()->find($item_list->item_id);
                                $current_return = $item_list->return_quantity;
                                @endphp
								<tr role="row" class="odd"  >

							    <td>{{$item->item_code}} </td>

								<td class="item_name">
								{{$item->item_name}} - {{$item->manufacture->name}}
								<?= ($item->risk_type == 'critical') ? '<span class="critical">Critical</span>' : '<span class="non_critical">Non Critical</span>' ?>
								</td>

								<td>
								{{$current_return}}
								</td>

							
								</tr>

								<?php
								 $count ++;
								 $quantity += $current_return; ?>
								 @endforeach 
								

								</tbody>
								</table>



								 <div class="row">
                                <div class="col-md-6 col-xs-6"></div>
								<div class="col-md-6 col-xs-6" style="text-align: right;">
								<div class="pricing-section">
									<p>
									<b style="color:black;" class="us-text">Total Inventory:</b> <span style="margin-left: 10rem;"> {{number_format($count, 2)}}</span>
									</p>

									<p>
									<b style="color:black;" class="us-text">Total Inventory Quantity:</b> <span style="margin-left: 9.5rem;"> {{number_format($quantity, 2)}}</span>
									</p>

                                </div>

								</div>
							    </div>
								</div>

								</div>
								</div>
								</div>
								</div>
@stop

@section('js')  

<script type="text/javascript">

function submitCsForm(self) {
	$(self).html('Processing...');
	$(self).prop('disabled' , true);
	$( "#cs_form" ).submit();
}

function sendCsToCompany(pr_id , vendor_id) {

var item_ids = [];
var vendor_prices = [];
var vendor_messages = [];

	$('.vendor_price').each(function() {
	    vendor_prices.push($(this).val());
	});

	$('.vendor_message').each(function() {
	 	vendor_messages.push($(this).val());
	});

	$('.item_ids').each(function() {
	 	item_ids.push($(this).val());
	});

if(vendor_prices == "," || vendor_prices  == "")
{
if (confirm("You are not enter any single item price? Do you agreed with company price?") == false) 
  {
  	$('#thisBtn').html('Save Cs');
	$('#thisBtn').prop('disabled' , false);
    return false;
  }
}
	   $.ajaxSetup({
		headers: {
		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		}
		});

		$.ajax({
		url:"{{ route('comparative-statements.send') }}",
		method:'POST',
		dataType:'json',
		data: {pr_id:pr_id,vendor_id:vendor_id ,item_ids:item_ids, vendor_prices:vendor_prices , vendor_messages:vendor_messages},
		success:function(data)
		{
          if(data.response == 'yes')
          {
          	$('#successMessage').html(data.message);
          	$('#successMessage').show('slow');
          	setTimeout(function(){ location.reload(true) }, 3000);
          }
          else if(data.response == 'invalid')
          {
			$('#thisBtn').html('Send Comparative Statement');
			$('#thisBtn').prop('disabled' , false);
			$('#errorMessage').html(data.message);
			$('#errorMessage').show('slow');
          }
          else
          {
          	alert('Something Went Wrong.')
          	location.reload(true)
          }
		}
		})

	return false;
}



	function showPriceBox(item_id , self) 
	{
		$('#'+item_id+'_default').toggle();
		$('#'+item_id+'_vendor_price').toggle();
		$('#'+item_id+'_vendor_message').toggle();
		$('#'+item_id+'_vendor_price').val('');
		$('#'+item_id+'_vendor_message').val('');
		return false;
	}

	

    function validate()
    { 
        if(!confirm('Are you sure you want to cancel this purchase request?'))
        {
            return false;
        } 
    }



</script>

@stop