@extends('layouts.app')

@section('title')
All Item Variance Analysis
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Items Variance Analysis</li>
      </ol>
@stop
@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
 <style type="text/css">
  .us_task_select
  {
  color: white;
  padding: 5px 10px 5px 10px;
  background: #080b12;
  border-radius: 20px;
  }
  .us_blk_col
  {
    color: black;
    font-weight: bold;
  }
  .us-table
  {
    border: 1px solid #dfdfdf;
  }
  .myParentTable th
  {
    color: white !important;
  }
 </style>
@stop
@section('content')
  <div class="container-fluid">
  <div class="row">
                    
    <div class="col-sm-12">
                  <div class="white-box">

                    <h3 style="text-align: right;" class="box-title m-b-0">

                    <span style="float: left;">Items Variance Analysis</span>

                     <span id="task_name"></span>

                     <button style="font-size: 1.4rem;background: transparent;border: none;" onclick="return showTaskModal(this);" >Change Task <i style="margin-left: 0.4rem;" class="fa fa-refresh" aria-hidden="true"></i></button>

                    </h3>

                    <div class="col-md-12" style="margin-top: 2rem;">
                      <div class="row">
                        <div class="col-md-4">
                            <span>
                            <div>Limit Exceeded</div>

                            <div style="background:red;padding: 1rem;"></div>
                            </span>
                        </div>


                        <div class="col-md-4">
                            <span>
                            <div>Below actual quantity</div>

                            <div style="background:green;padding: 1rem;"></div>
                            </span>
                        </div>


                         <div class="col-md-4">
                            <span>
                            <div>Normal</div>

                            <div style="background:white;padding: 1rem;border: 0.1px solid gray;"></div>
                            </span>
                        </div>

                      </div>
                    </div>
                           
                           <div class="col-md-12">
                              <div class="row">
                                 <div class="table-responsive" id="us_tbl_list">
                                    <!-----table list----------------->          
                            </div>
                              </div>
                           </div>
                           

                            </div>
                        </div>
                    </div>
             </div>
      </div>



            <!-- Modal -->
<div class="modal fade" id="work_order_selection" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
  
      <div class="modal-body">
        <div class="row" style="padding: 2rem;">

            <div class="col-md-12" style="margin-top: 2rem;" id="task_list">

            <center>
            <h3 style="background: #4a5256;color: white;padding: 1rem;margin-bottom: 2rem;">
            Work Order Tasks
            </h3>
            </center>

            <select class="form-control chosen-select" onchange="return select_task(this)" id="select_task">
                <option value="0">Select Task</option>
                @foreach($tasks as $task)
                <option value="{{$task->id}}">{{$task->text}}</option>
                @endforeach
            </select>
            </div> 


        </div>
      </div>
     
    </div>
  </div>
</div>

@stop

@section('js')

<script type="text/javascript">
     $( document ).ready(function() {
        $("#work_order_selection").modal({backdrop: "static"});
        return  false;
     });

        function select_task(self) 
    {

      if ($(self).val() != '0')
      {
        $("#work_order_selection").modal('hide');
        $('#task_name').text($('#select_task').find('option:selected').text())
        $("#task_name").addClass("us_task_select");

        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });

        $.ajax({
        url:"{{ route('item.variance-report') }}",
        method:'POST',
        dataType:'json',
        data: {task_id:$('#select_task').val() },
        success:function(data)
        {
        
            if (data.response == 'found')
            {

              var output = '';
              var childOutput = '';
              var tableDefault = 'class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 10px;">Item Code</th><th style="" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 10px;">Item Name</th> <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Unit</th><th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Quantity</th><th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Rate per Unit</th><th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Total</th><th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Date</th></tr></thead><tbody >';
             

                $.each(data.boq, function(key, value) {

                  output += '<table id="myParentTable" class="table table-striped table-bordered dataTable color-table primary-table myParentTable" role="grid" aria-describedby="myTable_info"><thead><tr role="row" style="background: #080b12;"><th style="color: white;" '+tableDefault;

                  output += '<tr>';
                  output += '<td>'+value.item_code+'</td>';
                  output += '<td>'+value.item_name+'</td>';
                  output += '<td>'+value.item_unit+'</td>';
                  output += '<td>'+value.quantity+'</td>';
                  output += '<td>'+value.rate_per_unit+'</td>';
                  output += '<td>'+value.total_cost+'</td>';
                  output += '<td>'+value.date+'</td>';
                  output += '</tr>';  
                  output += '</tbody></table>';

                  output += '<center><h3>Current Consuming</h3></center>';

                  output += '<table id="myTable" class="table us-table" role="grid" aria-describedby="myTable_info"><thead><tr role="row"><th style="color: black;" '+tableDefault;
                  var quantity = '';
                  var total_cost = '';
                   var rate_per_unit = '';
                  $.each(data.current_item_consume, function(key, v) 
                  {
                      if (v.item_id == value.item_id ) 
                      {
                        var rate_per_unit_style = '';
                        var total_cost_style = '';

                        output += '<tr>';
                        output += '<td>'+v.item_code+'</td>';
                        output += '<td>'+v.item_name+'</td>';
                        output += '<td>'+v.item_unit+'</td>';
                        output += '<td>'+v.quantity+'</td>';

                         if (value.rate_per_unit < v.rate_per_unit) 
                          {
                             rate_per_unit_style = 'background:red;color:white;    border-right: 1px solid;';
                          }
                            else if(value.rate_per_unit > v.rate_per_unit)
                          {
                             rate_per_unit_style = 'background:green;color:white;    border-right: 1px solid;';
                          }

                        output += '<td style="'+rate_per_unit_style+'" >'+v.rate_per_unit+'</td>';

                         if (value.total_cost < v.total_cost) 
                          {
                             total_cost_style = 'background:red;color:white;';
                          }
                            else if(value.total_cost > v.total_cost)
                          {
                             total_cost_style = 'background:green;color:white;';
                          }

                        output += '<td style="'+total_cost_style+'" >'+v.total_cost+'</td>';
                        output += '<td>'+v.date+'</td>';
                        output += '</tr>';  

                        quantity += v.quantity;
                        rate_per_unit += v.rate_per_unit;
                        total_cost += v.total_cost;

                      }

                       if (key == data.current_item_consume.length-1) 
                        {
                          output += '<tr style="border: 2px solid #e7e7e7;">';
                          output += '<td colspan="3" class="us_blk_col" ><b style="font-size: 15px;">Total:</b> </td>';

                          var style = '';

                          if (value.quantity < quantity) 
                          {
                            style = 'background:red;color:white;';
                          }
                          else if(value.quantity > quantity)
                          {
                             style = 'background:green;color:white;';
                          }

                          output += '<td class="us_blk_col" style="'+style+'" >'+quantity+'</td>';
                          
                          output += '<td class="us_blk_col">'+rate_per_unit+'</td>';
                          output += '<td colspan="3" class="us_blk_col">'+total_cost+'</td>';
                          output += '</tr>'; 
                        }

                  });

                        output += '</tbody></table>';

               });


        
            $('#us_tbl_list').html(output)
          
            }

        }
        })
      }
      else
      {
         $('#task_name').text('')
           $('#us_tbl_list').html('')
         $("#task_name").removeClass("us_task_select");
      }

       return false;
    }

       function showTaskModal(self) 
       {
          $("#work_order_selection").modal({backdrop: "static"});
          return false;
       }

</script>

@stop