@extends('layouts.app')

@section('title')
View Item
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Items</li>
      </ol>
@stop
@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
@stop
@section('css') 
<style type="text/css">
.anychart-credits
{
display: none;
}
</style>
@stop

 @section('content')
  <div class="container-fluid">
  <div class="row">
                    
    <div class="col-sm-12">


        <div class="white-box">
                          <h3 class="box-title m-b-0">ITEM {{$item->item_code}} / <span style="font-size: 1.6rem;color: gray;">{{$item->item_name}}</span> </h3>
                          
                            <!-- Nav tabs -->
                            <ul class="nav customtab nav-tabs" role="tablist" style="margin-top: 3rem;">

                                <li role="presentation" class="active"><a href="#detail" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-home"></i></span><span class="hidden-xs"> Details</span></a></li>


                                <li role="presentation" class=""><a href="#releasing" aria-controls="profile" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-user"></i></span> <span class="hidden-xs">Releasing</span></a></li>


                                <li role="presentation" class=""><a href="#graph" aria-controls="profile" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-user"></i></span> <span class="hidden-xs">Graphs</span></a></li>


                            </ul>
                            <!-- Tab panes -->
                       <div class="tab-content">
                       <div role="tabpanel"  class="tab-pane fade active in" id="detail">

                      <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">

                        <thead>
                        <tr role="row">
                        <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Po#</th>
                        <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Vendor</th>

                        <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 50px;">Order Qty</th>

                        <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 80px;">Receive Qty</th>

                        <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Price</th>

                        <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;"> Date</th>

                        </tr>
                        </thead>
                        <tbody>
  
                            @php
                            $total_price = 0;
                            $total_quantity = 0;
                            @endphp
                                @foreach( $item_purchase_order  as $list )

                                <tr role="row" class="odd">
                                 @php 
                                 $po = \App\PurchaseOrder::find($list->purchase_order_id );
                                 @endphp

                                <td>
                                  
                                <a href="{{url('purchase-orders/detail?vendor='.Crypt::encryptString($po->vendor_id).'&purchase_request='.Crypt::encryptString($po->purchase_request_id).'')}}"  target="_blank">
                                    PO-{{$po->id}}
                                </a>
                                </td>

                                <td>
                                   <a href="{{route('vendor.view' , [$po->vendor->id])}}"> {{ucfirst($po->vendor->name)}}
                                   </a> 
                                </td>

                                <td> {{number_format($list->demand_quantity , 2)}}</td>

                                <td> {{number_format($list->received_quantity , 2)}}</td>

                                <td> {{number_format($list->price , 2)}} </td>

                                <td style="font-size: 15px;">{{date('d-F-Y' , strtotime($po->created_at))}}</td>


                                </tr>
                                @php
                                 $total_price += $list->price * $list->received_quantity;
                                 $total_quantity += $list->received_quantity ;
                                @endphp
                                @endforeach   
                                     
                                </tbody>
                                </table>
                                    <div class="clearfix" style="text-align: right;">																		  <div>                                            <b style="margin-right: 1rem;">Total Receive Qty : </b> {{number_format($total_quantity , 2)}}                                        </div>										
                                        <div  style="    margin-top: 1rem;">
                                            <b style="margin-right: 1rem;">Total Receive Qty Amount: </b> {{number_format($total_price , 2)}}
                                        </div>
                                    </div>
                                </div>

                            <div role="tabpanel" class="tab-pane fade" id="releasing">
                        <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                        <thead>
                        <tr role="row">

                            <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Pr#</th>

                       

                        <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Department</th>

                         <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Releasing By </th>

                          <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Received By </th>


                        <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 80px;">Releasing  Quantity</th>

                        <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Releasing Date</th>

                      
                        </tr>
                        </thead>
                        <tbody>
  
								@php								
                                $total_release = 0;					
                                @endphp								 
                                @foreach( $item_releasings  as $item_list )

                                @php                            
                                $current_release = \App\Http\Controllers\ItemController::getCurrentRelease($item->id , $item_list->purchase_request_id , $item_list->department_id);                           
                                @endphp 

                                    @if($current_release > 0 )

                                @php
                                $quantity = 0;																$current_release = 0;
                                foreach($item_list->releasing_items as $quantity)
                                if($quantity->item_releasing_id == $item_list->id) $quantity = $quantity->item_quantity;
                                $project_id = null;
                                $department_id = $item_list->department_id;
                                if (! isset($out[$project_id ])) {
                                $out[$project_id ] = array('project_id' => $project_id ); 
                                }
                                if (! isset($out[$project_id ][$department_id ])) 
                                {
                                $out[$project_id ][$department_id ] = 0;    
                                }
                                $out[$project_id ][$department_id ] += $quantity;																                                   							
                                @endphp
  
                              
                                <tr role="row" class="odd">

                                <td>
								@if($item_list->purchase_request_id > 0)
								@permission('view-purchase-request')
								<a target="_blank" href="{{route('purchase-requests.view' , [$item_list->purchase_request_id])}}">PR-{{$item_list->purchase_request_id }} </a>
								@else
								PR-{{$item_list->purchase_request_id }}
								@endpermission
								@else
								--
								@endif
                                </td>
                                <td> {{$item_list->department->department_name}}</td>

                                <td> {{ucfirst($item_list->releaser_name)}} </td>

                                <td> {{ucfirst($item_list->receiver_name)}} </td>

                                <td> 							
    								{{$current_release}}
                                </td>

                                <td >{{date('d-F-Y' , strtotime($item_list->releasing_date))}}</td>

                                </tr>								
                                @php									
                                $total_release  = $total_release  + $current_release;				
                                @endphp
                                @endif
                                @endforeach   
                                     
                                </tbody>
                                </table>
								<div class="clearfix" style="text-align: right;">								<div  style="margin-top: 1rem;">								<b style="margin-right: 1rem;">Total Release Qty : </b> {{number_format($total_release , 2)}}								</div>								</div>
                                    </div>

                                    <div role="tabpanel" class="tab-pane fade" id="graph">


                                    @if(!empty($out))
                                    <h3 class="box-title m-b-0">Item Usage  </h3>

                                    <div id="container-1" style=" margin-top: 5rem; width: 100%; height: 100%"></div>
                                    @endif


                                    <h3 class="box-title m-b-0">Item Stock  </h3>
 

                                  <div id="container-2" style="margin-top: 5rem; width: 100%; height: 100%"></div>

                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
            </div>
      </div>
@stop

@section('js')  


 <script>

@if(!empty($out))
    anychart.onDocumentReady(function() {
 
        // set the data
        var data = {
        header: ["Name", "Total Usage"],
        rows: [
        @php
        foreach ($out as $key => $value) {
        for ($i=1; $i < sizeof(array_keys($value)); $i++) { 
        @endphp
        ["{{ env('APP_NAME') }} - {{\App\Department::find(array_keys($value)[$i])->department_name}}" , "{{$value[array_keys($value)[$i]]}}"],
        @php
        }
        }
        @endphp
        ]  
        };
 
        // create the chart
        var chart = anychart.column();
 
        // add the data
        chart.data(data);
 
      
 
        // draw
        chart.container("container-1");
        chart.draw();
      });
@endif
      anychart.onDocumentReady(function() {
 
        // set the data
        var data = {
            header: ["Name", "In Stock"],
            rows: [
              ["{{$item->item_name}}", "{{$item->quantity}}"]
        ]};
 
        // create the chart
        var chart = anychart.bar();
 
        // add the data
        chart.data(data);
 
      
 
        // draw
        chart.container("container-2");
        chart.draw();
      });
    </script>

    @stop