
@extends('layouts.app')

@section('title')
All MIR List
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li>
            <a href="{{route('home')}}">
                <i class="fa fa-dashboard"></i> 
            Home
        </a>
        </li>

        <li class="active">
             Material Issue Request List
        </li>
    </ol>
@stop
@section('css')
<style type="text/css">
    .dropdown-menu 
    {
    left: -50px;
    }

    .chosen-container-multi .chosen-choices {

    height: 38px;
    }

    .chosen-container-multi .chosen-choices li.search-field {

    padding: 5px;
    }
</style>
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
@stop
@section('content')
  <div class="container-fluid">
  <div class="row">
                    
    <div class="col-sm-12">
    <div class="white-box">

    <h3 style="text-align: right;" class="box-title m-b-0">
        <span style="float: left;"> Material Issue Request List</span>
      
        @permission(['mir'])


        <div class="btn-group" role="group">
        <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
        Create Mir
        <span class="caret"></span>
        </button>
        <ul class="dropdown-menu">
        <li><a href="#"  id="item_release_btn">With Pr</a></li>
        <li><a href="#" id="item_release_btn_wo_pr">Without Pr</a></li>
        </ul>
        </div>

        @endpermission
    </h3>

    <div class="table-responsive">

    @if(Session::has('success'))   
        <div id="successMessage" class="alert alert-success" role="alert">
            {{ Session::get('success') }}
        </div>
    @endif

    <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
    <thead>
    <tr role="row">

    <th class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 50px;">MIR #</th>

    <th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 130px;">PR # </th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Department</th>

     <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Request By</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Request date</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 50px;">Release Status</th>

    <th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Action</th>

    </tr>
    </thead>
    <tbody>
    @if( $material_issue_requests->count() > 0 )
    @foreach( $material_issue_requests as $list )
    
    <tr class="active ">     
 
    <td class="">MIR-{{$list->id }}</td>
   
    <td >
        @if($list->pr_id > 0 ) 
        PR-{{$list->pr_id}} 
        @else 
        <span style="color: #8787ff;">
        {{'Without Pr'}}
        </span> 

        
        &nbsp;&nbsp;(
        @if($cancelCount[$list->id] > 0 )
        <span style="color:red">
            Cancel
        </span>
        
        @elseif($approvalCount[$list->id] > 0 )
        <span style="color:#eba053">
            Approval pending
        </span>
        @else
         <span style="color:#00c900">
           Approved
        </span>
        @endif
        )

      
        @endif
    </td>

    <td>{{ !empty($list->department)?$list->department->department_name:'' }}</td>
      <td>{{ $list->request_person_name }}</td>
    <td>{{ date('d-F-Y' , strtotime($list->request_date)) }}</td>
    <td>
        {{ucfirst($list->status)}}
    </td>
    <td>


    <a data-toggle="tooltip" data-placement="top" title="View" style="margin-left: 1rem; color: #e8b600"  href="javascript:void(0);" onclick="return showItems(this , '{{$list->id}}')">
        <i class="fa fa-eye" aria-hidden="true"></i>
    </a>

    @if($list->status == 'pending')

    <form action="{{ route('mir.delete', [$list->id] ) }}"
        method="post" style='display: inline;'>
        @method('DELETE')
        @csrf
        <button class="btn btn-link btn-s" style="color:red;"
            type="submit" name="action" value="delete"
            data-toggle="confirmation"
            data-title="Are you sure to delete?">
            <i class="fa fa-trash-o" aria-hidden="true"></i>
        </button>
    </form>

     {{-- <a data-toggle="tooltip" data-placement="top" title="Remove"  style="color:red;margin-left: 1rem;" onclick="return validate();" href="{{ route('mir.delete', [$list->id] ) }}"><i class="fa fa-trash-o" aria-hidden="true"></i></a> --}}
     @endif

    </td>
    </tr>
    @endforeach   
    @endif

    </tbody>
    </table>

    </div>
    </div>
    </div>
    </div>


    </div>

    </div>
    </div>


                                <!-- Modal -->
<div class="modal fade" id="mirModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">MIR Items</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <table class="table table-striped">
  <thead>
    <tr>
      
      <th >Item</th>
      <th >Total Request</th>
      <th >Status</th>
    </tr>
  </thead>
  <tbody id="mir_item">
   
  </tbody>
</table>
<div>
<strong>Note:</strong> 
   <span  id="mir_notes">
       <!-----Desccription gose from her------------->
   </span>
</div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        
      </div>
    </div>
  </div>
</div>



    <!----------------Releaseing----------------->


        <div class="modal fade" id="item_release_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel1">
        <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
        <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="Modal_Title">
        Release <span id="with_or_without"></span> Purchase Request
        </h4></div>
        <div class="modal-body">

    
        
        <div class="row" id="release_with_pr" style="">
        <div class="col-md-6">
        <label><span id="release_by">Requested By</span> <b style="color:red;">*</b></label>
        <input type="text" id="releaser_name" value="{{ucfirst(Auth::user()->name)}}" readonly placeholder="Please Enter Name..." class="form-control" name="">

        </div>

       


        <div class="col-md-6">
        <label>
        <span id="release_date">Request Date </span><b style="color:red;margin-right: 1rem;">*</b></label>
        <span id="invalid_date_errorMessage" style="display:none; color: red;margin-left: 1rem;"></span>
        <input type="date" id="date" min="{{date('Y-m-d')}}" value="{{date('Y-m-d')}}" class="form-control">
        </div>

        <div class="col-md-6" id="select_pr" style="margin-top: 1rem;display: none;">
        <label >Select PR <b style="color:red;margin-right: 1rem;">*</b></label>
        <select class="form-control "  name="purchase_requests_id" onchange="return getDepartment(this);"  id="purchase_requests_id">
            <option value="">Select Pr</option> 
        
        @foreach($purchase_requests as $purchase_request)
        <option value="{{ $purchase_request->id }}">PR- {{ $purchase_request->id  }}</option>
        @endforeach
       
        </select>

        </div>



        <div class="col-md-6" id="select_without_pr" style="margin-top: 1rem;display: none;">
        <label >Select Item <b style="color:red;margin-right: 1rem;">*</b></label>
        <select class="form-control chosen-select" multiple  name="item_name" onchange="return OnSelectItem(this);"  id="item_id">
        <option value="">Select Item</option> 
       
        @foreach($items as $item)
        <option value="{{ $item->id }}">{{ $item->item_name  }}</option>
        @endforeach
     
        </select>

        </div>




        <div class="col-md-6" id="select_project" style="margin-top: 1rem;display: none;">
        <label >Project <b style="color:red;margin-right: 1rem;">*</b></label>
        
         <input type="text" class="form-control" id="project_name" readonly="readonly"  value="{{ env('APP_NAME') }}">

        </div>


        <div class="col-md-6" id="with_pr_department" style="margin-top: 1rem;">
        <label >Department <b style="color:red;margin-right: 1rem;">*</b></label>
         <input type="hidden" readonly="readonly" id="department_id" name="">
        <input type="text" class="form-control" id="department_name" readonly="readonly"  value="">
        </div>
       

        <div class="col-md-3" id="without_pr_department" style="display: none;margin-top: 1rem;">
        <label >Departments <b style="color:red;margin-right: 1rem;">*</b></label>

        <select class="form-control chosen-select"  name="department_select_id" id="department_select_id">
        
        @foreach($departments as $department)
        <option value="{{ $department->id }}">{{ $department->department_name  }}</option>                             
        @endforeach
       
        </select>
        </div>



        <div class="col-md-3" id="approval_roles" style="display: none;margin-top: 1rem;">
        <label >Approval Roles <b style="color:red;margin-right: 1rem;">*</b></label>

        <select class="form-control chosen-select"   name="approval_roles" id="approval_selected_roles">
        
        @foreach($approval_roles as $approval_role)
        <option value="{{ $approval_role->id }}">{{ $approval_role->name  }}</option>                             
        @endforeach
        
        </select>
        </div>



        <div class="col-md-12" id="mir_info" style="margin-top: 1rem;">
             <label >Note:</label>
            <textarea class="form-control" placeholder="type here..." rows="3" id="description"></textarea>
        </div>


        </div>

        <input type="hidden" id="check_type" name="">



        <table id="myTable" class="table table-striped dataTable no-footer with_pr_table" role="grid" aria-describedby="myTable_info">
        <thead>
        <tr role="row">

        <th class="sorting hide_on_wo_pr" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 50px;" >Select</th>

       <th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 50px;">Category</th>

        <th class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 50px;">Code</th>


        <th class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 150px;">Name</th>



        <th class="sorting hide_on_wo_pr" tabindex="0" id="demand_quantity_th" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Demand Qty</th>


        <th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Available Qty</th>


        <th class="sorting hide_on_wo_pr" tabindex="0" id="c_r_quantity_th" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Current Receive</th>


        <th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 203px; text-align: center;" id="column_type">Request Qty</th>
        </tr>

        </thead>
        <tbody id="data"> </tbody>
        </table>

        </div>
        <div class="modal-footer">

            <div class="alert alert-success" role="alert" style="display:none;text-align: left;"  id="succeessMessage2">
       
        </div>

        <div class="alert alert-danger" role="alert" style="display:none;text-align: left;"  id="errorMessage2"></div>


        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        <button type="submit"  onclick="return confirmReleasing(this)" class="btn btn-primary"  id="thisBtn" >Confirm</button>
        </form>
        </div>
        </div>
        </div>
</div>



@stop



@section('js')  

<script type="text/javascript">

let type = false;
let is_with_pr = false;


function OnSelectItem(argument) 
{
     $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        $.ajax({
        url:"{{ route('item.get-item-for-release') }}",
        method:'GET',
        dataType:'json',
        data:{'item_id':$(argument).val()},
        success:function(data)
        {
            if (data.response == 'yes') 
            {
            
            $table_data_rows = '';
            $.each(data.output, function(k, v) {

            $table_data_rows += '<tr> <td>'+v.category.category_name +'</td>  <td>'+v.item_code +'</td> <td>'+v.item_name+' - '+v.manufacture.name+' </td>  <td>'+v.quantity+'</td> <td id="item_'+v.id+'" class="release_quantity"><input class="item_id" value = "'+v.id+'" type="hidden" /> <input type="number" style="width: 100%;background: transparent;border: none;" value="release_qty[]" class="release_qty" /></td></tr>';
            });

             $('#data').html($table_data_rows);
            }
            else if(data.response == 'empty')
            {
                $('#data').html('<tr><td>No Item Found For Release</td></tr>');
            }
            else
            {
                alert("Something went wrong!")
                location.reload(true)
            }
        }
        })

}

$("#item_release_btn").click(function()
{
    is_with_pr = true;
    $('#purchase_requests_id').show();
    $('#with_pr_department').show();
    $('#select_without_pr').hide()
    $('#without_pr_department').hide()
    $('#select_pr').show()
    $('#approval_roles').hide()
    $('#item_release_modal').modal('show')
    $('#data').html('')
    $('.hide_on_wo_pr').show()
    $("#date").prop("readonly", false); 
    $('#with_or_without').html('With')
});



    $("#item_release_btn_wo_pr").click(function()
    {
        is_with_pr = false;
        $('#purchase_requests_id').hide();
        $('#with_pr_department').hide();
        $('#select_pr').hide()
        $('#select_without_pr').show()
        $('#without_pr_department').show()
        $('#approval_roles').show()
        $('#item_release_modal').modal('show')
        $('#data').html('')
        $('.hide_on_wo_pr').hide()
        $("#date").prop("readonly", true); 
        $('#with_or_without').html('Without')
    });


    function showItems(self , id) 
    {
          $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        $.ajax({
        url:"{{ route('mir.get-item') }}",
        method:'POST',
        dataType:'json',
        data: {id:id},
        success:function(data)
        {

            if (data.response == 'yes') 
            {
                $table_data_rows = '';
                $.each(data.output, function(k, v) 
                {
                    $_status = '';

                    if (v.status == 'Release') 
                    {
                       $_status = '<span style="padding: 0.5rem;background: #00f500;color: white;font-weight: bold;border-radius: 15px;">'+v.status+'</span>';
                    }

                     if (v.status == 'Pending') 
                    {
                       $_status = '<span style="padding: 0.5rem;background: #f50000;color: white;font-weight: bold;border-radius: 15px;">'+v.status+'</span>';
                    }

                $table_data_rows += '<tr> <td>'+v.item_name +'</td>  <td>'+v.request_quntity +'</td> <td>'+$_status +'</td> </tr>';
                });

                $('#mir_notes').html(data.note);
                $('#mir_item').html($table_data_rows);

               $('#mirModal').modal('show');
            }
            
        }
        })
     

        return false;
    }

  
       function getDepartment(self) {
      
        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        $.ajax({
        url:"{{ route('purchase-requests.get') }}",
        method:'POST',
        dataType:'json',
        data: {pr_id:$(self).val()},
        success:function(data)
        {
            $table_data_rows = '';
            $.each(data.items, function(k, v) 
            {

              $table_data_rows += '<tr> <td><input type="checkbox" class="item_check" ></td> <td>'+v.category +'</td>  <td>'+v.item_code +'</td> <td>'+v.item_name+'  - '+v.brand+'</td>   <td>'+v.demand_quantity+'</td>  <td>'+v.quantity+'</td> <td>'+v.current_releasing+'</td>    <td id="item_'+v.id+'" class="release_quantity" > <input class="item_id" value = "'+v.id+'" type="hidden" /><input type="number" style="width: 100%;background: transparent;border: none;" value="release_qty[]" class="release_qty" /></td></tr>';
            });

            $('#data').html($table_data_rows);

            $('#department_name').val(data.department_name)
            $('#department_id').val(data.department_id)
        }
        })
        return false;
    }


    function confirmReleasing(self)
     {

	var items = [];
	var releaser_name = $('#releaser_name').val();
	var date = $('#date').val();
	var receiver_name = $('#receiver_name').val();


if (is_with_pr == true) 
{
var department = $('#department_id').val();
}
else
{
    var department = $('#department_select_id').val();
}
	
	var purchase_requests_id = $('#purchase_requests_id option:selected').val();
  

     $(self).html('Processing...')
     $(self).prop('disabled' , true);


 if (is_with_pr == true) 
    {

        $('.release_quantity').each(function()
        {
    	     if ($(this).closest('tr').find('.item_check').is(':checked')) 
    	     {
    	     	 items.push({'item_id':$(this).find(".item_id").val() ,'releasing_quantity': $('#item_'+$(this).find(".item_id").val() ).find('.release_qty').val() });
    	     }
        });

    }


    if (is_with_pr == false) 
    {

        $('.release_quantity').each(function()
        {
                 items.push({'item_id':$(this).find(".item_id").val() ,'releasing_quantity': $('#item_'+$(this).find(".item_id").val() ).find('.release_qty').val() });
             
        });

    }


    if (is_with_pr == true) 
    {
        var dataArray = {'items':items , 'releaser_name':releaser_name ,'receiver_name':receiver_name , 'date':date , 'purchase_requests_id':purchase_requests_id , 'department' : department , 'type':type,'is_with_pr' : is_with_pr,'note':$('#description').val()};
    }


    if (is_with_pr == false) 
    {
        var dataArray = {'items':items , 'releaser_name':releaser_name ,'receiver_name':receiver_name , 'date':date , 'purchase_requests_id':0 , 'department' : department , 'type':type , 'is_with_pr':is_with_pr, 'approval_roles':$('#approval_selected_roles').val(),'note':$('#description').val()};
    }


      $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
        });

        $.ajax({
        url:"{{ route('material.issue.request.create') }}",
        method:'POST',
        dataType:'json',
        data: dataArray,
        success:function(data)
        {
         if(data.response)
         {
            $('#errorMessage2').html(data.message);
            $('#errorMessage2').show();
            $(self).html('Confirm')
            $(self).prop('disabled' , false);
            setTimeout(function(){  $('#errorMessage2').hide();}, 5000);
         }

          if(data.result)
         {
            $('#succeessMessage2').html(data.message);
            $('#succeessMessage2').show();
            setTimeout(function(){ location.reload(true) }, 5000);
         }

        }
        })



        return false;
    }


    function addItems() 
    {
      var checkedNum = $('input[name="items[]"]:checked').length;

        if (!checkedNum) 
        {
          $('#item_release_btn').hide();
        }
        else
        {
          $('#item_release_btn').show();
        }
    }


    function validate()
    { 
        if(!confirm('Are you sure you want to delete?'))
        {
            return false;
        } 
    }
 
 
</script>

@stop