@extends('layouts.app')

@section('title')
Add Project
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Projects</li>
      </ol>
@stop

@section('content')
  <div class="container-fluid">
<div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0">Add New Project</h3>
                            <p class="text-muted m-b-30 font-13">  </p>
                            <form class="form-horizontal" method="POST" action="{{ route('project.insert') }}">
                            	 {{csrf_field()}}

                                <div class="form-group">

                                <div class="col-md-6">
                                <input type="text" class="form-control" placeholder ="Type Project Name here...." value="{{old('name')}}" name="name">
                                @if ($errors->has('name'))
                                <span >
                                <strong class="error_messages" >{{ $errors->first('name') }}</strong>
                                </span>
                                @endif

                                </div>



                                <div class="col-md-6">
                                <input type="text" class="form-control" placeholder ="Type Vendor Phone here..." value="{{old('contact')}}" name="contact">
                                @if ($errors->has('contact'))
                                <span >
                                <strong class="error_messages" >{{ $errors->first('contact') }}</strong>
                                </span>
                                @endif

                                </div>


                                </div>


                                <div class="form-group">
                                <div class="col-md-12">
                                <label class="col-md-12">Address</label>
                                <textarea class="form-control" name="address" rows="3">{{old('address')}}</textarea>
                                @if ($errors->has('address'))
                                <span >
                                <strong class="error_messages" >{{ $errors->first('address') }}</strong>
                                </span>
                                @endif
                                </div>
                                </div>


                                <div class="form-group">
                                <div class="col-md-12">
                                <label class="col-md-12">Description</label>
                                <textarea class="form-control" name="description" rows="5">{{old('description')}}</textarea>
                                </div>
                                </div>


                                <div class="form-group">

                                <div class="col-md-12">
                                <button type="submit" class="btn btn-success waves-effect waves-light m-r-10">Submit</button>
                                </div>
                                </div>

                               
                               
                                	
                            </form>
                        </div>
                    </div>
                </div>

      </div>
@stop