@extends('layouts.app')

@section('title')
All Project
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Projects</li>
      </ol>
@stop

@section('content')
  <div class="container-fluid">
    <div class="row">
                    
<div class="col-sm-12">
                        <div class="white-box">
                           
                             <h3 class="box-title m-b-0"><a class="btn btn-info" href="{{ route('project.add') }}">Add New Project</a></h3>
                            <div class="table-responsive">
                             
                            @if(Session::has('success'))   
                            <div id="successMessage" class="alert alert-success" role="alert">
                            {{ Session::get('success') }}
                            </div>
                            @endif

                                <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                                    <thead>
                                        <tr role="row">
                                        	<th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Name</th>

                                            <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Contact</th>

                                            <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 220px;">Address</th>

                                        	<th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 348px;">Description </th>

                                        	<th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Created Date</th>

                                            <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 163px;">Action</th>


                                        </tr>
                                    </thead>
                                    <tbody>
  
                                    @if( $projectList->count() > 0 )
                                    @foreach( $projectList as $list )

                                        <tr role="row" class="odd">
                                            <td>{{$list->project_name}}</td>
                                            <td>0{{$list->contact}}</td>
                                            <td>{{$list->address}}</td>
                                            <td>{{$list->description}}</td>
                                            <td>{{$list->created_at}}</td>
                                             <td>
                                                <a style="color:red;" href="{{ route('project.delete',[$list->id] ) }}" data-toggle="confirmation" data-title="Are you sure to delete?" ><i class="fa fa-trash-o" aria-hidden="true"></i></a>

                                                 <a style="margin-left: 1rem;"  href="{{ route('project.edit',[$list->id] ) }}"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>

                                            </td>

                                        </tr>
                                     @endforeach   
                                     @endif

                                      
                                    </tbody>
                                </table>
                                
                            </div>
                            </div>
                        </div>
                    </div>


    </div>

      </div>
@stop
