@extends('layouts.app')

@section('title')
Purchase Order Receipt
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Purchase Order Receipts</li>
      </ol>
@stop
@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
@stop
@section('content')
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        <div class="white-box">

                                <div class="printableArea">  
                           
                          <h3 class="box-title" style="margin-bottom: 3rem;"> <b style="font-size: 2.2rem;color: gray;">Receipts</b>
                          

                          </h3>

                              <table id="myTable" style="margin-top: 5rem;" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
	                            <thead>
								<tr role="row">

								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Po#</th>


								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Vendor</th>

								
								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Total Amount</th>

								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;"> Pay Amount</th>

								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Remaining Amount</th>

								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 130px;">Status</th>


								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 200px;text-align: center;">Date</th>


								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Action</th>

								</tr>

	                            </thead>
                                <tbody>
  
			                   	@foreach($total_receipts as $pr )
								@foreach($pr->receipts as $list )
								@php
								$vendor = \App\PurchaseRequestVendor::find($list->vendor_id);
								@endphp
			                    <tr role="row" class="odd">

			                    <td>
			                    	@permission('list-purchase-order')
			                    	<a href="{{url('purchase-orders/detail?vendor='.Crypt::encryptString($vendor->id).'&purchase_request='.Crypt::encryptString($list->purchase_request_id).'')}}"  target="_blank" >PO-{{ucfirst($list->purchase_order_id)}}</a> 
			                    	@else

			                    	PO-{{ucfirst($list->purchase_order_id)}}
			                    	@endpermission
			                    </td>

								<td>
									@permission('view-vendor')
									<a href="{{ route('vendor.view' ,[$vendor->id]) }}">{{ucfirst($vendor->name)}}</a>
									@else
									{{ucfirst($vendor->name)}}
									@endpermission </td>
								
								<td>{{number_format($list->total_amount , 2)}}</td>

								<td>{{number_format($list->total_pay_amount, 2)}}</td>

								<td>{{number_format($list->remaining_amount, 2)}}</td>

								<td>
									
								@if($list->status == 0)
								<div style="background: red;color: white;text-align: center;font-size: 1.5rem;padding: 2px 0px 2px 0px;border-radius: 20px;">UNPAID</div>
								@elseif($list->status == 1)

								<div style="background: #2bd600;color: white;text-align: center;font-size: 1.5rem;padding: 2px 0px 2px 0px;border-radius: 20px;">PAID</div>

								@elseif($list->status == 2)

								<div style="background: #f5c516;color: white;text-align: center;font-size: 1.3rem;padding: 2px 0px 2px 0px;border-radius: 20px;">PARTIALLY PAID</div>
								@endif
								</td>


                                <td style="line-height: 30px;font-size: 15px;text-align: center;">
                                	<b>Created At :</b><br> {{date('d-F-Y' , strtotime($list->receipt_date))}}
                                	@if(!empty($list->receipt_pay_date))
                                	<br>
                                	<hr>
                                    <b>Paid At :</b> <br> {{date('d-F-Y' , strtotime($list->receipt_pay_date)) }}
                                	@endif
                                </td>

								<td>

									@permission('list-po-receipt')
								
								<a href="{{url('purchase-order-receipts/detail?vendor='.Crypt::encryptString($vendor->id).'&purchase_order='.Crypt::encryptString($list->purchase_order_id).'&receipt_id='.Crypt::encryptString($list->id).'&purchase_request='.Crypt::encryptString($list->purchase_request_id).'')}}" class="btn btn-success btn-sm" target="_blank">View</a> 
								@endpermission
								</td>

			                    </tr>
                              
			                    @endforeach   
 @endforeach  
			                    </tbody>
			                    </table>

             
								</div>

								</div>
								</div>
								</div>
								</div>
@stop