@extends('layouts.app')

@section('title')
Purchase Order Receipt
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Purchase Order Receipts</li>
      </ol>
@stop
@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
@stop
@section('content')
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        <div class="white-box" id="printableSection">


							<h3 class="box-title avoid-this" style="margin-bottom: 3rem;"> <b style="font-size: 2.2rem;">PO-{{$purchase_order->id}} / <span style="font-size: 1.5rem;">Receipt # {{$receipt->id}}</span> </b> <span style="float: right;">Receipt Date : <span class="blk_clr_dt  blk_clr">{{date('d-F-Y h:i a' , strtotime($receipt->receipt_date))}}</span></span>
							<br>
							@if(!empty($receipt->receipt_pay_date))
							<span style="float: right;">Pay Date : <span class="blk_clr_dt  blk_clr">{{date('d-F-Y h:i a' , strtotime($receipt->receipt_pay_date))}}</span></span>
							@endif
							</h3>


							<div class="alert alert-success" role="alert" style="display:none;" id="succeessMessage">
							PAID.
							</div>

                                
                               	
                                <div class="">  

								@if($receipt->status == 0)
								<h1 class="avoid-this" style="width: 22%;border: 5px solid red;border-radius: 7px;text-align: center;color: red;font-weight: bold;position: relative;bottom: 0px;margin-right: 3rem;">UNPAID</h1>
								@elseif($receipt->status == 1)

								<h1  class="avoid-this" style="width: 20%;border: 5px solid #4fde06;border-radius: 7px;text-align: center;color: #4fde06;font-weight: bold;position: relative;bottom: -20px;margin-right: 3rem;">PAID</h1>

								@elseif($receipt->status == 2)

								<h1  class="avoid-this" style="width: 20%;border: 5px solid #e2c601;border-radius: 7px;font-size: 2rem;text-align: center;color: #e2c601;font-weight: bold;position: relative;bottom: -20px;margin-right: 3rem;">PARTIALLY PAID</h1>

								@endif
 
								<div class="row avoid-this">

								<div class="col-md-12 col-xs-12 ">
								<h3 class="box-title"><b >Vendor Details</b></h3>

								<div class="col-md-4 col-xs-4 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold">Name</span>
								<span style="margin-left: 5px;font-weight: 400;" class="blk_clr">
								{{ Ucfirst($vendor->name)}}
								</span>
								</div>

								<div class="col-md-4 col-xs-4 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold">Phone</span>
								<span style="margin-left: 5px;font-weight: 400;" class="blk_clr">
								0{{ $vendor->phone_number}}
								</span>
								</div>


								<div class="col-md-4 col-xs-4 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold">Email</span>
								<span style="margin-left: 5px;font-weight: 400;" class="blk_clr">
								{{ $vendor->email }}
								</span>
								</div>


								<div class="col-md-4 col-xs-4 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold">Cnic</span>
								<span style="margin-left: 5px;font-weight: 400;" class="blk_clr">
								{{ $vendor->cnic }}
								</span>
								</div>

								<div class="col-md-8 col-xs-8 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold">Address</span>
								<span style="margin-left: 5px;font-weight: 400;" class="blk_clr">
								{{ $vendor->address }}
								</span>
								</div>


								</div>

								<div class="col-md-12 col-xs-12" style="margin-top: 2rem;">

								<h3 class="box-title"><b >Company Details</b>
								</h3>

								<div class="col-md-3 col-xs-3 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold">Company</span>
								<span style="margin-left: 5px;font-weight: 400;" class="blk_clr">
								{{ env('APP_NAME') }}
								</span>
								</div>

								<div class="col-md-3 col-xs-4 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold">Contact</span>
								<span style="margin-left: 5px;font-weight: 400;" class="blk_clr">
								{{ env('APP_CONTACT') }}
						    	</span>
								</div>


								<div class="col-md-6 col-xs-5 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold">Address</span>
								<span style="margin-left: 5px;font-weight: 400;" class="blk_clr">
								{{ env('APP_ADDRESS') }}
								</span>
								</div>
								
								</div>

								</div>


<center><div class="row hide-default" >
							<h3 class="box-title">
							<?= (env('DOCUMENT_LOGO')) ? '<img src="'.asset(env('DOCUMENT_LOGO')).'" class="logo-img"><br>' : '' ?>
							{{env('APP_NAME')}}
							</h3>

							<div class="col-md-12" id="GRN-CNG" style="border: 1px solid;color: black; text-align: center;font-weight: bold;padding: 1rem;font-size: 1.5rem; margin-bottom: 3rem;">
							PURCHASE ORDER RECEIPT
							</div>


							<div class="col-md-6 col-xs-6">
							<div class="row">
							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;">
							RECEIPT ID
							</div>

							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;">
								{{$receipt->id}}
								
							</div>

							</div>
							</div>



							<div class="col-md-6 col-xs-6">
							<div class="row">
							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;">
							STATUS
							</div>

							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;">
								@if($receipt->status == 0)
								{{ 'UNPAID' }}
								@elseif($receipt->status == 1)

								{{ 'PAID' }}

								@elseif($receipt->status == 2)

								{{ 'PARTIALLY PAID' }}</h1>

								@endif
							</div>

							</div>
							</div>


							<div class="col-md-6 col-xs-6">
							<div class="row">
							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem; margin-bottom: 3rem;">
							PO NO.
							</div>

							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;">
							{{$purchase_order->id}}
							</div>

							</div>
							</div>

							<div class="col-md-6 col-xs-6">
							<div class="row">
							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;">
							RECEIPT DATE
							</div>

							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;">
								 {{date('d-F-Y' , strtotime( $receipt->receipt_date))}}
							</div>

							</div>
							</div>


							



							<div class="col-md-12 col-xs-12">
							<div class="row">

						
							<div class="col-md-12" style="border: 1px solid;color: black; text-align: left;font-weight: bold;padding: 1rem;font-size: 1.5rem; margin-bottom: 3rem;">
							BILL TO:
							</div>


							<table style="width: 100%;margin-top: -3rem;" id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
							<thead>
							<tr role="row">
							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Name </th>

							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Phone </th>

							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">STRN </th>

							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">NTN </th>

							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">T. C. No </th>

							</tr>
							</thead>
							<tbody>
							<tr role="row" class="odd">
							<td>{{ Ucfirst($vendor->name)}}</td>
							<td>0{{ $vendor->phone_number}}</td>
							<td>{{ $vendor->stn}}</td>
							<td>{{ $vendor->ntn}}</td>
							<td>{{ $vendor->test_certificate}}</td>
							</tr>
							</tbody>
							</table>

							</div>
							</div>




							<div class="col-md-12 col-xs-12">
							<div class="row">

						
							<div class="col-md-12" style="border: 1px solid;color: black; text-align: left;font-weight: bold;padding: 1rem;font-size: 1.5rem; margin-bottom: 3rem;">
							SHIP TO:
							</div>


							<table style="width: 100%;margin-top: -3rem;" id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
							<thead>
							<tr role="row">
							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Project </th>

							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Phone </th>

							</tr>
							</thead>
							<tbody>
							<tr role="row" class="odd">
							<td>{{ env('APP_NAME') }}</td>
							<td>{{ env('APP_CONTACT') }}</td>

							</tr>
							</tbody>
							</table>

							</div>
							</div>




							</div>
							</center>



								<h3 style="text-align:right;" class="box-title avoid-this" style="margin-top: 5rem;">
								<b style="margin-top: 1rem; float: left;"> Items </b>

								<a class="btn btn-warning avoid-this" id="print" href="#">Print</a>
								
								<a class="btn btn-warning avoid-this" id="grn" href="#">GRN</a>
								</h3>

                              <table id="myTable" style="margin-top: -0.2rem;" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
	                            <thead>
								<tr role="row">

								<th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Code</th>
								

								<th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Item - Brand</th>

								<th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Description</th>


								<th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Quantity</th>


								<th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 203px; text-align: center;">Price</th>

								</tr>

	                            </thead>
                                <tbody>
								
								@php $count = 0; $quantity = 0; 
								$vendor_item_price = 0; @endphp
								@foreach($receipt->ReceiptItems as $list )
                                
								<tr role="row" class="odd"  >


								@php 
								$item = \App\Item::withTrashed()->find($list->item_id);

								$item_cs = \App\ComparativeStatement::getItemPrices($purchase_request_id , $vendor->id , $list->item_id)['item'];
								@endphp

							    <td>{{$item->item_code}} </td>

								<td class="item_name">
								{{$item->item_name}} - {{$item->manufacture->name}}
								<?= ($item->risk_type == 'critical') ? '<span class="critical">Critical</span>' : '<span class="non_critical">Non Critical</span>' ?>
								</td>

								<td class="description"> 
								<span class="default-text">{{$purchase_request->item->where('item_id' , $list->item_id )->first()->description}}</span>
								<span class="after-load-more" style="display:none;"></span>
								</td>

								<td>{{number_format($list->pass_quantity, 2)}} </td>

                                <td style="text-align:center;">
									PKR {{number_format($item_cs->price , 2)}}
								</td>

								</tr>

								 @php
								
								 $count ++;
								
								 $quantity += $list->pass_quantity; 

								 @endphp

								 @endforeach 
								

								</tbody>
								</table>



<center><div class="row hide-default" >
						
<table style="width: 100%;" id="myTable" style="margin-top: -1rem;" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
							<thead>
							<tr role="row">
							<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Total Item(s)</th>

							<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Item(s) Qty</th>

							<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Amount To Pay</th>

							<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Paid Amount</th>


							<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Due Amount</th>

							</tr>

							</thead>
							<tbody>


							<tr role="row" class="odd">

							<td>{{number_format($count, 2)}}</td>

							<td>{{number_format($quantity, 2)}} </td>

							<td>PKR {{number_format($receipt->total_amount , 2) }}</td>

							<td>PKR {{number_format($receipt->total_pay_amount , 2)}}</td>

							<td>PKR {{number_format($receipt->remaining_amount , 2)}}</td>
							</tr>

							</tbody>
							</table>


							
								<div class="col-md-12" style="border: 1px solid;color: black; text-align: center;font-weight: bold;padding: 1rem;font-size: 1.5rem; margin-bottom: 3rem;margin-top: 0rem;">
									Authorized By
								</div>


							<table style="width: 100%;" id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
							<thead>
							<tr role="row">
							<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Name</th>

							<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Date</th>

							<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Signature</th>

							</tr>

							</thead>
							<tbody>


							<tr role="row" class="odd">

							<td>@if($receipt->account_officer_name) {{ $receipt->account_officer_name }} @else {{'.'}} @endif </td>

							<td>@if($receipt->account_officer_name_date) {{date('d-F-Y' , strtotime($receipt->account_officer_name_date))}} @else {{'.'}} @endif  </td>

							<td></td>
							</tr>

							</tbody>
							</table>


							</div>
							</center>

							<div style="float-left:right;color:black !important; " class="hide-default">
							@if($receipt->receipt_pay_date)
							<span style="float: right; margin-top: 2rem;"><b>Pay Date : </b>{{date('d-F-Y' , strtotime($receipt->receipt_pay_date))}}
							</span>
							<br>
							@endif
							<b>Date : </b> {{date('d-F-Y')}}
							<br>
							<b >Print By : </b>{{ Ucfirst(Auth::user()->name) }}
							</div>

								<div style="text-align: right;">
								<div class="row avoid-this">

								<div class="col-md-6 col-xs-6">
								<form method="POST" style="float: left;" onsubmit="return add_account_officer('{{$receipt->id}}' , this )" >

								<span style="color:black;margin-top: 6rem;" class="dis_block">Accounts Officer Name & Signature</span>

								<input type="text" placeholder="Type here ..." style="border:none;border-bottom: 1px solid gray; margin-top: 5rem;margin-left: 1rem;font-size: 1.2rem;" value="{{$receipt->account_officer_name}}" id="name_account_officer">

								<button class="avoid-this" type="submit" style="background: transparent;border: none;"><i style="color:#d4af37" class="fa fa-pencil-square" aria-hidden="true"></i>
								</button>

								</form>
								</div>

								<div class="col-md-6 col-xs-6" style="text-align: right;">
								<div class="pricing-section">
								<p>
								<b style="color:black;" class="us-text">Total Item:</b> <span style="margin-left: 10rem;" class="blk_clr"> {{number_format($count, 2)}}</span>
								</p>

								<p>
								<b style="color:black;" class="us-text">Total Item Quantity:</b> <span style="margin-left: 9.5rem;" class="blk_clr"> {{number_format($quantity, 2)}}</span>
								</p>

                               	<p>
								<b style="color:black;" class="us-text">Total Amount To Pay:</b> 
								<span style="margin-left: 3rem" class="blk_clr"> 
								PKR {{number_format($receipt->total_amount , 2) }}
								</span>
									</p>

									<p>
								<b style="color:black;" class="us-text">Total Paid:</b> 
								<span style="margin-left: 3rem" class="blk_clr"> 
								PKR {{number_format($receipt->total_pay_amount , 2) }}
								</span>
									</p>


								<b style="color:black;" class="us-text">Remaining Amount:</b> 
								<span style="margin-left: 3rem" class="blk_clr"> 
								PKR {{number_format($receipt->remaining_amount , 2) }}
								</span>
					
								</div>
							</div>
						</div>

								</div>

								</div>
								</div>
								</div>
								</div>
								</div>




							<div class="modal fade" id="receiptModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel1">
							<div class="modal-dialog" role="document">
							<div class="modal-content">
							<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
							<h4 class="modal-title" id="exampleModalLabel1">PO Receipt </h4></div>
							<div class="modal-body">

							<div class="alert alert-danger" role="alert" style="display:none;"  id="errorMessage">
							
							</div>



							<div class="alert alert-success" role="alert" style="display:none;"  id="succeessModalMessage">
							Succussfully paid.
							</div>

							<form method="POST" onsubmit="return payToOrder('{{$purchase_request_id}}' , '{{$vendor->id}}' , this)">

								<label>Total Amount to Pay is 
								PKR {{number_format($receipt->remaining_amount , 2) }}
								</label>

								<br>
								<br>

								<input type="text" placeholder="Enter Price in number to pay"  class="form-control" id = "amount_to_pay">


							</div>
							<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
							<button type="submit" class="btn btn-primary" id="thisBtn" >Pay</button>
							</form>

							</div>
							</div>
							</div>
							</div>



<div class="container-fluid" id="grn_section" style="margin-top: -100px;">
<div class="row">
<div class="col-md-12">
<div class="white-box">
<h3 class="box-title" style="text-align: center;"> 
<b style="font-size: 2.2rem;color: gray;">GOOD RECEIVING NOTE</b>
</h3>
</div>
</div>
</div>
</div>


	<div class="container-fluid" style="margin-top: -450px;">
	<div class="row">
	<div class="col-md-12">
	<div class="white-box" >

	<div class="grn_section" id="grn_{{$receipt->id}}">  
     <div class="row avoid-this">

								<div class="col-md-6">
								<h3 class="box-title"><b style="color: gray;font-weight: bold;">PO No: {{$purchase_order->id}}</b></h3>

								<div class="col-md-12" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;">Supplier Name</span>
								<span style="margin-left: 5rem;font-weight: 400;" class="blk_clr">
								{{ Ucfirst($vendor->name)}}
								</span>
								</div>

								<div class="col-md-12" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;">Delivery Date : </span>
								<span style="margin-left: 5.3rem;font-weight: 400;" class="blk_clr">
								{{date('d-F-Y' , strtotime($purchase_order->delivery_date))}}
								</span>
								</div>


								<div class="col-md-12" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;">Received By </span>
								<span style="margin-left: 7rem;font-weight: 400;" class="blk_clr">
								{{Ucfirst($receipt->po_receiver_name)}}
								</span>
								</div>


								<div class="col-md-12" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;">Receiving Date</span>
								<span style="margin-left: 5.5rem;font-weight: 400;" class="blk_clr">
								{{date('d-F-Y' , strtotime($receipt->po_receiveing_date))}}
								</span>
								</div>

					
						</div>

					</div>

<center><div class="row hide-default" >
							<h3 class="box-title">
							<?= (env('DOCUMENT_LOGO')) ? '<img src="'.asset(env('DOCUMENT_LOGO')).'" class="logo-img"><br>' : '' ?>
							{{env('APP_NAME')}}
							</h3>

							<div class="col-md-12" id="GRN-CNG" style="border: 1px solid;color: black; text-align: center;font-weight: bold;padding: 1rem;font-size: 1.5rem; margin-bottom: 3rem;">
							GOODS RECEIVED NOTE
							</div>

							<div class="col-md-6 col-xs-6">
							<div class="row">
							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem; margin-bottom: 3rem;">
							PO NO.
							</div>

							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;">
							{{$purchase_order->id}}
							</div>

							</div>
							</div>

							<div class="col-md-6 col-xs-6">
							<div class="row">
							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;">
							INVOICE NO
							</div>

							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;">
								@if(!empty( $receipt->invoice_no) ) {{ $receipt->invoice_no }} @else {{'.'}}@endif

							
							</div>

							</div>
							</div>


							<div class="col-md-12 col-xs-12">
							<div class="row">

						
							<div class="col-md-12" style="border: 1px solid;color: black; text-align: left;font-weight: bold;padding: 1rem;font-size: 1.5rem; margin-bottom: 3rem;">
							Received  From
							</div>


							<table style="width: 100%;margin-top: -3rem;" id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
							<thead>
							<tr role="row">
							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Name </th>

							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Phone </th>

							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">STRN </th>

							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">NTN </th>

							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">T. C. No </th>

							</tr>
							</thead>
							<tbody>
							<tr role="row" class="odd">
							<td>{{ Ucfirst($vendor->name)}}</td>
							<td>0{{ $vendor->phone_number}}</td>
							<td>{{ $vendor->stn}}</td>
							<td>{{ $vendor->ntn}}</td>
							<td>{{ $vendor->test_certificate}}</td>
							</tr>
							</tbody>
							</table>

							</div>
							</div>

							</div>
							</center>


  <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
	                            <thead>
								<tr role="row">


								<th class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 50px;">Code</th>
								

								<th class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 150px;">Item</th>


								<th class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 150px;">Description</th>


								<th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Receive Quantity</th>


								<th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Pass Quantity</th>


								<th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px; text-align: center;">Price</th>

								</tr>

	                            </thead>
                                <tbody>
								
								@php $count = 0; $quantity = 0; 
								$vendor_item_price = 0; $pass_quantity = 0; @endphp
								@foreach($receipt->ReceiptItems as $list )
                                
								<tr role="row" class="odd"  >

								@php 
								$item = \App\Item::withTrashed()->find($list->item_id);

								$item_cs = \App\ComparativeStatement::getItemPrices($purchase_request_id , $vendor->id , $list->item_id)['item'];
								@endphp

							    <td>{{$item->item_code}} </td>

								<td class="item_name">
								{{$item->item_name}} - {{$item->manufacture->name}}
								<?= ($item->risk_type == 'critical') ? '<span class="critical">Critical</span>' : '<span class="non_critical">Non Critical</span>' ?>
								</td>


								<td class="description"> 
								<span class="default-text">{{$purchase_request->item->where('item_id' , $list->item_id )->first()->description}}</span>
								<span class="after-load-more" style="display:none;"></span>
								</td>


								<td>{{number_format($list->quantity, 2)}} </td>

								<td>{{number_format($list->pass_quantity, 2)}} </td>

                                <td style="text-align:center;">
									PKR {{number_format($item_cs->price , 2)}}
								</td>

								</tr>

								 @php
								
								 $count ++;
								
								 $quantity += $list->quantity; 

								 $pass_quantity += $list->pass_quantity; 

								 @endphp

								 @endforeach 
								

								</tbody>
								</table>

								<center>
							<div class="row hide-default">
							<div class="col-md-6 col-xs-6">
							<div class="row">
							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem; margin-bottom: 3rem;font-weight: bold;">
							Received BY
							</div>

							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;">
							{{ucfirst($receipt->po_receiver_name)}}
							</div>

							</div>
							</div>

							<div class="col-md-6 col-xs-6">
							<div class="row">
							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;font-weight: bold;">
							Received Date
							</div>

							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;">
							{{date('d-F-Y' , strtotime($receipt->po_receiveing_date))}}
							</div>

							</div>
							</div>

							<div class="col-md-12 col-xs-12">
							<div class="row">
							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;font-weight: bold;">
							Material Inspection Documents Received
							</div>

							<div class="col-md-3 col-xs-3" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;">
							Yes @if(!empty($receipt->quality_insu_docs)) <i class="fa fa-check" aria-hidden="true"></i> @endif
							</div>

							<div class="col-md-3 col-xs-3" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;">
							No @if(empty($receipt->quality_insu_docs))  <i class="fa fa-check" aria-hidden="true"></i> @endif
							</div>

							</div>
							</div>


							<div class="col-md-12" style="border: 1px solid;color: black; text-align: center;font-weight: bold;padding: 1rem;font-size: 1.5rem; margin-bottom: 3rem;margin-top: 12rem;">
									Approved By
							</div>


							 <table style="width: 100%;" id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
	                            <thead>
								<tr role="row">
								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Name</th>
								
								<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Date</th>

								<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Signature</th>

								</tr>

	                            </thead>
                                <tbody>
  
			           
								<tr role="row" class="odd">

								<td>@if($receipt->quality_test_inspector_name) {{$receipt->quality_test_inspector_name}}@else {{'.'}} @endif </td>

								<td>@if($receipt->quality_test_inspector_date) {{date('d-F-Y' , strtotime($receipt->quality_test_inspector_date))}} @else {{'.'}} @endif</td>

								<td></td>
								</tr>
					
			                    </tbody>
			                    </table>
						</div>
					</center>
					<div style="float-left:right;color:black !important; " class="hide-default">
						<b>Date : </b> {{date('d-F-Y')}}
						<br>
						<b >Print By : </b>{{ Ucfirst(Auth::user()->name) }}
						</div>



								 <div class="row avoid-this">
                                <div class="col-md-6 col-xs-6">
                                	<span style="color:black;margin-top: 6rem;">Name & Signature</span>
						
						<input type="text" readonly placeholder="Type here ..." style="border:none;border-bottom: 1px solid gray; margin-top: 5rem;margin-left: 1rem;font-size: 1.2rem;color: black;" value="{{$receipt->quality_test_inspector_name}}" id="inspector_name">

                                </div>
								<div class="col-md-6 col-xs-6" style="text-align: right;">
								<div class="pricing-section">
								<p>
								<b style="color:black;" class="us-text">Total Item:</b> <span style="margin-left: 10rem;" class="blk_clr"> {{number_format($count, 2)}}</span>
								</p>

								<p>
								<b style="color:black;" class="us-text">Pass Item Quantity:</b> <span style="margin-left: 9.5rem;" class="blk_clr"> {{number_format($pass_quantity, 2)}}</span>
								</p>


                               	<p>
								<b style="color:black;" class="us-text">Total Amount To Pay:</b> 
								<span style="margin-left: 3rem" class="blk_clr"> 
								PKR {{number_format($receipt->total_amount , 2) }}
								</span>
							    </p>

								</div>
							</div>
					
								</div>


	</div>
<button type="button" onclick="return print_grn('{{$receipt->id}}')" class="btn btn-xs btn-primary">Print</button>

@if(!empty($receipt->documents))
<h3 style="margin-top: 5rem;margin-bottom: 3rem;">Invoice Documents</h3>
@php
$images = json_decode($receipt->documents , true);
$file_ext = array('docx','pdf');
echo '<div class="row">';
for($img = 0; $img < count($images); $img++)
{
	$url = asset('storage/uploads/'.$images[$img]);
$urlExt = pathinfo($url, PATHINFO_EXTENSION);
if (!in_array($urlExt, $file_ext)) 
{
echo '<div class="col-md-2" ><a target="_blank" href="'.url('storage/uploads/'.$images[$img]).'"><img  title="Image" style="height: 100px;border-radius: 10px;" class="img-responsive" src="'.url('storage/uploads/'.$images[$img]).'"></a></div>';
}
if (in_array($urlExt, $file_ext)) 
{
echo '<div class="col-md-2" ><a target="_blank" href="'.url('storage/uploads/'.$images[$img]).'"><img title="'.ucfirst($urlExt).' File" style="height: 100px;border-radius: 10px;" class="img-responsive" src="'.url('storage/file.jpg').'"></a></div>';
}
}
echo '</div>';
@endphp
@endif
	</div>
	</div>
	</div>
	
@Stop


@section('js')  

<script type="text/javascript">

$(document).ready(function() {

$('.odd').each(function()
{
var description = $(this).find('.description .default-text').text();
// var word = description.split(" ");
if(description.length > 20 )
{
$(this).find('.after-load-more').html(description);
var content =   description.slice(0 , 20)+'... <a href="javascript:void(0)" onclick="return showContent(this)">load more</a>'
$(this).find('.description .default-text').html(content);
}

});

});
function showContent(self) {
$(self).closest('.description').find('.after-load-more').show();
$(self).closest('.description').find('.default-text').hide();
}


		function add_account_officer(receipt_id , self )
	{
	    var name_account_officer = $(self).find('#name_account_officer').val();

		$.ajaxSetup({
		headers: {
		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		}
		});

		$.ajax({
		url:"{{ route('purchase-orders-receipts.add_account_officer') }}",
		method:'POST',
		dataType:'json',
		data: {name_account_officer:name_account_officer,receipt_id:receipt_id},
		success:function(data)
		{
           if(data.response == 'invalid')
           {
               alert(data.message)
           }
           else if(data.response == 'yes')
           {
		       	alert('Successfully Added.')
		       	location.reload(true)
           }
           else
           {
	           	alert('Something went wrong.')
	           	location.reload(true)
           }
		}
		})

	return false;
	}


	function payToOrder(pr_id , vendor_id , self) {
		
		
		$('#thisBtn').html('Please Wait...')
		$('#thisBtn').prop('disabled' , true);
	
        var amount_to_pay   = $('#amount_to_pay').val();

      $.ajaxSetup({
		headers: {
		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		}
		});

		$.ajax({
		url:"{{ route('purchase-order-receipts.pay') }}",
		method:'POST',
		dataType:'json',
		data: {pr_id:pr_id , receipt_id : '{{$receipt->id}}' , amount_to_pay :amount_to_pay ,vendor_id:vendor_id},
		success:function(data)
		{
           if(data.response == 'yes')
           {
				$("#succeessModalMessage").show('slow')
				setTimeout(function(){ location.reload(true);}, 3000);
           }
           else if(data.response == 'invalid_value')
           {
           	$("#errorMessage").html(data.message)
           	$("#errorMessage").show('slow')
		    setTimeout(function(){ $("#errorMessage").hide('slow')}, 3000);
		    $('#thisBtn').html('Pay')
	    	$('#thisBtn').prop('disabled' , false);
           }
           else
           {
           	alert('Something went wrong.')
           	location.reload(true);
           }
		}
		})

	  return false;
	}

    

function print_grn(id)
{

$("div#grn_"+id).print({
//Use Global styles
globalStyles : true,
//Add link with attrbute media=print
mediaPrint : false,
iframe : false,
//Don't print this
noPrintSelector : ".avoid-this",
//Add this at top
// prepend : "<b>Print By </b> {{ Ucfirst(Auth::user()->name) }} <br/> <b>Date </b> {{date('d-F-Y')}} <br/>  ",
//Add this on bottom
// append : "<span><br/>GOOD LUCK!</span>",
//Log to console when printing is done via a deffered callback
deferred: $.Deferred().done(function() { console.log('Printing done', arguments); })
});
	return false;
}

$("#grn").click(function() {
    $('html, body').animate({
        scrollTop: $("#grn_section").offset().top
    }, 1000);
});


</script>

@stop