@extends('layouts.app')

@section('title')
Purchase Order Receipt
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Purchase Order Receipts</li>
      </ol>
@stop
@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
@stop
@section('content')
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        <div class="white-box">

                                <div class="printableArea">  
                           
                          <h3 class="box-title" style="margin-bottom: 3rem;"> <b style="font-size: 2.2rem;color: gray;">Receipts /   </b>PR-{{$pr_id}} 
                          

                          </h3>

                              <table id="myTable" style="margin-top: 5rem;" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
	                            <thead>
								<tr role="row">

								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Po#</th>


								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Vendor</th>


								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Receipt ID#</th>

								
								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Total Amount</th>

								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;"> Pay Amount</th>

								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Remaining Amount</th>

								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 130px;">Status</th>


								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Action</th>

								</tr>

	                            </thead>
                                <tbody>
  
			                   
			                    @foreach($vendors as $list )


			                    @foreach($list->receipts as $receipt)
                               
                            	@if($receipt->status != 3 && $receipt->receipt_type == 1)

			                     <tr role="row" class="odd">

			                    <td>
			                    	@permission('list-purchase-order')
			                    	<a href="{{url('purchase-orders/detail?vendor='.Crypt::encryptString($list->id).'&purchase_request='.Crypt::encryptString($pr_id).'')}}"  target="_blank">PO-{{ucfirst($receipt->purchase_order_id)}}</a>
			                    	@else

			                    	PO-{{ucfirst($receipt->purchase_order_id)}}
			                    	@endpermission </td>

								<td>
									@permission('view-vendor')
									<a href="{{route('vendor.view' , [$list->id])}}">{{ucfirst($list->name)}}</a>
									@else
									{{ucfirst($list->name)}}
									@endpermission </td>

								<td>{{$receipt->id}} </td>

								
								<td>
									{{number_format($receipt->total_amount , 2)}}
								</td>

								<td>
									{{number_format($receipt->total_pay_amount, 2)}}
								</td>

								<td>{{number_format($receipt->remaining_amount, 2)}}</td>


								<td>
									
									@if($receipt->status == 0)

								<div style="background: red;color: white;text-align: center;font-size: 1.5rem;padding: 2px 0px 2px 0px;border-radius: 20px;">UNPAID</div>
								@elseif($receipt->status == 1)

								<div style="background: #2bd600;color: white;text-align: center;font-size: 1.5rem;padding: 2px 0px 2px 0px;border-radius: 20px;">PAID</div>

								@elseif($receipt->status == 2)

								<div style="background: #f5c516;color: white;text-align: center;font-size: 1.3rem;padding: 2px 0px 2px 0px;border-radius: 20px;">PARTIALLY PAID</div>
								@endif
								</td>

								<td>
								
								@permission('list-po-receipt')
								<a href="{{url('purchase-order-receipts/detail?vendor='.Crypt::encryptString($list->id).'&purchase_order='.Crypt::encryptString($receipt->purchase_order_id).'&receipt_id='.Crypt::encryptString($receipt->id).'&purchase_request='.Crypt::encryptString($pr_id).'')}}" class="btn btn-success btn-sm" target="_blank">View</a> 
								@endpermission
								</td>

			                    </tr>
			                @endif
                                    @endforeach 
			                    @endforeach   

			                    </tbody>
			                    </table>

             
								</div>

								</div>
								</div>
								</div>
								</div>
@Stop

