@extends('layouts.app')

@section('title')
Purchase Order
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Purchase Orders</li>
      </ol>
@stop
@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
@stop
@section('content')
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                      <div class="white-box " id="printableSection">

							<h3 class="box-title avoid-this" style="margin-bottom: 3rem;"> 
							<span style="font-size:2.5rem;">Pr-{{$purchase_request_id}} / </span> <b style="font-size: 2rem;"> PO # {{$purchase_order->id}} </b>
							<span style="float: right;" class="blk_clr">
							Current Status: 
							@if($purchase_order->status == 1) 
							<span class="blk_clr" style="font-size: 1.5rem;color: #fbc603;margin-left: 1rem;">
							PO Sent 
							</span> 
							
							@elseif($purchase_order->status == 2) 
							<span style="font-size: 1.5rem;color: #65d400;margin-left: 1rem;">Received </span>
							
							@elseif($purchase_order->status == 3) 
							<span style="font-size: 1.5rem;color: #d4ba00;margin-left: 1rem;">
							Partially Received 
							</span> 
							
							@endif
							</span>
							</h3>
					
<div class="container">
					<div class="row hide-default">
						<div class="col-md-12 ">
							<h3 class="box-title text-right" style="margin-bottom: 5rem;">
								<span class="">
									<b class="font-size">PURCHASE ORDER</b>
								</span>
							</h3>
						</div>
					</div>
				</div>

				<div class="row hide-default">
					<div class="col-lg-9 col-md-9 col-sm-9 col-xs-9">

						<h3 class="box-title" style="margin: 0;">
							<span class="float-left" style="border: 1px solid black; padding: 20px 10px;">
								<b class="font-size">{{env('APP_NAME')}}</b>
							</span>
						</h3>
					</div>
					<div class="col-lg-3 col-md-3 col-sm-3 col-xs-3">
						<table style="width: 100%; margin: 0;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid" >
							<tbody>
								<tr>
									<td>No:</td>
									<td><center>FGI/FI/{{$purchase_order->id}}</center></td>
								</tr>
								<tr>
									<td>Date:</td>
									<td>{{date('d-F-Y' , strtotime($purchase_order->created_at))}}</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
				
				<br>
				
				<div class="row hide-default">
					<div class="col-md-12 col-xs-12">TO:</div>
				</div>

				<div class="row hide-default">
					<div class="col-lg-6 col-md-6 col-sm-6 col-xs-6">
						<table style="width: 100%; margin: 0;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid" >
							<tbody>
								<tr>
									<td><strong>SUPPLIER:</strong></td>
									<td>{{ Ucfirst($vendor->name)}}</td>
								</tr>
								<tr>
									<td><strong>Quotation Ref:</strong></td>
									<td>&nbsp;</td>
								</tr>
								<tr>
									<td>Contact Person:</td>
									<td>{{$vendor->phone_number}}</td>
								</tr>
								<tr>
									<td colspan="2">ADDRESS:<br>
										<span><center>{{ $vendor->address}}<center></span>
									</td>
								</tr>
								<tr>
									<td>EMAIL ID:</td>
									<td>{{$vendor->email}}</td>
								</tr>
								<tr>
									<td>NTN NO:</td>
									<td>{{ $vendor->ntn}}</td>
								</tr>
								<tr>
									<td>STRN NO:</td>
									<td>{{ $vendor->stn}}</td>
								</tr>
							</tbody>
						</table>
					</div>
					<div class="col-md-6 col-xs-6">
						<table style="width: 100%; margin: 0;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid" >
							<tbody>
								<tr>
									<td><strong>DELIVERY DATE:</strong></td>
									<td colspan="2"><center>{{date('d-F-Y' , strtotime($purchase_order->delivery_date))}}</center></td>
								</tr>
								<tr>
									<td colspan="3"><strong>DELIVER AT:</strong></td>
								</tr>
								<tr>
									<td><strong>SITE CODE:</strong></td>
									<td colspan="2"><strong><center>FGI</center></strong></td>
								</tr>
								<tr >
									<td style="padding-top: 15px; padding-bottom: 15px;"><br><strong>ADDRESS:</strong><br>&nbsp;<br></td>
									<td colspan="2" style="padding-top: 15px; padding-bottom: 15px;"><br>Plot No. 8, 10th Avenue F10 Islamabad<br>&nbsp;<br></td>
								</tr>
								<tr>
									<td>Contact Person:</td>
									<td>&nbsp;</td>
									<td>&nbsp;</td>
								</tr>
								<tr>
									<td>Attn:</td>
									<td>&nbsp;</td>
									<td>&nbsp;</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
				<br>
				<div class="row hide-default">
					<div class="col-md-12">
						<table style="width: 100%; margin: 0;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid" >
							<tbody>
								<tr>
									<td><strong>S. No.</strong></td>
									<td><strong>DESCRIPTION</strong></td>
									<td><center><strong>UNIT</strong></center></td>
									<td><center><strong>QUANTITY</strong></center></td>
									<td><center><strong>AMOUNT<br>(Rs.)</strong></center></td>
								</tr>

								@foreach( $po_items as $list )
                                
								

								@php 
								$item = \App\Item::withTrashed()->find($list->item_id);
								@endphp


									<tr role="row" class="odd"  >

								@php 
								$item = \App\Item::withTrashed()->find($list->item_id);
								@endphp



							   <td>{{$item->item_code}} </td>

								<td class="item_name">
								{{$item->item_name}} - {{$item->manufacture->name}}
								<?= ($item->risk_type == 'critical') ? '<span class="critical">Critical</span>' : '<span class="non_critical">Non Critical</span>' ?>
								</td>

								<td>{{$item->unit}} </td>

								

								<td>{{number_format($list->demand_quantity , 2)}} </td>


                                <td style="text-align:center;">
									PKR {{number_format($list->price , 2)}}
								</td>

								</tr>
							


								@endforeach
							
							</tbody>
						</table>
					</div>
				</div>

				<br><br>
				<div class="row hide-default">
					<div class="col-md-12">
						<table style="width: 100%; margin: 0;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid" >
							<tbody>
								<tr>
									<td>Amount in words:</td>
									<td>
										<span>(Rupees &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>
										<span style="float:right;">)</span>
									</td>
								</tr>
							</tbody>
						</table>
					</div>	
				</div>
				<br>
				<div class="row hide-default" style="margin-bottom: 1rem;">
					<div class="col-md-12">
						<strong><u>Terms & Conditions:</u></strong>
					</div>
				</div>
				<div class="row hide-default">
					<div class="col-md-12">
						<table style="width: 100%; margin: 0;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid" >
							<tbody>
								<tr>
									<td><center>1</center></td>
									<td>There shall be no change in rate during the validity of this PO;</td>
								</tr>
								<tr>
									<td><center>2</center></td>
									<td>Payment terms shall be as per mutual understanding;</td>
								</tr>
								<tr>
									<td><center>3</center></td>
									<td>Payment shall be made through Cross Cheque / Pay Order in the name of M/S</td>
								</tr>
								<tr>
									<td><center>4</center></td>
									<td>Income tax shall be witheld / deducted as per law;</td>
								</tr>
								<tr>
									<td><center>5</center></td>
									<td>Kindly deliver the goods &(or) services as per delivery date mentioned above. Any delay in delivery from supplier's end should be informed to the Paurchase Department <br> well before delivery time;</td>
								</tr>
								<tr>
									<td><center>6</center></td>
									<td>Penalty will be charged on per day basis from the total invoice value incase of delay in delivery;</td>
								</tr>
								<tr>
									<td><center>7</center></td>
									<td>Buyer has the right to cancel full P.O incase of below standard goods and services;</td>
								</tr>
								<tr>
									<td><center>8</center></td>
									<td>Duly signed & stamped invoice and 2 copies of delivery challan will be required at the time of delivery.</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>

				<br><br>
				<div class="row hide-default">
					<div class="col-md-3 col-xs-3">
						<table style="width: 100%; margin: 0;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid" >
							<tbody>
								<tr>
									<td colspan="2"><br><br><br></td>
								</tr>
								<tr>
									<td colspan="2"><center><strong>PREPARED BY</strong></center></td>
								</tr>
									<tr>
									<td width="20%">Name:</td>
									<td>&nbsp;</td>
								</tr>

									<tr>
									<td width="20%">Designation:</td>
									<td>&nbsp;</td>
								</tr>
							</tbody>
						</table>
					</div>
					<div class="col-md-3 col-xs-3">
						<table style="width: 100%; margin: 0;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid" >
							<tbody>
								<tr>
									<td colspan="2"><br><br><br></td>
								</tr>
								<tr>
									<td colspan="2"><center><strong>VERIFIED BY</strong></center></td>
								</tr>
									<tr>
									<td width="20%">Name:</td>
									<td>&nbsp;</td>
								</tr>

									<tr>
									<td width="20%">Designation:</td>
									<td>&nbsp;</td>
								</tr>
							</tbody>
						</table>
					</div>
					<div class="col-md-3 col-xs-3">
						<table style="width: 100%; margin: 0;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid" >
							<tbody>
								<tr>
									<td colspan="2"><br><br><br></td>
								</tr>
								<tr>
									<td colspan="2" style="padding-top:3.3rem; padding-bottom: 3.3rem; ;"><center><strong>APPROVED BY</strong></center></td>
								</tr>
							</tbody>
						</table>
					</div>
					<div class="col-md-3 col-xs-3">
						<table style="width: 100%; margin: 0;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid" >
							<tbody>
								<tr>
									<td colspan="2"><br><br><br></td>
								</tr>
								<tr>
									<td colspan="2"><center><strong>SUPPLIER'S ACCEPTANCE</strong></center></td>
								</tr>
								<tr>
									<td width="20%">Name:</td>
									<td>&nbsp;</td>
								</tr>

									<tr>
									<td width="20%">Designation:</td>
									<td>&nbsp;</td>
								</tr>


							</tbody>
						</table>
					</div>
				</div>

				<br>























							

                           
                               
                                <div class="">  
                        
								<div class="row avoid-this" style="margin-top: -15rem;">

							<div class="col-md-12 col-xs-12">
								<h3 class="box-title"><b style="">Vendor Details</b></h3>

								<div class="col-md-4 col-xs-4 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold">Name</span>
								<span class="blk_clr" style="margin-left: 5px;font-weight: 400;">
								{{ Ucfirst($vendor->name)}}
								</span>
								</div>

							<div class="col-md-4 col-xs-3 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold">Phone</span>
								<span class="blk_clr" style="margin-left: 5px;font-weight: 400;">
								0{{ $vendor->phone_number }}
								</span>
								</div>


								<div class="col-md-4 col-xs-5 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold">Email</span>
								<span class="blk_clr" style="margin-left: 5px;font-weight: 400;">
								{{ $vendor->email }}
								</span>
								</div>


								<div class="col-md-4 col-xs-4 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold">Cnic</span>
								<span class="blk_clr" style="margin-left: 5px;font-weight: 400;">
								{{ $vendor->cnic }}
								</span>
								</div>

								<div class="col-md-8 col-xs-8 div-border" style="margin-top: 2rem;">
								<span class="blk_clr" style="color:black;font-weight: bold;" class="font-weight-bold">Address</span>
								<span style="margin-left: 5px;font-weight: 400;">
								{{ $vendor->address }}
								</span>
								</div>


							

								</div>

								<div class="col-md-12 col-xs-12">

								<h3 class="box-title" style="margin-top: 3rem;"><b style="">Company Details</b></h3>

								<div class="col-md-4 col-xs-4 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold">Company</span>
								<span class="blk_clr" style="margin-left: 5px;font-weight: 400;">
								{{ env('APP_NAME')}}
								</span>
								</div>

									<div class="col-md-4 col-xs-4 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold">Contact</span>
								<span class="blk_clr" style="margin-left: 5px;font-weight: 400;">
								{{ env('APP_CONTACT')}}
								</span>
								</div>

								<div class="col-md-4 col-xs-4 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold">Address</span>
								<span  class="blk_clr" style="margin-left: 5px;font-weight: 400;">
								{{ env('APP_ADDRESS')}}
								</span>
								</div>


								<div class="col-md-4 col-xs-4 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold">Po Sent Date</span>
								<span  class="blk_clr" style="margin-left: 5px;font-weight: 400;">
								{{date('d-F-Y' , strtotime($purchase_order->created_at))}}
								</span>
								</div>


								<div class="col-md-4 col-xs-4 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold">Delivery Date</span>
								<span  class="blk_clr" style="margin-left: 5px;font-weight: 400;">
								{{date('d-F-Y' , strtotime($purchase_order->delivery_date))}}
								</span>
								</div>



							@if($po_receipts->count() > 0 )
							<div class="col-md-4  col-xs-4 avoid-this" style="margin-top: 2rem;">
							<span  style="color:black;font-weight: bold;">MIR</span>
							<a  href="javascript:" id="grn" class="avoid-this" style="margin-left: 2rem;">View</a>
							</div>

							@endif


							<div class="col-md-12 col-xs-12 div-border" style="margin-top: 2rem;">
							<span style="color:black;font-weight: bold;" class="font-weight-bold">Special Instructions</span>
							<span  class="blk_clr" style="margin-left: 5px;font-weight: 400;">
							{{$purchase_order->special_instruction}}
							</span>
							</div>

								
							</div>

							</div>



                                <h3 style="text-align:right;" class="box-title avoid-this" style="margin-top: 5rem;"><b style="float: left;"> Items List</b>



								@if($purchase_order->status == 1 )
								<button class="btn btn-success avoid-this" data-toggle="modal" data-target="#poModal" >Received Order</button>
								@elseif($purchase_order->status == 3 || $remaing > 0)
								<button class="btn btn-success avoid-this" data-toggle="modal" data-target="#poremainModal" >Received remaining order</button>
								@elseif($purchase_order->status == 2 && $remaing == 0) 

								@permission('view-po-receipt')
								<a href="{{route('purchase-order-receipts.view' , [$purchase_request_id])}}" class="btn btn-success avoid-this" target="_blank">Receipts</a> 
								@endpermission
								@endif

								<a class="btn btn-warning avoid-this" id="print" href="#">Print</a>


                             </h3>

                             
                              <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table us-tbl avoid-this" role="grid" aria-describedby="myTable_info">
	                          <thead>
								<tr role="row">


								<th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Code</th>
								

								<th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Item - Brand</th>

								<th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 150px;">Description</th>


								<th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 50px;">Demand Qty</th>

								<th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 50px;">Received Qty</th>

								<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 50px; text-align: center;">Price</th>

								</tr>

	                            </thead>
                                <tbody>
								
								<?php 
								$count = 0;  $receive_quantity = 0;  $quantity = 0;
								$vendor_item_price = 0;$i=0; 
								?>
								@foreach( $po_items as $list )
                                
								<tr role="row" class="odd"  >

								

								@php 
								$item = \App\Item::withTrashed()->find($list->item_id);
								@endphp



							   <td>{{$item->item_code}} </td>

								<td class="item_name">
								{{$item->item_name}} - {{$item->manufacture->name}}
								<?= ($item->risk_type == 'critical') ? '<span class="critical">Critical</span>' : '<span class="non_critical">Non Critical</span>' ?>
								</td>

								<td class="description"> 
								<span class="default-text">{{!empty($purchase_request)?$purchase_request->item->where('item_id' , $list->item_id )->first()->description:null}}</span>
								<span class="after-load-more" style="display:none;"></span>
								</td>

								<td>{{number_format($list->demand_quantity , 2)}} </td>

								<td>{{number_format($list->received_quantity , 2)}} </td>

                                <td style="text-align:center;">
									PKR {{number_format($list->price , 2)}}
								</td>

								</tr>
								<?php
								$count ++;
								$vendor_item_price += ( $list->price * $list->demand_quantity );
								$quantity += $list->demand_quantity; 
								$receive_quantity += $list->received_quantity; 
								?>

								@if($loop->last)
								<tr >
								<th rowspan="3" colspan="3"  >Total</th>
								<td>{{number_format($quantity , 2)}} </td>
								<td>{{number_format($receive_quantity , 2)}} </td>
								<td style="text-align:center">PKR {{number_format($vendor_item_price , 2)}} </td>
								</tr>
								@endif

								 @endforeach 
								

								</tbody>
								</table>


								
								<div style="float-left:right;color:black !important; " class="hide-default avoid-this">
								<b>Date : </b> {{date('d-F-Y')}}
								<br>
								<b >Print By : </b>{{ Ucfirst(Auth::user()->name) }}
								</div>


								<div class="row avoid-this">

                                <div class="col-md-6 col-xs-6">
                                <!-- 	<label style="font-weight:bold;color: black;">Payment Terms</label>
                                	<form method="POST" onsubmit="return update_description('{{$purchase_order->id}}')">
                                	<textarea id="special_description" placeholder="Type here..." class="form-control us-po-design" rows="4">{{$purchase_order->payment_terms}}</textarea>

									<button class="avoid-this" type="submit" style="background: transparent;border: none;"><i style="color:#d4af37;margin-top: 1rem;margin-bottom: 1rem;" class="fa fa-pencil-square" aria-hidden="true"></i>
									</button>
                                   </form>
                                	<br>

                                	<span id="po_auth" class="blk_clr">Authorize signature and Stamp <br>_______________________________</span> -->
                                </div>

								<div class="col-md-6 col-xs-6" style="text-align: right;">
								<div class="pricing-section">
								<p>
								<b style="color:black;" class="us-text">Total Item:</b> <span style="margin-left: 10rem;" class="blk_clr"> {{number_format($count, 2)}}</span>
								</p>

								<p>
								<b style="color:black;" class="us-text">Demand Quantity:</b> <span style="margin-left: 9.5rem;" class="blk_clr"> {{number_format($quantity, 2)}}</span>
								</p>

                                
                                <p>
								<b style="color:black;" class="us-text">Receive Quantity:</b> <span style="margin-left: 9.5rem;" class="blk_clr"> {{number_format($receive_quantity, 2)}}</span>
								</p>
								
                                <p>
								<b style="color:black;" class="us-text"> Amount :</b> 
								<span style="margin-left: 3rem" class="blk_clr"> 
								PKR {{number_format($vendor_item_price , 2) }}
								</span>
								</p>

								@php
								$advanceAmount = ( $purchase_order->total_amount*$purchase_order->advance) / 100;
								@endphp

								<b style="color:black;" class="us-text">Advance :</b> 
								<span style="margin-left: 3rem" class="blk_clr"> 
								 {{number_format($advanceAmount) . ' (' .$purchase_order->advance  .'%)' }}
								</span>
							

								 </div>



								</div>
								</div>

								</div>

								</div>
								</div>
								</div>
								</div>
								</div>



							<div class="modal fade" id="poModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel1">
							<div class="modal-dialog modal-lg" role="document">
							<div class="modal-content">
							<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
							<h4 class="modal-title" id="exampleModalLabel1">PO Validate </h4></div>
							<div class="modal-body">
							<div class="alert alert-success" role="alert" style="display:none;"  id="succeessMessage">
							Purchase Order Received.
							</div>

							<div class="alert alert-danger" role="alert" style="display:none;"  id="errorMessage">
							Error! You enter invalid received quantity for one item.
							</div>

							<div class="row">
							<div class="col-md-6">
							<label>Receive By <b style="color:red;">*</b></label>
							<span id="invalid_receiver_name_errorMessage" style="display:none; color: red;margin-left: 1rem;">Please Input Valid Receiver Name.</span>
							<input type="text" id="receiver_name" placeholder="Please Enter Your Name..." class="form-control" name="">

							</div>


							<div class="col-md-6">
							<label>Documents <b style="color:red;margin-right: 1rem;">*</b> (Supplier Invoices)</label>
							<span id="invalid_document_errorMessage" style="display:none; color: red;margin-left: 1rem;"></span>
							<input type="file" id="documents" multiple="multiple"  class="form-control">
                             <small><b>INFO : </b>Press and hold ctrl button to select multiple images</small>
                           <!--    -->
							</div>
							</div>


							<table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
							<thead>
							<tr role="row">


							<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Code</th>


							<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Item - Brand</th>

							<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Description</th>


							<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Demand Quantity</th>


							<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 203px; text-align: center;">Received Quantity</th>

							</tr>

							</thead>
							<tbody>

							@foreach( $po_items as $list )

							<tr role="row" class="odd"  >

							@php 
							$item = \App\Item::withTrashed()->find($list->item_id); 
							@endphp

							<td>{{$item->item_code}} </td>

							<td class="item_name">
							{{$item->item_name}} - {{$item->manufacture->name}}
							<?= ($item->risk_type == 'critical') ? '<span class="critical">Critical</span>' : '<span class="non_critical">Non Critical</span>' ?>
							</td>

							<td class="description"> 
								<span class="default-text">{{!empty($purchase_request)?$purchase_request->item->where('item_id' , $list->item_id )->first()->description:null}}</span>
								<span class="after-load-more" style="display:none;"></span>
								</td>

							<td>{{number_format($list->demand_quantity , 2)}} </td>

							<td>
								<input type="hidden" class="item_id" value="{{$list->item_id}}" >
								<input type="number" class="po_item_qty" style="border: none; background: transparent; width: 100%;" name="" placeholder="Type here...">
							</td>

							</tr>

							@endforeach 


							</tbody>
							</table>

							</div>
							<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
							<button type="submit" class="btn btn-primary" onclick="return createReceipt('{{$vendor->id}}' , '{{$purchase_request_id}}' , this)" id="thisBtn" >Validate</button>
							</form>
							</div>
							</div>
							</div>
							</div>



                            <div class="modal fade" id="poremainModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel1">
							<div class="modal-dialog modal-lg" role="document">
							<div class="modal-content">
							<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
							<h4 class="modal-title" id="exampleModalLabel1">PO Validate </h4></div>
							<div class="modal-body">
							<div class="alert alert-success" role="alert" style="display:none;"  id="succeessMessage2">
							Purcahse Order Received.
							</div>

							<div class="alert alert-danger" role="alert" style="display:none;"  id="errorMessage2">
							Error! You enter invalid received quantity for one item.
							</div>


							<div class="row">
							<div class="col-md-6">
							<label>Receive By <b style="color:red;">*</b></label>
							<span id="invalid_receiver_name_errorMessage" style="display:none; color: red;margin-left: 1rem;">Please Input Valid Receiver Name.</span>
							<input type="text" id="remain_order_receiver_name" placeholder="Please Enter Your Name..." class="form-control" name="">

							</div>


							<div class="col-md-6">
							<label>Documents <b style="color:red;margin-right: 1rem;">*</b> (Supplier Invoices)</label>
							<span id="invalid_remaindocuments_errorMessage" style="display:none; color: red;margin-left: 1rem;"></span>
							<input type="file" id="remaindocuments" multiple="multiple"  class="form-control">
                             <small><b>INFO : </b>Press and hold ctrl button to select multiple images</small>
        
							</div>
							</div>



							<table id="myTable" class="table table-striped dataTable no-footer" role="grid" aria-describedby="myTable_info">
							<thead>
							<tr role="row">


							<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Code</th>


							<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Item - Brand</th>

							<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Description</th>


							<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Demand Quantity</th>

							<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Remaining Quantity</th>


							<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 203px; text-align: center;">Received Quantity</th>

							</tr>

							</thead>
							<tbody>

							@foreach( $po_items as $list )

							@php 
							$item = \App\Item::withTrashed()->find($list->item_id); 
							@endphp

							@if($list->received_quantity < $list->demand_quantity)

							<tr role="row" class="odd"  >

							<td>{{$item->item_code}} </td>

							<td class="item_name">
								{{$item->item_name}} - {{$item->manufacture->name}}
								<?= ($item->risk_type == 'critical') ? '<span class="critical">Critical</span>' : '<span class="non_critical">Non Critical</span>' ?>
								</td>

							<td class="description"> 
							<span class="default-text">{{!empty($purchase_request)?$purchase_request->item->where('item_id' , $list->item_id )->first()->description:null}}</span>
							<span class="after-load-more" style="display:none;"></span>
							</td>

							<td>{{number_format($list->demand_quantity , 2)}} </td>

							<td>{{$list->demand_quantity - $list->received_quantity}} </td>

							<td>
								<input type="hidden" class="update_item_id" value="{{$list->item_id}}" >
								<input type="number" class="update_po_item_qty" style="border: none; background: transparent;" name="" placeholder="Type here...">
							</td>

							</tr>
							@endif

							@endforeach 


							</tbody>
							</table>

							</div>
							<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
							<button type="submit" class="btn btn-primary" onclick="return updateReceipt('{{$vendor->id}}' , '{{$purchase_request_id}}' , this)" id="thisBtn" >Validate</button>
							</form>
							</div>
							</div>
							</div>
							</div>


@if($po_receipts->count() > 0 )



<div class="page-wrapper" id="grn_section">
<div class="container-fluid" style="margin-top: -100px;">
<div class="row">
<div class="col-md-12">
<div class="white-box">
<h3 class="box-title" style="text-align: center;"> 
<b style="font-size: 2.2rem;">MATERIAL INSPECTION</b>
</h3>

</div>
</div>
</div>
</div>
</div>

@foreach($po_receipts as $receipt)

@if($receipt->receipt_type == 1)
	<div class="page-wrapper" >
	<div class="container-fluid" style="margin-top: -450px;">
	<div class="row">
	<div class="col-md-12">
	<div class="white-box" >

	<div id="grn_{{$receipt->id}}">  

     <div class="row avoid-this">

								<div class="col-md-12">
								<h3 class="box-title">
									<b style="">
										Goods Inspection Report / PO No: {{$purchase_order->id}}
									</b>

									<form method="POST" style="display:inline;" onsubmit="return add_MIR_details('0' ,'{{$receipt->id}}' , this , 'invoice')" >
									<span style="float:right;">Invoice / Bill No  <input type="text" id="invoice" value="{{$receipt->invoice_no}}" placeholder="Type here ..." style="border:none;border-bottom: 1px solid gray; margin-left: 1rem;font-size: 1.2rem;" name="">
									<button class="avoid-this" type="submit" style="background: transparent;border: none;"><i style="color:#d4af37" class="fa fa-pencil-square" aria-hidden="true"></i>
									</button></span>
									</form>

								</h3>

								<div class="col-md-4 col-xs-4 div-border" style="margin-top: 2rem;">
								<span style="color:black; font-weight: bold;" >Supplier Name</span>
								<span style="margin-left: 2rem;font-weight: 400;" class="blk_clr">
								{{ Ucfirst($vendor->name)}}
								</span>
								</div>

								<div class="col-md-4 col-xs-4 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;">Supplier Phone</span>
								<span style="margin-left: 2rem;font-weight: 400;" class="blk_clr">
								0{{ $vendor->phone_number}}
								</span>
								</div>


								<div class="col-md-4 col-xs-4 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;">Supplier Cnic</span>
								<span style="margin-left: 2rem;font-weight: 400;" class="blk_clr">
								{{ Ucfirst($vendor->cnic)}}
								</span>
								</div>



								<div class="col-md-4 col-xs-4 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;">NTN</span>
								<span style="margin-left: 2rem;font-weight: 400;" class="blk_clr">
								{{ Ucfirst($vendor->ntn)}}
								</span>
								</div>



								<div class="col-md-4 col-xs-4 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;">STN</span>
								<span style="margin-left: 2rem;font-weight: 400;" class="blk_clr">
								{{ Ucfirst($vendor->stn)}}
								</span>
								</div>


								<div class="col-md-4 col-xs-4 div-border" style="margin-top: 2rem;">
								<form method="POST" onsubmit="return add_MIR_details('{{$vendor->id}}','{{$receipt->id}}' , this , 'vendor_tc')" >
								<span style="color:black;font-weight: bold;">Supplier T. C. No</span>
								<input type="text" id="vendor_tc" placeholder="Type here ..." style="border:none;border-bottom: 1px solid gray;font-size: 1.2rem;margin-left: 0.5rem;" value="{{$vendor->test_certificate}}" name="">
								<button class="avoid-this" type="submit" style="background: transparent;border: none;"><i style="color:#d4af37" class="fa fa-pencil-square" aria-hidden="true"></i>
						       </button>
							   </form>
							 	</div>



								<div class="col-md-4 col-xs-4 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;">Delivery Date : </span>
								<span style="margin-left: 2rem;font-weight: 400;" class="blk_clr">
								{{date('d-F-Y' , strtotime($purchase_order->delivery_date))}}
								</span>
								</div>


								<div class="col-md-4 col-xs-4 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;">Received By </span>
								<span style="margin-left: 2rem;font-weight: 400;" class="blk_clr">
								{{Ucfirst($receipt->po_receiver_name)}}
								</span>
								</div>

							   
							   <div class="col-md-4 col-xs-4 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;">Receiving Date</span>
								<span style="margin-left: 2rem;font-weight: 400;" class="blk_clr">
								{{date('d-F-Y' , strtotime($receipt->po_receiveing_date))}}
								</span>
								</div>


								</div>

							<div class="col-md-6 avoid-this" style="margin-top:3rem;">
							<div class="row">
								<form method="POST" onsubmit="return uploadDocs('{{$receipt->id}}' , this)">
							<div class="col-md-9">
							<label style="font-weight: bold;color: black;">Material Inspection Documents <b style="color:red;margin-right: 1rem;">*</b> </label>
							<br>
							<span id="SucessMessageDOCS" style="display:none; color: green;margin-left: 1rem;">Successfully Upload.</span>
							<input type="file"    id="qualitydocuments" multiple="multiple"  class="form-control">
							<small><b>INFO : </b>Press and hold ctrl button to select multiple images</small>
							</div>

							<div class="col-md-3" style="margin-top:3rem;">
                             @if(empty($receipt->quality_insu_docs))
			 				<button type="submit" id="doc_BTN" class="btn btn-success btn-sm">UPLOAD</button>
							@else
							<button type="submit" id="doc_BTN" class="btn btn-success btn-sm">UPDATE</button>

							@endif

							</div>
                            </form>

							</div>

							</div>


					         </div>














<center><div class="row hide-default" >
							<h3 class="box-title">
							<?= (env('DOCUMENT_LOGO')) ? '<img src="'.asset(env('DOCUMENT_LOGO')).'" class="logo-img"><br>' : '' ?>
							{{env('APP_NAME')}}
							</h3>

							<div class="col-md-12" id="GRN-CNG" style="border: 1px solid;color: black; text-align: center;font-weight: bold;padding: 1rem;font-size: 1.5rem; margin-bottom: 3rem;">
							GOODS RECEIVED NOTE
							</div>

							<div class="col-md-6 col-xs-6">
							<div class="row">
							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem; margin-bottom: 3rem;">
							PO NO.
							</div>

							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;">
							{{$purchase_order->id}}
							</div>

							</div>
							</div>

							<div class="col-md-6 col-xs-6">
							<div class="row">
							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;">
							INVOICE NO
							</div>

							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;">
								@if(!empty( $receipt->invoice_no) ) {{ $receipt->invoice_no }} @else {{'.'}}@endif

							
							</div>

							</div>
							</div>


							<div class="col-md-12 col-xs-12">
							<div class="row">

						
							<div class="col-md-12" style="border: 1px solid;color: black; text-align: left;font-weight: bold;padding: 1rem;font-size: 1.5rem; margin-bottom: 3rem;">
							Received  From
							</div>


							<table style="width: 100%;margin-top: -3rem;" id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
							<thead>
							<tr role="row">
							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Name </th>

							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Phone </th>

							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">STRN </th>

							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">NTN </th>

							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">T. C. No </th>

							</tr>
							</thead>
							<tbody>
							<tr role="row" class="odd">
							<td>{{ Ucfirst($vendor->name)}}</td>
							<td>0{{ $vendor->phone_number}}</td>
							<td>{{ $vendor->stn}}</td>
							<td>{{ $vendor->ntn}}</td>
							<td>{{ $vendor->test_certificate}}</td>
							</tr>
							</tbody>
							</table>

							</div>
							</div>

							</div>
							</center>




					
						<h3 class="box-title avoid-this" style="margin-top: 3rem;"><b style="">Items List</b></h3>


						<table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
						<thead>
						<tr role="row">


						<th  class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Item</th>


						<th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">
						Quantity
						</th>

						<th  class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 170px;">TEST QTY<span style="font-size: 1.3rem;margin-left: 1rem;"> <span class="pass_quantity"> Pass </span>  <span class="fail_quantity"><b class="fail">/</b> Fail </span> <span class="remainingQuantity"> <b class="remainingQuantity">/</b> Pend </span> </span></th>


						<th  class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 200px; text-align: center;">Description</th>

						<th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 150px;">Material Inspection</th>

						</tr>

						</thead>
						<tbody>

						@php $count = 0; $quantity = 0; 
						$vendor_item_price = 0; $total_accept = 0; $total_reject = 0; 
                        $under_testing = 0;
						@endphp
						@foreach($receipt->ReceiptItems as $list )

						<tr role="row" class="odd"  >

						@php 
						$item = \App\Item::withTrashed()->find($list->item_id);
						$item_cs = \App\ComparativeStatement::getItemPrices($purchase_request_id , $vendor->id , $list->item_id)['item'];
						$remainingQuantity = $list->quantity - ($list->pass_quantity+$list->fail_quantity);
						@endphp

						<td>{{$item->item_name}} </td>

						<td>{{number_format($list->quantity, 2)}} </td>

						<td><span class="pass_quantity">{{number_format($list->pass_quantity, 2)}}</span> <span class="fail_quantity" ><b class="fail">/</b> {{number_format($list->fail_quantity, 2)}}</span> <span class="remainingQuantity"> <b>/</b> {{number_format($remainingQuantity , 2)}}</span></td>
						<td style="text-align:center;">
						{{$list->note}}
						</td>
						<td> 
						@if((empty($list->approval_status) &&  $list->approval_status !== "approve")  || $remainingQuantity > 0)


						<span class="pen-status"> Pending </span>
						<br>
						<button type="button" style="margin-top:1rem;" class="btn btn-xs btn-success avoid-this" onclick="return completeQualityTesting(this , 'pass' , '{{$remainingQuantity}}' )" data-item-id = "{{$list->item_id}}" data-item-quantity = "{{$list->quantity}}" data-receipt-id = "{{$receipt->id}}" data-item-note = "{{$list->note}}" >Pass</button>

						<button type="button" style="margin-top:1rem;" class="btn btn-xs btn-danger avoid-this" onclick="return completeQualityTesting(this , 'fail' , '{{$remainingQuantity}}' )" data-item-id = "{{$list->item_id}}" data-item-quantity = "{{$list->quantity}}" data-receipt-id = "{{$receipt->id}}" data-item-note = "{{$list->note}}">Fail</button>

						@else

						<span class="com-status" >Completed</span>
						<br>
						<br>
						<b>Tested By: </b> {{$list->quality_test_approve_by}}
						<br>
						<b>Test Date: </b> {{$list->approval_date}}

						@endif
						</td>

						</tr>

						@php

						$count ++;

						$quantity += $list->quantity; 

						$total_accept += $list->pass_quantity;

						$total_reject += $list->fail_quantity;

						$under_testing += $list->quantity - ($list->pass_quantity + $list->fail_quantity)

						@endphp

						@endforeach 

						</tbody>
						</table>
						<center>
							<div class="row hide-default">
							<div class="col-md-6 col-xs-6">
							<div class="row">
							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem; margin-bottom: 3rem;font-weight: bold;">
							Received BY
							</div>

							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;">
							{{ucfirst($receipt->po_receiver_name)}}
							</div>

							</div>
							</div>

							<div class="col-md-6 col-xs-6">
							<div class="row">
							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;font-weight: bold;">
							Received Date
							</div>

							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;">
							{{date('d-F-Y' , strtotime($receipt->po_receiveing_date))}}
							</div>

							</div>
							</div>

							<div class="col-md-12 col-xs-12">
							<div class="row">
							<div class="col-md-6 col-xs-6" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;font-weight: bold;">
							Material Inspection Documents Received
							</div>

							<div class="col-md-3 col-xs-3" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;">
							Yes @if(!empty($receipt->quality_insu_docs)) <i class="fa fa-check" aria-hidden="true"></i> @endif
							</div>

							<div class="col-md-3 col-xs-3" style="border: 1px solid;color: black;padding: 0.5rem;margin-bottom: 3rem;">
							No @if(empty($receipt->quality_insu_docs))  <i class="fa fa-check" aria-hidden="true"></i> @endif
							</div>

							</div>
							</div>


							<div class="col-md-12" style="border: 1px solid;color: black; text-align: center;font-weight: bold;padding: 1rem;font-size: 1.5rem; margin-bottom: 3rem;margin-top: 12rem;">
									Approved By
							</div>


							 <table style="width: 100%;" id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
	                            <thead>
								<tr role="row">
								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Name</th>
								
								<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Date</th>

								<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Signature</th>

								</tr>

	                            </thead>
                                <tbody>
  
			           
								<tr role="row" class="odd">

								<td>@if($receipt->quality_test_inspector_name) {{$receipt->quality_test_inspector_name}}@else {{'.'}} @endif </td>

								<td>@if($receipt->quality_test_inspector_date) {{date('d-F-Y' , strtotime($receipt->quality_test_inspector_date))}} @else {{'.'}} @endif</td>

								<td></td>
								</tr>
					
			                    </tbody>
			                    </table>
						</div>
					</center>

						<div style="float-left:right;color:black !important; " class="hide-default">
						<b>Date : </b> {{date('d-F-Y')}}
						<br>
						<b >Print By : </b>{{ Ucfirst(Auth::user()->name) }}
						</div>

							<div class="row avoid-this">
							<div class="col-md-6 col-xs-6">
							<form method="POST" onsubmit="return add_MIR_details('0' ,'{{$receipt->id}}' , this , 'inspector')" >
							<span style="color:black;margin-top: 6rem;">Name & Signature</span>
						
						<input type="text" placeholder="Type here ..." style="border:none;border-bottom: 1px solid gray; margin-top: 5rem;margin-left: 1rem;font-size: 1.2rem;" value="{{$receipt->quality_test_inspector_name}}" id="inspector_name">
						<button class="avoid-this" type="submit" style="background: transparent;border: none;"><i style="color:#d4af37" class="fa fa-pencil-square" aria-hidden="true"></i>
						</button>
						</form>
						</div>
						<div class="col-md-6 col-xs-6" style="text-align: right;">
						<div class="pricing-section">
						<p>
						<b style="color:black; margin-right: 5rem" class="us-text">Total Item:</b> <span class="blk_clr"> {{number_format($count, 2)}}</span>
						</p>

						<p>
						<b style="color:black;margin-right: 5rem" class="us-text">Total Item Quantity:</b> <span class="blk_clr" > {{number_format($quantity, 2)}}</span>
						</p>

						<p class="pass_quantity">
						<b style="color:black;margin-right: 5rem" class="us-text">Total Aceptable Quantity:</b> 
						<span class="blk_clr"> 
						{{number_format($total_accept , 2) }}
						</span>
						</p>


						<p class="fail_quantity">
						<b style="color:black;margin-right: 5rem" class="us-text">Total Rejected Quantity:</b> 
						<span class="blk_clr"> 
						{{number_format($total_reject , 2) }}
						</span>
						</p>

						<p class="remainingQuantity">
						<b style="color:black;margin-right: 5rem" class="us-text">Under testing Quantity:</b> 
						<span class="blk_clr"> 
						{{number_format($under_testing , 2) }}
						</span>
						</p>


						</div>
						</div>
						</div>

						</div>
<h3 >Print</h3>						
<button type="button" onclick="return print_docs('{{$receipt->id}}' , 'gir' , ' Goods Inspection Report ')" class="btn btn-xs btn-primary"> Goods Inspection Report </button>

<button type="button" onclick="return print_docs('{{$receipt->id}}' , 'grn' , ' GOODS RECEIVING NOTE')" class="btn btn-xs btn-primary"> Goods Receiving Note</button>

<button type="button" onclick="return print_docs('{{$receipt->id}}' , 'mrn' , ' GOODS  RETURN NOTE')" class="btn btn-xs btn-primary"> Goods  Return Note</button>

@if(!empty($receipt->documents))
<h3 style="margin-top: 5rem;margin-bottom: 3rem;">Invoice Documents</h3>
@php
$images = json_decode($receipt->documents , true);
$file_ext = array('docx','pdf');
echo '<div class="row">';
for($img = 0; $img < count($images); $img++)
{
$url = asset('storage/uploads/'.$images[$img]);
$urlExt = pathinfo($url, PATHINFO_EXTENSION);
if (!in_array($urlExt, $file_ext)) 
{
echo '<div class="col-md-2" ><a target="_blank" href="'.url('storage/uploads/'.$images[$img]).'"><img  title="Image" style="height: 100px;border-radius: 10px;" class="img-responsive" src="'.url('storage/uploads/'.$images[$img]).'"></a></div>';
}
if (in_array($urlExt, $file_ext)) 
{
echo '<div class="col-md-2" ><a target="_blank" href="'.url('storage/uploads/'.$images[$img]).'"><img title="'.ucfirst($urlExt).' File" style="height: 100px;border-radius: 10px;" class="img-responsive" src="'.url('storage/file.jpg').'"></a></div>';
}
}
echo '</div>';
@endphp
@endif

@if(!empty($receipt->quality_insu_docs))
<h3 style="margin-top: 5rem;margin-bottom: 3rem;">Material Inspection Documents</h3>
@php
$Qualityimages = json_decode($receipt->quality_insu_docs , true);
echo '<div class="row">';
for($img = 0; $img < count($Qualityimages); $img++)
{
$url = asset('storage/quality_documents/'.$Qualityimages[$img]);
$urlExt = pathinfo($url, PATHINFO_EXTENSION);
if (!in_array($urlExt, $file_ext)) 
{
 echo '<div class="col-md-2" ><a target="_blank" href="'.asset('storage/quality_documents/'.$Qualityimages[$img]).'"><img  title="Image" style="height: 100px;border-radius: 10px;" class="img-responsive" src="'.asset('storage/quality_documents/'.$Qualityimages[$img]).'"></a></div>';    
}
if (in_array($urlExt, $file_ext)) 
{
 echo '<div class="col-md-2" ><a target="_blank" href="'.asset('storage/quality_documents/'.$Qualityimages[$img]).'"><img title="'.ucfirst($urlExt).' File" style="height: 100px;border-radius: 10px;" class="img-responsive" src="'.asset('storage/file.jpg').'"></a></div>';    
}
}
echo '</div>';
@endphp
@endif
	</div>
	</div>
	</div>
	</div>
	</div>

	@endif

	<!-----------------------------New Quality test modal-------------------->

                            <div class="modal fade" id="qualityModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel1">
							<div class="modal-dialog " role="document">
							<div class="modal-content">
							<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
							<h4 class="modal-title" id="exampleModalLabel1">Verify Item Quality Insurance</h4> Pending <b id="pending_testing">loading...</b></div>
							<div class="modal-body">
							<div class="alert alert-success" role="alert" style="display:none;"  id="qualitysucceessMessqualityage2">
							Successfully  Update.
							</div>

							<div class="alert alert-danger" role="alert" style="display:none;"  id="qualityerrorMessage2">
							Error! You enter invalid received quantity for one item.
							</div>


							<div class="row">
							<div class="col-md-12">
							<label> Approved By <b style="color:red;">*</b></label>
							<span id="invalid_qualityreceiver_name_errorMessage" style="display:none; color: red;margin-left: 1rem;">Please Input Valid Receiver Name.</span>
							<input type="text" id="quality_order_receiver_name" placeholder="Please Enter Your Name..." class="form-control" name="">
							</div>

							<div class="col-md-12" style="margin-top:2rem;">
							<label> <span id="us-txt"></span> Quantity <b style="color:red;">*</b></label>
							<span id="invalid_quality_number_errorMessage" style="display:none; color: red;margin-left: 1rem;">Please Input Valid Quantity Number.</span>
							<input type="text" id="quality_number" placeholder="Please Enter Quantity ..." class="form-control" name="">
							</div>

							<div class="col-md-12" style="margin-top:2rem;">
							<label> Note: </label>
							<textarea class="form-control" id="note" placeholder="Type your text here..." rows="5"></textarea>
							</div>

                            <input type="hidden" id="item_quantity" name="">
                            <input type="hidden" id="item_id" name="">
                            <input type="hidden" id="receipt_id" name="">
                            <input type="hidden" id="type" name="">

							</div>


							</div>
							<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
							<button type="button" class="btn btn-primary" onclick="return qualityTestComplete('{{$vendor->id}}' , '{{$purchase_request_id}}' , this)" id="thisBtn" >
							Complete
						    </button>

							</div>


							</div>
							</div>
							</div>
@endforeach

@endif



@stop

@section('js')  

<script type="text/javascript">

	function update_description(po_id) {
		var special_description = $('#special_description').val();


		$.ajaxSetup({
		headers: {
		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		}
		});

		$.ajax({
		url:"{{ route('purchase-orders.update_po_description') }}",
		method:'POST',
		dataType:'json',
		data: {special_description:special_description,po_id:po_id},
		success:function(data)
		{
           if(data.response == 'invalid')
           {
               alert(data.message)
            
           }
           else if(data.response == 'yes')
           {
		       	alert('Successfully Added.')
		       	location.reload(true)
           }
           else
           {
	           	alert('Something went wrong.')
	           	location.reload(true)
           }
		}
		})


		return false;
	}

$(document).ready(function() {

$('.odd').each(function()
{
var description = $(this).find('.description .default-text').text();
// var word = description.split(" ");
if(description.length > 10 )
{
$(this).find('.after-load-more').html(description);
var content =   description.slice(0 , 10)+'... <a href="javascript:void(0)" onclick="return showContent(this)">load more</a>'
$(this).find('.description .default-text').html(content);
}

});

});
function showContent(self) {
$(self).closest('.description').find('.after-load-more').show();
$(self).closest('.description').find('.default-text').hide();
}


	function print_docs(id , status , innerHTML)
{
if(status == 'gir')
	var ignoreClassis = ".avoid-this"

else if(status == 'grn')
	var ignoreClassis =  ".avoid-this , .fail_quantity , .remainingQuantity"

else if(status == 'mrn')
	var ignoreClassis =  ".avoid-this , .pass_quantity , .remainingQuantity , .fail"


$("div#grn_"+id).find('#GRN-CNG').html(innerHTML)
$("div#grn_"+id).print({
//Use Global styles
globalStyles : true,
//Add link with attrbute media=print
mediaPrint : false,
iframe : false,
//Don't print this
noPrintSelector : ignoreClassis,
//Add this at top
// prepend : "Print By {{ Ucfirst(Auth::user()->name) }} <br/>",
//Add this on bottom
// append : "<span><br/>GOOD LUCK!</span>",
//Log to console when printing is done via a deffered callback
deferred: $.Deferred().done(function() { console.log('Printing done', arguments); })
});

 return false;
}



	function add_MIR_details(vendor_id = null,receipt_id , self , type)
	{

	    var inspector_name = $(self).find('#inspector_name').val();
	    var vendor_tc = $(self).find('#vendor_tc').val();
	    var invoice =  $(self).find('#invoice').val();

		$.ajaxSetup({
		headers: {
		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		}
		});

		$.ajax({
		url:"{{ route('purchase-orders.add_mir_details') }}",
		method:'POST',
		dataType:'json',
		data: {inspector_name:inspector_name,receipt_id:receipt_id,vendor_tc:vendor_tc,vendor_id:vendor_id , type:type , invoice:invoice},
		success:function(data)
		{
           if(data.response == 'invalid')
           {
               alert(data.message)
            
           }
           else if(data.response == 'yes')
           {
		       	alert('Successfully Added.')
		       	location.reload(true)
           }
           else
           {
	           	alert('Something went wrong.')
	           	location.reload(true)
           }
		}
		})

	return false;
	}

	function createReceipt(vendor_id , purchase_request_id , self) {

	var item_ids = [];
	var po_item_qty = [];
    var receiver_name = $('#receiver_name').val();
    var documents = $('#documents').prop('files').length; 
    var formData = new FormData();

     $(self).html('Processing...')
     $(self).prop('disabled' , true)

	$('.item_id').each(function()
	{
	  item_ids.push($(this).val());
	});
    

    $('.po_item_qty').each(function()
	{
	  po_item_qty.push($(this).val());
	});



if(po_item_qty == "" || po_item_qty == ",")
{

if (confirm("If you donot enter any item quantity. Then system automatically consider demand quantity as a received quantity.") == false) 
  {
		$(self).html('Validate')
		$(self).prop('disabled' , false)
		return false;
  }
}

	for (var i = 0; i < documents; i++) {

	formData.append(i, $('#documents').prop('files')[i]);
	}

	formData.append('pr_id', purchase_request_id);
	formData.append('vendor_id', vendor_id);
	formData.append('item_ids', item_ids);
	formData.append('po_item_qty', po_item_qty);
	formData.append('receiver_name', receiver_name);
	formData.append('file_length', documents);


	$.ajaxSetup({
		headers: {
		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		}
		});

		$.ajax({
		url:"{{ route('purchase-orders.validate') }}",
		method:'POST',
		dataType:'json',
		 cache: false,
         contentType : false, // you can also use multipart/form-data replace of false
         processData: false,
		data: formData,
		success:function(data)
		{

				$(self).html('Validate')
           $(self).prop('disabled' , false)

           if(data.response == 'yes')
           {
               
			$("#succeessMessage").show('slow')
		    setTimeout(function(){ location.reload(true);}, 3000);

           }
           else if(data.response == 'invalid_qty')
           {
           	$("#errorMessage").show('slow')
           	$(self).html('Validate')
           $(self).prop('disabled' , false)
            setTimeout(function(){ $("#errorMessage").hide('slow') }, 3000);
           }

           else if(data.response == 'invalid_receiver_name')
           {
           	$("#invalid_receiver_name_errorMessage").show('slow')
           	$(self).html('Validate')
            $(self).prop('disabled' , false)
            setTimeout(function(){ $("#invalid_receiver_name_errorMessage").hide('slow') }, 3000);
           }
           else if(data.response == 'invalid_document')

           {
           	
          $('#invalid_document_errorMessage').html(data.message)
           	$("#invalid_document_errorMessage").show('slow')
            $(self).prop('disabled' , false)
           	$(self).html('Validate')
           	 setTimeout(function(){ $("#invalid_document_errorMessage").hide('slow') }, 3000);
           }

           else
           {
           	alert('Something went wrong.')
           	location.reload(true);
           }
		}
		})

	return false;
	}


	function updateReceipt(vendor_id , purchase_request_id , self) {

	var item_ids = [];
	var po_item_qty = [];
    var remain_order_receiver_name = $('#remain_order_receiver_name').val();
     var documents = $('#remaindocuments').prop('files').length; 
    var formData = new FormData();

     $(self).html('Processing...')
     $(self).prop('disabled' , true)

	$('.update_item_id').each(function()
	{
	  item_ids.push($(this).val());
	});
    

    $('.update_po_item_qty').each(function()
	{
	  po_item_qty.push($(this).val());
	});

for (var i = 0; i < documents; i++) {

	formData.append(i, $('#remaindocuments').prop('files')[i]);
}

formData.append('pr_id', purchase_request_id);
formData.append('vendor_id', vendor_id);
formData.append('item_ids', item_ids);
formData.append('po_item_qty', po_item_qty);
formData.append('remain_order_receiver_name', remain_order_receiver_name);
formData.append('file_length', documents);


if(po_item_qty == "" || po_item_qty == ",")
{

if (confirm("If you donot enter any item quantity. Then system automatically consider demand quantity as a received quantity.") == false) 
  {
  	$(self).html('Validate')
     $(self).prop('disabled' , false)
    return false;
  }
}

	$.ajaxSetup({
		headers: {
		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		}
		});

		$.ajax({
		url:"{{ route('purchase-orders.validate-remaining-po-qty') }}",
		method:'POST',
		dataType:'json',
		 cache: false,
         contentType : false, // you can also use multipart/form-data replace of false
         processData: false,
		data: formData,
		success:function(data)
		{
           if(data.response == 'yes')
           {
               
			$("#succeessMessage2").show('slow')
		    setTimeout(function(){ location.reload(true);}, 3000);

           }
           else if(data.response == 'invalid_qty')
           {
           	$("#errorMessage2").show('slow')
           	$(self).html('Validate')
           $(self).prop('disabled' , false)
            setTimeout(function(){ $("#errorMessage2").hide('slow') }, 3000);
           }
             else if(data.response == 'invalid_receiver_name')
           {
           	$("#invalid_remain_order_receiver_name_errorMessage").show('slow')
           	$(self).html('Validate')
            $(self).prop('disabled' , false)
            setTimeout(function(){ $("#invalid_remain_order_receiver_name_errorMessage").hide('slow') }, 3000);
           }
           else if(data.response == 'invalid_document')

           {
           	

           	$('#invalid_remaindocuments_errorMessage').html(data.message)
           	$("#invalid_remaindocuments_errorMessage").show('slow')
            $(self).prop('disabled' , false)
           	$(self).html('Validate')
           	 setTimeout(function(){ $("#invalid_remaindocuments_errorMessage").hide('slow') }, 3000);
           }

           else
           {
           	alert('Something went wrong.')
           	location.reload(true);
           }
		}
		})

	return false;
	}



	function addItems() 
	{
	  var checkedNum = $('input[name="items[]"]:checked').length;

		if (!checkedNum) 
		{
		  $('#po_btn').hide();
		}
		else
		{
		  $('#po_btn').show();
		}
	}






$("#grn").click(function() {
    $('html, body').animate({
        scrollTop: $("#grn_section").offset().top
    }, 1000);
});

function completeQualityTesting(self , type , remainingQuantity , note) {
$('#item_quantity').val($(self).attr("data-item-quantity"))
$('#item_id').val($(self).attr("data-item-id"))
$('#receipt_id').val($(self).attr("data-receipt-id"))
$('#type').val(type);
$('#note').val($(self).attr("data-item-note"))
$('#pending_testing').text('(' + remainingQuantity + ')');
if(type == 'pass')
{
	$('#us-txt').text('Passed')
}

if(type == 'fail')
{
	$('#us-txt').text('Failed')
}

$('#qualityModal').modal('show')
return false;
}


function qualityTestComplete(vendor_id , purchase_request_id , self) {
var item_id = $('#item_id').val();
var item_quantity= $('#item_quantity').val();
var receiver_name = $('#quality_order_receiver_name').val();
var quality_number = $('#quality_number').val();
var type = $('#type').val();
var note = $('#note').val();
var receipt_id = $('#receipt_id').val();
var formData = new FormData();
$(self).html('Processing...')
$(self).prop('disabled' , true)

formData.append('pr_id', purchase_request_id);
formData.append('vendor_id', vendor_id);
formData.append('item_id', item_id);
formData.append('item_quantity', item_quantity);
formData.append('receiver_name', receiver_name);
formData.append('type', type);
formData.append('note', note);
formData.append('quality_number', quality_number);
formData.append('receipt_id', receipt_id);

	    $.ajaxSetup({
		headers: {
		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		}
		});

		$.ajax({
		url:"{{ route('purchase-orders.quanlity-test') }}",
		method:'POST',
		dataType:'json',
		 cache: false,
         contentType : false, // you can also use multipart/form-data replace of false
         processData: false,
		data: formData,
		success:function(data)
		{
		$(self).html('Complete')
           $(self).prop('disabled' , false)
           if(data.response == 'yes')
           {
               
			$("#qualitysucceessMessqualityage2").show('slow')
		    setTimeout(function(){ location.reload(true);}, 3000);
           }

           else if(data.response == 'invalid')
			{
			  alert(data.message);
			  $(self).html('Complete')
              $(self).prop('disabled' , false)
			}
           
           else
           {
           	alert('Something went wrong.')
           	location.reload(true);
           }
		}
		})
	return false;
	}

	function uploadDocs(receipt_id , self)
	{
	$(self).find('#doc_BTN').prop('disabled' , true);
	var documents = $(self).find('#qualitydocuments').prop('files').length; 
	var formData = new FormData();
	for (var i = 0; i < documents; i++) {
	formData.append(i, $(self).find('#qualitydocuments').prop('files')[i]);
	}
	formData.append('file_length', documents);
	formData.append('receipt_id', receipt_id);
	$.ajaxSetup({
	headers: {
	'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
	}
	});
	$.ajax({
	url:"{{ route('purchase-orders.upload-quanlity-test-docs') }}",
	method:'POST',
	dataType:'json',
	cache: false,
	contentType : false, // you can also use multipart/form-data replace of false
	processData: false,
	data: formData,
	success:function(data)
	{
	if(data.response == 'invalid_document')
	{
	alert(data.message);
	$(self).find('#doc_BTN').prop('disabled' , false);
	}
	else if(data.response == 'yes')
	{
	$(self).find('#SucessMessageDOCS').show();
	setTimeout(function(){ location.reload(true);}, 3000);
	}
	else
	{
	alert('Something went wrong.')
	location.reload(true);
	}
	}
	})
	return false;
	}


</script>

@stop