@extends('layouts.app')

@section('title')
Purchase Order
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Purchase Orders</li>
</ol>
@stop
@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
@stop
@section('content')
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        <div class="white-box">

                                <div class="printableArea">  
                          
                          <h3 class="box-title" style="margin-bottom: 3rem;"> <b style="font-size: 2.2rem;color: gray;">Purchase Orders / </b>PR-{{$pr_id}} 
                          </h3>
                        
								@if(Session::has('success'))   
								<div  class="alert alert-success" role="alert">
								{{ Session::get('success') }}
								</div>
								@endif


								@if(Session::has('error'))   
								<div  class="alert alert-danger" role="alert">
								{{ Session::get('error') }}
								</div>
								@endif


                             <table id="myTable" style="margin-top: 5rem;" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                             	
	                            <thead>
								<tr role="row">

								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 80px;">ID#</th>

								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Vendor</th>


								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 20px;">Total Item</th>


								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 110px;">Status</th>

								

								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 80px;">Sent date</th>

								
								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 80px;">Delivery date</th>


								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Action</th>

								</tr>

	                            </thead>
                                <tbody>
  
			                   
	                    @foreach($vendors as $list )
	                    @php
						$po = \App\PurchaseOrder::getStatusOfPurcchaseOrder($pr_id , $list->id);
						@endphp

	                     <tr role="row" class="odd">

	                    <td>PO-{{$po->id}} </td>

						<td>
							@permission('view-vendor')
							<a href="{{route('vendor.view' , [$list->id])}}">{{ucfirst($list->name)}}</a>
							@else
							{{ucfirst($list->name)}}
							@endpermission
							 </td>

						


						<td>
					        [ {{\App\PurchaseOrder::getPurchaseOrderTotalItems($po->id , $pr_id)}} ]
						</td>


						<td>
						@if($po->status == 1) 
						<div style="background: #0283cc;color: white; padding: 5px;font-size: 13px;border-radius: 20px;text-align: center;">
						{{ 'PO SENT' }}
						</div>
						@elseif ($po->status == 2) 
						<div style="background: #03c500;color: white; padding: 5px;font-size: 13px;border-radius: 20px;text-align: center;">
						{{ 'PO RECEIVED' }}
						</div>
						@elseif($po->status == 3)
						<div style="background: #f5cb00;color: white; padding: 5px;font-size: 13px;border-radius: 20px;text-align: center;">

						{{ 'PARTIALLY RECEIVED' }} 

						</div>
						@endif
						</td>


						<td style="font-size: 15px;">{{date('d-F-Y' , strtotime($po->created_at))}}</td>

					    <td style="font-size: 15px;">{{date('d-F-Y' , strtotime($po->delivery_date))}}</td>

                     
							<td>

							@permission('list-purchase-order')
							<a href="{{url('purchase-orders/detail?vendor='.Crypt::encryptString($list->id).'&purchase_request='.Crypt::encryptString($pr_id).'')}}" class="btn btn-success btn-xs" target="_blank">View</a>
							@endpermission
							
							</td>

							</tr>

			                    @endforeach   

			                    </tbody>
			                    </table>

             
								</div>

								</div>
								</div>
								</div>
								</div>
@stop



						


@section('js')  

<script type="text/javascript">
 setTimeout(function(){$('.alert').hide(); }, 3000);

	function show_quotation_valid_date_form() {
		$('#quotation_valid_date_form').toggle('slow');
		return false;
	}
	function changeQuotationValidDate(pr_id) {
		var quotation_valid_date = $('#quotation_valid_date').val();
     $('#quotation_valid_date_btn').html('Processing...')
     $('#quotation_valid_date_btn').prop('disabled' , true)
        $.ajaxSetup({
		headers: {
		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		}
		});
		$.ajax({
		url:"{{ route('request-for-quotations.change-date') }}",
		method:'POST',
		dataType:'json',
		data: {pr_id:pr_id ,quotation_valid_date:quotation_valid_date},
		success:function(data)
		{
         if (data.quotation_valid_date) 
         {
            $('#q_date_error').html(data.quotation_valid_date);
            $('#q_date_error').show();
            $('#quotation_valid_date_btn').html('Change')
            $('#quotation_valid_date_btn').prop('disabled' , false)
            setTimeout(function(){$('#q_date_error').hide(); }, 3000);
         }
         if(data.response)
         {
             $('#quot_date').html(data.date);
             $('#q_date_success').show('slow');
             $('#quotation_valid_date_btn').html('Change')
             $('#quotation_valid_date_btn').prop('disabled' , false)
             setTimeout(function(){$('#quotation_valid_date_form').hide(); }, 4000);
         }
   
		}
		})
		return false;
	}
</script>

@stop