@extends('layouts.app')

@section('title')
Add Purchase Request
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Purchase Requests</li>
      </ol>
@stop
@section('css')

 <style type="text/css">
  .us_task_select
  {
      color: white;
      padding: 5px 10px 5px 10px;
      background: #080b12;
      border-radius: 20px;
  }
 </style>
@stop
@section('content')
  <div class="container-fluid">
  <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 style="text-align: right;" class="box-title m-b-0">
                            <span style="float: left;">Cash Purchase Request</span>

                         

                            <button style="font-size: 1.4rem;background: transparent;border: none;" onclick="return showTaskModal(this);" ></button>

                             </h3>
                            <p class="text-muted m-b-30 font-13">  </p>
                            <form class="form-horizontal" method="POST"  id="pr-form" onsubmit="return createPO();">
                                 {{csrf_field()}}
                                <div class="form-group">
                                   
                                    <div class="col-md-6">
                                    <label >Select Project</label>
                                    <select class="form-control chosen-select"  name="project" >
                                    
                                    <option value="{{env('PROJECT_ID')}}">{{env('APP_NAME')}}</option> 
                                    
                                    </select>
                                    @if ($errors->has('project'))
                                    <span >
                                    <strong class="error_messages" >{{ $errors->first('project') }}</strong>
                                    </span>
                                    @endif

                                    </div>


                                    <div class="col-md-6">
                                    <label >Select Department</label>
                                    <select class="form-control chosen-select"  name="department" >
                                    @if($departments->count() > 0  )
                                    @foreach($departments as $department_lists)
                                    <option value="{{ $department_lists->id }}">{{ $department_lists->department_name  }}</option> 
                                    @endforeach
                                    @endif
                                    </select>

                                    @if ($errors->has('department'))
                                    <span >
                                    <strong class="error_messages" >{{ $errors->first('department') }}</strong>
                                    </span>
                                    @endif

                                    </div>


                                    </div>

                                     <div class="form-group" >
                                      
                                    <div class="col-md-12">

                                    <h3 class="box-title m-b-0">Item List</h3>
                                    <div class="alert alert-danger" style="display: none;" id="noItemFound">
                                    <strong style="color: white;">Exception!</strong> No more items found.
                                    </div>

                                      </div>
                                     
                                     </div>


                                     <div class="form-group parent_div" >


                                    <div class="col-md-5">

                                        <div class="row">
                                            <div class="col-md-6">
                                                <select class="form-control  vendor-list" onchange="return getItemOfCurrentVendor(this)"   name="vendor[]">
                                                @if($vendors->count() > 0  )
                                                <option value="0">Select vendor</option>

                                                @foreach($vendors as $vendor)
                                                <option  value="{{ $vendor->id }}">{{ $vendor->name }}</option> 
                                                @endforeach
                                                @endif
                                                </select>
                                            </div>


                                            <div class="col-md-6">
                                                <select class="form-control  us_valid" onchange="return getItemLatestPrice(this)"  name="items[]">
                                                @if($items->count() > 0  )
                                                <option value="0">Select Item</option>

                                                @foreach($items as $item_lists)
                                                <option  value="{{ $item_lists->id }}">{{ $item_lists->item_name }} - {{ $item_lists->unit }}</option> 
                                                @endforeach
                                                @endif
                                                </select>
                                            </div>


                                        </div>

                                            

                                    </div>
                                 

                                    <div class="col-md-3">

                                    <div class="row">

                                    <div class="col-md-6">

                                         

                                    <input type="number" maxlength="6" class="form-control search item_qty" oninput="this.value = Math.abs(this.value)" id="item_qty" placeholder ="Qty..." value="" name="quantity[]">
                                    <span style="color:green; display: none;" class="current_item_store"></span>
                                    <span style="color:red; display: none;" class="limit_error"></span>
                                    </div>

                                    <div class="col-md-6">
                                    <input type="number" maxlength="6" class="form-control price" placeholder ="Price..." value=""  oninput="this.value = Math.abs(this.value)"  name="price[]">
                                    
                                    </div>
                                    </div>

                                    </div>


                                 <div class="col-md-3">
                                    
                                 <textarea class="form-control" name="description[]" placeholder="Item Description / Specification" id="description"></textarea>
                                 </div>
                                   

                                    <div class="col-md-1">
                                     <button type="button" style="width: 100%;" class="btn btn-success waves-effect waves-light m-r-10 " onclick="return add_new_item(this)"><i class="fa fa-plus" aria-hidden="true"></i></button>

                                    </div>

                                    </div>

                                    <div id="main_item_section">
                                        <!------Add new item List goes from here---->      
                                    </div>


                                    <div class="form-group" >
                                      <div class="col-md-12">
                                        <h3 class="box-title m-b-0">Approvals</h3>
                                      </div>
                                     
                                     </div>


                                    <div class="form-group">
                                         
                                    <div class="col-md-4">
                                    <ul style="margin-bottom: 20px;">
                                        <li>
                                            Select approval roles from below.
                                        </li>
                                   
                                    </ul>
                                    <input type="hidden" name="role_orders" id="role_orders">
                                    <select class="chosen-select"  name="role_name[]" id="roles" multiple>
                                    @if($approvel_roles->count() > 0  )
                                    @foreach($approvel_roles as $list)
                                    <option value="{{ $list->id }}">{{ $list->name }}</option> 
                                    @endforeach
                                    @endif
                                    </select>
                                  

                                    @if(Session::has('role_orders'))   
                                    <span >
                                    <strong class="error_messages" >{{ Session::get('role_orders') }}</strong>
                                    </span>
                                    @endif

                                    </div>

                                    </div>


                               
                            <div class="form-group">
                            <div class="alert alert-danger" style="display:none;" id="errorMessage">
                            </div>

                            <div class="alert alert-success" style="display:none;" id="sucessMessage">
                            </div>

                            <div class="col-md-12">
                            <button type="submit" class="btn btn-success waves-effect waves-light m-r-10" id="subBTN">Submit</button>
                            </div>

                            </div>

                            </form>
                        </div>
                    </div>
                </div>

      </div>


<input type="hidden" value="{{$items->count()}}"  id="total_item">

    <div id="vendor_list" style="display:none;" >
        
        <select class="form-control  vendor-list" onchange="return getItemOfCurrentVendor(this)"  name="vendor[]" >
            @if($vendors->count() > 0  )
                <option value="0">Select vendor</option>
                @foreach($vendors as $vendor)
                <option  value="{{ $vendor->id }}">{{ $vendor->name }}</option> 
                @endforeach
            @endif
        </select>

    </div>

@stop
@section('js')  

<script type="text/javascript">

let workOrderType =  false;

function getItemOfCurrentVendor(self) 
{
     $(self).closest('.parent_div').find('.us_valid').html('<option value="0">Select Item</option>');

    $.ajax({
    type : 'get',
    url : "{{route('purchase-requests.getVendorItems')}}",
    data:{'vendor_id':$(self).val()},
    dataType: 'json',
    success:function(data)
    {
        if (data.response == 'yes')
        {
            var output = '';
            output += '<option value="0">Select Item</option>';
           $.each(data.output.items, function(key, value) 
           {
            output += '<option value="'+value.id+'">'+value.item_name+' - '+value.unit+'</option>';
           });

            $(self).closest('.parent_div').find('.us_valid').html(output);
        }
    }
    });

    return false;
}

$(document).ready(function() {

$(document).on('keyup', '.search', function() {

$item_id = $(this).closest('.parent_div').find('.us_valid :selected').val();

$qty = $(this).val();

if (workOrderType == true) 
{
    $task_id =   $('#select_task').val();
}
else
{
    return false;
}

var div = $(this);

$.ajax({
type : 'get',
url : "{{route('purchase-requests.search')}}",
data:{'qty':$qty , 'item_id' :$item_id   , 'task_id' : $task_id  },
dataType: 'json',
success:function(data)
{
  if (data.response == 'limit_exceed')
   {
     div.closest('.parent_div').find('.limit_error').text('Limit Exceeded Max ('+data.max+')');
     div.closest('.parent_div').find('.limit_error').show();
   }
   else if (data.response == 'limit_not_exceed')
   {
     div.closest('.parent_div').find('.limit_error').hide();
   }
}
});

return false;
});

});

    function hideModal(self) {
   
     var type = $(self).val();

        if (type == 'with_work_order')
         {
           workOrderType = true
         }
         else if (type == 'without_work_order')
         {
             workOrderType = false   
         }
      
       $("#work_order_selection").modal('hide');

    return false;
    }

    function showTaskModal(self) {
        $("#work_order_selection").modal({backdrop: "static"});
        return false;
    }

    function select_task(self) 
    {

        if ($(self).val() != '0')
        {
            $("#work_order_selection").modal('hide');
            $('#task_name').text($('#select_task').find('option:selected').text())
            $("#task_name").addClass("us_task_select");
        }
        else
        {
            $('#task_name').text('')
            $('#us_tbl_list').html('')
            $("#task_name").removeClass("us_task_select");
        }

        return false;
    }



    function changeType(self)
     {
        var type = $(self).val();

        if (type == 'with_work_order')
         {
           $('#task_list').show()
           workOrderType = true
           $('#done_btn').show()

            $( ".us_valid" ).each(function() {

                if ( $( this ).val() == '0' )
                {
                  
                   $(this).closest('.parent_div').find('.search').prop('disabled', true); 
                }

            }); 
         }
         else if (type == 'without_work_order')
         {
             $('#task_list').hide()
             workOrderType = false
             $('#done_btn').show()

             $('.search').prop('disabled', false); 
              
         }
         else
         {
              $('#done_btn').hide()
         }

        return false;
    }


    function getItemLatestPrice(self)
    {

       var item_id =  $(self).find(':selected').val();

       if (item_id != 0) 
       {
         $(self).closest('.parent_div').find('.search').prop('disabled', false);
         $(self).closest('.parent_div').find('.search').val('');
       }

       if (item_id == 0) 
       {
         $(self).closest('.parent_div').find('.search').val('');
         $(self).closest('.parent_div').find('.search').prop('disabled', true);
       }


        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        $.ajax({
        url:"{{ route('purchase-requests.get-item-latest-price') }}",
        method:'POST',
        dataType:'json',
        data: {item_id:item_id },
        success:function(data)
        {
        
           if(data.response == 'yes')
           {
            
                $(self).closest('.parent_div').find('.current_item_store').html('Current Qty in Store: '+data.quantity)
                $(self).closest('.parent_div').find('.current_item_store').css('display', 'block')
                
               $(self).closest('.parent_div').find('.price').val(data.price)
           }
           else if(data.response == 'null')
           {
                $(self).closest('.parent_div').find('#item_qty').val(data.quantity)
                $(self).closest('.parent_div').find('.price').val("")
           }
           else
           {
            alert('Something Went wrong!')
            location.reload(true)
           }
        }
        })


      
        return false;
    }

function add_new_item(self)
{
    var total_item = parseInt($('#total_item').val());

    var remaining = total_item - 1;

    if(remaining > 0)
 {
  $('#total_item').val(remaining)
  $.ajax({
   url:"{{ route('get-dynamic-items.fetch') }}",
   method:'GET',
   dataType:'json',
   success:function(data)
   {
    if(data.response == 'yes')
    {
    
    var output = '';

    output += ' <div class="form-group parent parent_div" >  <div class="col-md-5">  <div class="row"><div class="col-md-6" >'+$('#vendor_list').html()+'</div><div class="col-md-6"> <select class="form-control chosen-select us_valid" onchange="return getItemLatestPrice(this)" id="chosen-select'+data.id+'" name="items[]">';
    output += '<option value="0">Select Item</option>';
    $.each(data.items, function(key, value) {
    output += '<option value="'+value.id+'">'+value.item_name+' - '+value.unit+'</option>';
    });

     output += '</option> </select>  </div></div> </div> <div class="col-md-3"><div class="row"><div class="col-md-6"><input type="number" maxlength="6" class="form-control search" placeholder ="Qty..." id="item_qty" oninput="this.value = Math.abs(this.value)" value="" name="quantity[]"><span style="color:green; display: none;" class="current_item_store"></span><span style="color:red; display: none;" class="limit_error"></span></div><div class="col-md-6"><input type ="number" maxlength="6" class="form-control price" placeholder ="Price..." oninput="this.value = Math.abs(this.value)" value="" name="price[]"></div></div></div> <div class="col-md-3"><textarea class="form-control" name="description[]" placeholder="ItemDescription / Specification" id="description"></textarea></div><div class="col-md-1"><button type="button" style="width: 100%;" class="btn btn-danger waves-effect waves-light m-r-10 " onclick="return remove_item(this)"><i class="fa fa-trash-o" aria-hidden="true"></i></button></div> </div>';

      $('#main_item_section').append(output);
      $('#chosen-select'+data.id).chosen-select();

     if (workOrderType == true) 
    {
           
           $( ".us_valid" ).each(function() {

            if ( $( this ).val() == '0' )
            {
              
               $(this).closest('.parent_div').find('.search').prop('disabled', true); 
            }

            });

    }

       if (workOrderType == false) 
    {
          $(".search").prop('disabled', false); 
    }


    }
    
   }
  })

}
else
{
    $('#noItemFound').show('slow')
    setTimeout(function(){ $('#noItemFound').hide('slow') }, 3000);
}

return false;
}



function createPO() {
   
    $('#subBTN').html('Processing...')
    $('#subBTN').prop('disabled' , true);

    var pr_form = document.getElementById("pr-form");
    var fd = new FormData(pr_form );

    if (workOrderType == true) 
    {
        var work_order_type =  $('#select_task').val();

        fd.append("work_order_type", work_order_type);
    }
        fd.append("workOrderType", workOrderType);
        fd.append("pr_type", 'direct_pr');

    $.ajax({
        url:"{{ route('purchase-requests.insert') }}",
        data: fd,
        cache: false,
        processData: false,
        contentType: false,
        type: 'POST',
        dataType: 'json',
        success: function (data) 
        {
            if(data.quantity || data.items || data.price || data.project || data.department || data.role_orders || data.max_quantity_error)
            {
                  $('#errorMessage').html(data.message)
                  $('#errorMessage').show()
                  $('#subBTN').html('Submit')
                  $('#subBTN').prop('disabled' , false);
                  setTimeout(function(){ $('#errorMessage').hide() }, 5000);
            }

            if(data.success)
            {
                  $('#sucessMessage').html(data.message)
                  $('#sucessMessage').show()
                  setTimeout(function(){ window.location.href = "{{ route('purchase-requests.list') }}"; }, 3000);
            }

        }
    });
  

  return false;
}

function remove_item(self)
{
    $(self).closest('.parent').remove()
    var total_item = parseInt($('#total_item').val());
    var remaining = total_item + 1;
    $('#total_item').val(remaining)
    return false;
}

</script>
@stop