@extends('layouts.app')

@section('title')
View Purchase Request
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Purchase Requests</li>
      </ol>
@stop

@section('content')
  <div class="container-fluid">
  <div class="row">
                    
                    <div class="col-sm-12">
                    <div class="white-box">

                    @permission('create-purchase-order')
                    <h3 style="text-align: right;" class="box-title m-b-0">
                    <span style="float: left;">Purchase Requests List</span>
                    <a class="btn btn-info" href="{{ route('purchase-requests.add') }}">New PR</a>
                    <a class="btn btn-info" href="{{ route('purchase-requests.add.cash') }}">Cash PR</a>
                    </h3>
                    @endpermission
                    <div class="table-responsive">

                    @if(Session::has('success'))   
                    <div id="successMessage" class="alert alert-success" role="alert">
                    {{ Session::get('success') }}
                    </div>
                    @endif

                    <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                    <thead>
                    <tr role="row">
                    <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 10px;">Id#</th>

                    <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 203px;">Department</th>


                    <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Created By</th>


                    <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 150px;">Current Status</th>


                    <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 150px;">Type</th>


                    <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 13px;">Action</th>

                    </tr>
                    </thead>
                    <tbody>
  
                    @if( count($purchase_requests) > 0 )
                    @foreach( $purchase_requests as $list )

                  <tr role="row" class="odd">

                    <td>PR-{{$list->id }} 
                       
                      </td>


                        <td>
                            {{ \App\Department::withTrashed()->find($list->department_id)->department_name }}  
                        </td>

                        <td>{{ $list->user->name}} </td>


                         <td>
                             @if($list->status == 0)
                               <span style="color:#efbb00;">Pending</span>
                               @elseif($list->status == 1)
                               <span style="color:#ffbd02;">Approvals In Progress</span>
                               @elseif($list->status == 2)
                               <span style="color:red;">Rejected  (<a href="javascript:void(0);" onclick="return showRemarks(this)"><small>remark</small> <span style="display: none;" id="remk">{{$list->cancellation_remarks}}</span></a>)</span>
                                @elseif($list->status == 3)
                               <span style="color:#0d6efd;">RFQ</span>
                               @elseif($list->status == 4)
                               @permission('view-request-for-quotation')
                               <span style="color:#0d6efd;"><a target="_blank" href="{{ route('request-for-quotations.view' , [$list->id]) }}">RFQ SEND</a></span>
                               @endpermission
                               @elseif($list->status == 5)
                               @permission('view-comparative-statement')
                                <span style="color:#0d6efd;"><a target="_blank" href="{{ route('comparative-statements.view' , [$list->id]) }}">CS Received</a></span>
                                @endpermission
                                @elseif($list->status == 6)
                                @permission('view-purchase-order')
                                <span style="color:#0d6efd;"><a target="_blank" href="{{ route('purchase-orders.view' , [$list->id]) }}">PO Sent</a></span>
                                @endpermission
                                @elseif($list->status == 7)
                                @php
                                 $getPrStatus = \App\PurchaseRequest::getPrStatus($list->id);
                                @endphp
                                

                                @if( $getPrStatus['pending_po'] > 0)
                                @permission('view-purchase-order')
                                <span style="color:#0d6efd;"><a style="font-size: 12px;" target="_blank" href="{{ route('purchase-orders.view' , [$list->id]) }}">PO PENDING</a> <span style="padding: 0px 5px 0px 5px;border-radius: 50%;color: white;position: relative;bottom: 15px;background: red;">{{ $getPrStatus['pending_po'] }}</span></span>
                                @endpermission
                                @elseif( $getPrStatus['pending_recipt'] > 0)

                                @permission('view-po-receipt')
                                <span style="color:#0d6efd;"><a  style="font-size: 12px;" target="_blank" href="{{ route('purchase-order-receipts.view' , [$list->id]) }}">RECEIPT PENDING</a><span style="padding: 0px 5px 0px 5px;border-radius: 50%;color: white;position: relative;bottom: 15px;background: red;">{{$getPrStatus['pending_recipt']}}</span></span>
                                @endpermission

                                @elseif($getPrStatus['total_rfq'] > $getPrStatus['total_cs'])
                                @permission('view-request-for-quotation')
                                <span style="color:#0d6efd;font-size: 12px;"><a target="_blank" href="{{ route('request-for-quotations.view' , [$list->id]) }}">CS PENDING</a><span style="padding: 0px 5px 0px 5px;border-radius: 50%;color: white;position: relative;bottom: 15px;background: red;">{{$getPrStatus['total_rfq'] - $getPrStatus['total_cs']}}</span></span>
                                @endpermission
                                @else
                                <span style="color:#0ef30e;">Complete</span>
                                @endif

                             @endif
                         </td>

                         <td>
                             @if($list->pr_type == 'direct_pr')

                             <span style="padding: 5px 10px 5px 10px;background: antiquewhite;border-radius: 15px;">Cash</span>

                             @else

                             <span style="padding: 5px 10px 5px 10px;background: #68cbfb;border-radius: 15px;">Fully Processed</span>

                             @endif
                         </td>
                    
                     <td>
                            @permission('view-purchase-request')
                            <a  href="{{route('purchase-requests.view',[$list->id] ) }}">
                              <button class="btn btn-link btn-s" style="color:#fdb024;" >
                                <i class="fa fa-eye" aria-hidden="true"></i>
                              </button>
                              </a>
                            
                            {{-- <a style="color:#fdb024;font-size: 1.9rem;"  href="{{ route('purchase-requests.view',[$list->id] ) }}"><i class="fa fa-eye" aria-hidden="true"></i></a> --}}
                            @endpermission

                            @permission('delete-purchase-request')

                            <form action="{{ route('purchase-requests.delete',[$list->id] ) }}"
                              method="post" style='display: inline;'>
                              @method('DELETE')
                              @csrf
                              <button class="btn btn-link btn-s" style="color:red;"
                                  type="submit" name="action" value="delete"
                                  data-toggle="confirmation"
                                  data-title="Are you sure to delete?">
                                  <i class="fa fa-trash-o" aria-hidden="true"></i>
                              </button>
                          </form>
                            {{-- <a style="color:red; margin-left: 1rem;" href="{{ route('purchase-requests.delete',[$list->id] ) }}" data-toggle="confirmation" data-title="Are you sure to delete?" ><i class="fa fa-trash-o" aria-hidden="true"></i></a> --}}
                            @endpermission

                            @if($list->status == 0 && $list->pr_type == 'indirect_pr')
                            @permission('edit-purchase-request')

                            
                            <a  href="{{ route('purchase-requests.edit', [$list->id] )}}">
                              <button class="btn btn-link btn-s">
                                  <i class="fa fa-pencil-square-o" aria-hidden="true"></i>
                              </button>
                              </a>
                          
                            {{-- <a style="margin-left: 1rem;"  href="{{ route('purchase-requests.edit', [$list->id] ) }}"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a> --}}
                            @endpermission
                            @endif

                    </td>
                    </tr>
                 @endforeach   
                 @endif

                                      
              </tbody>
              </table>

              </div>
              </div>
              </div>
              </div>


              </div>

              </div>



<div class="modal fade" id="pr_remarks" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog" role="document">
<div class="modal-content">
<div class="modal-header">
<h5 class="modal-title" id="exampleModalLabel">Why this purchase Request Cancel</h5>
<button type="button" class="close" data-dismiss="modal" aria-label="Close">
<span aria-hidden="true">&times;</span>
</button>
</div>
<div class="modal-body" id="remark_div">

</div>
<div class="modal-footer">
<button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
</div>
</div>
</div>
</div>



@stop

@section('js')  

<script type="text/javascript">

    function showRemarks(self) 
    {
        var remark = $(self).find('#remk').text();

        if (remark.length > 0) 
        {
             $('#remark_div').html(remark)
        }
        else
        {
             $('#remark_div').html('<center> No Remarks Added</center>')
        }
      
       $('#pr_remarks').modal('show')

        return false;
    }
</script>
@stop