@extends('layouts.app')
@section('title')
View Purchase Request
@stop
@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
@stop

@section('breadcrumb')
                <ol class="breadcrumb pull-right">
                <li>
                         <a href="{{route('home')}}">
                         <i class="fa fa-dashboard"></i> Home
                </a>
                </li>
		<li class="active">Purchase Requests</li>     
	        </ol>
		@stop
		@section('content')       
		<div class="container-fluid">           
		<div class="row">                  
		<div class="col-md-12"> 
		<div style="padding:3rem;" class="white-box " id="printableSection">     
		<h3 class="box-title avoid-this" style="margin-bottom: 3rem;"> <b style="font-size: 2.2rem;">Purchase Request / </b>
			PR-{{$purchase_request->id}}     
		<span style="float: right;font-size: 1.5rem;">
		Role : {{ ucfirst(\App\ Role::with('user')->find($role)->name) }}</span>   
		<br>                          
		@if($purchase_request->approval_status[0]->approvel_status == 0)
		<span class ="status-pen">Status : Pending</span>			
		@elseif($purchase_request->approval_status[0]->approvel_status == 1)      
		<span class="status-approv">Status : Approved</span>			
		@elseif($purchase_request->approval_status[0]->approvel_status == 2)
		<span class="status-reject"> Status : Rejected</span>
		@endif                     
		</h3>                                
		<div class="">             
		@php     
	        $department = json_decode(json_encode($purchase_request->department), true); 
		@endphp 
		<center>
		<div class="row hide-default" >				
		<h3 class="box-title">
		<?= (env('DOCUMENT_LOGO')) ? '<img src="'.asset(env('DOCUMENT_LOGO')).'" class="logo-img"><br>' : '' ?>
		{{env('APP_NAME')}}
	        </h3>

		<div class="col-md-12" id="GRN-CNG" style="border: 1px solid;color: black; text-align: center;font-weight: bold;padding: 1rem;font-size: 1.5rem; margin-bottom: 3rem;">                                 
		  PURCHASE REQUISITION APRROVAL								</div>
		<table style="width: 100%;margin-top: -0.1rem;" id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">	
		<thead>						
		<tr role="row">			
		<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">PR-ID </th>	
		<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Created By  </th>	
		<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Created At  </th>	
		</tr>						
		</thead>		
		<tbody>			
		<tr role="row" class="odd">		
		<td>{{ $purchase_request->id }}</td>		
		<td>{{ $purchase_request->user->name }} </td>			
		<td>{{ date('Y-F-d' , strtotime($purchase_request->created_at))}}</td>		
		</tr>							
		</tbody>						
		</table>					
		<table style="width: 100%;margin-top: -0.1rem;" id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">			
		<thead>					
		<tr role="row">					
		<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Project </th>			
		<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Phone </th>		
		<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Department </th>	
		</tr>						
		</thead>						
		<tbody>					
		<tr role="row" class="odd">			
		
		<td>{{ env('APP_NAME') }}</td>	
		<td>{{ env('APP_CONTACT') }}</td>		
		<td>{{Ucfirst($department['department_name'])}}</td>		
		</tr>						
		</tbody>						
		</table>						
		</div>						
		</center>                 			
		<div class="row avoid-this">	
		<div class="col-md-6 col-xs-6 div-border" style="margin-top: 2rem;">	
		<span style="color:black;font-weight: bold;" class="font-weight-bold">Project</span>
		<span style="margin-left: 2rem;font-weight: 400;" id="project_name" class="blk_clr">	
		{{ env('APP_NAME') }}							
		</span>						
		</div>						
		<div class="col-md-6 col-xs-6 div-border" style="margin-top: 2rem;">	
		<span style="color:black;font-weight: bold;" class="font-weight-bold">Department</span>		
		<span style="margin-left: 2rem;font-weight: 400;" class="blk_clr">						
		{{Ucfirst($department['department_name'])}}						
		</span>							
		</div>							
		<div class="col-md-6 col-xs-6 div-border" style="margin-top: 2rem;">	
		<span style="color:black;font-weight: bold;" class="font-weight-bold">Created By</span> 
		<span style="margin-left: 2rem;font-weight: 400;" class="blk_clr">							
		{{ $purchase_request->user->name}}			
		</span>					
		</div>						
		<div class="col-md-6 col-xs-6 div-border" style="margin-top: 2rem;">
		<span style="color:black;font-weight: bold;" class="font-weight-bold">Created At</span> 
		<span style="margin-left: 2rem" class="blk_clr">							
		{{date('Y-F-d' , strtotime($purchase_request->created_at))}}			
		</span>						
		</div>							
		<div class="col-md-6 col-xs-6 div-border" style="margin-top: 2rem;">	
		<span style="color:black;font-weight: bold;" class="font-weight-bold">Current Status</span>	
		@if($purchase_request->status == 0)							
			<span style="color:#ffed14;margin-left: 2rem">Pending</span>	
		@elseif($purchase_request->status == 1)							
		<span style="color:#ffbd02;margin-left: 2rem">					
		Approvals In Progress</span>				
		@elseif($purchase_request->status == 2)				
		<span style="color:red;margin-left: 2rem">Rejected</span>		
		@elseif($purchase_request->status == 3)						
		<span style="color:#0d6efd;margin-left: 2rem">RFQ</span>	
		@elseif($purchase_request->status == 4)						
		<span style="color:#0d6efd;margin-left: 2rem"><a target="_blank" href="{{ route('request-for-quotations.view' , [$purchase_request->id]) }}">RFQ SEND</a>
		<span class="avoid-this" style="padding: 2px 7px 2px 7px;border-radius: 50%;color: white;position: relative;bottom: 15px;right: 10px;background: red;">{{$total_rfq}}</span></span>
		@elseif($purchase_request->status == 5)							
		<span style="color:#0d6efd;margin-left: 2rem"><a target="_blank" href="{{ route('comparative-statements.view' , [$purchase_request->id]) }}">CS Received</a> 
		<span class="avoid-this" style="padding: 2px 7px 2px 7px;border-radius: 50%;color: white;position: relative;bottom: 15px;right: 10px;background: red;">{{$total_cs}}</span></span>	
		@elseif($purchase_request->status == 6)						
		<span style="color:#0d6efd;margin-left: 2rem"><a target="_blank" href="{{ route('purchase-orders.view' , [$purchase_request->id]) }}">PO Sent</a> 
		<span class="avoid-this" style="padding: 2px 7px 2px 7px;border-radius: 50%;color: white;position: relative;bottom: 15px;right: 10px;background: red;">{{$total_po}}</span></span>		
		@elseif($purchase_request->status == 7)                        							
		@if($pending_po > 0)							
			<span style="color:#0d6efd;margin-left: 2rem"><a target="_blank" href="{{ route('purchase-orders.view' , [$purchase_request->id]) }}">PO PENDING</a> <span class="avoid-this" style="padding: 2px 7px 2px 7px;border-radius: 50%;color: white;position: relative;bottom: 15px;right: 10px;background: red;">{{$pending_po}}</span></span>		
		@elseif($pending_recipt > 0)				
		<span style="color:#0d6efd;margin-left: 2rem"><a target="_blank" href="{{ route('purchase-order-receipts.view' , [$purchase_request->id]) }}">RECEIPT PENDING</a><span class="avoid-this" style="padding: 2px 7px 2px 7px;border-radius: 50%;color: white;position: relative;bottom: 15px;right: 10px;background: red;">{{$pending_recipt}}</span></span>		
		@elseif($total_rfq > $total_cs)		
		<span style="color:#0d6efd;margin-left: 2rem"><a target="_blank" href="{{ route('request-for-quotations.view' , [$purchase_request->id]) }}">CS PENDING</a><span class="avoid-this" style="padding: 2px 7px 2px 7px;border-radius: 50%;color: white;position: relative;bottom: 15px;right: 10px;background: red;">{{$total_rfq - $total_cs}}</span></span>		
		@else						
			<span style="color:#0ef30e;margin-left: 2rem">Complete</span>		
		@endif                
		@endif				
		</div>				
		</div>				
		<h3 class="box-title avoid-this" style="margin-top: 5rem;text-align: right;">		
		<b style="float:left;font-size: 2rem;">Items</b>	
		<a style="float: right;margin-bottom: 1rem;" class="btn btn-warning btn-sm avoid-this" id="print" href="#">Print</a>	
		</h3>                                                
		<table id="myTable" style="margin-top: -0.1rem;" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">	        
		<thead>							
		<tr role="row">		
		<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 10px;">Code</th>		
		<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Item - Brand</th>  
		<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Description</th>	
		<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 50px;">Quantity</th>	
		<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 50px;">Unit Price</th>			
		<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 13px;">Subtotal</th>							
		</tr>	                    
        </thead>             
		<tbody>  			 
		<?php  $count = 0; $amount = 0;  $quantity = 0;?>	
		@foreach( \App\PurchaseRequest::find($purchase_request->id)->item as $list )		
		@php                               
		$item = \App\Item::withTrashed()->find($list->item_id);			    
		@endphp			                 
		<tr role="row" class="odd">		
		<td>{{$item->item_code}} </td>		
		<td class="item_name">
		{{$item->item_name}} - {{$item->manufacture->name}}
		<?= ($item->risk_type == 'critical') ? '<span class="critical">Critical</span>' : '<span class="non_critical">Non Critical</span>' ?>
		</td>	
		<td class="description"> 							
		<span class="default-text">{{$list->description}}</span>
		<span class="after-load-more" style="display:none;"></span>		
		</td>							
		<td>{{number_format($list->quantity , 2)}} </td>		
		<td> {{number_format($list->price , 2)}} </td>	
		<td>PKR {{number_format($list->price * $list->quantity , 2)}} </td>		
		</tr>			                 
		<?php $count ++; $amount += ( $list->price * $list->quantity ); $quantity += $list->quantity; ?>
		@endforeach   			                 
		</tbody>			      
		</table> 
		<center>
		<div class="row hide-default" >		
		<table style="width: 100%;margin-top: -0.1rem;" id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">							<thead>							<tr role="row">							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Approval Role </th>							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Status </th>							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;"> Date</th>							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;"> Signature</th>							</tr>							</thead>							<tbody>							<tr role="row" class="odd">							<td>								<b>									{{ ucfirst(\App\ Role::with('user')->find($role)->name) }}								</b>							</td>							<td>								@if($purchase_request->approval_status[0]->approvel_status == 0)								{{ 'Pending' }}								@elseif($purchase_request->approval_status[0]->approvel_status == 1)                                {{ 'Approved' }}								@elseif($purchase_request->approval_status[0]->approvel_status == 2)								{{'Rejected'}}								@endif							</td>							<td>								{{ date('d-F-Y' , strtotime($purchase_request->approval_status[0]->updated_at)) }}							</td>							<td></td>							</tr>							</tbody>							</table>							<table style="width: 100%;margin-top: -0.1rem;" id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">							<thead>							<tr role="row">							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Total Item(s)</th>							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Total Item Quantity(s) </th>							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Total Total Amount </th>							</tr>							</thead>							<tbody>							<tr role="row" class="odd">							<td>{{number_format($count, 2)}}</td>							<td>{{number_format($quantity, 2)}}</td>							<td>{{number_format($amount, 2)}}</td>							</tr>							</tbody>							</table>							</div>							</center>                        <div style="float-left:right;color:black !important; " class="hide-default">							<b>Date : </b> {{date('d-F-Y')}}							<br>							<b >Print By : </b>{{ Ucfirst(Auth::user()->name) }}							</div>								<div class="row avoid-this">                                <div class="col-md-6 col-xs-6">                                <span style="color:black;margin-top: 1rem;" class="dis_block">Name & Signature</span>								<input type="text" readonly="readonly" placeholder="Type here ..." style="border:none;border-bottom: 1px solid gray; margin-top: 5rem;margin-left: 1rem;font-size: 1.2rem;color: black;" value="{{ ucfirst(\App\ Role::with('user')->find($role)->name) }}" id="name_account_officer">                                </div>								<div class="col-md-6 col-xs-6" style="text-align: right;">								<div class="pricing-section">								<p>								<b style="color:black;" class="us-text">Total Item:</b> <span style="margin-left: 12rem;" class="blk_clr"> {{number_format($count, 2)}}</span>								</p>								<p>								<b style="color:black;" class="us-text">Total Item Quantity:</b> <span style="margin-left: 5rem;" class="blk_clr"> {{number_format($quantity, 2)}}</span>								</p>								<b style="color:black;" class="us-text">Total Amount:</b> 								<span style="margin-left: 3rem" class="blk_clr"> 								PKR {{number_format($amount , 2) }}								</span>								</div>								</div>                                 </div>                                 								</div>								</div>								</div>								</div>								</div>								</div>							<div class="modal fade" id="rfqModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel1">							<div class="modal-dialog" role="document">							<div class="modal-content">							<div class="modal-header">							<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>							<h4 class="modal-title" id="exampleModalLabel1">SENT RFQ </h4></div>							<div class="modal-body">							<div class="alert alert-success" role="alert" style="display: none;" id="succeessMessage">							Your request for quotation send successfully to all vendors.							</div>							<form method="post" onsubmit="return sendRfq('{{$purchase_request->id}}' , this)">							<div class="form-group">							<label for="recipient-name" class="control-label">Quotation Valid Until <b style="color:red;">*</b></label>							<span id="quatation_date_error" style="color:red; display: none;"></span>							<input type="date" min="{{date('Y-m-d')}}" class="form-control" id="quatation_date"></div>							<div class="form-group">							<label for="recipient-name" class="control-label">Selected Vendors <b style="color:red;">*</b></label>							<span id="selected_vendor_error" style="color:red; display: none;">Please Select Valid Vendor.</span>							<span id="vendor_list"></span>												    	</div>							<div class="form-group">							<label for="message-text" class="control-label">Important Instructions: (Optional)</label>							<textarea class="form-control" rows="5" id="message"></textarea>							</div>												</div>							<div class="modal-footer">							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>					
		<button type="submit" class="btn btn-primary" id="thisBtn" >Send</button>	
		</form>						
		</div>						
		</div>						
		</div>
		@stop
		@section('js')
		<script type="text/javascript">$(document).ready(function() {
			$('.odd').each(function(){var description = $(this).find('.description .default-text').text();
			var word = description.split(" ");if(description.length > 20 )
			{
				$(this).find('.after-load-more').html(description);
				var content =   description.slice(0 , 20)+'... <a href="javascript:void(0)" onclick="return showContent(this)">load more</a>'
				$(this).find('.description .default-text').html(content);
				}
				
				});
				});
				function showContent(self) {
					$(self).closest('.description').find('.after-load-more').show();
					$(self).closest('.description').find('.default-text').hide();
					}	function getVendorForRfq(pr_id , self)
					{	
					$(self).html('Proccessing...');		
					$(self).prop('disabled' , true);		
					$.ajaxSetup({		
					headers: {		
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')	
					}		
					});		
					$.ajax({	
					url:"{{ route('request-for-quotations.get-vendor-for-rfq') }}",		method:'POST',		dataType:'json',		data: {pr_id:pr_id},		success:function(data)		{                  if (data.response == 'yes')          {         	var output = '';			output += '<select class="chosen-select" id="rfq_vendors" multiple="multiple" name="vendors[]">';			$.each(data.vendor, function(key, value) {			output += '<option value="'+value.id+'">'+value.name+'</option>';			});			output += '</select> ';			$('#vendor_list').html(output);			$('#rfqModal').modal('show');			$('#rfq_vendors').chosen-select();			$('#rfq_vendors').val(data.vendor_keys).change();			$(self).html('SEND RFQ BY EMAIL');		    $(self).prop('disabled' , false);         }         else         {         	alert('Something went wrong. Click Ok to reload');         	location.reload(true);         }		}		})				return false;	}	$('#pending_cs').tooltip('show');	function sendRfq(pr_id , self)	{		$('#thisBtn').html('Proccessing...');		$('#thisBtn').prop('disabled' , true);       var quatation_date = $('#quatation_date').val();       var message = $('#message').val();       var project_name = $('#project_name').text();       var vendors = $('#rfq_vendors').val();				$.ajaxSetup({		headers: {		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')		}		});		$.ajax({		url:"{{ route('request-for-quotations.sendRfq') }}",		method:'POST',		dataType:'json',		data: {purchase_request_id:pr_id , quatation_date:quatation_date , message:message , project_name:project_name , vendors:vendors},		success:function(data)		{         if(data.quatation_date)         {			$('#quatation_date_error').text(data.quatation_date);			$('#quatation_date_error').show();			$('#thisBtn').html('Send');			$('#thisBtn').prop('disabled' , false);         }          else if(data.purchase_request_id)         {         	alert('Somethign went wrong.')         	location.reload(true)         }         else if(data.response)         {           $('#succeessMessage').show('slow');           setTimeout(function(){ location.reload(true); }, 3000);         }         else if(data.empty)         {         	$('#selected_vendor_error').show('slow');           setTimeout(function(){$('#selected_vendor_error').hide('slow'); }, 3000);         }         else         {         	alert('Somethign went wrong.')         	location.reload(true)         }		}		})       return false;	}    function validate()    {         if(!confirm('Are you sure you want to cancel this purchase request?'))        {            return false;        }     }  $("#approvalBtn").click(function() {    $('html, body').animate({        scrollTop: $("#approval_section").offset().top    }, 1000);});</script>
		@stop
