@extends('layouts.app')

@section('title')
View Purchase Request
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Purchase Requests</li>
      </ol>
@stop
@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
 <style type="text/css">
 	.popover-title
 	{
 		text-align: center;
 		    cursor: pointer;
 	}
 </style>
@stop
@section('content')
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                       <div style="padding:3rem;" class="white-box " id="printableSection">


							<h3  class="box-title align-right avoid-this" style="margin-bottom: 3rem;">

							<span class="float-left" >
							<b class="font-size">
							Purchase Request
							</b> <span class="avoid-this">/  PR-{{$purchase_request->id}}</span> 
							</span>


							<!-------------------------------------------------------
             			MI Code Starts Here
             		-------------------------------------------------------->
					@if($purchase_request->status == 0 && $approval == 1)
            		<form method="POST" style="display: inline;" action="{{ route('purchase-request-approvals.changeStatus') }}"  id="pr_approval_form_">
		                {{csrf_field()}}
		                <input type="hidden" name="role_id" id="role_id" value="{{Auth::user()->role->role_id}}">
		                <input type="hidden" name="pr_id" id="pr_id" value="{{$purchase_request->id}}">
		                
		                <button type="submit" name="status" class="btn btn-success avoid-this" value="approve" style="background: #5cb85c; border-color: #5cb85c;">Approve</button>
	                </form>
	                @endif

	                @if($purchase_request->status == 4)
	                @permission('view-request-for-quotation')
	                <a class="btn btn-success avoid-this" href="{{route('request-for-quotations.view' , [$purchase_request->id])}}">Receive CS</a>	
					@endpermission
					@endif

					@if($purchase_request->status == 5)
	                @permission('view-comparative-statement')
	                <a class="btn btn-success avoid-this" href="{{ route('comparative-statements.view' , [$purchase_request->id]) }}">Make PO</a>	
					@endpermission
					@endif
             		<!-------------------------------------------------------
             			MI Code Ends Here
             		-------------------------------------------------------->
             		

							@if($purchase_request->status == 0)
							@permission('edit-purchase-request')
							<a class="btn btn-info avoid-this" href="{{route('purchase-requests.edit' , [$purchase_request->id])}}">Edit</a>
							@endpermission
							@endif
							<a class="btn btn-warning avoid-this" id="print" href="#">
							Print
						    </a>
							@permission('delete-purchase-request')
							<a class="btn btn-danger avoid-this"  href="{{route('purchase-requests.delete' , [$purchase_request->id])}}" data-toggle="confirmation" data-title="Are you sure to delete?" >Cancel</a>
							@endpermission

							@if($purchase_request->status  == 3)
							@permission('send-request-for-quotation')
							<a class="btn btn-warning avoid-this" href="#" onclick="return getVendorForRfq('{{$purchase_request->id}}' , this)" >
							SEND RFQ </a>
							@endpermission
							@endif

							</h3>

					


								<!------------------Print Section--------------------->


<div class="row hide-default">
					<div class="col-md-12">
						<h3 class="box-title" style="margin-bottom: 1rem;">
							<span class="float-left" style="border: 1px solid black; padding: 5px 10px;">
								<b class="font-size" style="font-weight:bold;">{{env('APP_NAME')}}</b>
							</span>
						</h3>
						<br>
						<h3 class="box-title text-center" style="margin-bottom: 1rem;">
							<span>
								<b class="font-size">DEMAND / INDENT / PURCHASE REQUISITION</b>
							</span>
						</h3> 
					</div>
				</div>

				<div class="row hide-default">
					<div class="col-md-4 col-xs-4">
						<table style="width: 100%;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid" >
							<tbody>
								<tr>
									<td style="font-weight:bold;">DEPARTMENT:</td>
									<td>{{$purchase_request->department->department_name}}</td>
								</tr>
								<tr>
									<td style="font-weight:bold;">PROJECT:</td>
									<td>{{env('APP_NAME')}}</td>
								</tr>
								<tr>
									<td style="font-weight:bold;">CONTRACTOR:</td>
									<td>&nbsp;</td>
								</tr>
							</tbody>
						</table>
					</div>
					<div class="col-md-5 col-xs-5"></div>
					<div class="col-md-3 col-xs-3">
						<table style="width: 100%;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid" >
							<tbody>
								<tr>
									<td style="font-weight:bold;">No:</td>
									<td>PR-{{$purchase_request->id}}</td>
								</tr>
								<tr>
									<td style="font-weight:bold;">Date:</td>
									<td>{{date('d-F-Y' , strtotime($purchase_request->created_at))}}</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>
				<br>
				<div class="row hide-default">
					<div class="col-md-2 col-xs-2" style="font-weight:bold;">PURPOSE:</div>
					<div class="col-md-10 col-xs-10">
						<p style="border-bottom: 1px solid black;">&nbsp;</p>
					</div>
				</div>

				<div class="row hide-default">
					<div class="col-md-12">
						<table style="width: 100%;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid">
							<thead class="text-center">
								<tr>
									<td rowspan="2" style="font-weight:bold;">S.No.</td>
									<td rowspan="2" style="font-weight:bold;">Description</td>
									<td rowspan="2" style="font-weight:bold;">Make</td>
									<td rowspan="2" style="font-weight:bold;">Unit</td>
									<td colspan="2" style="font-weight:bold;">Quantity</td>
									<td rowspan="2">Total Required as per BOQ</td>
									<td rowspan="2">Booked till to date</td>
									<td rowspan="2">Received till to date</td>
									<td rowspan="2">Balance till to date</td>
									<td rowspan="2">Now Demanded</td>
									<td rowspan="2">Remarks</td>
								</tr>
								<tr>
									
									<td style="font-weight:bold;">Demanded</td>
									<td style="font-weight:bold;">Sanctioned</td>
									
								</tr>
							</thead>
							<tbody>

								@foreach( $purchase_request->item as $list )


								@php
								$item = \App\Item::withTrashed()->find($list->item_id);
								@endphp

								<tr>
									<td>{{$item->item_code}}</td>
									<td>{{$item->item_name}}
								     <?= ($item->risk_type == 'critical') ? '<span class="critical">Critical</span>' : '<span class="non_critical">Non Critical</span>' ?></td>
									<td>{{$item->manufacture->name}}</td>
									<td>{{$item->unit}}</td>
									<td>{{number_format($list->quantity , 2)}}</td>
									<td>&nbsp;</td>
									<td>&nbsp;</td>
									<td>&nbsp;</td>
									<td>&nbsp;</td>
									<td>&nbsp;</td>
									<td>{{number_format($list->quantity , 2)}}</td>
									<td>{{$list->description}}</td>
								</tr>

								@endforeach
								

							</tbody>
						</table>
					</div>	
				</div>

				<div class="row hide-default">
					<div class="col-md-12" style="font-weight:bold;"><u>REMARKS</u></div>
				</div>
				<br>
				<div class="row hide-default">
					<div class="col-md-12">
						<p style="border-bottom: 1px solid black;">&nbsp;</p>
					</div>
				</div>
				<br>
				<div class="row hide-default">
					<div class="col-md-12">
						<p style="border-bottom: 1px solid black;">&nbsp;</p>
					</div>
				</div>
				<br>
				<div class="row hide-default">
					<div class="col-md-4 col-xs-4">
						<table style="width: 100%; margin-bottom: 0;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid">
							<tbody>
								<tr>
									<td><br><br><br><br><br><br></td>
								</tr>
								<tr><td><strong><center>ORIGINATED BY</center></strong></td></tr>
								<tr><td>Name: {{ $purchase_request->user->name}}</td></tr>
								<tr><td>Designation: {{ $purchase_request->user->roles[0]->display_name }}</td></tr>
							</tbody>
						</table>
						<p style="padding: 0px 10px;">(To be signed & stamped<br>
						in case of contractor)</p>
					</div>
					<div class="col-md-4 col-xs-4">
						<table style="width: 100%;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid">
							<tbody>
								<tr>
									<td><br><br><br><br><br><br></td>
								</tr>
								<tr><td><strong><center>RECOMMENDED BY (DEPTT. HEAD)</center></strong></td></tr>
								<tr><td>Name: </td></tr>
								<tr><td>Designation:</td></tr>
							</tbody>
						</table>
					</div>
					<div class="col-md-4 col-xs-4">
						<table style="width: 100%;" id="myTable" class="table table-bordered dataTable color-table primary-table" role="grid">
							<tbody>
								<tr>
									<td><br><br><br><br><br><br></td>
								</tr>
								<tr>
									<td>
										<strong><center><br><br>APPROVED BY<br><br><br></center></strong>
									</td>
								</tr>
							</tbody>
						</table>
					</div>
				</div>







































                                <div class="">  
                           
                                <div class="avoid-this" style=" margin-bottom: 5rem;margin-left: 2.5rem;">

                            	<span class="pr_steps first_step" style="border-left: 1px solid #d8d8d8;">
                            	<i class="fa fa-check" title="Complete" aria-hidden="true" style="color: #00e200;margin-right: 1rem;margin-left: 1rem;"></i>
                            	@permission('view-purchase-request')
                            	<a href="{{ route('purchase-requests.view' , [$purchase_request->id]) }}">Purchase Request </a>
                            	@endpermission                            	
                               </span> 

                               <span class="pr_steps" >

								@if($approval_status > 0)
								<i class="fa fa-hourglass-half" title="Pending" aria-hidden="true" style="color: #ffbc00;margin-right: 1rem;margin-left: 1rem;">
									
								</i>
								@else
								<i class="fa fa-check" title="Complete" aria-hidden="true" style="color: #00e200;margin-right: 1rem; margin-left: 1rem;"></i>
								@endif

								<a href="#/aprroval-section" id="approvalBtn">Approvals</a>

								</span>

								@if($purchase_request->status  == 2 )

								<span class="pr_steps" >
								<i class="fa fa-frown-o" title="Rejected" aria-hidden="true" style="color: red;margin-right: 1rem;margin-left: 1rem;font-size: 2rem;"></i>
								Rejected 

								</span>

                                @else

                               <span class="pr_steps" >
                               
                               	@if($purchase_request->status < 4)
								<i class="fa fa-hourglass-half" title="Pending" aria-hidden="true" style="color: #ffbc00;margin-right: 1rem;margin-left: 1rem;"></i>
								RFQ Sent
								@else
								@permission('view-request-for-quotation')
								<i class="fa fa-check" title="Complete" aria-hidden="true" style="color: #00e200;margin-right: 1rem; margin-left: 1rem;"></i>
								<a target="_blank" href="{{ route('request-for-quotations.view' , [$purchase_request->id]) }}">RFQ Send <span style="padding: 2px 7px 2px 7px;border-radius: 50%;color: white;position: relative;bottom: 15px;right: 10px;background: red;">{{$total_rfq}}</span></a>
								@endpermission
								@endif

                               </span>

                               <span class="pr_steps" >
                               	@if($purchase_request->status < 5)
                               	<i class="fa fa-hourglass-half" title="Pending" aria-hidden="true" style="color: #ffbc00;margin-right: 1rem;margin-left: 1rem;"></i>
                            	CS Received
                            	@else

								@if($total_cs == $total_rfq)
								<i class="fa fa-check" title="Complete" aria-hidden="true" style="color: #00e200;margin-right: 1rem; margin-left: 1rem;"></i>
								@else

								<i id="pending_cs" class="fa fa-hourglass-half" tabindex="0" data-toggle="tooltip" title="Pending {{$total_rfq - $total_cs}}" title="Pending" data-placement="bottom" aria-hidden="true" style="color: #ffbc00;margin-right: 1rem;margin-left: 1rem;"></i>

								@endif
								@permission('view-comparative-statement')
								<a target="_blank" href="{{ route('comparative-statements.view' , [$purchase_request->id]) }}">CS  Received<span style="padding: 2px 7px 2px 7px;border-radius: 50%;color: white;position: relative;bottom: 15px;right: 10px;background: red;">{{$total_cs}}</span></a>
								@endpermission
								@endif

                               </span>

                               @php
                                 
                                 $cancel_po_name = $total_cancel_po->count(). ' Purchase Order cancelled '; 
                               @endphp

                            

                                <span class="pr_steps" style="pointer-events: none;" id='example' >

                               	@if($purchase_request->status < 6)
                               	<i class="fa fa-hourglass-half" title="Pending" aria-hidden="true" style="color: #ffbc00;margin-right: 1rem;margin-left: 1rem;"></i>
                            	PO 
                            	@else
                            	@permission('view-purchase-order')
                            	<i class="fa fa-check" title="Complete" aria-hidden="true" style="color: #00e200;margin-right: 1rem; margin-left: 1rem;"></i>
								<a target="_blank" style="pointer-events: visible;" href="{{ route('purchase-orders.view' , [$purchase_request->id]) }}">PO  <span style="padding: 2px 7px 2px 7px;border-radius: 50%;color: white;position: relative;bottom: 15px;right: 10px;background: red;">{{$total_po}}</span></a>
								@endpermission
								@endif
                            	
                                </span>

                                <span class="pr_steps" >
                                @if($purchase_request->status < 7)
                               	<i class="fa fa-hourglass-half" title="Pending" aria-hidden="true" style="color: #ffbc00;margin-right: 1rem;margin-left: 1rem;"></i>
                            	Receipts
                            	@else
                            	@permission('view-po-receipt')
                            	<i class="fa fa-check" title="Complete" aria-hidden="true" style="color: #00e200;margin-right: 1rem; margin-left: 1rem;"></i>
								<a target="_blank" href="{{ route('purchase-order-receipts.view' , [$purchase_request->id]) }}">Receipts <span style="padding: 2px 7px 2px 7px;border-radius: 50%;color: white;position: relative;bottom: 15px;right: 10px;background: red;">{{$total_recipt}}</span></a>
								@endpermission
								@endif
                            	
                               </span>

                                @endif

                                </div>
                          

								<h3 class="box-title avoid-this"><b >Purchase Request Details</b></h3>

								<div class="row avoid-this">

								<div class="col-md-6 col-xs-6 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold">Project</span>
								<span style="margin-left: 2rem;font-weight: 400;" id="project_name" class="blk_clr">
								{{ env('APP_NAME')}}
								</span>
								</div>

								<div class="col-md-6 col-xs-6 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold">Department</span>
								<span style="margin-left: 2rem;font-weight: 400;" class="blk_clr">
								{{$purchase_request->department->department_name}}
								</span>
								</div>

								<div class="col-md-6 col-xs-6 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold">Created By</span> 
								<span style="margin-left: 2rem;font-weight: 400;" class="blk_clr">
								<td>{{ $purchase_request->user->name}} </td>
								</span>
								</div>

								<div class="col-md-6 col-xs-6 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold" >Created At</span> 
							    <span style="margin-left: 2rem" class="blk_clr">
								{{date('Y-F-d' , strtotime($purchase_request->created_at))}}
								</span>
								</div>

								<div class="col-md-6 col-xs-6 div-border" style="margin-top: 2rem;">

								<span style="color:black;font-weight: bold;" class="font-weight-bold">Current Status</span>

								@if($purchase_request->status == 0)
								<span style="color:#ffed14;margin-left: 2rem" class="blk_clr">Pending</span>
								@elseif($purchase_request->status == 1)
								<span style="color:#ffbd02;margin-left: 2rem" class="blk_clr">
								Approvals In Progress</span>
								@elseif($purchase_request->status == 2)
								<span style="color:red;margin-left: 2rem" class="blk_clr">Rejected</span>
								@elseif($purchase_request->status == 3)
								<span style="color:#0d6efd;margin-left: 2rem" class="blk_clr">RFQ</span>
								@elseif($purchase_request->status == 4)

								<span style="color:#0d6efd;margin-left: 2rem"><a target="_blank" href="{{ route('request-for-quotations.view' , [$purchase_request->id]) }}" class="blk_clr">RFQ SEND</a>
									<span class="avoid-this" style="padding: 2px 7px 2px 7px;border-radius: 50%;color: white;position: relative;bottom: 15px;right: 10px;background: red;">{{$total_rfq}}</span></span>
								@elseif($purchase_request->status == 5)
								<span style="color:#0d6efd;margin-left: 2rem"><a target="_blank" href="{{ route('comparative-statements.view' , [$purchase_request->id]) }}" class="blk_clr">CS Received</a> <span class="avoid-this" style="padding: 2px 7px 2px 7px;border-radius: 50%;color: white;position: relative;bottom: 15px;right: 10px;background: red;">{{$total_cs}}</span></span>
								@elseif($purchase_request->status == 6)
								<span style="color:#0d6efd;margin-left: 2rem"><a target="_blank" href="{{ route('purchase-orders.view' , [$purchase_request->id]) }}" class="blk_clr">PO Sent</a> <span class="avoid-this" style="padding: 2px 7px 2px 7px;border-radius: 50%;color: white;position: relative;bottom: 15px;right: 10px;background: red;">{{$total_po}}</span></span>

								@elseif($purchase_request->status == 7)
                        

								@if($pending_po > 0)
								<span style="color:#0d6efd;margin-left: 2rem"><a target="_blank" href="{{ route('purchase-orders.view' , [$purchase_request->id]) }}" class="blk_clr">PO PENDING</a> <span class="avoid-this" style="padding: 2px 7px 2px 7px;border-radius: 50%;color: white;position: relative;bottom: 15px;right: 10px;background: red;">{{$pending_po}}</span></span>


								@elseif($pending_recipt > 0)
								<span style="color:#0d6efd;margin-left: 2rem"><a target="_blank" href="{{ route('purchase-order-receipts.view' , [$purchase_request->id]) }}" class="blk_clr">RECEIPT PENDING</a><span class="avoid-this" style="padding: 2px 7px 2px 7px;border-radius: 50%;color: white;position: relative;bottom: 15px;right: 10px;background: red;">{{$pending_recipt}}</span></span>

								@elseif($total_rfq > $total_cs)
								<span style="color:#0d6efd;margin-left: 2rem"><a target="_blank" href="{{ route('request-for-quotations.view' , [$purchase_request->id]) }}" class="blk_clr">CS PENDING</a><span class="avoid-this" style="padding: 2px 7px 2px 7px;border-radius: 50%;color: white;position: relative;bottom: 15px;right: 10px;background: red;">{{$total_rfq - $total_cs}}</span></span>
								@else
								<span style="margin-left: 2rem" class="blk_clr green_status">Complete</span>
								@endif

                                @endif
								</div>



								


								<div class="col-md-12 col-xs-12" style="margin-top: 2rem;">
								<h3 class="box-title" id="approval_section">
								<b >Approval Status</b>
								</h3>
								</div>

                            		
								<?php $numering = 1 ?>
								@foreach(\App\PurchaseRequest::find($purchase_request->id)->approvalStatus as $approval_status)  
								<div class="col-md-3 col-xs-4 div-border avoid-this" style="margin-top: 2rem">
								<b class="font-weight-bold"><span style="color:black;">{{$numering}} :</span></b> 
								<a href="{{route('purchase-requests.print',['view' => $purchase_request->id,'user'=> $approval_status->role_id])}}" style="text-decoration: none; color: black;">{{ \App\Role::find($approval_status->role_id)->name}}</a> - @if($approval_status->approvel_status == 0)
								<span class="yellow_status"  > Pending  </span>
								@elseif($approval_status->approvel_status == 1)
								<span class="green_status" > Approved </span>
								@elseif($approval_status->approvel_status == 2)
								<span class="red_status" > Rejected </span>
								@endif
								</div>
								<?php $numering++; ?>
								@endforeach 
								</div>



                             <h3 class="box-title avoid-this" style="margin-top: 5rem;"><b >Purchase Request Items</b></h3>
                             

                              <table style="width: 100%;" id="myTable" class="table table-striped table-bordered dataTable color-table primary-table avoid-this" role="grid" aria-describedby="myTable_info">
	                            <thead>
								<tr role="row">
								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 10px;">Code</th>

								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Item - Brand</th>



								<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Quantity</th>


								<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 50px;"> Price</th>

								<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Description</th>


								<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 13px;">Subtotal</th>

								</tr>

	                            </thead>
                                <tbody>
  
			                    <?php  $count = 0; $amount = 0;  $quantity = 0;?>
			                    @foreach( $purchase_request->item as $list )
			                    @php
			                    $item = \App\Item::withTrashed()->find($list->item_id);
			                    @endphp

			                     <tr role="row" class="odd">

								<td>{{$item->item_code}} </td>

								<td class="item_name">
								{{$item->item_name}} - {{$item->manufacture->name}}
								<?= ($item->risk_type == 'critical') ? '<span class="critical">Critical</span>' : '<span class="non_critical">Non Critical</span>' ?>
								</td>

								<td>{{number_format($list->quantity , 2)}} </td>

								<td> {{number_format($list->price , 2)}} </td>

								<td class="description"> 
								<span class="default-text">{{$list->description}}</span>
								<span class="after-load-more" style="display:none;"></span>
								</td>

								<td>PKR {{number_format($list->price * $list->quantity , 2)}} </td>

			                    </tr>

			                    <?php $count ++; $amount += ( $list->price * $list->quantity ); $quantity += $list->quantity; ?>
			                    @endforeach   

			                    </tbody>
			                    </table>


							
             
								<div class="row avoid-this">
                                <div class="col-md-6 col-xs-6" style="text-align:center;">

                                	<div class="row">
                                		
										

                                	</div> 
                                	


                                	


                                </div>
								<div class="col-md-6 col-xs-6" style="text-align: right;">
								<div class="pricing-section">
								<p>
								<b style="color:black;" class="us-text">Total Item:</b> <span style="margin-left: 12rem;" class="blk_clr"> {{number_format($count, 2)}}</span>
								</p>

								<p>
								<b style="color:black;" class="us-text">Total Item Quantity:</b> <span style="margin-left: 5rem;" class="blk_clr"> {{number_format($quantity, 2)}}</span>
								</p>

								<b style="color:black;" class="us-text">Total Amount:</b> 
								<span style="margin-left: 3rem" class="blk_clr"> 
								PKR {{number_format($amount , 2) }}
								</span>
								</div>
								</div>


                                 </div>

								</div>

								</div>
								</div>
								</div>
								</div>
								</div>


<?php if($total_cancel_po->count() > 0 )
{
?>
															<!-- Modal -->
<div class="modal fade" id="show_cancel_po" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title" id="myModalLabel">Cancel Purchase order With Remarks</h4>
      </div>
      <div class="modal-body">
       <table class="table table-striped">
  <thead>
    <tr>
      <th scope="col">PO #</th>
      <th scope="col">Vendor</th>
      <th scope="col">Remarks</th>
    </tr>
  </thead>
  <tbody>

  	@foreach($total_cancel_po as $PoList)
    <tr>
      <th scope="row">PO-{{$PoList->po_id}}</th>
      <td>{{$PoList->vendor->name}}</td>
      <td>{{$PoList->remark}}</td>
    </tr>
  @endforeach
  </tbody>
</table>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
       
      </div>
    </div>
  </div>
</div>

<?php
}
?>


							<div class="modal fade" id="rfqModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel1">
							<div class="modal-dialog" role="document">
							<div class="modal-content">
							<div class="modal-header">
							<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
							<h4 class="modal-title" id="exampleModalLabel1">SENT RFQ </h4></div>
							<div class="modal-body">
							<div class="alert alert-success" role="alert" style="display: none;" id="succeessMessage">
							Your request for quotation send successfully to all vendors.
							</div>
							<form method="post" onsubmit="return sendRfq('{{$purchase_request->id}}' , this)">


							<div class="form-group">
							<label for="recipient-name" class="control-label">Quotation Valid Until <b style="color:red;">*</b></label>
							<span id="quatation_date_error" style="color:red; display: none;"></span>
							<input type="date" value="{{date('Y-m-d')}}" min="{{date('Y-m-d')}}" class="form-control" id="quatation_date"></div>



							<div class="form-group">
							<label for="recipient-name" class="control-label">Selected Vendors <b style="color:red;">*</b></label>
							<span id="selected_vendor_error" style="color:red; display: none;">Please Select Valid Vendor.</span>
							<span id="vendor_list"></span>
							
					    	</div>



							<div class="form-group">
							<label for="message-text" class="control-label">Important Instructions: (Optional)</label>
							<textarea class="form-control" rows="5" id="message"></textarea>
							</div>
					
							</div>
							<div class="modal-footer">
							<button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
							<button type="submit" class="btn btn-primary" id="thisBtn" >Send</button>
							</form>
							</div>
							</div>
							</div>







@stop


@section('js')  

<script type="text/javascript">

    

	function showCancelPoModal() {

	  $('#show_cancel_po').modal('show');
	}
	
<?php if($total_cancel_po->count() > 0 )
{
?>
	$(function() { 

	const content = `<span>{{$cancel_po_name}}</span>`;

   $("#example").popover({
    placement: 'top',
    html: true,
    title: '<a href="javascript:void(0);"  onclick="return showCancelPoModal()">View All</a>',
    content: content
});

        $("#example").popover('show');

     
      });

	  $('body')
  .on('mousedown', '.popover', function(e) {
    e.preventDefault()
  });

<?php
}
?>


function add_pr_auth(status , self) {

var auth_person = $('#auth_person').val();
var remarks =  $('#remarks').val();
	$.ajaxSetup({
		headers: {
		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		}
		});

		$.ajax({
		url:"{{ route('purchase-requests.add-person') }}",
		method:'POST',
		dataType:'json',
		data: {pr_id:'{{$purchase_request->id}}' , auth_person:auth_person , status:status , remarks:remarks},
		success:function(data)
		{
         
       if(data.response == 'invalid')
           {
               alert(data.message)
            
           }
           else if(data.response == 'yes')
           {
		       	alert('Successfully Added.')
		       	location.reload(true)
           }
           else
           {
	           	alert('Something went wrong.')
	           	location.reload(true)
           }

		}
		})

		return false;
}
	$(document).ready(function() {

$('.odd').each(function()
{
var description = $(this).find('.description .default-text').text();
// var word = description.split(" ");
if(description.length > 10 )
{
$(this).find('.after-load-more').html(description);
var content =   description.slice(0 , 10)+'... <a href="javascript:void(0)" onclick="return showContent(this)">load more</a>'
$(this).find('.description .default-text').html(content);
}

});

});
function showContent(self) {
$(self).closest('.description').find('.after-load-more').show();
$(self).closest('.description').find('.default-text').hide();
}

	function getVendorForRfq(pr_id , self) {
		$(self).html('Proccessing...');
		$(self).prop('disabled' , true);

		$.ajaxSetup({
		headers: {
		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		}
		});

		$.ajax({
		url:"{{ route('request-for-quotations.get-vendor-for-rfq') }}",
		method:'POST',
		dataType:'json',
		data: {pr_id:pr_id},
		success:function(data)
		{
         
         if (data.response == 'yes') 
         {
         	var output = '';

			output += '<select class="chosen-select" id="rfq_vendors" multiple="multiple" name="vendors[]">';

			$.each(data.vendor, function(key, value) {
			output += '<option value="'+value.id+'">'+value.name+'</option>';
			});

			output += '</select> ';

			$('#vendor_list').html(output);

			$('#rfqModal').modal('show');

			$('#rfq_vendors').chosen-select();

			$('#rfq_vendors').val(data.vendor_keys).change();

			$(self).html('SEND RFQ BY EMAIL');
		    $(self).prop('disabled' , false);

         }
          else if (data.response == 'no_vendor_assign') 
         {
         	alert('Please Assign Item(s) To Vendor First.');
            $(self).html('SEND RFQ BY EMAIL');
		    $(self).prop('disabled' , false);
         }
         else
         {
         	alert('Something went wrong. Click Ok to reload');
         	location.reload(true);

         }

		}
		})
		

		return false;
	}


	$('#pending_cs').tooltip('show');

	function sendRfq(pr_id , self)
	{
		$('#thisBtn').html('Proccessing...');
		$('#thisBtn').prop('disabled' , true);
       var quatation_date = $('#quatation_date').val();
       var message = $('#message').val();
       var project_name = $('#project_name').text();
       var vendors = $('#rfq_vendors').val();
		
		$.ajaxSetup({
		headers: {
		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		}
		});

		$.ajax({
		url:"{{ route('request-for-quotations.sendRfq') }}",
		method:'POST',
		dataType:'json',
		data: {purchase_request_id:pr_id , quatation_date:quatation_date , message:message , project_name:project_name , vendors:vendors},
		success:function(data)
		{
         if(data.quatation_date)
         {
			$('#quatation_date_error').text(data.quatation_date);
			$('#quatation_date_error').show();
			$('#thisBtn').html('Send');
			$('#thisBtn').prop('disabled' , false);
         }

          else if(data.purchase_request_id)
         {
         	alert('Somethign went wrong.')
         	location.reload(true)
         }

         else if(data.response)
         {
           $('#succeessMessage').show('slow');
           setTimeout(function(){ location.reload(true); }, 3000);
         }
         else if(data.empty)
         {
         	$('#selected_vendor_error').show('slow');
           setTimeout(function(){$('#selected_vendor_error').hide('slow'); }, 3000);
         }

         else
         {
         	alert('Somethign went wrong.')
         	location.reload(true)
         }

		}
		})

       return false;
	}

    function validate()
    { 
        if(!confirm('Are you sure you want to cancel this purchase request?'))
        {
            return false;
        } 
    }

  $("#approvalBtn").click(function() {
    $('html, body').animate({
        scrollTop: $("#approval_section").offset().top
    }, 1000);
});



</script>

@stop