@extends('layouts.app')

@section('title')
RFQ
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">RFQs</li>
      </ol>
@stop
@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
@stop
@section('content')
		<div class="container-fluid">
		<div class="row">
		<div class="col-md-12">
		<div class="white-box">

		<div class="printableArea">  

		<table id="myTable" style="margin-top: 5rem;" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
		<thead>
		<tr role="row">

		<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">PR#</th>

		<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Vendor</th>


		<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Comparative Statement</th>

		<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Total Items</th>


		<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Action</th>

		</tr>

		</thead>
		<tbody>

		@foreach($purchase_request_rfq as $pr )


		@foreach(json_decode($pr->rfq_vendors)  as $vendors )

		@php
		$list = \App\PurchaseRequestVendor::find($vendors );
		$total_item = \App\RequestForQuotation::getVendorTotalItems($list->id, $pr->id )
		@endphp

		@if(\App\ComparativeStatement::countCs( $pr->id , $list->id)  > 0 && $status == 'cs-receive')

		<tr role="row" class="odd">

		<td>@permission('view-purchase-request')
			<a href="{{route('purchase-requests.view' , [$pr->id])}}">PR-{{$pr->id}}</a>
			@else
			PR-{{$pr->id}}

			@endpermission
			 </td>

		<td>
			@permission('view-vendor')
			<a href="{{route('vendor.view' , [$list->id])}}">{{ucfirst($list->name)}}</a> 
			@else
			{{ucfirst($list->name)}}
			@endpermission
		</td>
		<td>


		<b style="font-size: 12px;background: #00d400;color: white;padding: 10px;border-radius: 20px;">Received</b>
		</td>

		<td> [ {{ $total_item }} ]</td>

		<td>
			@permission('list-request-for-quotation')
		<a href="{{url('request-for-quotations/detail?vendor='.Crypt::encryptString($list->id).'&purchase_request='.Crypt::encryptString( $pr->id ).'')}}" class="btn btn-success" target="_blank">View</a> 
		@endpermission

		</td>

		</tr>

		@elseif(\App\ComparativeStatement::countCs( $pr->id , $list->id)  == 0 && $status == 'cs-pending')

		<tr role="row" class="odd">

		<td>
			@permission('view-purchase-request')
			<a href="{{route('purchase-requests.view' , [$pr->id])}}">PR-{{$pr->id}}</a>
			@else
			PR-{{$pr->id}}
			@endpermission </td>

		<td>
			@permission('view-vendor')
			<a href="{{route('vendor.view' , [$list->id])}}">{{ucfirst($list->name)}}</a> 
		@else
		{{ucfirst($list->name)}}
	@endpermission</td>
		<td>

		<b style="font-size: 12px;background: #fbd20b;color: white;padding: 10px;border-radius: 20px;">Pending</b>

		</td>

		<td> [ {{ $total_item }} ]</td>

		<td>
			@permission('list-request-for-quotation')
		<a href="{{url('request-for-quotations/detail?vendor='.Crypt::encryptString($list->id).'&purchase_request='.Crypt::encryptString( $pr->id ).'')}}" class="btn btn-success" target="_blank">View</a> 
		@endpermission

		</td>

		</tr>

		@elseif($status == 'rfq-sent')

		<tr role="row" class="odd">

		<td>
			@permission('view-purchase-request')
			<a href="{{route('purchase-requests.view' , [$pr->id])}}">PR-{{$pr->id}}</a>
			@else
			PR-{{$pr->id}}
			@endpermission </td>

		<td>
			@permission('view-vendor')
			<a href="{{route('vendor.view' , [$list->id])}}">{{ucfirst($list->name)}}</a> 
		@else
		{{ucfirst($list->name)}}
	@endpermission</td>


		<td>
		@if(\App\ComparativeStatement::countCs($pr->id , $list->id)  > 0)
		<b style="font-size: 12px;background: #00d400;color: white;padding: 10px;border-radius: 20px;">Received</b>
		@else
		<b style="font-size: 12px;background: #fbd20b;color: white;padding: 10px;border-radius: 20px;">Pending</b>
		@endif

		</td>

		<td> [ {{ $total_item }} ]</td>

		<td>
			@permission('list-request-for-quotation')
		<a href="{{url('request-for-quotations/detail?vendor='.Crypt::encryptString($list->id).'&purchase_request='.Crypt::encryptString( $pr->id ).'')}}" class="btn btn-success" target="_blank">View</a> 
		@endpermission

		</td>

		</tr>


		@endif
		@endforeach   
		@endforeach   
		</tbody>
		</table>


		</div>

		</div>
		</div>
		</div>
		</div>
@stop  

@section('js')
<script type="text/javascript">
	function show_quotation_valid_date_form() {
		$('#quotation_valid_date_form').toggle('slow');
		return false;
	}
	function changeQuotationValidDate(pr_id) {
		var quotation_valid_date = $('#quotation_valid_date').val();
     $('#quotation_valid_date_btn').html('Processing...')
     $('#quotation_valid_date_btn').prop('disabled' , true)
        $.ajaxSetup({
		headers: {
		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		}
		});
		$.ajax({
		url:"{{ route('request-for-quotations.change-date') }}",
		method:'POST',
		dataType:'json',
		data: {pr_id:pr_id ,quotation_valid_date:quotation_valid_date},
		success:function(data)
		{
         if (data.quotation_valid_date) 
         {
            $('#q_date_error').html(data.quotation_valid_date);
            $('#q_date_error').show();
            $('#quotation_valid_date_btn').html('Change')
            $('#quotation_valid_date_btn').prop('disabled' , false)
            setTimeout(function(){$('#q_date_error').hide(); }, 3000);
         }
         if(data.response)
         {
             $('#quot_date').html(data.date);
             $('#q_date_success').show('slow');
             $('#quotation_valid_date_btn').html('Change')
             $('#quotation_valid_date_btn').prop('disabled' , false)
             setTimeout(function(){$('#quotation_valid_date_form').hide(); }, 4000);
         }
   
		}
		})
		return false;
	}
</script>

@stop