@extends('layouts.app')

@section('title')
RFQ
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">RFQs</li>
      </ol>
@stop
@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
@stop
@section('content')
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        
                        
                        <div class="white-box " id="printableSection">


                            <h3 class="box-title" style="margin-bottom: 3rem;"> <b style="font-size: 2.2rem;color: gray;">Comparative Statement / </b>PR-{{$purchase_request->id}}</h3>
                            <div class="alert alert-success" style="display: none;" role="alert" id="successMessage">
							</div>

							<div class="alert alert-danger" style="display: none;" role="alert" id="errorMessage">
							
							</div>

                                
                                <a class="btn btn-warning" id="print" href="#">Print</a>
                               
                                <div class="">  
                           
                               
							

								<div class="row">

									<div class="col-md-6">
								  <h3 class="box-title"><b style="color: gray;">Vendor Details</b></h3>

								  <div class="col-md-12" style="margin-top: 2rem;">
								<span style="color:black;">Name</span>
								<span style="margin-left: 8rem;font-weight: 400;">
								{{ Ucfirst($vendor->name)}}
								</span>
								</div>

								<div class="col-md-12" style="margin-top: 2rem;">
								<span style="color:black;">Phone</span>
								<span style="margin-left: 8rem;font-weight: 400;">
								0{{ $vendor->phone }}
								</span>
								</div>


								<div class="col-md-12" style="margin-top: 2rem;">
								<span style="color:black;">Email</span>
								<span style="margin-left: 8rem;font-weight: 400;">
								{{ $vendor->email }}
								</span>
								</div>


								<div class="col-md-12" style="margin-top: 2rem;">
								<span style="color:black;">Cnic</span>
								<span style="margin-left: 8rem;font-weight: 400;">
								{{ $vendor->cnic }}
								</span>
								</div>

								<div class="col-md-12" style="margin-top: 2rem;">
								<span style="color:black;">Address</span>
								<span style="margin-left: 8rem;font-weight: 400;">
								{{ $vendor->address }}
								</span>
								</div>


								</div>

								<div class="col-md-6">

								<h3 class="box-title"><b style="color: gray;">Company Details</b></h3>

								<div class="col-md-12" style="margin-top: 2rem;">
								<span style="color:black;">Company</span>
								<span style="margin-left: 10rem;font-weight: 400;">
								{{ Ucfirst($project->project_name)}}
								</span>
								</div>

								<div class="col-md-12" style="margin-top: 2rem;">
								<span style="color:black;">Address</span>
								<span style="margin-left: 10rem;font-weight: 400;">
								{{$project->address}}
								</span>
								</div>


								<div class="col-md-12" style="margin-top: 2rem;">
								<span style="color:black;">Contact</span>
								<span style="margin-left: 10rem;font-weight: 400;">
								0{{$project->contact}}
								</span>
								</div>


								
								</div>

								
							
								</div>



                             <h3 class="box-title" style="margin-top: 5rem;"><b style="color: gray;"> Items List</b></h3>

                             <div class="alert alert-success" role="alert" style="display:none;"  id="succeessMessage">
							Purcahse Order Confirmed.
							</div>

                             <button class="btn btn-success" style="display:none;" onclick="return createPo('{{$vendor->id}}' , '{{$purchase_request_id}}' , this)" id="po_btn">Confirm Order</button>

							

                              <table id="myTable" class="table table-striped dataTable no-footer" role="grid" aria-describedby="myTable_info">
	                            <thead>
								<tr role="row">

								<th class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 50px;">Select Items</th>

								<th class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Code</th>
								

								<th class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Item</th>

								<th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 203px;">Description</th>


								<th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Quantity</th>


								<th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 50px;">Your Price</th>

								<th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 203px;">Vendor Price</th>

								</tr>

	                            </thead>
                                <tbody>
								
								@php $count = 0; $amount = 0;  $quantity = 0; 
								$vendor_item_price = 0; $book = array(); @endphp
								@foreach( $rfq_items as $list )
                                
								@php
								foreach ($is_item_exist as $key => $value)
								{
								if(in_array($list->item_id, $value->purchaseOrderItems->pluck('item_id')->toArray())) 
									{
									  $book[] = $list->item_id;
									}
								}

								@endphp
								
								<tr role="row" class="odd"  >

								<td style="text-align: center;">
									
								@if(in_array($list->item_id ,  $book))
								<i class="fa fa-check" style="font-size: 2rem;color: #00ec00;" aria-hidden="true"></i>
								@else
								<input type="checkbox" value="{{$list->item_id}}"  name="items[]" onchange="addItems()">
								@endif
								</td>

								@php 
								$item = \App\Item::withTrashed()->find($list->item_id); 
								@endphp

							    <td>{{$item->item_code}} </td>

								<td>{{$item->item_name}} </td>

								<td>{{$list->description}} </td>

								<td>{{number_format($list->quantity , 2)}} </td>

								<td> {{number_format($list->price , 2)}} </td>


								@if(in_array($list->item_id ,  $book))


								<td style="text-align:center;">
									 
									
									Order Booked
									
								</td>

								@else

								<td>
								@php 
                                $price = 0;
                                $message = '';
								$vendor_data = \App\ComparativeStatement::getItemPrices($purchase_request->id , $vendor->id ,$list->item_id)['item']; 
								if($vendor_data == true)
								{
									$price  = $vendor_data->price;
									$message  = $vendor_data->message;
								}

								@endphp

                                <?= '<b>Price : </b>'. number_format($price  , 2).'<br> <b>Send Date :</b> '.date('Y-F-d' , strtotime($vendor_data->created_at)).'<br>
                                <b>Message : </b>'.$message; ?>
								</td>

								@endif

								</tr>

									@php

									$count ++;
									$amount += ( $list->price * $list->quantity ); 
									if(!in_array($list->item_id ,  $book))
									{
									$vendor_item_price += ( $price * $list->quantity );
									}
									$quantity += $list->quantity;

									@endphp

								 @endforeach 
								

								</tbody>
								</table>



								<div style="text-align: right;">
								<p>
								<b style="color:black;">Total Item:</b> <span style="margin-left: 10rem;"> {{number_format($count, 2)}}</span>
								</p>

								<p>
								<b style="color:black;">Total Item Quantity:</b> <span style="margin-left: 9.5rem;"> {{number_format($quantity, 2)}}</span>
								</p>

                                
                                <p>
								<b style="color:black;">Total Unit Amount:</b> 
								<span style="margin-left: 3rem"> 
								PKR {{number_format($amount , 2) }}
								</span>
								</p>
								
                                @if($vendor_item_price > 0 )
								<b style="color:black;">Total Vendor Amount:</b> 
								<span style="margin-left: 3rem"> 
								PKR {{number_format($vendor_item_price , 2) }}
								</span>
								@endif

								
								</div>

								</div>

								</div>
								</div>
								</div>
								</div>
@stop





@section('js')  

<script type="text/javascript">

	function createPo(vendor_id , purchase_request_id , self) {

	var item_ids = [];
     
     $(self).html('Processing...')
     $(self).prop('disabled' , true)

	$('input[name="items[]"]:checked').each(function()
	{
	  item_ids.push($(this).val());
	});

	$.ajaxSetup({
		headers: {
		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		}
		});

		$.ajax({
		url:"{{ route('purchase-orders.create') }}",
		method:'POST',
		dataType:'json',
		data: {pr_id:purchase_request_id,vendor_id:vendor_id ,item_ids:item_ids},
		success:function(data)
		{
           if(data.response == 'yes')
           {
               
			$("#succeessMessage").show('slow')
		    setTimeout(function(){ location.reload(true);}, 3000);

           }
           else if(data.response == 'invalid')
           {
           		alert('Some of the items already order to another vendor. Please ok to refresh the page.')
           	location.reload(true);
           }
           else
           {
           	alert('Something went wrong.')
           	location.reload(true);
           }
		}
		})

	return false;
	}

	function addItems() 
	{
	  var checkedNum = $('input[name="items[]"]:checked').length;

		if (!checkedNum) 
		{
		  $('#po_btn').hide();
		}
		else
		{
		  $('#po_btn').show();
		}
	}

    

</script>

@stop