@extends('layouts.app')

@section('title')
RFQ
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">RFQs</li>
      </ol>
@stop
@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
@stop
@section('content')
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        <div class="white-box " id="printableSection">


							<h3 style="text-align:right;" class="box-title avoid-this" style="margin-bottom: 3rem;"> 
							<span style="float: left;"><b style="font-size: 2.2rem;">Request For Quotation / </b>PR-{{$purchase_request->id}}</span>
							<a class="btn btn-warning avoid-this" id="print" href="#">
							Print
						    </a>
							@permission('send-comparative-statement')
							<button class="btn btn-warning avoid-this" id="thisBtn"  onclick="submitCsForm(this)" >Save CS</button>
							@endpermission
							</h3>


                            <div class="alert alert-success" style="display: none;" role="alert" id="successMessage">
							</div>

							<div class="alert alert-danger" style="display: none;" role="alert" id="errorMessage">
							
							</div>

                                
							<h3 class="box-title avoid-this" id="rfq_title"><b style="">Purchase Request Details</b></h3>
                             

                            <div class="">  
                                
							<center><div class="row hide-default" >
							<h3 class="box-title">

							<?= (env('DOCUMENT_LOGO')) ? '<img src="'.asset(env('DOCUMENT_LOGO')).'" class="logo-img"><br>' : '' ?>
								
							{{env('APP_NAME')}}
						    </h3>

							<div class="col-md-12" id="GRN-CNG" style="border: 1px solid;color: black; text-align: center;font-weight: bold;padding: 1rem;font-size: 1.5rem; margin-bottom: 3rem;">
							REQUEST FOR QUOTATION
							</div>


							<table style="width: 100%;margin-top: -0.1rem;" id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
							<thead>
							<tr role="row">
							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Project </th>

							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Phone </th>


							</tr>
							</thead>
							<tbody>
							<tr role="row" class="odd">
							<td>	{{ env('APP_NAME')}}</td>
							<td>	{{ env('APP_CONTACT')}}</td>

							</tr>
							</tbody>
							</table>



							<table style="width: 100%;margin-top: -0.1rem;" id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
							<thead>
							<tr role="row">
							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Quote Date </th>

							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Quote Valid Date </th>

							<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">CS Status </th>

							</tr>
							</thead>
							<tbody>
							<tr role="row" class="odd">
							<td>{{date('Y-F-d' , strtotime($purchase_request->quotation_created_date))}}</td>
							<td>{{date('Y-F-d' , strtotime($purchase_request->quotation_valid_date))}}</td>
							<td>
							@if($total_cs > 0)
							<b>Received</b>
							@else
							<b>Pending</b>
							@endif
							</td>
							</tr>
							</tbody>
							</table>



							</div>
							</center>


								<div class="row avoid-this">

								<div class="col-md-3 col-xs-3 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="">Company</span>
								<span style="margin-left: 5px;font-weight: 400;" class="blk_clr">
								    {{env('APP_NAME')}}
								    </span>
								    </div>



								<div class="col-md-3 col-xs-3 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="">Contact</span>
								<span style="margin-left: 5px;font-weight: 400;" class="blk_clr">
								   {{env('APP_CONTACT')}}
								</span>
								</div>


								<div class="col-md-6 col-md-6 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="">Address</span>
								<span style="margin-left: 5px;font-weight: 400;" class="blk_clr">
								{{ env('APP_ADDRESS')}}
								</span>
								</div>


								<div class="col-md-3 col-xs-3 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold">CS status </span>
								<span style="margin-left: 5px;font-weight: 400;" class="blk_clr">
								@if($total_cs > 0)
								<b style="font-size: 12px;background: #00d400;color: white;padding: 10px;border-radius: 20px;">Received</b>
								@else
								<b style="font-size: 12px;background: #fbd20b;color: white;padding: 10px;border-radius: 20px;">Pending</b>
								@endif
								</span>
								</div>


								<div class="col-md-3 col-xs-3 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold us-next-line">Quotation  Date</span>
								<span style="font-weight: 400;" class="blk_clr">
								{{date('Y-F-d' , strtotime($purchase_request->quotation_created_date))}}
								</span>
								</div>

									<div class="col-md-6 col-xs-6 div-border" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold">Valid Until</span>
								<span style="font-weight: 400;" class="blk_clr">
								{{date('Y-F-d' , strtotime($purchase_request->quotation_valid_date))}} <br><small > After valid date you will not be able to sent your quotation. </small>
								</span>
								</div>


								<div class="col-md-12 col-xs-12" style="margin-top: 2rem;">
								<span style="color:black;font-weight: bold;" class="font-weight-bold">Important Instructions</span>

								<span style="margin-left: 2rem;font-weight: 400;" class="blk_clr">
								<?= (!empty($purchase_request->note)) ? $purchase_request->note : 'none' ?> 
								</span>
								</div>

							
								</div>



                             <h3 class="box-title avoid-this" style="margin-top: 5rem;">
                             	<b style=""> Items </b>

                             	<span  style="font-size: 1.5rem;float: right;margin-top: -3rem;margin-right: -8rem;">
                             		<label>Upload Document</label>

                             		<input type="file" multiple name="quatation_images[]"  id="documents">
                             	</span>

                             	
                             </h3>

							

                              <table id="myTable" style="margin-top: -0.1rem;" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
	                            <thead>
								<tr role="row">

								<th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Code</th>
								

								<th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Item</th>

							
								<th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Quantity</th>

								<th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Description</th>
								

								<th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 50px;">Vendor Price</th>


								<th class="sorting avoid-this" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 13px;">Action</th>

								</tr>

	                            </thead>
                                <tbody>
								<form method="post" id="cs_form" onsubmit="return sendCsToCompany('{{$purchase_request->id}}' , '{{$vendor_id}}')">
								<?php  $count = 0; $amount = 0;  $quantity = 0; 
								$vendor_item_price = 0; ?>
								@foreach( $rfq_items as $list )
								@php
								$item = \App\Item::withTrashed()->find($list->item_id);

								@endphp

								<tr role="row" class="odd"  >

        						<td>{{$item->item_code}} </td>

								<td class="item_name">
								{{$item->item_name}} - {{$item->manufacture->name}}
								<?= ($item->risk_type == 'critical') ? '<span class="critical">Critical</span>' : '<span class="non_critical">Non Critical</span>' ?>
								</td>

								<td>{{number_format($list->quantity , 2)}} </td>

								<td class="description"> 
								<span class="default-text">{{$list->description}}</span>
								<span class="after-load-more" style="display:none;"></span>
								</td>

								<td>
								<input type="hidden" class="item_ids" value="{{$list->item_id}}">
								<input id="{{$list->item_id}}_vendor_price" type="number" name="price[]" placeholder="Type price..." style="display: none;border: 1px solid #e6e6e6;padding: 5px; border-radius: 5px;" class="vendor_price">

								<textarea rows="4" name="message[]" placeholder="Type a message..." id="{{$list->item_id}}_vendor_message" style="display: none;margin-top: 1rem;padding: 5px; border-radius: 5px;border: 1px solid #e6e6e6;"  class="vendor_message"></textarea>
                                
								<span id="{{$list->item_id}}_default">
								@php 
                                $price = 0;
								$vendor_data = \App\ComparativeStatement::getItemPrices($purchase_request->id , $vendor_id ,$list->item_id)['item']; 

								if($vendor_data == true)
								{
									$price  = $vendor_data->price;
								}
								@endphp
								{{number_format($price , 2)}}
							    </span> 
							    
								</td>

								

								<td class="avoid-this">
								<button type="button" onclick="return showPriceBox('{{$list->item_id}}' , this)" class="btn btn-success btn-sm">
								My Price
								</button>
								</td>

								</tr>

								<?php
								 $count ++;
								 $quantity += $list->quantity; ?>
								@endforeach 
								</form>  

								</tbody>
								</table>


									<center><div class="row hide-default" >


									<table style="width: 100%;margin-top: -0.1rem;" id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
									<thead>
									<tr role="row">
									<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Important Instructions </th>

									</tr>
									</thead>
									<tbody>
									<tr role="row" class="odd">
									<td><?= (!empty($purchase_request->note)) ? $purchase_request->note : '.' ?> </td>
									</tr>
									</tbody>
									</table>

									<table style="width: 100%;margin-top: -0.1rem;" id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
									<thead>
									<tr role="row">
									<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Total Item </th>

									<th style="color:black;" class="" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1"  style="width: 100px;">Total Item Quantity </th>


									</tr>
									</thead>
									<tbody>
									<tr role="row" class="odd">
									<td>{{number_format($count, 2)}}</td>
									<td>{{number_format($quantity, 2)}}</td>

									</tr>
									</tbody>
									</table>


									</div>
									</center>

									<div style="float-left:right;color:black !important; " class="hide-default">
									<b>Date : </b> {{date('d-F-Y')}}
									<br>
									<b >Print By : </b>{{ Ucfirst(Auth::user()->name) }}
									</div>


								 <div class="row avoid-this">
                                <div class="col-md-6 col-xs-6"></div>
								<div class="col-md-6 col-xs-6" style="text-align: right;">
								<div class="pricing-section">
									<p>
									<b style="color:black;" class="us-text">Total Item:</b> <span style="margin-left: 10rem;" class="blk_clr"> {{number_format($count, 2)}}</span>
									</p>

									<p>
									<b style="color:black;" class="us-text">Total Item Quantity:</b> <span style="margin-left: 9.5rem;" class="blk_clr"> {{number_format($quantity, 2)}}</span>
									</p>

                                </div>

								</div>


@if($docs->count() > 0)
<h3 style="margin-top: 5rem;margin-bottom: 3rem;">Cs Documents</h3>
@php
$file_ext = array('docx','pdf');
echo '<div class="row">';
foreach($docs as $img)
{
$url = asset('storage/cs_document/'.$img->document_name);
$urlExt = pathinfo($url, PATHINFO_EXTENSION);
if (!in_array($urlExt, $file_ext)) 
{
 echo '<div class="col-md-2" ><a target="_blank" href="'.asset('storage/cs_document/'.$img->document_name).'"><img  title="Image" style="height: 100px;border-radius: 10px;" class="img-responsive" src="'.asset('storage/cs_document/'.$img->document_name).'"></a> <a style="margin-left: 4rem;" href="'.route('delete.cs.docs' , [$img->id]).'" data-toggle="confirmation" data-title="Are you sure to delete?" ><i class="fa fa-trash" aria-hidden="true"></i></a></div>';    
}
if (in_array($urlExt, $file_ext)) 
{
 echo '<div class="col-md-2" ><a target="_blank" href="'.asset('storage/cs_document/'.$img->document_name).'"><img title="'.ucfirst($urlExt).' File" style="height: 100px;border-radius: 10px;" class="img-responsive" src="'.asset('storage/file.jpg').'"></a> <a style="margin-left: 4rem;" href="'.route('delete.cs.docs' , [$img->id]).'" data-toggle="confirmation" data-title="Are you sure to delete?" ><i class="fa fa-trash"  aria-hidden="true"></i></a></div>';    
}
}
echo '</div>';
@endphp
@endif


							    </div>
								</div>

								</div>
								</div>
								</div>
								</div>
@stop

@section('js')  

<script type="text/javascript">

$(document).ready(function() {

$('.odd').each(function()
{
var description = $(this).find('.description .default-text').text();
// var word = description.split(" ");
if(description.length > 10 )
{
$(this).find('.after-load-more').html(description);
var content =   description.slice(0 , 10)+'... <a href="javascript:void(0)" onclick="return showContent(this)">load more</a>'
$(this).find('.description .default-text').html(content);
}

});

});
function showContent(self) {
$(self).closest('.description').find('.after-load-more').show();
$(self).closest('.description').find('.default-text').hide();
}



function submitCsForm(self) {
	$(self).html('Processing...');
	$(self).prop('disabled' , true);
	$( "#cs_form" ).submit();
}

function sendCsToCompany(pr_id , vendor_id) {

var item_ids = [];
var vendor_prices = [];
var vendor_messages = [];

var documents = $('#documents').prop('files').length; 
var formData = new FormData();




	$('.vendor_price').each(function() {
	    vendor_prices.push($(this).val());
	});

	$('.vendor_message').each(function() {
	 	vendor_messages.push($(this).val());
	});

	$('.item_ids').each(function() {
	 	item_ids.push($(this).val());
	});

	if(vendor_prices == "," || vendor_prices  == "")
	{
	if (confirm("You are not enter any single item price? Do you agreed with company price?") == false) 
	  {
	  	$('#thisBtn').html('Save Cs');
		$('#thisBtn').prop('disabled' , false);
	    return false;
	  }
	}

	

	for (var i = 0; i < documents; i++) {

	formData.append(i, $('#documents').prop('files')[i]);
	}

    formData.append('pr_id', pr_id);
	formData.append('vendor_id', vendor_id);
	formData.append('item_ids', item_ids);
	formData.append('vendor_prices', vendor_prices);
	formData.append('vendor_messages', vendor_messages);
	formData.append('file_length', documents);


	   $.ajaxSetup({
		headers: {
		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		}
		});

		$.ajax({
		url:"{{ route('comparative-statements.send') }}",
		method:'POST',
		dataType:'json',
		cache: false,
		contentType : false, // you can also use multipart/form-data replace of false
		processData: false,
		data: formData,
		success:function(data)
		{
          if(data.response == 'yes')
          {
          	$('#successMessage').html(data.message);
          	$('#successMessage').show('slow');
          	setTimeout(function(){ location.reload(true) }, 3000);
          }
          else if(data.response == 'invalid')
          {
			$('#thisBtn').html('Send Cs');
			$('#thisBtn').prop('disabled' , false);
			$('#errorMessage').html(data.message);
			$('#errorMessage').show('slow');
          }
          else
          {
          	alert('Something Went Wrong.')
          	location.reload(true)
          }
		}
		})

	return false;
}



	function showPriceBox(item_id , self) 
	{
		$('#'+item_id+'_default').toggle();
		$('#'+item_id+'_vendor_price').toggle();
		$('#'+item_id+'_vendor_message').toggle();
		$('#'+item_id+'_vendor_price').val('');
		$('#'+item_id+'_vendor_message').val('');
		return false;
	}

	



</script>

@stop