@extends('layouts.app')

@section('title')
RFQ
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">RFQs</li>
      </ol>
@stop
@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
@stop
@section('content')
  <div class="container-fluid">
  <div class="row">
                    
    <div class="col-sm-12">
                        <div class="white-box">
                           
                            <div class="table-responsive">
                             
                            @if(Session::has('success'))   
                            <div id="successMessage" class="alert alert-success" role="alert">
                            {{ Session::get('success') }}
                            </div>
                            @endif

                            <h3  class="box-title m-b-0">
                            Request For Quotation List
                            </h3>

                            <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                                    <thead>
                                        <tr role="row">
                                            <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 10px;">Id#</th>

                                        	

                                            <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 203px;">Department</th>


                                             <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Created By</th>


                                              <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 150px;">Current Status</th>



                                            <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 13px;">Total Rfq</th>


                                            <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Action </th>

                                        </tr>
                                    </thead>
                                <tbody>
  
                    @if( $purchase_requests->count() > 0 )
                    @foreach( $purchase_requests as $list )

                     <tr role="row" class="odd">

                        <td><a target="_blank" href="{{route('purchase-requests.view' , [$list->id])}}">PR-{{$list->id }} </a></td>


                        <td>{{ \App\Department::withTrashed()->find($list->department_id)->department_name }}  </td>
                        <td>{{ $list->user->name}}</td>


                         <td>
                             @if($list->status == 0)
                               <span style="color:#ffed14;">Pending</span>
                               @elseif($list->status == 1)
                               <span style="color:#ffbd02;">In Progress</span>
                               @elseif($list->status == 2)
                               <span style="color:red;">Rejected</span>
                                @elseif($list->status == 3)
                               <span style="color:#0d6efd;">RFQ</span>
                               @elseif($list->status == 4)
                               <span style="color:#0d6efd;"><a target="_blank" href="{{ route('request-for-quotations.view' , [$list->id]) }}">RFQ SEND</a></span>
                               @elseif($list->status == 5)
                                <span style="color:#0d6efd;"><a target="_blank" href="{{ route('comparative-statements.view' , [$list->id]) }}">CS Received</a></span>
                                @elseif($list->status == 6)
                                <span style="color:#0d6efd;"><a target="_blank" href="{{ route('purchase-orders.view' , [$list->id]) }}">PO Sent</a></span>
                                @elseif($list->status == 7)
                                @php
                                 $getPrStatus = \App\PurchaseRequest::getPrStatus($list->id);
                                @endphp
                                @if( $getPrStatus['pending_po'] > 0)
                                <span style="color:#0d6efd;"><a style="font-size: 12px;" target="_blank" href="{{ route('purchase-orders.view' , [$list->id]) }}">PO PENDING</a> <span style="padding: 0px 5px 0px 5px;border-radius: 50%;color: white;position: relative;bottom: 15px;background: red;">{{ $getPrStatus['pending_po'] }}</span></span>
                                @elseif( $getPrStatus['pending_recipt'] > 0)
                                <span style="color:#0d6efd;"><a  style="font-size: 12px;" target="_blank" href="{{ route('purchase-order-receipts.view' , [$list->id]) }}">RECEIPT PENDING</a><span style="padding: 0px 5px 0px 5px;border-radius: 50%;color: white;position: relative;bottom: 15px;background: red;">{{$getPrStatus['pending_recipt']}}</span></span>

                                @elseif($getPrStatus['total_rfq'] > $getPrStatus['total_cs'])
                                <span style="color:#0d6efd;font-size: 12px;"><a target="_blank" href="{{ route('request-for-quotations.view' , [$list->id]) }}">CS PENDING</a><span style="padding: 0px 5px 0px 5px;border-radius: 50%;color: white;position: relative;bottom: 15px;background: red;">{{$getPrStatus['total_rfq'] - $getPrStatus['total_cs']}}</span></span>
                                @else
                                <span style="color:#0ef30e;">Complete</span>
                                @endif
                             @endif
                         </td>


                                          
                 <td>
                 
                   [ {{ sizeof(json_decode($list->rfq_vendors)) }} ]
                 
                </td>


                 <td>
                  @if(sizeof(json_decode($list->rfq_vendors)) > 0)
                    <a style="color:#fdb024;font-size: 1.9rem;"  href="{{ route('request-for-quotations.view',[$list->id] ) }}"><i style="margin-left: 1rem;" class="fa fa-eye" aria-hidden="true"></i>
                    </a>
                    @else

                    {{'Not Yet Sent'}}
                    
                    @endif
                </td>

            </tr>
                 @endforeach   
                 @endif

                                      
                                </tbody>
                                </table>
                                
                            </div>
                            </div>
                        </div>
                    </div>


    </div>

      </div>
@stop
