@extends('layouts.app')

@section('title')
RFQ
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">RFQs</li>
      </ol>
@stop
@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
@stop
@section('content')
            <div class="container-fluid">
                <div class="row">
                    <div class="col-md-12">
                        <div class="white-box">

                                <div class="printableArea">  
                           
                          <h3 class="box-title avoid-this" style="margin-bottom: 3rem;"> <b style="font-size: 2.2rem;color: gray;">Request for quotations/ </b>PR-{{$pr_id}} 
                          <div style="float: right;font-size: 1.4rem;margin-right: 8rem;">Quatation Sent Date :  {{date('d-F-Y' , strtotime($purchase_request->quotation_created_date))}}</div>
                           <br>
                          <div style="float: right;font-size: 1.4rem;line-height: 1px;">Quatation Valid Date :  <span id="quot_date">{{date('d-F-Y' , strtotime($purchase_request->quotation_valid_date))}}  </span>
                          	@permission('edit-request-for-quotation')
                          	<button style="margin-left: 1.3rem;" type="button" class="btn btn-sm btn-success" onclick="return show_quotation_valid_date_form()">Extend</button>
                          	@endpermission

                            <form style="display: none;" method="post" id="quotation_valid_date_form" onsubmit="return changeQuotationValidDate('{{$purchase_request->id}}')">

                         	<span id="q_date_error" style="display:none; color: red;"></span>
                            <span id="q_date_success" style="display:none;font-weight: bold; color: green;">SuccessFully Update.</span>
                         	<input type="date" style="margin-top: 1rem;"   class="form-control" id="quotation_valid_date">

                         	<button style="margin-top: 1rem; margin-bottom: 1rem;" type="submit" class="btn btn-sm btn-success" id="quotation_valid_date_btn">Change</button>
                            </form>
                            </div>

                          </h3>

                              <table id="myTable" style="margin-top: 5rem;" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
	                            <thead>
								<tr role="row">
								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Vendor</th>

								
								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Comparative Statement</th>

								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Total Items</th>


								<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Action</th>

								</tr>

	                            </thead>
                                <tbody>
  
			                   
			                    @foreach($vendors as $list )

			                     <tr role="row" class="odd">

								<td>
									@permission('view-vendor')
									<a href="{{route('vendor.view' , [$list->id])}}">{{ucfirst($list->name)}}</a>
									@else
									<a href="#">{{ucfirst($list->name)}}</a>
									@endpermission
									 </td>

								
								<td>
									@php
                                       $total_item = \App\RequestForQuotation::getVendorTotalItems($list->id, $pr_id )
									@endphp

								   @if(\App\ComparativeStatement::countCs($pr_id , $list->id)  > 0)
                                     <b style="font-size: 12px;background: #00d400;color: white;padding: 10px;border-radius: 20px;">Received</b>
                                     @else
                                         <b style="font-size: 12px;background: #fbd20b;color: white;padding: 10px;border-radius: 20px;">Pending</b>
                                     @endif
								</td>

								<td> [ {{ $total_item }} ]</td>

								<td>
									@permission('view-request-for-quotation')
								<a href="{{url('request-for-quotations/detail?vendor='.Crypt::encryptString($list->id).'&purchase_request='.Crypt::encryptString($pr_id).'')}}" class="btn btn-success" target="_blank">View</a> 
								@endpermission
							
							
								</td>

			                    </tr>

			                    @endforeach   

			                    </tbody>
			                    </table>

             
								</div>

								</div>
								</div>
								</div>
								</div>
@stop


@section('js')  

<script type="text/javascript">
	function show_quotation_valid_date_form() {
		$('#quotation_valid_date_form').toggle('slow');
		return false;
	}
	function changeQuotationValidDate(pr_id) {
		var quotation_valid_date = $('#quotation_valid_date').val();
     $('#quotation_valid_date_btn').html('Processing...')
     $('#quotation_valid_date_btn').prop('disabled' , true)
        $.ajaxSetup({
		headers: {
		'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
		}
		});
		$.ajax({
		url:"{{ route('request-for-quotations.change-date') }}",
		method:'POST',
		dataType:'json',
		data: {pr_id:pr_id ,quotation_valid_date:quotation_valid_date},
		success:function(data)
		{
         if (data.quotation_valid_date) 
         {
            $('#q_date_error').html(data.quotation_valid_date);
            $('#q_date_error').show();
            $('#quotation_valid_date_btn').html('Change')
            $('#quotation_valid_date_btn').prop('disabled' , false)
            setTimeout(function(){$('#q_date_error').hide(); }, 3000);
         }
         if(data.response)
         {
             $('#quot_date').html(data.date);
             $('#q_date_success').show('slow');
             $('#quotation_valid_date_btn').html('Change')
             $('#quotation_valid_date_btn').prop('disabled' , false)
             setTimeout(function(){$('#quotation_valid_date_form').hide(); }, 4000);
         }
   
		}
		})
		return false;
	}
</script>

@stop