@extends('layouts.app')

@section('title')
Dashboard
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Dashboard</li>
      </ol>
@stop

@section('css')
<style type="text/css">
  #purchase_requests_id_chosen
  {
     display: none;
  }
</style>
@stop

@section('content')
  <div class="container-fluid">
  <div class="row">
            
            <div class="col-md-3">
            <div class="white-box bg-success color-box" style="padding: 0px 0px 20px 20px;">
            <h1 style="font-size: 3rem;" class="text-white font-light m-b-0">Pending MIR</h1>
            
            <p class="cb-text">Info</p>
            <h6 class="text-white font-semibold">Total <span style="margin-left: 2rem;" class="font-light">{{$total_pending_mir->count()}}</span></h6>

          
            </div>
            </div>



             <div class="col-md-3">
            <div class="white-box bg-primary color-box" style="padding: 0px 0px 20px 20px;">
            <h1 style="font-size: 3rem;" class="text-white font-light m-b-0">Release MIR</h1>
            
            <p class="cb-text">Info</p>
            <h6 class="text-white font-semibold">Total <span style="margin-left: 2rem;" class="font-light">{{$total_release_mir}}</span></h6>
           
            </div>
            </div>




             <div class="col-md-3">
            <div class="white-box bg-warning color-box" style="padding: 0px 0px 20px 20px;">
            <h1 style="font-size: 3rem;" class="text-white font-light m-b-0">Department Release</h1>
            
            <p class="cb-text">Info</p>
             <h6 class="text-white font-semibold">Total <span style="margin-left: 2rem;" class="font-light">{{$total_department_release}}</span></h6>
           
            </div>
            </div>


            <div class="col-md-3">
            <div class="white-box bg-danger color-box" style="padding: 0px 0px 20px 20px;">
            <h1 style="font-size: 3rem;" class="text-white font-light m-b-0">Department Return</h1>
            
            <p class="cb-text">Info</p>
             <h6 class="text-white font-semibold">Total <span style="margin-left: 2rem;" class="font-light">{{$total_department_return}}</span></h6>
           
            </div>
            </div>




            <div class="col-md-4">
              <div class="white-box ecom-stat-widget">
                <div class="row">
                  <div class="col-xs-6">
                    <span class="text-blue font-light">Total <br>{{$sent_purchase_orders}} </span>
                    <p class="font-12">Sent Order</p>
                  </div>
                  <div class="col-xs-6">
                    <span class="icoleaf bg-danger text-white"><i class="mdi mdi-coin"></i></span>
                  </div>
                </div>
              </div>
            </div>



            <div class="col-md-4">
              <div class="white-box ecom-stat-widget">
                <div class="row">
                  <div class="col-xs-6">
                    <span class="text-blue font-light">Total <br>{{$receive_purchase_orders}} </span>
                    <p class="font-12">Received Order</p>
                  </div>
                  <div class="col-xs-6">
                    <span class="icoleaf bg-danger text-white"><i class="mdi mdi-coin"></i></span>
                  </div>
                </div>
              </div>
            </div>



            <div class="col-md-4">
              <div class="white-box ecom-stat-widget">
                <div class="row">
                  <div class="col-xs-6">
                    <span class="text-blue font-light">Total <br>{{$partial_purchase_orders}} </span>
                    <p class="font-12">Partial Receive Order</p>
                  </div>
                  <div class="col-xs-6">
                    <span class="icoleaf bg-danger text-white"><i class="mdi mdi-coin"></i></span>
                  </div>
                </div>
              </div>
            </div>

            <!-------------------------End----------------------------------------->


                <div class="col-sm-12">
                <div class="white-box">
                <h3 class="box-title" style="margin-bottom: 3rem;"> Pending MIR's</h3>

                @if(Session::has('success'))   
                <div id="successMessage" class="alert alert-success" role="alert">
                {{ Session::get('success') }}
                </div>
                @endif


                <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                <thead>
                <tr role="row">
                <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">MIR #</th>

                <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">PR #</th>

                <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Department</th>


                <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Request By</th>

                <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Request date </th>

                <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Release Status  </th>

                <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 50px;">Action</th>

                </tr>
                </thead>
                <tbody id="pr-appro-tbl-body">
  
                    @if( $total_pending_mir->count() > 0 )
                    @foreach( $total_pending_mir as $list )

                      <tr>
                      <td class="">MIR-{{$list->id }}</td>

                      <td >PR-{{$list->pr_id}}</td>

                      <td>{{ !empty($list->department) ? $list->department->department_name : '' }}</td>
                      <td>{{ $list->request_person_name }}</td>
                      <td>{{ date('d-F-Y' , strtotime($list->request_date)) }}</td>
                      <td>{{ucfirst($list->status)}}</td>
                      <td>
                          <a data-toggle="tooltip" data-placement="top" title="View" style="margin-left: 1rem; color: #e8b600"  href="javascript:void(0);" onclick="return showItemReleseModal(this , '{{$list->id}}')">
                          <i class="fa fa-eye" aria-hidden="true"></i>
                          </a>
                      </td>
                      </tr>
                 @endforeach   
                 @endif


                </tbody>
                </table>
                </div>
                </div>



                <!-------------------Latest------------------------->


                            <!-------------------------End----------------------------------------->


                <div class="col-sm-12">
                <div class="white-box">

                  <div class="row">
                <div class="col-sm-6">


                <h3 class="box-title" style="margin-bottom: 3rem;"> Latest Releasing's</h3>



                <div class="table-responsive">
                <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                <thead>
                <tr role="row">
                <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 10px;">MIR</th>

                <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Release For</th>


                <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Depart</th>

                <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Released By</th>

                <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Releasing Date</th>


                <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Received By</th>


                <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Action </th>

                </tr>
                </thead>
                <tbody>
                @foreach( $item_releasings as $list )
                @php
                $total = 0;
                foreach($list->releasing_items as $quantity)
                $total ++;
                @endphp
                <tr role="row" class="odd">

                <td>
                {{$list->mir_id > 0  ?  'MIR-'.$list->mir_id : '-' }} 
                </td>


                <td>
                @if($list->purchase_request_id > 0)
                @permission('view-purchase-request')
                <a target="_blank" href="{{route('purchase-requests.view' , [$list->purchase_request_id])}}">PR-{{$list->purchase_request_id }} </a>
                @else
                PR-{{$list->purchase_request_id }}
                @endpermission
                @else
                Department
                @endif
                </td>


                <td>
                {{!empty($list->department)?$list->department->department_name:''}}
                </td>

                <td>
                {{$list->releaser_name}}
                </td>

                <td>
                {{ date('d-M-Y' , strtotime($list->releasing_date))}}
                </td>

                <td>
                {{$list->receiver_name}}
                </td>



                <td>

                <a href="{{route('item.releasing-details' , [$list->id])}}"><i style="margin-left: 1rem;" class="fa fa-eye" aria-hidden="true"></i></a>

                </td>

                </tr>
                @endforeach   



                </tbody>
                </table>

                </div>

                </div>


    <div class="col-sm-6">


                <h3 class="box-title" style="margin-bottom: 3rem;"> Latest Return's</h3>


                <div class="table-responsive">


                   <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                                    <thead>
                                        <tr role="row">
                                        <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 10px;">MIR</th>

                                        <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Release For</th>

                                      
                                        <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Depart</th>

                                        <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Return By</th>

                                        <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Return Date</th>


                                        <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Received By</th>


                                        <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Action </th>

                                        </tr>
                                    </thead>
                        <tbody>
                        @foreach( $item_returings as $list )
                        @php
                        $total = 0;
                        foreach($list->releasing_items as $quantity)
                        $total ++;
                        @endphp
                        <tr role="row" class="odd">

                          <td>
                          {{$list->mir_id > 0  ?  'MIR-'.$list->mir_id : '-' }} 
                        </td>


                        <td>
                        @if($list->purchase_request_id > 0)
                        @permission('view-purchase-request')
                        <a target="_blank" href="{{route('purchase-requests.view' , [$list->purchase_request_id])}}">PR-{{$list->purchase_request_id }} </a>
                        @else
                        PR-{{$list->purchase_request_id }}
                        @endpermission
                        @else
                         Department
                        @endif
                        </td>


                        <td>
                          {{!empty($list->department)?$list->department->department_name:''}}
                        </td>

                        <td>
                          {{$list->returning_name}}
                        </td>

                        <td>
                          {{ date('d-M-Y' , strtotime($list->return_date))}}
                        </td>

                        <td>
                          {{$list->receiver_name}}
                        </td>

                        

                        <td>
                       
                          <a href="{{route('item.returning-details' , [$list->id])}}"><i style="margin-left: 1rem;" class="fa fa-eye" aria-hidden="true"></i></a>
                        
                        </td>
                
                       </tr>
                      @endforeach   
               

                                      
                                </tbody>
                                </table>


                </div>

                </div>



                  </div>






                </div>
                </div>

</div>

</div>




                        <!----------------Releaseing----------------->


                            <div class="modal fade" id="item_release_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel1">
                            <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                            <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 class="modal-title" id="Modal_Title">
                            Release Items
                            </h4></div>
                            <div class="modal-body">

                            
                            <div class="row" id="release_with_pr" >
                            <div class="col-md-3">
                            <label><span id="release_by">Released By</span> <b style="color:red;">*</b></label>
                            <input type="text" id="releaser_name" value="{{ucfirst(Auth::user()->name)}}" readonly placeholder="Please Enter Name..." class="form-control" name="">

                            </div>

                            <div class="col-md-3">
                            <label>Received By <b style="color:red;">*</b></label>
                            <input type="text"   id="receiver_name" placeholder="Please Enter Name..." class="form-control" name="">

                            </div>


                            <div class="col-md-6">
                            <label>
                                <span id="release_date">Releasing Date </span><b style="color:red;margin-right: 1rem;">*</b></label>
                            <span id="invalid_date_errorMessage" style="display:none; color: red;margin-left: 1rem;"></span>
                            <input type="date" id="date" min="{{date('Y-m-d')}}" value="{{date('Y-m-d')}}" class="form-control">
                            </div>

                            <div class="col-md-6" id="select_pr" style="margin-top: 1rem;">
                            <label >Selected MIR <b style="color:red;margin-right: 1rem;">*</b></label>

                            <div id="mirs_list">
                            <input type="text" readonly class="form-control" id="current_mir" >
                            <select class="form-control chosen-select" style="display: none;"  name="purchase_requests_id" onchange="return getDepartment(this);"  id="purchase_requests_id">
                            <option value="">Select Mir</option> 
                            @if($mirs->count() > 0  )
                            @foreach($mirs as $list)
                            <option value="{{ $list->id }}">MIR- {{ $list->id  }}</option>@endforeach
                            @endif
                            </select>

                             </div>

                            </div>


                            <div class="col-md-6" id="select_project" style="margin-top: 1rem;display: none;">
                            <label >Project <b style="color:red;margin-right: 1rem;">*</b></label>
                            
                             <input type="text" class="form-control" id="project_name" readonly="readonly"  value="{{ env('APP_NAME') }}">

                            </div>


                            <div class="col-md-6" id="with_pr_department" style="margin-top: 1rem;">
                            <label >Department <b style="color:red;margin-right: 1rem;">*</b></label>
                             <input type="hidden" readonly="readonly" id="department_id" name="">
                            <input type="text" class="form-control" id="department_name" readonly="readonly"  value="">
                            </div>
                           

                            </div>

                            <input type="hidden" id="check_type" name="">



                            <table id="myTable"  class="table table-striped dataTable no-footer with_pr_table" role="grid" aria-describedby="myTable_info">
                            <thead>
                            <tr role="row">

                           <th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 50px;">Category</th>

                            <th class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 50px;">Code</th>


                            <th class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 150px;">Name</th>



                            <th class="sorting" tabindex="0" id="demand_quantity_th" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Demand Qty</th>


                            <th class="sorting" tabindex="0" id="total_receive_th" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Total Receive</th>


                            <th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Available Qty</th>


                            <th class="sorting" tabindex="0" id="c_r_quantity_th" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Current Release</th>


                            <th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 203px; text-align: center;" id="column_type">Release Qty</th>
                            </tr>

                            </thead>
                            <tbody id="data"> </tbody>
                            </table>

                            </div>
                            <div class="modal-footer">

                                <div class="alert alert-success" role="alert" style="display:none;text-align: left;"  id="succeessMessage2">
                           
                            </div>

                            <div class="alert alert-danger" role="alert" style="display:none;text-align: left;"  id="errorMessage2"></div>


                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit"  onclick="return confirmReleasing(this)" class="btn btn-primary"  id="thisBtn" >Confirm</button>
                            </form>
                            </div>
                            </div>
                            </div>
@stop

@section('js')  

<script type="text/javascript">
    let type = false;

    function showItemReleseModal(self , mir_id)
    {
      $('#purchase_requests_id option[value="'+mir_id+'"]').prop("selected",true).trigger("change");

      $('#current_mir').val('MIR-'+mir_id);

      $('#item_release_modal').modal('show');
    }

    $('input:radio[name="type"]').change(
    function(){
        var name = '{{ucfirst(Auth::user()->name)}}';

        if ($('#showSelectOption').val() == 'with_pr') 
        {
           $('#data').html(''); 
        }
        

        if ($(this).is(':checked') && $(this).val() == 'release') 
        {


        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        $.ajax({
        url:"{{ route('purchase-requests.return.or.reles.mir') }}",
        method:'POST',
        dataType:'json',
        data:{type: 'release'},
        success:function(data)
        {

            if ($('#showSelectOption').val() == 'with_pr') 
        {
            
            $option_data_rows = '';

            $option_data_rows +='<select class="form-control chosen-select"  name="purchase_requests_id" onchange="return getDepartment(this);"  id="purchase_requests_id"><option value="">Select Mir</option>';
            $.each(data.output, function(k, v) 
            {
             $option_data_rows += '<option value="'+v.id+'">MIR-'+v.id+'</option>';
            });

             $option_data_rows += '</select>';

             $('#mirs_list').html($option_data_rows);

         }

            
            $('#column_type').html('Release Qty')
            $('#release_by').html('Released By')
            $('#release_date').html('Releasing Date')
            $('#Modal_Title').html('Release Item(s)')
            $('#releaser_name').val(name)
            $('#releaser_name').prop('readonly', true);
            $('#receiver_name').prop('readonly', false);
            $('#receiver_name').val('')
            type = false;

        }
        })

        }

         if ($(this).is(':checked') && $(this).val() == 'return')
          {
            

        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        $.ajax({
        url:"{{ route('purchase-requests.return.or.reles.mir') }}",
        method:'POST',
        dataType:'json',
        data:{type: 'return'},
        success:function(data)
        {

            if ($('#showSelectOption').val() == 'with_pr') 
            {

                $option_data_rows = '';

                $option_data_rows +='<select class="form-control chosen-select"  name="purchase_requests_id" onchange="return getDepartment(this);"  id="purchase_requests_id"><option value="">Select Mir</option>';
                $.each(data.output, function(k, v) 
                {
                 $option_data_rows += '<option value="'+v.id+'">MIR-'+v.id+'</option>';
                });

                 $option_data_rows +='</select>';

                 $('#mirs_list').html($option_data_rows);

             }
           
            
            $('#column_type').html('Return Qty')
            $('#release_by').html('Return By')
            $('#release_date').html('Return Date')
            $('#Modal_Title').html('Return Item(s)')
            $('#receiver_name').val(name)
            $('#releaser_name').prop('readonly', false);
            $('#receiver_name').prop('readonly', true);
            $('#releaser_name').val('')
            type = true;

        }
        })

          }

    });



    function showSelectOption(self) {
       
      if($(self).val() == 'with_pr') 
      {
        $('#check_type').val('with_pr');
        $('#data').html("");
        $('#release_with_pr').show('slow')
        $('#thisBtn').show('slow');
        $('#select_pr').show('slow')
        $('#select_project').hide('slow')
        $('#c_r_quantity_th').show('slow')
        $('#demand_quantity_th').show('slow')
        $('#total_receive_th').show('slow')
        $('#without_pr_department').hide('slow')
        $('#with_pr_department').show('slow')
        $('#item_release_modal').find('.with_pr_table').show('slow');
      }
       else if($(self).val() == 'without_pr') 
       {
         $('#check_type').val('without_pr');
        $('#data').html("");
        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        $.ajax({
        url:"{{ route('item.get-item-for-releasing') }}",
        method:'GET',
        dataType:'json',
        success:function(data)
        {
            if (data.response == 'yes') 
            {
            
            $table_data_rows = '';
            $.each(data.output, function(k, v) {

            $table_data_rows += '<tr> <td>'+v.category.category_name +'</td>  <td>'+v.item_code +'</td> <td>'+v.item_name+' - '+v.manufacture.name+' </td>  <td>'+v.quantity+'</td> <td id="item_'+v.id+'" class="release_quantity"><input class="item_id" value = "'+v.id+'" type="hidden" /> <input type="number" style="width: 100%;background: transparent;border: none;" value="release_qty[]" class="release_qty" /></td></tr>';
            });

             $('#data').html($table_data_rows);
            }
            else if(data.response == 'empty')
            {
                $('#data').html('<tr><td>No Item Found For Release</td></tr>');
            }
            else
            {
                alert("Something went wrong!")
                location.reload(true)
            }

            $('#c_r_quantity_th').hide('slow')
            $('#demand_quantity_th').hide('slow')
            $('#total_receive_th').hide('slow')
            $('#release_with_pr').show('slow')
            $('#thisBtn').show('slow');
            $('#select_pr').hide('slow')
            $('#select_project').show('slow')
            $('#without_pr_department').show('slow')
            $('#with_pr_department').hide('slow')
            $('#item_release_modal').find('.with_pr_table').show('slow');
        }
        })

       }
       else
       {
         $('#check_type').html("");
         $('#data').html("");
         $('#release_with_pr').hide('slow')
         $('#thisBtn').hide('slow');
         $('#item_release_modal').find('.with_pr_table').hide('slow');
       }
       
        return false;
    }


       function getDepartment(self) {
      
        $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        $.ajax({
        url:"{{ route('purchase-requests.get-department') }}",
        method:'POST',
        dataType:'json',
        data: {mir_id:$(self).val()},
        success:function(data)
        {
            $table_data_rows = '';
            $request_quantity = '';
            $.each(data.items, function(k, v) 
            {
               if (type == false) 
               {
                  $request_quantity = v.requesting_quantity; 
               }

                $table_data_rows += '<tr> <td>'+v.category +'</td>  <td>'+v.item_code +'</td> <td>'+v.item_name+' - '+v.brand+'</td>   <td>'+v.demand_quantity+'</td> <td>'+v.total_receive_items+'</td> <td>'+v.quantity+'</td> <td>'+v.current_releasing+'</td>    <td id="item_'+v.id+'" class="release_quantity" > <input class="item_id" value = "'+v.id+'" type="hidden" /><input type="number" style="width: 100%;background: transparent;border: none;" value="'+$request_quantity+'" class="release_qty" /></td></tr>';
            });

            $('#data').html($table_data_rows);

            $('#department_name').val(data.department_name)
            $('#department_id').val(data.department_id)
        }
        })
        return false;
    }


    function confirmReleasing(self) {
     var items = [];
     var releaser_name = $('#releaser_name').val();
     var date = $('#date').val();
     var receiver_name = $('#receiver_name').val();

     var department = $('#department_id').val();
     var purchase_requests_id = $('#purchase_requests_id option:selected').val();
    

     $(self).html('Processing...')
     $(self).prop('disabled' , true);

    $('.release_quantity').each(function()
    {

    items.push({'item_id':$(this).find(".item_id").val() ,'releasing_quantity': $('#item_'+$(this).find(".item_id").val() ).find('.release_qty').val() });
    });


      $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
          }
        });

        $.ajax({
        url:"{{ route('item.releasing') }}",
        method:'POST',
        dataType:'json',
        data: {items:items , releaser_name:releaser_name ,receiver_name:receiver_name , date:date , mir_id:purchase_requests_id , department : department , type:type},
        success:function(data)
        {
         if(data.response)
         {
            $('#errorMessage2').html(data.message);
            $('#errorMessage2').show();
            $(self).html('Confirm')
            $(self).prop('disabled' , false);
            setTimeout(function(){  $('#errorMessage2').hide();}, 5000);
         }

          if(data.result)
         {
            $('#succeessMessage2').html(data.message);
            $('#succeessMessage2').show();
            setTimeout(function(){ location.reload(true) }, 5000);
         }

        }
        })



        return false;
    }


    function addItems() 
    {
      var checkedNum = $('input[name="items[]"]:checked').length;

        if (!checkedNum) 
        {
          $('#item_release_btn').hide();
        }
        else
        {
          $('#item_release_btn').show();
        }
    }

 
</script>

@stop