@extends('layouts.app')

@section('title')
Purchase Order
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Purchase Order</li>
      </ol>
@stop
@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
@stop
@section('css') 
<style type="text/css">
.anychart-credits
{
display: none;
}
.us_notify
{

}
</style>
@stop

 @section('content')
  <div class="container-fluid">
  <div class="row">
                    
    <div class="col-sm-12">


        <div class="white-box">
                          <h3 class="box-title m-b-0">Purchase Order </h3>
                          
                            <!-- Nav tabs -->
                            <ul class="nav customtab nav-tabs" role="tablist" style="margin-top: 3rem;">

                                <li role="presentation" class="active"><a href="#detail" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-home"></i> </span><span class="hidden-xs"> Sent Orders</span> <span style ="background: #0283cc;color: white;position: relative;border-radius: 50%;padding: 1px 6px 1px 6px;bottom: 1rem;">{{$sent_purchase_orders->count()}}</span></a> </li>


                                <li role="presentation" class=""><a href="#releasing" aria-controls="profile" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-user"></i></span> <span class="hidden-xs">Receive Orders</span><span style ="background: #03c500;color: white;position: relative;border-radius: 50%;padding: 1px 6px 1px 6px;bottom: 1rem;">{{$receive_purchase_orders->count()}}</span></a></li>


                                <li role="presentation" class=""><a href="#graph" aria-controls="profile" role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i class="ti-user"></i></span> <span class="hidden-xs">Partial Receive Orders</span><span style ="background: #f5cb00;color: white;position: relative;border-radius: 50%;padding: 1px 6px 1px 6px;bottom: 1rem;">{{$partial_purchase_orders->count()}}</span></a></li>


                            </ul>
                            <!-- Tab panes -->
                       <div class="tab-content">
                       <div role="tabpanel"  class="tab-pane fade active in" id="detail">

                      <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">

                        <thead>
                        <tr role="row">
                        <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Po#</th>
                        <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Vendor</th>

                        <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 50px;">Status</th>

                        <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 80px;">Sent Date </th>

                        <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Delivery Date</th>

                        <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;"> Action</th>

                        </tr>
                        </thead>
                        <tbody>
  
                            @foreach($sent_purchase_orders as $sent_order)

                           

                                <tr role="row" class="odd">
                                    <td>PO-{{$sent_order->id}}</td>
                                    <td>{{$sent_order->vendor->name}}</td>
                                    <td>
                                    @if($sent_order->status == 1) 
                                    <div style="background: #0283cc;color: white; padding: 5px;font-size: 13px;border-radius: 20px;text-align: center;">
                                    {{ 'PO SENT' }}
                                    </div>
                                    @elseif ($sent_order->status == 2) 
                                    <div style="background: #03c500;color: white; padding: 5px;font-size: 13px;border-radius: 20px;text-align: center;">
                                    {{ 'PO RECEIVED' }}
                                    </div>
                                    @elseif($sent_order->status == 3)
                                    <div style="background: #f5cb00;color: white; padding: 5px;font-size: 13px;border-radius: 20px;text-align: center;">

                                    {{ 'PARTIALLY RECEIVED' }} 

                                    </div>
                                    @endif
                                    </td>
                                    <td style="font-size: 15px;">{{date('d-F-Y' , strtotime($sent_order->created_at))}}</td>

                                    <td style="font-size: 15px;">{{date('d-F-Y' , strtotime($sent_order->delivery_date))}}</td>
                                    <td>
                                        @permission(['list-purchase-order' , 'store-keeper'])
                                        <a href="{{url('purchase-orders/detail?vendor='.Crypt::encryptString($sent_order->vendor->id).'&purchase_request='.Crypt::encryptString($sent_order->purchase_request_id).'')}}" class="btn btn-success btn-xs" target="_blank">View</a>
                                        @endpermission
                                    </td>
                                </tr>  
                             

                                @endforeach
                                     
                                </tbody>
                                </table>
                                   
                                </div>

                            <div role="tabpanel" class="tab-pane fade" id="releasing">
                        <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                        <thead>
                        <tr role="row">

                        <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Po#</th>
                        <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Vendor</th>

                        <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 50px;">Status</th>

                        <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 80px;">Sent Date </th>

                        <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Delivery Date</th>

                        <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;"> Date</th>

                      
                        </tr>
                        </thead>
                        <tbody>
  
								
    @foreach($receive_purchase_orders as $sent_order)


                                <tr role="row" class="odd">
                                    <td>PO-{{$sent_order->id}}</td>
                                    <td>{{$sent_order->vendor->name}}</td>
                                    <td>
                                    @if($sent_order->status == 1) 
                                    <div style="background: #0283cc;color: white; padding: 5px;font-size: 13px;border-radius: 20px;text-align: center;">
                                    {{ 'PO SENT' }}
                                    </div>
                                    @elseif ($sent_order->status == 2) 
                                    <div style="background: #03c500;color: white; padding: 5px;font-size: 13px;border-radius: 20px;text-align: center;">
                                    {{ 'PO RECEIVED' }}
                                    </div>
                                    @elseif($sent_order->status == 3)
                                    <div style="background: #f5cb00;color: white; padding: 5px;font-size: 13px;border-radius: 20px;text-align: center;">

                                    {{ 'PARTIALLY RECEIVED' }} 

                                    </div>
                                    @endif
                                    </td>
                                    <td style="font-size: 15px;">{{date('d-F-Y' , strtotime($sent_order->created_at))}}</td>

                                    <td style="font-size: 15px;">{{date('d-F-Y' , strtotime($sent_order->delivery_date))}}</td>
                                    <td>
                                        @permission(['list-purchase-order', 'store-keeper'])
                                        <a href="{{url('purchase-orders/detail?vendor='.Crypt::encryptString($sent_order->vendor->id).'&purchase_request='.Crypt::encryptString($sent_order->purchase_request_id).'')}}" class="btn btn-success btn-xs" target="_blank">View</a>
                                        @endpermission
                                    </td>
                                </tr>  
                           

                                @endforeach
                                     
                                </tbody>
                                </table>
								
                                    </div>

                                    <div role="tabpanel" class="tab-pane fade" id="graph">


                                     <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                        <thead>
                        <tr role="row">

                        <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Po#</th>
                        <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Vendor</th>

                        <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 50px;">Status</th>

                        <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 80px;">Sent Date </th>

                        <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Delivery Date</th>

                        <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;"> Date</th>

                      
                        </tr>
                        </thead>
                        <tbody>
  
                                
    @foreach($partial_purchase_orders as $sent_order)

                    

                                <tr role="row" class="odd">
                                    <td>PO-{{$sent_order->id}}</td>
                                    <td>{{$sent_order->vendor->name}}</td>
                                    <td>
                                    @if($sent_order->status == 1) 
                                    <div style="background: #0283cc;color: white; padding: 5px;font-size: 13px;border-radius: 20px;text-align: center;">
                                    {{ 'PO SENT' }}
                                    </div>
                                    @elseif ($sent_order->status == 2) 
                                    <div style="background: #03c500;color: white; padding: 5px;font-size: 13px;border-radius: 20px;text-align: center;">
                                    {{ 'PO RECEIVED' }}
                                    </div>
                                    @elseif($sent_order->status == 3)
                                    <div style="background: #f5cb00;color: white; padding: 5px;font-size: 13px;border-radius: 20px;text-align: center;">

                                    {{ 'PARTIALLY RECEIVED' }} 

                                    </div>
                                    @endif
                                    </td>
                                    <td style="font-size: 15px;">{{date('d-F-Y' , strtotime($sent_order->created_at))}}</td>

                                    <td style="font-size: 15px;">{{date('d-F-Y' , strtotime($sent_order->delivery_date))}}</td>
                                    <td>
                                        @permission(['list-purchase-order', 'store-keeper'])
                                        <a href="{{url('purchase-orders/detail?vendor='.Crypt::encryptString($sent_order->vendor->id).'&purchase_request='.Crypt::encryptString($sent_order->purchase_request_id).'')}}" class="btn btn-success btn-xs" target="_blank">View</a>
                                        @endpermission
                                    </td>
                                </tr>  
                              

                                @endforeach
                                     
                                </tbody>
                                </table>

                
                                    </div>
                            </div>
                        </div>
                    </div>
            </div>
      </div>
@stop

@section('js')  


 <script>


    </script>

    @stop