@extends('layouts.app')

@section('title')
Add Vendor
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Add Vendor</li>
      </ol>
@stop

@section('css')


@stop


@section('content')
  <div class="container-fluid">
  <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0">Add  Vendor</h3>
                            <p class="text-muted m-b-30 font-13">  </p>
                            <form class="form-horizontal" method="POST" action="{{ route('vendor.insert') }}">
                            	 {{csrf_field()}}
                                <div class="form-group">


                                     <div class="col-md-4">
                                        <label>Name <b style="color:red;">*</b></label>
                                        <input type="text" class="form-control" placeholder ="Type Vendor Name here...." value="{{old('name')}}" name="name">
                                         @if ($errors->has('name'))
                                    <span >
                                        <strong class="error_messages" >{{ $errors->first('name') }}</strong>
                                    </span>
                                         @endif

                                     </div>
                                 

                                    <div class="col-md-4">
                                        <label>Phone <b style="color:red;">*</b></label>
                                        <input type="text" maxlength="11" class="form-control" placeholder ="Type Vendor Phone here..." value="{{old('phone')}}" name="phone">
                                         @if ($errors->has('phone'))
                                    <span >
                                        <strong class="error_messages" >{{ $errors->first('phone') }}</strong>
                                    </span>
                                         @endif

                                     </div>
                                   

                                    <div class="col-md-4">
                                        <label>Email <b style="color:red;">*</b></label>
                                            <input type="email" class="form-control" placeholder ="Type email  here...." value="{{old('email')}}" name="email">
                                            @if ($errors->has('email'))
                                            <span >
                                            <strong class="error_messages" >{{ $errors->first('email') }}</strong>
                                            </span>
                                            @endif

                                          </div>

                                            </div>



                                    <div class="form-group">
                                      <div class="col-md-6">
                                        <label style="    margin-bottom: 10px;" >National Tax Number (NTN) <b style="color:red;">*</b></label>
                                        <input type="text" maxlength="15" class="form-control" placeholder ="Type NTN  here...." value="{{old('ntn')}}" name="ntn">
                                         @if ($errors->has('ntn'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('ntn') }}</strong>
                                        </span>
                                         @endif

                                     </div>


                                      <div class="col-md-6">
                                        <label style="    margin-bottom: 10px;" >Sales Tax Number (STN) <b style="color:red;">*</b></label>
                                        <input type="text" maxlength="15" class="form-control" placeholder ="Type STN  here...." value="{{old('stn')}}" name="stn">
                                         @if ($errors->has('stn'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('stn') }}</strong>
                                        </span>
                                         @endif

                                     </div>
                                 
                                 </div>



                             <div class="form-group">
                               <div class="col-md-6">
                                <label style="margin-bottom: 1.3rem;">Select one or more than one item.</label>
                                    <select class="chosen-select"  name="item_name[]" multiple="multiple">
                                    @if($itemList->count() > 0  )
                                    @foreach($itemList as $list)
                                    <option value="{{ $list->id }}">{{ $list->item_name }}</option> 
                                    @endforeach
                                    @endif
                                    </select>

                                   @if ($errors->has('item_name'))
                                    <span >
                                        <strong class="error_messages" >{{ $errors->first('item_name') }}</strong>
                                    </span>
                                         @endif

                                     </div>


                                      <div class="col-md-6">
                                        <label style="    margin-bottom: 10px;" >Add valid 13 digits CNIC with dashes <b style="color:red;">*</b></label>
                                        <input type="text" maxlength="15" class="form-control" placeholder ="Type Cnic  here...." value="{{old('cnic')}}" name="cnic">
                                         @if ($errors->has('cnic'))
                                        <span >
                                        <strong class="error_messages" >{{ $errors->first('cnic') }}</strong>
                                        </span>
                                         @endif

                                     </div>
                                 
                                 </div>


                                   
                                    <div class="form-group">
                                    <label class="col-md-12">Address</label>
                                    <div class="col-md-12">
                                        <textarea class="form-control" name="address" rows="5"></textarea>
                                    </div>
                                </div>
                                
                               
                                <div class="form-group">
                                   
                                    <div class="col-md-12">
                                           <button type="submit" class="btn btn-success waves-effect waves-light m-r-10">Submit</button>
                                    </div>
                                </div>

                               
                               
                                	
                            </form>
                        </div>
                    </div>
                </div>

      </div>
@Stop
