@extends('layouts.app')

@section('title')
All Vendor
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Vendors</li>
      </ol>
@stop




@section('content')
  <div class="container-fluid">
  <div class="row">
                    
    <div class="col-sm-12">
                        <div class="white-box">
                           @permission('create-vendor')

                          

                             <h3 style="text-align: right;" class="box-title m-b-0">
                                <span style="float: left;"> Vendors List</span>
                                <a  class="btn btn-info btn-sm" href="{{ route('vendor.add') }}">Add Vendor</a>
                             </h3>

                             @endpermission
                            <div class="table-responsive">
                             
                            @if(Session::has('success'))   
                            <div id="successMessage" class="alert alert-success" role="alert">
                            {{ Session::get('success') }}
                            </div>
                            @endif

                            <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">
                                    <thead>
                                        <tr role="row">
                                        	<th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 200px;">Name</th>

                                            <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 200px;">Phone </th>

                                        	<th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Email</th>

                                            <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending" style="width: 100px;">Action</th>

                                        </tr>
                                    </thead>
                                <tbody>
  
                                    @if( $vendorList->count() > 0 )
                                    @foreach( $vendorList as $list )

                                    <tr role="row" class="odd">
                                            <td> {{ucfirst($list->name) }}
                                         </td>

                                             <td>

                                               {{$list->phone_number }}

                                             </td>

                                            <td>{{ $list->email }} </td>
                                           
                                            
                                             <td>
                                                @permission('view-vendor')

                                                <a style="color:#ffbc00;"  href="{{ route('vendor.view',[$list->id] ) }}"><i class="fa fa-eye" aria-hidden="true"></i></a>

                                                @endpermission


                                                
                                                @permission('edit-vendor')
                                                 <a style="margin-left: 1rem;"  href="{{ route('vendor.edit', [$list->id] ) }}"><i class="fa fa-pencil-square-o" aria-hidden="true"></i></a>
                                                 @endpermission

                                              @permission('delete-vendor')
                                           
                                              <form action="{{route('vendor.delete',[$list->id] ) }}" method="post" style='display: inline;'>
                                                @method('DELETE')
                                                @csrf                                       
                                                <button class="btn btn-link btn-s" style="color:red;"  type="submit" name="action" value="delete" data-toggle="confirmation" data-title="Are you sure to delete?">
                                                    <i class="fa fa-trash-o" aria-hidden="true"></i>
                                                </button>                                                  
                                             </form>
                                             @endpermission
                                              {{-- <a style="color:red;margin-left: 1rem;" onclick="return validate();" href="{{ route('vendor.delete',[$list->id] ) }}"><i class="fa fa-trash-o" aria-hidden="true"></i></a> --}}
                                               

                                            </td>
                                        </tr>
                                     @endforeach   
                                     @endif

                                      
                                </tbody>
                                </table>
                                
                            </div>
                            </div>
                        </div>
                    </div>


    </div>

      </div>
@Stop

@section('js')  

<script type="text/javascript">
    function validate()
    { 
        if(!confirm('Are you sure you want to delete?'))
        {
            return false;
        } 
    }
</script>

@stop