@extends('layouts.app')
@section('title')
Add Vendor
@stop
@section('breadcrumb')
<ol class="breadcrumb pull-right">   
<li><a href="{{route('home')}}">

<i class="fa fa-dashboard"></i> Home</a></li>   
<li class="active">Vendors</li>      </ol>
@stop
@section('content') 
<div class="container-fluid"> 
<div class="row">          
<div class="col-sm-12">   
<div class="white-box">
<h3 class="box-title m-b-0">ITEM {{$item->item_code}} / <span style="font-size: 1.6rem;color: gray;">{{$item->item_name}}</span> 
</h3>     
<div class="table-responsive">
@if(Session::has('success'))                              
<div id="successMessage" class="alert alert-success" role="alert">                            {{ Session::get('success') }}                 
</div>                       
@endif                                              
<table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table" role="grid" aria-describedby="myTable_info">                                  
<thead>                                     
<tr role="row">                                      
<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Po#</th>                                        	
<th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Name: activate to sort column descending" style="width: 100px;">Order Quantity</th>                                           
<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;">Price</th>                                          
<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;"> Date</th>                                          
<th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable" rowspan="1" colspan="1" aria-label="Position: activate to sort column ascending" style="width: 100px;"> Receiving</th>                                    	                                        </tr>                                  
</thead>                          
<tbody>                                                                   
@foreach( $item_purchase_order  as $list )                              
<tr role="row" class="odd">                                @php                                
$po = \App\PurchaseOrder::getPurcchaseOrder($list->purchase_order_id , $vendorId);                               
@endphp                              
<td>                                 
@permission('list-purchase-order')                             
<a href="{{url('purchase-orders/detail?vendor='.Crypt::encryptString($vendorId).'&purchase_request='.Crypt::encryptString($po->purchase_request_id).'')}}"  target="_blank">PO-{{$po->id}}</a>                               
@endpermission                           
</td>                              
<td> {{number_format($list->demand_quantity , 2)}}</td>                              
<td> {{number_format($list->price , 2)}} </td>                              
<td style="font-size: 15px;">{{date('d-F-Y' , strtotime($po->created_at))}}</td>                             
<td style="line-height: 30px;">
@if(!empty($po->purchaseOrderReceipts[0]))                              
<div><b>By : </b>{{ucfirst($po->purchaseOrderReceipts[0]->po_receiver_name)}}</div>                              
<b>At : </b>{{date('d-F-Y' , strtotime($po->purchaseOrderReceipts[0]->po_receiveing_date))}}                              
@else                               
<span style="font-size: 13px;background: #0283cc; padding: 1px 15px 2px 15px;border-radius: 18px;font-size: 13px;color: white;">{{'Not Yet Receive'}}</span>                                @endif                               
</td>                                </tr>                                @endforeach        
</tbody>                                </table>                                                            </div>                            </div>                      
</div>                  
</div>   
</div>   
</div>
@stop 