 @extends('layouts.app')

 @section('title')
     Dashboard
 @stop

 @section('breadcrumb')
     <ol class="breadcrumb pull-right">
         <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>

         <li class="active">Procurement Dashboard</li>
     </ol>
 @stop

 @section('css')

     <style>
         /*.parent_div::-webkit-scrollbar
    {
      width: 1em;
    }

    .parent_div::-webkit-scrollbar-track
    {
      border-radius: 10px;
      -webkit-box-shadow: inset 0 0 6px rgba(0, 0, 0, 0.3);
    }

    .parent_div::-webkit-scrollbar-thumb
    {
      border-radius: 10px;
      background-color: #00bd86;
      outline: 2px solid slategrey;
    }

    .parent_div::-webkit-scrollbar:vertical
    {
      display: none;
    }*/
     </style>

 @stop


 @section('content')
     <div class="container-fluid">
         <div class="row">


             <div class="col-md-4">
                 <div class="white-box ecom-stat-widget">
                     <div class="row">
                         <div class="col-xs-6">
                             <span class="text-blue font-light">PKR <br>{{ number_format($data['total_purchase'], 2) }}
                             </span>
                             <p class="font-12">Total Purchasing</p>
                         </div>
                         <div class="col-xs-6">
                             <span class="icoleaf bg-danger text-white"><i class="mdi mdi-coin"></i></span>
                         </div>
                     </div>
                 </div>
             </div>



             <div class="col-md-4">
                 <div class="white-box ecom-stat-widget">
                     <div class="row">
                         <div class="col-xs-6">
                             <span class="text-blue font-light">PKR
                                 <br>{{ number_format($data['total_monthly_purchase'], 2) }} </span>
                             <p class="font-12">{{ date('F') }}</p>
                         </div>
                         <div class="col-xs-6">
                             <span class="icoleaf bg-danger text-white"><i class="mdi mdi-coin"></i></span>
                         </div>
                     </div>
                 </div>
             </div>



             <div class="col-md-4">
                 <div class="white-box ecom-stat-widget">
                     <div class="row">
                         <div class="col-xs-6">
                             <span class="text-blue font-light">PKR <br>{{ number_format($data['total_pay_purchase'], 2) }}
                             </span>
                             <p class="font-12">Paid Amount</p>
                         </div>
                         <div class="col-xs-6">
                             <span class="icoleaf bg-danger text-white">
                                 <i class="mdi mdi-coin"></i>
                             </span>
                         </div>
                     </div>
                 </div>
             </div>


             <!----------------------Purchase Requests ----------------------->
             <div class="col-md-6">
                 <div class="white-box bg-warning color-box" style="background-color: #98dc98; padding: 2rem;">
                     <h1 style="font-size: 3rem;" class="text-white font-light m-b-0">Purchase Requests</h1>

                     <div class="row parent_div" style="width: auto;height: 200px;overflow: auto;padding: 1rem;">

                         @foreach ($data['departments'] as $departments)
                             <div class="text-center" style="display: inline-block;">

                                 <p class="cb-text ">{{ $departments->department_name }}</p>

                                 <a
                                     href="{{ route('purchase-requests.detail', ['status' => 'complete', 'department' => $departments->id]) }}">
                                     <h6 class="text-white font-semibold cus_btn_4"><b
                                             style="margin-left: 5px;">Complete</b> <span
                                             style="margin-left: 0rem;font-weight: bold; color:white;"
                                             class="font-light">{{ \App\PurchaseRequest::getPrWithStatus('complete', $departments->id)[0] }}
                                         </span></h6>
                                 </a>

                                 <a
                                     href="{{ route('purchase-requests.detail', ['status' => 'pending', 'department' => $departments->id]) }}">
                                     <h6 class="text-white font-semibold cus_btn_4"><b style="margin-left: 10px;">In Prog
                                         </b><span style="margin-left: 0rem;font-weight: bold; color:white;"
                                             class="font-light">{{ \App\PurchaseRequest::getPrWithStatus('pending', $departments->id)[0] }}</span>
                                     </h6>
                                 </a>


                                 <a
                                     href="{{ route('purchase-requests.detail', ['status' => 'cancel', 'department' => $departments->id]) }}">
                                     <h6 class="text-white font-semibold cus_btn_4"><b style="margin-left: 10px;">Cancel</b>
                                         <span style="margin-left: 0rem;font-weight: bold; color:white;"
                                             class="font-light">{{ \App\PurchaseRequest::getPrWithStatus('cancel', $departments->id)[0] }}</span>
                                     </h6>
                                 </a>


                             </div>
                         @endforeach

                     </div>


                 </div>
             </div>


             <!----------------------Purchase Orders ----------------------->

             <div class="col-md-6 text-center">
                 <div class="white-box bg-info color-box" style="background-color: #1c3752;padding: 2rem;">
                     <h1 style="font-size: 3rem;" class="text-white font-light m-b-0">Purchase Orders</h1>


                     <div class="row parent_div" style="width: auto;height: 200px;overflow: auto;padding: 1rem;">


                         @foreach ($data['departments'] as $departments)
                             <div class="text-center" style="display:inline-block;">

                                 <p class="cb-text">{{ $departments->department_name }}</p>

                                 <a
                                     href="{{ route('purchase-orders.lists', ['status' => 'po-sent', 'department' => $departments->id]) }}">
                                     <h6 class="text-white font-semibold cus_btn_3"><b style="margin-left: 10px;">Sent Po
                                         </b> <span style="margin-left: 0rem;font-weight: bold; color:white;"
                                             class="font-light">{{ \App\PurchaseRequest::getPoStatus('1', $departments->id) }}</span>
                                     </h6>
                                 </a>


                                 <a
                                     href="{{ route('purchase-orders.lists', ['status' => 'po-receive', 'department' => $departments->id]) }}">
                                     <h6 class="text-white font-semibold cus_btn_3"><b style="margin-left: 10px;">Receive
                                         </b><span style="margin-left: 0rem;font-weight: bold; color:white;"
                                             class="font-light">{{ \App\PurchaseRequest::getPoStatus('2', $departments->id) }}</span>
                                     </h6>
                                 </a>


                                 <a
                                     href="{{ route('purchase-orders.lists', ['status' => 'po-partial-receive', 'department' => $departments->id]) }}">
                                     <h6 class="text-white font-semibold cus_btn_3"><b style="margin-left: 10px;">Par-Rec
                                         </b><span style="    margin-left: 0rem;font-weight: bold; color:white;"
                                             class="font-light">{{ \App\PurchaseRequest::getPoStatus('3', $departments->id) }}</span>
                                     </h6>
                                 </a>


                             </div>
                         @endforeach

                     </div>


                 </div>
             </div>



             <!----------------------Purchase RFq's ----------------------->

             <div class="col-md-6 text-center">
                 <div class="white-box bg-primary color-box" style="padding: 2rem;">
                     <h1 style="font-size: 3rem;" class="text-white font-light m-b-0">RFQ's & CS's</h1>

                     <div class="row parent_div" style="width: auto;height: 200px;overflow: auto;padding: 1rem;">


                         @foreach ($data['departments'] as $departments)
                             <div class="text-center" style="display:inline-block">

                                 <p class="cb-text">{{ $departments->department_name }}</p>

                                 <a
                                     href="{{ route('request-for-quotations.all', ['status' => 'rfq-sent', 'department' => $departments->id]) }}">
                                     <h6 class="text-white font-semibold cus_btn_2"><b style="margin-left: 0px;">Sent
                                             Rfq's</b> <span style="margin-left: 0px;font-weight: bold; color:white;"
                                             class="font-light">{{ \App\PurchaseRequest::getrfqAndCsCount($departments->id)[0] }}</span>
                                     </h6>
                                 </a>


                                 <a
                                     href="{{ route('request-for-quotations.all', ['status' => 'cs-receive', 'department' => $departments->id]) }}">
                                     <h6 class="text-white font-semibold cus_btn_2"><b style="margin-left: 10px;">Recv CS
                                         </b><span style="margin-left: 0px;font-weight: bold; color:white;"
                                             class="font-light">{{ \App\PurchaseRequest::getrfqAndCsCount($departments->id)[2] }}</span>
                                     </h6>
                                 </a>

                                 <a
                                     href="{{ route('request-for-quotations.all', ['status' => 'cs-pending', 'department' => $departments->id]) }}">
                                     <h6 class="text-white font-semibold cus_btn_2"><b style="margin-left: 10px;">Pend CS
                                         </b><span style="margin-left: 0px;font-weight: bold; color:white;"
                                             class="font-light">{{ \App\PurchaseRequest::getrfqAndCsCount($departments->id)[1] }}</span>
                                     </h6>
                                 </a>

                             </div>
                         @endforeach

                     </div>

                 </div>
             </div>




             <!----------------------Purchase Receipts ----------------------->

             <div class="col-md-6 text-center">
                 <div class="white-box bg-success color-box" style="background-color: #98dc98; padding: 2rem;">
                     <h1 style="font-size: 3rem;" class="text-white font-light m-b-0">Receipts</h1>

                     <div class="row parent_div" style="width: auto;height: 200px;overflow: auto;padding: 1rem;">


                         @foreach ($data['departments'] as $departments)
                             <div class="text-center" style="display: inline-block;">

                                 <p class="cb-text">{{ $departments->department_name }}</p>

                                 <a
                                     href="{{ route('purchase-order-receipts.lists', ['status' => 'paid', 'department' => $departments->id]) }}">
                                     <h6 class="text-white font-semibold cus_btn"><b style="margin-left: 15px;">Paid</b>
                                         <span style="margin-left: 2rem;font-weight: bold; color:white;"
                                             class="font-light">{{ \App\PurchaseRequest::getReceiptStatus('1', $departments->id) }}</span>
                                     </h6>
                                 </a>

                                 <a
                                     href="{{ route('purchase-order-receipts.lists', ['status' => 'unpaid', 'department' => $departments->id]) }}">
                                     <h6 class="text-white font-semibold cus_btn"><b style="margin-left: 10px;">Unpaid</b>
                                         <span style="margin-left: 1rem;font-weight: bold; color:white;"
                                             class="font-light">{{ \App\PurchaseRequest::getReceiptStatus('0', $departments->id) }}</span>
                                     </h6>
                                 </a>

                                 <a
                                     href="{{ route('purchase-order-receipts.lists', ['status' => 'partial-paid', 'department' => $departments->id]) }}">
                                     <h6 class="text-white font-semibold cus_btn"><b style="margin-left: 10px;">Par
                                             Paid</b><span style="margin-left: 1rem;font-weight: bold; color:white;"
                                             class="font-light">{{ \App\PurchaseRequest::getReceiptStatus('2', $departments->id) }}</span>
                                     </h6>
                                 </a>


                             </div>
                         @endforeach
                     </div>

                 </div>
             </div>


             <!-------------------------End----------------------------------------->







             <div class="col-sm-12">
                 <div class="white-box">
                     <h3 class="box-title" style="margin-bottom: 3rem;"> Purchase Requests For Approval</h3>

                     @if (Session::has('success'))
                         <div id="successMessage" class="alert alert-success" role="alert">
                             {{ Session::get('success') }}
                         </div>
                     @endif


                     <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table"
                         role="grid" aria-describedby="myTable_info">
                         <thead>
                             <tr role="row">
                                 <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable"
                                     rowspan="1" colspan="1" aria-sort="ascending"
                                     aria-label="Name: activate to sort column descending" style="width: 100px;">Id#</th>

                                 <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable"
                                     rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending"
                                     style="width: 100px;">Department</th>


                                 <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable"
                                     rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending"
                                     style="width: 100px;">Created By</th>

                                 <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable"
                                     rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending"
                                     style="width: 50px;">Action</th>

                             </tr>
                         </thead>
                         <tbody id="pr-appro-tbl-body">

                             @if ($purchase_requests->count() > 0)
                                 @foreach ($purchase_requests as $list)
                                     <tr role="row" class="odd">

                                         <td>PR-{{ $list->id }}

                                         </td>


                                         <td>{{ $list->department->department_name }} </td>
                                         <td>{{ $list->user->name }} </td>


                                         <td>
                                             <a href="{{ route('purchase-requests.view', [$list->id]) }}" target="_blank"
                                                 class="btn btn-warning btn-xs">view</a>

                                             <form method="POST" style="display: inline;"
                                                 action="{{ route('purchase-request-approvals.changeStatus') }}"
                                                 id="pr_approval_form_{{ $list->id }}">
                                                 {{ csrf_field() }}
                                                 <input type="hidden" name="role_id" id="role_id"
                                                     value="{{ $role_id }}">
                                                 <input type="hidden" name="pr_id" id="pr_id"
                                                     value="{{ $list->id }}">
                                                 <textarea name="remarks" style="display: none;" id="pr_approval_form_{{ $list->id }}remarks"></textarea>
                                                 <button type="submit" name="status" class="btn btn-success btn-xs"
                                                     value="approve">Approve</button>
                                                 <button type="button"
                                                     onclick="return addRemarks(this , 'pr_approval_form_{{ $list->id }}' )"
                                                     name="status" class="btn btn-danger btn-xs"
                                                     value="unapprove">Cancel</button>
                                             </form>


                                         </td>
                                     </tr>
                                 @endforeach
                             @endif


                         </tbody>
                     </table>
                 </div>
             </div>

             <div class="col-sm-12">
                 <div class="white-box">
                     <h3 class="box-title" style="margin-bottom: 3rem;">Purchase Orders For Approval</h3>

                     @if (Session::has('success-po'))
                         <div id="successMessage" class="alert alert-success" role="alert">
                             {{ Session::get('success-po') }}
                         </div>
                     @endif


                     <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table"
                         role="grid" aria-describedby="myTable_info">
                         <thead>
                             <tr role="row">
                                 <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable"
                                     rowspan="1" colspan="1" aria-sort="ascending"
                                     aria-label="Name: activate to sort column descending" style="width: 100px;">PR#</th>

                                 <th style="color:black;" class="sorting_asc" tabindex="0" aria-controls="myTable"
                                     rowspan="1" colspan="1" aria-sort="ascending"
                                     aria-label="Name: activate to sort column descending" style="width: 100px;">PO#</th>

                                 <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable"
                                     rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending"
                                     style="width: 100px;">Department</th>


                                 <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable"
                                     rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending"
                                     style="width: 100px;">Created By</th>

                                 <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable"
                                     rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending"
                                     style="width: 100px;">Total Amount</th>

                                 <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable"
                                     rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending"
                                     style="width: 100px;">Advance</th>


                                 <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable"
                                     rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending"
                                     style="width: 100px;">Action</th>

                             </tr>
                         </thead>
                         <tbody id="po-appro-tbl-body">


                             @foreach ($approval_pending_cs as $list)
                                 @php
                                     $poid = 0;
                                 @endphp
                                 @foreach ($list->cs_approval_status as $po_id)
                                     @php
                                         $poid = $po_id->purchase_order_id;
                                         $po = \App\PurchaseOrder::find($poid);
                                         $advanceAmount = ($po->total_amount * $po->advance) / 100;
                                     @endphp
                                     <tr role="row" class="odd">

                                         <td>PR-{{ $list->id }}
                                         <td>PR-{{ $po->id }} </td>


                                         <td>{{ \App\Department::withTrashed()->find($list->department_id)->department_name }}
                                         </td>


                                         <td>{{ $list->user->name }} </td>

                                         <td>{{ number_format($po->total_amount) }} </td>

                                         <td>{{ number_format($advanceAmount) . ' (' . $po->advance . '%)' }} </td>

                                         <td>
                                             <a href="{{ route('comparative-statements-view-approval-pending', ['view' => $list->id, 'user' => $role_id, 'po' => $poid]) }}"
                                                 target="_blank" class="btn btn-warning btn-xs">View</a>

                                             <form method="POST" style="display: inline;"
                                                 action="{{ route('purchase-order-approvals.change-cs-status') }}"
                                                 id="pr_approval_form_{{ $list->id }}">
                                                 {{ csrf_field() }}
                                                 <input type="hidden" name="role_id" id="role_id"
                                                     value="{{ $role_id }}">
                                                 <input type="hidden" name="purchase_request_id"
                                                     id="purchase_request_id" value="{{ $list->id }}">
                                                 <input type="hidden" name="purchase_order_id" id="purchase_order_id"
                                                     value="{{ $poid }}">
                                                 <button type="submit" name="status" class="btn btn-success btn-xs"
                                                     value="approve">Approved</button>
                                             </form>

                                             <a href="javascript:void(0);"
                                                 onclick="return cancelPo(this , '{{ $list->id }}' , '{{ $poid }}' )"
                                                 class="btn btn-danger btn-xs">Cancel</a>

                                         </td>
                                     </tr>
                                 @endforeach
                             @endforeach


                         </tbody>
                     </table>
                 </div>
             </div>



             <!-------------material issue request -------------------------->

             <div class="col-sm-12">
                 <div class="white-box">
                     <h3 class="box-title" style="margin-bottom: 3rem;">Material Issue requests For Approval</h3>

                     @if (Session::has('success-mir'))
                         <div id="successMessage" class="alert alert-success" role="alert">
                             {{ Session::get('success-mir') }}
                         </div>
                     @endif




                     <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table"
                         role="grid" aria-describedby="myTable_info">
                         <thead>
                             <tr role="row">

                                 <th class="sorting_asc" tabindex="0" aria-controls="myTable" rowspan="1"
                                     colspan="1" aria-sort="ascending"
                                     aria-label="Name: activate to sort column descending" style="width: 50px;">MIR #</th>


                                 <th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1"
                                     colspan="1" aria-label="Position: activate to sort column ascending"
                                     style="width: 100px;">Department</th>

                                 <th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1"
                                     colspan="1" aria-label="Office: activate to sort column ascending"
                                     style="width: 100px;">Request By</th>

                                 <th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1"
                                     colspan="1" aria-label="Office: activate to sort column ascending"
                                     style="width: 100px;">Request date</th>

                                 <th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1"
                                     colspan="1" aria-label="Office: activate to sort column ascending"
                                     style="width: 50px;">Release Status</th>

                                 <th class="sorting" tabindex="0" aria-controls="myTable" rowspan="1"
                                     colspan="1" aria-label="Office: activate to sort column ascending"
                                     style="width: 100px;">Action</th>

                             </tr>
                         </thead>
                         <tbody>
                             @if ($material_issue_requests->count() > 0)
                                 @foreach ($material_issue_requests as $list)
                                     @if ($approvalCount[$list->id] > 0)
                                         <tr class="active ">

                                             <td class="">MIR-{{ $list->id }}</td>




                                             <td>{{ $list->department ? $list->department->department_name : '' }}</td>
                                             <td>{{ $list->request_person_name }}</td>
                                             <td>{{ date('d-F-Y', strtotime($list->request_date)) }}</td>
                                             <td>
                                                 {{ ucfirst($list->status) }}
                                             </td>
                                             <td>

                                                 <a data-toggle="tooltip" data-placement="top" title="View"
                                                     style="margin-left: 1rem; color: #e8b600" href="javascript:void(0);"
                                                     onclick="return showItems(this , '{{ $list->id }}')">
                                                     <i class="fa fa-eye" aria-hidden="true"></i>
                                                 </a>


                                                 <a data-toggle="tooltip" data-placement="top" title="Approve"
                                                     style="color:green;margin-left: 1rem;"
                                                     href="{{ route('material.issue.request.approve', [$list->id, 'user' => Auth::user()->role->role_id]) }}">
                                                     <i class="fa fa-check" aria-hidden="true"></i>
                                                 </a>

                                                 <a data-toggle="tooltip" data-placement="top" title="Cancel"
                                                     style="color:red;margin-left: 1rem;"
                                                     onclick="return validate_for_cancel_mir();"
                                                     href="{{ route('material.issue.request.cancel', [$list->id, 'user' => Auth::user()->role->role_id]) }}">
                                                     <i class="fa fa-times" aria-hidden="true"></i>
                                                 </a>



                                                 @if ($list->status == 'pending')
                                                     <a data-toggle="tooltip" data-placement="top" title="Remove"
                                                         style="color:red;margin-left: 1rem;"
                                                         onclick="return validate_mir();"
                                                         href="{{ route('mir.delete', [$list->id]) }}"><i
                                                             class="fa fa-trash-o" aria-hidden="true"></i></a>
                                                 @endif

                                             </td>
                                         </tr>
                                     @endif
                                 @endforeach
                             @endif

                         </tbody>
                     </table>

                 </div>
             </div>



             <div class="col-md-12">

                 <div class="white-box">
                     <div class="row">

                         <div class="col-md-6">
                             <h3 class="box-title" style="margin-bottom: 3rem;">Latest Purchase Requests</h3>


                             <table id="myTable"
                                 class="table table-striped table-bordered dataTable color-table primary-table"
                                 role="grid" aria-describedby="myTable_info">
                                 <thead>
                                     <tr role="row">
                                         <th style="color:black;" class="sorting_asc" tabindex="0"
                                             aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending"
                                             aria-label="Name: activate to sort column descending" style="width: 10px;">
                                             Id#</th>


                                         <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable"
                                             rowspan="1" colspan="1"
                                             aria-label="Office: activate to sort column ascending" style="width: 203px;">
                                             Department</th>


                                         <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable"
                                             rowspan="1" colspan="1"
                                             aria-label="Office: activate to sort column ascending" style="width: 100px;">
                                             Created By</th>


                                         <th style="color:black;" class="sorting" tabindex="0" aria-controls="myTable"
                                             rowspan="1" colspan="1"
                                             aria-label="Office: activate to sort column ascending" style="width: 150px;">
                                             Current Status</th>

                                     </tr>
                                 </thead>
                                 <tbody>

                                     @if ($data['purchase_request_latest']->count() > 0)
                                         @foreach ($data['purchase_request_latest'] as $list)
                                             <tr role="row" class="odd">

                                                 <td><a href="{{ route('purchase-requests.view', [$list->id]) }}"
                                                         target="_blank"> PR-{{ $list->id }} </a></td>

                                                 <td>{{ \App\Department::withTrashed()->find($list->department_id)->department_name }}
                                                 </td>

                                                 <td>{{ $list->user->name }} </td>


                                                 <td>
                                                     @if ($list->status == 0)
                                                         <span style="color:#eab800;">Pending</span>
                                                     @elseif($list->status == 1)
                                                         <span style="color:#ffbd02;">Approvals In Progress</span>
                                                     @elseif($list->status == 2)
                                                         <span style="color:red;">Rejected</span>
                                                     @elseif($list->status == 3)
                                                         <span style="color:#0d6efd;">RFQ</span>
                                                     @elseif($list->status == 4)
                                                         <span style="color:#0d6efd;"><a target="_blank"
                                                                 href="{{ route('request-for-quotations.view', [$list->id]) }}">RFQ
                                                                 SEND</a></span>
                                                     @elseif($list->status == 5)
                                                         <span style="color:#0d6efd;"><a target="_blank"
                                                                 href="{{ route('comparative-statements.view', [$list->id]) }}">CS
                                                                 Received</a></span>
                                                     @elseif($list->status == 6)
                                                         <span style="color:#0d6efd;"><a target="_blank"
                                                                 href="{{ route('purchase-orders.view', [$list->id]) }}">PO
                                                                 Sent</a></span>
                                                     @elseif($list->status == 7)
                                                         @php
                                                             $getPrStatus = \App\PurchaseRequest::getPrStatus($list->id);
                                                         @endphp


                                                         @if ($getPrStatus['pending_po'] > 0)
                                                             <span style="color:#0d6efd;"><a style="font-size: 12px;"
                                                                     target="_blank"
                                                                     href="{{ route('purchase-orders.view', [$list->id]) }}">PO
                                                                     PENDING</a> <span
                                                                     style="padding: 0px 5px 0px 5px;border-radius: 50%;color: white;position: relative;bottom: 15px;background: red;">{{ $getPrStatus['pending_po'] }}</span></span>
                                                         @elseif($getPrStatus['pending_recipt'] > 0)
                                                             <span style="color:#0d6efd;"><a style="font-size: 12px;"
                                                                     target="_blank"
                                                                     href="{{ route('purchase-order-receipts.view', [$list->id]) }}">RECEIPT
                                                                     PENDING</a><span
                                                                     style="padding: 0px 5px 0px 5px;border-radius: 50%;color: white;position: relative;bottom: 15px;background: red;">{{ $getPrStatus['pending_recipt'] }}</span></span>
                                                         @elseif($getPrStatus['total_rfq'] > $getPrStatus['total_cs'])
                                                             <span style="color:#0d6efd;font-size: 12px;"><a
                                                                     target="_blank"
                                                                     href="{{ route('request-for-quotations.view', [$list->id]) }}">CS
                                                                     PENDING</a><span
                                                                     style="padding: 0px 5px 0px 5px;border-radius: 50%;color: white;position: relative;bottom: 15px;background: red;">{{ $getPrStatus['total_rfq'] - $getPrStatus['total_cs'] }}</span></span>
                                                         @else
                                                             <span style="color:#0ef30e;">Complete</span>
                                                         @endif
                                                     @endif
                                                 </td>

                                             </tr>
                                         @endforeach
                                     @endif


                                 </tbody>
                             </table>


                         </div>

                         <div class="col-md-6">

                             <h3 class="box-title" style="margin-bottom: 3rem;">Latest Purchase Orders</h3>

                             <table id="myTable"
                                 class="table table-striped table-bordered dataTable color-table primary-table"
                                 role="grid" aria-describedby="myTable_info">

                                 <thead>
                                     <tr role="row">

                                         <th style="color:black;" class="sorting_asc" tabindex="0"
                                             aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending"
                                             aria-label="Name: activate to sort column descending" style="width: 80px;">
                                             ID#</th>

                                         <th style="color:black;" class="sorting_asc" tabindex="0"
                                             aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending"
                                             aria-label="Name: activate to sort column descending" style="width: 100px;">
                                             Vendor</th>



                                         <th style="color:black;" class="sorting_asc" tabindex="0"
                                             aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending"
                                             aria-label="Name: activate to sort column descending" style="width: 20px;">
                                             Total Item</th>


                                         <th style="color:black;" class="sorting_asc" tabindex="0"
                                             aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending"
                                             aria-label="Name: activate to sort column descending" style="width: 110px;">
                                             Status</th>



                                         <th style="color:black;" class="sorting_asc" tabindex="0"
                                             aria-controls="myTable" rowspan="1" colspan="1" aria-sort="ascending"
                                             aria-label="Name: activate to sort column descending" style="width: 100px;">
                                             Action</th>

                                     </tr>

                                 </thead>
                                 <tbody>


                                     @foreach ($data['total_purchase_orders'] as $po)
                                         @php
                                             $vendor = \App\PurchaseRequestVendor::find($po->vendor_id);
                                         @endphp

                                         <tr role="row" class="odd">

                                             <td> <a href="{{ url('purchase-orders/detail?vendor=' . Crypt::encryptString($vendor->id) . '&purchase_request=' . Crypt::encryptString($po->purchase_request_id) . '') }}"
                                                     target="_blank"> PO-{{ $po->id }} </a></td>

                                             <td><a
                                                     href="{{ route('vendor.view', [$vendor->id]) }}">{{ ucfirst($vendor->name) }}</a>
                                             </td>

                                             <td>
                                                 [
                                                 {{ \App\PurchaseOrder::getPurchaseOrderTotalItems($po->id, $po->purchase_request_id) }}
                                                 ]
                                             </td>


                                             <td>
                                                 @if ($po->status == 1)
                                                     <div
                                                         style="background: #0283cc;color: white; padding: 5px;font-size: 13px;border-radius: 20px;text-align: center;">
                                                         {{ 'PO SENT' }}
                                                     </div>
                                                 @elseif ($po->status == 2)
                                                     <div
                                                         style="background: #03c500;color: white; padding: 5px;font-size: 13px;border-radius: 20px;text-align: center;">
                                                         {{ 'PO RECEIVED' }}
                                                     </div>
                                                 @elseif($po->status == 3)
                                                     <div
                                                         style="background: #f5cb00;color: white; padding: 5px;font-size: 13px;border-radius: 20px;text-align: center;">

                                                         {{ 'PARTIALLY RECEIVED' }}

                                                     </div>
                                                 @endif
                                             </td>

                                             <td>


                                                 @if ($po->status == 1)
                                                     <a href="javascript:void(0);"
                                                         onclick="return cancelPo(this , '{{ $po->purchase_request_id }}' , '{{ $po->id }}' )"
                                                         class="btn btn-danger btn-xs">Cancel</a>
                                                 @else
                                                     <a href="{{ url('purchase-orders/detail?vendor=' . Crypt::encryptString($vendor->id) . '&purchase_request=' . Crypt::encryptString($po->purchase_request_id) . '') }}"
                                                         class="btn btn-success btn-xs" target="_blank">View</a>
                                                 @endif
                                             </td>

                                         </tr>
                                     @endforeach

                                 </tbody>
                             </table>


                         </div>
                     </div>
                 </div>
             </div>

         </div>




         <!-- Modal -->
         <div class="modal fade" id="remark_modal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
             <div class="modal-dialog" role="document">
                 <div class="modal-content">
                     <div class="modal-header">
                         <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                                 aria-hidden="true">&times;</span></button>
                         <h4 class="modal-title" id="myModalLabel">Remarks</h4>
                     </div>
                     <div class="modal-body">
                         <label>Why You cancel this Purchase Request?</label>
                         <textarea rows="5" class="form-control" id="pr_remarks"></textarea>
                         <input type="hidden" id="pr_id_for_remarks">
                     </div>
                     <div class="modal-footer">
                         <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                         <button type="button" onclick="return updateRemark(this)"
                             class="btn btn-primary">Confirm</button>
                     </div>
                 </div>
             </div>
         </div>


         <!-- Modal -->
         <div class="modal fade" id="mirModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
             <div class="modal-dialog">
                 <div class="modal-content">
                     <div class="modal-header">
                         <h5 class="modal-title" id="exampleModalLabel">MIR Items</h5>
                         <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                             <span aria-hidden="true">&times;</span>
                         </button>
                     </div>
                     <div class="modal-body">
                         <table class="table table-striped">
                             <thead>
                                 <tr>

                                     <th>Item</th>
                                     <th>Total Request</th>
                                     <th>Status</th>
                                 </tr>
                             </thead>
                             <tbody id="mir_item">

                             </tbody>
                         </table>
                         <div>
                             <strong>Note:</strong>
                             <span id="mir_notes">
                                 <!-----Desccription gose from her------------->
                             </span>
                         </div>
                     </div>
                     <div class="modal-footer">
                         <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>

                     </div>
                 </div>
             </div>
         </div>




         <!-- Modal -->
         <div class="modal fade" id="po_remark_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
             aria-hidden="true">
             <div class="modal-dialog" role="document">
                 <div class="modal-content">
                     <div class="modal-header">
                         <h5 class="modal-title" id="exampleModalLabel">Remarks</h5>
                         <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                             <span aria-hidden="true">&times;</span>
                         </button>
                     </div>
                     <div class="modal-body">
                         <label>Why You cancel this Purchase order?</label>
                         <form method="GET" action="{{ route('purchase-orders.cancel') }}">
                             <textarea rows="5" class="form-control" name="po_remarks" id="po_remarks"></textarea>
                             <input type="hidden" id="r_pr_id" name="pr_id">
                             <input type="hidden" id="r_po_id" name="po_id">
                     </div>
                     <div class="modal-footer">
                         <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                         <button type="submit" class="btn btn-primary">Confirm</button>
                         </form>
                     </div>
                 </div>
             </div>
         </div>


     @stop


     @section('js')
         <script src="{{ asset('pusher/pusher.min.js') }}"></script>
         <script type="text/javascript">
             // Enable pusher logging - don't include this in production
             Pusher.logToConsole = false;
             var pusher = new Pusher('{{ env('PUSHER_APP_KEY') }}', {
                 cluster: '{{ env('PUSHER_APP_CLUSTER') }}'
             });
             var channel = pusher.subscribe('approval-channel');
             channel.bind('{{ $role_id }}', function(data) {
                 getPrData()
                 getPoData();
                 playSound("{{ url('bell/bell.mp3') }}");
             });


             function showItems(self, id) {
                 $.ajaxSetup({
                     headers: {
                         'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                     }
                 });
                 $.ajax({
                     url: "{{ route('mir.get-item') }}",
                     method: 'POST',
                     dataType: 'json',
                     data: {
                         id: id
                     },
                     success: function(data) {

                         if (data.response == 'yes') {
                             $table_data_rows = '';
                             $.each(data.output, function(k, v) {
                                 $_status = '';

                                 if (v.status == 'Release') {
                                     $_status =
                                         '<span style="padding: 0.5rem;background: #00f500;color: white;font-weight: bold;border-radius: 15px;">' +
                                         v.status + '</span>';
                                 }

                                 if (v.status == 'Pending') {
                                     $_status =
                                         '<span style="padding: 0.5rem;background: #f50000;color: white;font-weight: bold;border-radius: 15px;">' +
                                         v.status + '</span>';
                                 }

                                 $table_data_rows += '<tr> <td>' + v.item_name + '</td>  <td>' + v
                                     .request_quntity + '</td> <td>' + $_status + '</td> </tr>';
                             });

                             $('#mir_notes').html(data.note);
                             $('#mir_item').html($table_data_rows);

                             $('#mirModal').modal('show');
                         }

                     }
                 })


                 return false;
             }



             function updateRemark(self) {
                 var message = $.trim($("#pr_remarks").val());


                 if (message.length == 0) {

                     alert('Please Add Reason For Cancellation.')
                     return false;
                 }

                 var unique_id = $('#pr_id_for_remarks').val()
                 $('#' + unique_id + 'remarks').html(message);
                 $('#' + unique_id).submit();
                 return false;
             }

             function addRemarks(self, pr_id) {
                 $('#pr_id_for_remarks').val(pr_id)
                 $('#remark_modal').modal('show');

                 return false;
             }

             function cancelPo(self, pr_id, po_id) {
                 $('#r_pr_id').val(pr_id)
                 $('#r_po_id').val(po_id)

                 $('#po_remark_modal').modal('show');
                 return false;
             }


             function getPoData() {
                 var role_id = '{{ $role_id }}';
                 $.ajaxSetup({
                     headers: {
                         'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                     }
                 });
                 $.ajax({
                     url: "{{ route('purchase-orders.get-latest-po-for-approval') }}",
                     method: 'POST',
                     dataType: 'json',
                     data: {
                         role_id: role_id
                     },
                     success: function(data) {

                         if (data.total > 0) {
                             var output = '';

                             $.each(data.response, function(key, value) {
                                 output += '<tr>';
                                 output += '<td>PR-' + value.id + '</td>';
                                 output += '<td>PO-' + value.po + '</td>';
                                 output += '<td>' + value.department + '</td>';
                                 output += '<td>' + value.created_by + '</td>';
                                 output += '<td>' + value.total_amount + '</td>';
                                 output += '<td>' + value.advance + '</td>';
                                 output += '<td>' + value.action + '</td>';
                                 output += '</tr> ';
                             });

                         } else {
                             var output = '<tr><td><center>No data found</center></td></tr>';
                         }

                         $('#po-appro-tbl-body').html(output)

                     }
                 })


                 return false;
             }



             function getPrData() {
                 var role_id = '{{ $role_id }}';
                 $.ajaxSetup({
                     headers: {
                         'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                     }
                 });
                 $.ajax({
                     url: "{{ route('purchase-requests.get-latest-pr-for-approval') }}",
                     method: 'POST',
                     dataType: 'json',
                     data: {
                         role_id: role_id
                     },
                     success: function(data) {

                         if (data.total > 0) {
                             var output = '';


                             $.each(data.response, function(key, value) {
                                 output += '<tr>';
                                 output += '<td>PR-' + value.id + '</td>';
                                 output += '<td>' + value.department + '</td>';
                                 output += '<td>' + value.created_by + '</td>';
                                 output += '<td>' + value.action + '</td>';
                                 output += '</tr> ';
                             });


                         } else {
                             var output = '<tr><td><center>No data found</center></td></tr>';
                         }

                         $('#pr-appro-tbl-body').html(output)

                     }
                 })


                 return false;
             }

             function playSound(soundFile) {
                 var audioElement = document.createElement('audio');
                 audioElement.setAttribute('src', soundFile);
                 audioElement.play();
             }

             function validate_mir() {
                 if (!confirm('Are you sure you want to delete?')) {
                     return false;
                 }
             }


             function validate_for_cancel_mir() {
                 if (!confirm('Are you sure you want to cancel?')) {
                     return false;
                 }
             }

             function validate(self) {
                 $(self).prop('disabled', true);
                 if (confirm('Are you sure about cancel this PO?')) {
                     return true;
                 }
                 return false;

             }
         </script>

     @Stop
