@extends('layouts.app')

@section('title')
Add Work Order
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Work Order</li>
      </ol>
@stop

@section('css')
 <link href="{{asset('css/procurement_css.css')}}" rel="stylesheet">
@stop

@section('content')
  <div class="container-fluid">
  <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title m-b-0">Add New Work Order</h3>
                            <p class="text-muted m-b-30 font-13">  </p>
                            <form class="form-horizontal" method="POST" onsubmit="return addWorkOrder(this)" >
                            	 {{csrf_field()}}
                                <div class="form-group" style="margin-bottom: 25px;">
                                    <!-- <label class="col-md-12">Default Text <span class="help"> e.g. "George deo"</span></label> -->


                                <div class="col-md-6">
                                    <label>Name</label>
                                    <input type="text" class="form-control" placeholder ="Type Task Name ...." value="{{old('name')}}" id="name" name="name">
                                    @if ($errors->has('name'))
                                    <span >
                                    <strong class="error_messages" >{{ $errors->first('name') }}</strong>
                                    </span>
                                    @endif
                                </div>


                                    <div class="col-md-6" style="" id="task_list">
                                        <label>Task List</label>

                                        <div class="row">
                                        <div class="col-md-12">


                                       <select class="form-control chosen-select" name="category" id="sub_task">
                                        <option value="0">None</option>
                                        @if($task->count() > 0  )

                                        @foreach($task as $parent_list)
                                         
                                        <optgroup label="{{$parent_list->text}}">

                                        
                                        <option value="{{ $parent_list->id }}">
                                            {{ $parent_list->text }} 
                                         @if(count($parent_list->childs) )

                                            @include('procurement.work-order.child-layout.manage-child',['childs' => $parent_list->childs])
                                         @endif
                                        </option> 
                                       
 
                                        </optgroup>
                                        
                                        @endforeach
                                    
                                        @endif
                                        </select>

                                               
                      

                                        </div>

                                         
                                        </div>
                                    </div>

                                   <div id="form_fileds" style="">
                                    <div class="col-md-12" style="margin-top:1rem;">

                                    <center>
                                        <h3 class="us-nav">
                                        Task Details

                                        <div onclick="return showFullForm(this);" style="display: inline;float: right;cursor: pointer;"><i  class="fa fa-plus" aria-hidden="true"></i></div>
                                         </h3>
                                    </center>

                                
                                    </div>

                                    <div id="main_form" style="display:none;">

                                        <div class="col-md-4">
                                        <label>Start date</label>
                                        <input type="date"  id="start_date" class="form-control" name="">
                                        </div>

                                        <div class="col-md-4">
                                        <label>Duration</label>
                                        <input type="text" id="duration"  placeholder="Duration in days" class="form-control" name="">
                                        </div>

                                        <div class="col-md-4">
                                        <label>Progress <span id="txt_prog"></span>%</label>
                                        <input type="hidden" value="0" maxlength="3" id="progress" >

                                        <div class="slidecontainer" style="margin-top: 1rem;">
                                        <input type="range" min="0" max="100" value="0" id="myRange">
                                        </div>

                                        </div>

                                        <div class="col-md-6" style="margin-top:1rem;">
                                        <label>Task Type</label>
                                        <select class="form-control" id="task_type">
                                            <option value="planed">Planed</option>
                                             <option value="unplaned">Unplaned</option>
                                        </select>
                                        </div>


                                         <div class="col-md-6" style="margin-top:1rem;">
                                        <label>Task Priorty</label>
                                        <select class="form-control" id="priorty">
                                            <option value="high">High</option>
                                            <option value="normal">Normal</option>
                                            <option value="low">Low</option>
                                        </select>
                                        </div>

                                        <div class="col-md-6" style="margin-top:1rem;">
                                        <label>Assign To</label>
                                        <input type="text" id="assign_to" placeholder="Assign To" class="form-control" name="">
                                        </div>


                                        <div class="col-md-6" style="margin-top:1rem;">
                                        <label>Created By</label>
                                        <input type="text" readonly="readonly" value="{{Auth::user()->name}}" id="created_by" placeholder="Created By" class="form-control" name="">
                                        </div>

                                        <div class="col-md-12" style="margin-top:1rem;">
                                        <label>Description</label>
                                        <textarea class="form-control" rows="5" placeholder="type here..." id="description" style="width: 600px; height: 110px;"></textarea>
                                        </div>

                                        <div class="col-md-12" style="margin-top:1rem;">
                                            <center>
                                                <h3 class="us-nav">
                                                   Bill Of Quantity
                                                </h3>
                                            </center>
                                        </div>

                                        
                                        <div class="col-md-12">
                                            
                                <div class="form-group parent_div" >

                                    <div class="alert alert-danger" style="display: none;" id="noItemFound">
                                    <strong style="color: white;">Exception!</strong> No more items found.
                                    </div>

                                    <div class="col-md-5">
                                    <label>Item</label>
                                    <select class="form-control chosen-select item_list" onchange="return getItemLatestPrice(this)"  name="items[]">
                                    @if($items->count() > 0  )
                                    <option value="0">Select Item</option>

                                    @foreach($items as $item_lists)
                                    <option  value="{{ $item_lists->id }}">{{ $item_lists->item_name }} - {{ $item_lists->unit }}</option> 
                                    @endforeach
                                    @endif
                                    </select>

                                    </div>
                                 

                                    <div class="col-md-6">

                                    <div class="row">
                                    
                                    <div class="col-md-6">
                                        <label>Quantity</label>
                                    <input type="number" maxlength="6" class="form-control item_qty" placeholder ="Quatity..." value="" name="quantity[]">
                                   
                                    </div>

                                    <div class="col-md-6">
                                       <label>Rate Per Unit</label>
                                    <input type="number" step="any" maxlength="10" class="form-control price" placeholder ="Rate  Per Unit ..." value=""   name="price[]">
                                  
                                    </div>
                                    </div>

                                    </div>



                                    <div class="col-md-1" style="margin-top: 2.5rem;">
                                     <button type="button" style="width: 100%;" class="btn btn-success waves-effect waves-light m-r-10 " onclick="return add_new_item(this)"><i class="fa fa-plus" aria-hidden="true"></i></button>

                                    </div>

                                    </div>

                                    <div id="main_item_section">
                                        <!------Add new item List goes from here---->      
                                    </div>

                                        </div>
                               

                                        
                                        </div>

                                        


                                        <div class="col-md-12" style="margin-top: 3rem;">

                                        <div style="display:none;" id="error_message" class="alert alert-danger" role="alert"></div>

                                        <div class="alert alert-success" style="display:none;" role="alert" id="success_message"></div>

                                        <button type="submit" class="btn btn-success waves-effect waves-light m-r-10 sub_btn" id="sub_btn">Submit</button>
                                        </div>
                                 

                                   </div>

                                    </div>

                                </div>
                               
                               
    	
                            </form>
                        </div>
                    </div>
                </div>

      </div>
      <input type="hidden" value="{{$items->count()}}"  id="total_item">


      <!-- Modal -->
<div class="modal fade" id="alert-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Warning</h5>
      </div>
      <div class="modal-body" id="modal-body">
      <center><h3>Loading...</h3></center>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">No! Cancel</button>
        <button type="button" class="btn btn-primary" onclick="return proceedWorkOrder(this)">Yes! Proceed</button>
      </div>
    </div>
  </div>
</div>

@stop 

@section('js')

<script>
let validate_start_date = false;


var slider = document.getElementById("myRange");
var outputs = document.getElementById("progress");
var txt_prog = document.getElementById("txt_prog");

outputs.value = slider.value;
txt_prog.innerHTML = slider.value

slider.oninput = function() {
  outputs.value = this.value;
  txt_prog.innerHTML = this.value;
}
</script>

<script type="text/javascript">

let order_status = false;

function add_new_item(self)
{
    var total_item = parseInt($('#total_item').val());

    var remaining = total_item - 1;

    if(remaining > 0)
 {
  $('#total_item').val(remaining)
  $.ajax({
   url:"{{ route('get-dynamic-items.fetch') }}",
   method:'GET',
   dataType:'json',
   success:function(data)
   {
    if(data.response == 'yes')
    {
    
    var output = '';

    output += ' <div class="form-group parent parent_div" >  <div class="col-md-5">   <select class="form-control chosen-select item_list" onchange="return getItemLatestPrice(this)" id="chosen-select'+data.id+'" name="items[]">';
    output += '<option value="0">Select Item</option>';
    $.each(data.items, function(key, value) {
    output += '<option value="'+value.id+'">'+value.item_name+' - '+value.unit+'</option>';
    });

     output += '</option> </select> </div> <div class="col-md-6"><div class="row"><div class="col-md-6"><input type="number" maxlength="6" class="form-control item_qty" placeholder ="Quantity..." value="" name="quantity[]"></div><div class="col-md-6"><input type="number" step="any" maxlength="6" class="form-control price" placeholder ="Rate Per Unit..." value="" name="price[]"></div></div></div>  <div class="col-md-1"><button type="button" style="width: 100%;" class="btn btn-danger waves-effect waves-light m-r-10 " onclick="return remove_item(this)"><i class="fa fa-trash-o" aria-hidden="true"></i></button></div> </div>';

      $('#main_item_section').append(output);
     $('#chosen-select'+data.id).chosen-select();

    }
    
   }
  })

}
else
{
    $('#noItemFound').show('slow')
    setTimeout(function(){ $('#noItemFound').hide('slow') }, 3000);
}

return false;
}


function remove_item(self)
{
    $(self).closest('.parent').remove()
    var total_item = parseInt($('#total_item').val());
    var remaining = total_item + 1;
    $('#total_item').val(remaining)
    return false;
}


function showFullForm(self) 
{

    if($('#main_form').is(':visible'))
{
    $('#main_form').hide('slow');
    order_status = false;
}
    if($('#main_form').is(':hidden'))
{
    $('#main_form').show('slow');
    order_status = true;
}
    
    return false;
}


function proceedWorkOrder(self) 
{
   validate_start_date = true;
   $('#alert-modal').modal('hide')
   $('#sub_btn').click();

    return false;
}


function addWorkOrder(self) {
// $(self).find('.sub_btn').html('Procesing...')
// $(self).find('.sub_btn').prop('disabled' , true)

var name = $('#name').val();
var start_date = $('#start_date').val();
var duration = $('#duration').val();
var progress = $('#progress').val();
var task_type = $('#task_type').val();
var priorty = $('#priorty').val();
var assign_to = $('#assign_to').val();
var created_by = $('#created_by').val();
var description = $('#description').val();
var parent = $('#sub_task').val();

var items = [];

$('.item_list').each(function()
    {
        if ($(this).val() != "")
         {
             items.push({'item_id':$(this).val(),'quantity': $(this).closest('.parent_div').find('.item_qty').val() , 'price' : $(this).closest('.parent_div').find('.price').val()});
         }
   
    });


$.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });
        $.ajax({
        url:"{{ route('store.work-order') }}",
        method:'POST',
        dataType:'json',
        data: {name:name , start_date: start_date , duration:duration , progress:progress , parent:parent,task_type:task_type,priorty:priorty,assign_to:assign_to,created_by:created_by , description:description,order_status:order_status, items:items,validate_start_date:validate_start_date},
        success:function(data)
        {
            if (data.response == 'inserted') 
            {
                $('#success_message').html(data.message)
                $('#success_message').show()
                setTimeout(function(){ location.reload(true) }, 3000);
            }
            else if(data.response == 'error')
            {
                var output = '';
                output += '<ul>';
                if (data.errors.text) 
                {
                     output += '<li>'+data.errors.text+'</li>';
                }

                 if (data.errors.name) 
                {
                     output += '<li>'+data.errors.name+'</li>';
                }
                
                 if (data.errors.start_date)
                 {
                    output += '<li>'+data.errors.start_date+'</li>';
                 } 
                  if (data.errors.duration) 
                 {
                    output += '<li>'+data.errors.duration+'</li>';
                 }
                
                 if (data.errors.progress) 
                {
                    output += '<li>'+data.errors.progress+'</li>';
                }
                
                 if (data.errors.assign_to) 
                {
                    output += '<li>'+data.errors.assign_to+'</li>';
                }
                
                if (data.errors.created_by) 
                {
                    output += '<li>'+data.errors.created_by+'</li>';
                }
                
                if (data.errors.priorty) 
                {
                    output += '<li>'+data.errors.priorty+'</li>';
                }
                
                if (data.errors.parent) 
                {
                    output += '<li>'+data.errors.parent+'</li>';
                }
                
                if (data.errors.task_type) 
                {
                    output += '<li>'+data.errors.task_type+'</li>';
                }
                

                 output += '</ul> ';
                 $('#error_message').html(output)
                 $('#error_message').show()
                 $(self).find('.sub_btn').html('Submit')
                 $(self).find('.sub_btn').prop('disabled' , false)

            }
            else if(data.response == 'start_date_alert')
            {
                $(self).find('.sub_btn').html('Submit')
                $(self).find('.sub_btn').prop('disabled' , false)
                $('#modal-body').html(data.errors)
                $('#alert-modal').modal({backdrop: "static"})
            }
            else if(data.response == 'custom_error')
            {
               var output = '';
                output += '<ul>';

                if (data.errors) 
                {
                     output += '<li>'+data.errors+'</li>';
                }

                output += '</ul> ';

                $('#error_message').html(output)
                $('#error_message').show()
                $(self).find('.sub_btn').html('Submit')
                $(self).find('.sub_btn').prop('disabled' , false)
            }
            else
            {
              alert('Something Went Wrong! refresh.')
              // location.reload(true)
             }

            setTimeout(function(){ $('#error_message').hide('slow') }, 6000);

          }
        })
            

 return false;
}
    function hideTaskCategory(self) {
        $('#task_list').hide();
        $('#taskCategory').show()
        $('#form_fileds').hide();
    return false;
    }

    function taskCategory(self) {
    if ($(self).val() == 'sub-task')
     {
        $('#task_list').show();
        $('#taskCategory').hide()
        $('#form_fileds').show();
     }
     else if($(self).val() == 'task')
     {
        $('#task_list').hide();
        $('#taskCategory').show()
        $('#form_fileds').show();
     }
     else
     {
          $('#task_list').hide();
        $('#taskCategory').show()
        $('#form_fileds').hide();
     }

    return false;
    }
	
	$(".dropdown-toggle").click(function(){
    // get the scollTop (distance scrolled from top)
    var scrollTop = $(window).scrollTop();
    // get the top offset of the dropdown (distance from top of the page)
    var topOffset = $(".dropdown").offset().top;
    // calculate the dropdown offset relative to window position
    var relativeOffset = topOffset-scrollTop;
    // get the window height
    var windowHeight = $(window).height();
    
    // if the relative offset is greater than half the window height,
    // reverse the dropdown.
    if(relativeOffset > windowHeight/2){
        $(".dropdown-menu").addClass("reverse");
    }
    else{
        $(".dropdown-menu").removeClass("reverse");
    }
});
</script>
@stop