@extends('layouts.app')

@section('title')
    All Work Orders
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Work Order list</li>
    </ol>
@stop
@section('css')
    <link href="{{ asset('css/procurement_css.css') }}" rel="stylesheet">
@stop
@section('content')
    <div class="container-fluid">
        <div class="row">

            <div class="col-sm-12">
                <div class="white-box">

                    @permission('work-order')
                        <h3 style="text-align: right;" class="box-title m-b-0">
                            <span style="float: left;">List Of All Work Order</span><a class="btn btn-info btn-sm"
                                href="{{ route('work-order.create') }}">Add Work Order</a>
                        </h3>
                    @endpermission
                    <div class="table-responsive">

                        @if (Session::has('success'))
                            <div id="successMessage" class="alert alert-success" role="alert">
                                {{ Session::get('success') }}
                            </div>
                        @endif


                        @if (Session::has('error'))
                            <div id="successMessage" class="alert alert-danger" role="alert">
                                {{ Session::get('error') }}
                            </div>
                        @endif


                        <table id="myTable" class="table table-striped table-bordered dataTable color-table primary-table"
                            role="grid" aria-describedby="myTable_info">
                            <thead>
                                <tr role="row">
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable"
                                        rowspan="1" colspan="1" aria-sort="ascending"
                                        aria-label="Name: activate to sort column descending" style="width: 150px;">Name
                                    </th>
                                    <th style="color: black;" class="sorting_asc" tabindex="0" aria-controls="myTable"
                                        rowspan="1" colspan="1" aria-sort="ascending"
                                        aria-label="Name: activate to sort column descending" style="width: 100px;">Priority
                                    </th>

                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable"
                                        rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending"
                                        style="width: 100px;">Type</th>

                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable"
                                        rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending"
                                        style="width: 100px;">Asignee</th>

                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable"
                                        rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending"
                                        style="width: 100px;">Created By</th>

                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable"
                                        rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending"
                                        style="width: 100px;">Total Cost</th>


                                    <th style="color: black;" class="sorting" tabindex="0" aria-controls="myTable"
                                        rowspan="1" colspan="1" aria-label="Office: activate to sort column ascending"
                                        style="width: 50px;">Action</th>

                                </tr>
                            </thead>
                            <tbody>



                                @if ($task->count() > 0)
                                    @php
                                        $total_amount = 0;
                                    @endphp
                                    @foreach ($task as $key => $parent_list)
                                        <tr>
                                            <td>
                                                {{ $parent_list->text }}
                                            </td>

                                            <td class="<?php if ($parent_list->task_priority == 'high') {
                                                echo 'high_priorty';
                                            } elseif ($parent_list->task_priority == 'low') {
                                                echo 'low_priorty';
                                            } else {
                                                echo 'normal_priorty';
                                            } ?>">
                                                {{ Ucfirst($parent_list->task_priority) }}
                                            </td>

                                            <td>
                                                {{ Ucfirst($parent_list->task_type) }}
                                            </td>

                                            <td>
                                                <?= $parent_list->node_name == 'leaf' ? Ucfirst($parent_list->assign_to) : '-' ?>
                                            </td>

                                            <td>
                                                <?= $parent_list->node_name == 'leaf' ? Ucfirst($parent_list->created_by) : '-' ?>
                                            </td>

                                            <td>
                                                {{ number_format($parent_list->total_cost, 2) }}
                                            </td>

                                            <td>
                                                @if ($parent_list->node_name == 'leaf')
                                                <a  href="#" onclick="return showBoq(this)" data-bs-toggle="tooltip"
                                                  data-bs-placement="top" title="BOQ">
                                                  <button class="btn btn-link btn-s" tyle="color: #4a5256;">
                                                    <i class="fa fa-book"
                                                            aria-hidden="true"></i>
                                                  </button>
                                                  </a>
                                                    {{-- <a href="#" style="margin-right: 1rem;color: #4a5256;"
                                                        onclick="return showBoq(this)" data-bs-toggle="tooltip"
                                                        data-bs-placement="top" title="BOQ"><i class="fa fa-book"
                                                            aria-hidden="true"></i></a> --}}



                                                            <a  href="{{ route('work-order.edit', [$parent_list->id])}}">
                                                              <button class="btn btn-link btn-s">
                                                                  <i class="fa fa-pencil-square-o" aria-hidden="true"></i>
                                                              </button>
                                                              </a>
                                                          
                                                    {{-- <a href="{{ route('work-order.edit', [$parent_list->id]) }}"
                                                        style="margin-right: 1rem;" data-bs-toggle="tooltip"
                                                        data-bs-placement="top" title="EDIT"><i
                                                            class="fa fa-pencil-square-o" aria-hidden="true"></i>
                                                    </a> --}}

                                                    <form action="{{ route('work-order.delete', [$parent_list->id]) }}"
                                                        method="post" style='display: inline;'>
                                                        @method('DELETE')
                                                        @csrf
                                                        <button class="btn btn-link btn-s" style="color:red;"
                                                            type="submit" name="action" value="delete"
                                                            data-toggle="confirmation"
                                                            data-title="Are you sure to delete?">
                                                            <i class="fa fa-trash-o" aria-hidden="true"></i>
                                                        </button>
                                                    </form>

                                                    {{-- <a  href="{{ route('work-order.delete' , [$parent_list->id]) }}"data-toggle="confirmation" data-title="Are you sure to delete?" >
                                                  <i class="fa fa-trash-o" style="color:red" aria-hidden="true"></i>
                                              </a> --}}
                                                @else
                                                    {{ '-' }}
                                                @endif
                                            </td>


                                            @if (count($parent_list->childs))
                                                @include('procurement.work-order.child-layout.manage-list-child',
                                                    ['childs' => $parent_list->childs])
                                            @endif

                                        </tr>

                                        @if ($loop->last)
                                            <tr>
                                                <td colspan="5" style="font-weight: bold;"> Subtotal : </td>
                                                <td colspan="2"> {{ number_format($parent_list->total_cost, 2) }}
                                                </td>
                                            </tr>
                                        @endif
                                    @endforeach

                                @endif


                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>


    <!-- Modal -->
    <div class="modal fade" id="boq-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="boq_header"></h5>

                </div>


                <div class="modal-body">


                    <center>
                        <h3 style="background: #4a5256;color: white;padding: 1rem;">
                            Bill Of Quantity Items
                        </h3>
                    </center>


                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th scope="col">Item</th>
                                <th scope="col">Unit</th>
                                <th scope="col">quantity</th>
                                <th scope="col">Rate Per Unit</th>
                                <th scope="col">Total Cost</th>
                                <th scope="col">Date</th>
                            </tr>
                        </thead>
                        <tbody id="boq_items">

                        </tbody>
                    </table>

                </div>
                <div style="text-align: left;" class="modal-footer">
                    <b>Total : </b> <span id="total_ammount"></span>
                    <button type="button" style="float: right;" class="btn btn-secondary"
                        onclick="return hideModal()">Close</button>

                </div>
            </div>
        </div>
    </div>

@stop

@section('js')

    <script type="text/javascript">
        $('document').ready(function() {
            $('[data-bs-toggle=tooltip]').tooltip();
        });


        function hideModal() {
            $('#boq-modal').modal('hide')
        }

        function showBoq(self, id) {
            $.ajax({
                type: 'get',
                url: "{{ route('work-order.boq.view') }}",
                data: {
                    'id': id
                },
                dataType: 'json',
                success: function(data) {
                    if (data.response == 'found') {

                        var output = '';
                        $.each(data.boq, function(key, value) {
                            output += '<tr>';
                            output += '<td >' + value.item_name + '</td>';
                            output += '<td >' + value.item_unit + '</td>';
                            output += '<td >' + value.quantity + '</td>';
                            output += '<td >' + value.rate_per_unit + '</td>';
                            output += '<td >' + value.total_cost + '</td>';
                            output += '<td >' + value.date + '</td>';
                            output += '</tr>';
                        });


                        $('#boq_header').html('<b> ' + data.task.text + ' </b>')
                        $('#boq_items').html(output)
                        $('#total_ammount').html(data.total_ammount);

                        $('#boq-modal').modal({
                            backdrop: 'static'
                        })
                    }
                }
            });

            return false;
        }
    </script>
@stop
