@extends( 'layouts.app' )

@section('title')
Add Paradigm Amount 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
       <li ><a href="{{route('account.all')}}">Paradigm Account</a></li>
        <li class="active">Add Amount</li>
      </ol>
@stop

@section('content')

<div class="container-fluid">
    <form method="post" action="{{route('account.insert')}}" class="form-horizontal" enctype="multipart/form-data">
        {{csrf_field()}}
	<div class="row">
		<div class="col-lg-12 col-sm-12 col-xs-12">
            <div class="white-box">
                <h3 class="box-title">Payment Information</h3>
                            <hr>
                 <div class="col-md-6">
                         <div class="form-group">
                           <label class="control-label col-md-4">Select Unit # <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <select name="inventory_id" id='inventory_id' class="form-control chosen-select" >
                                                                <option value="" selected="">None</option>
                                                              @foreach($inventories as $inventory)
                                                              @if(old('inventory_id') == $inventory->id)
                                                              <option selected="" value="{{$inventory->id}}">{{$inventory->unit_number}}</option>
                                                              @else
                                                               <option value="{{$inventory->id}}">{{$inventory->unit_number}}</option>
                                                              @endif
                                                              @endforeach
                                                            </select>
                                                            @if ($errors->has('inventory_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('inventory_id') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>
                            <div class="clearfix"></div>

                            <div class="col-md-6">
                         <div class="form-group">
                           <label class="control-label col-md-4">Payment Head <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <select class="form-control chosen-select" name="payment_head">
                                                                @if(old('payment_head') ==\App\ProjectAccount::booking)
                                                                <option value="{{\App\ProjectAccount::booking}}" selected="">Booking</option>
                                                                <option value='{{\App\ProjectAccount::confirmation}}'>Confirmation</option>
                                                                <option value="{{\App\ProjectAccount::installment}}">Installment</option>

                                                               <option value="{{\App\ProjectAccount::possession}}">Possession</option>
                                                               @elseif(old('payment_head') == \App\ProjectAccount::confirmation)
                                                                <option value="{{\App\ProjectAccount::booking}}" >Booking</option>
                                                                <option selected="" value='{{\App\ProjectAccount::confirmation}}'>Confirmation</option>
                                                                <option value="{{\App\ProjectAccount::installment}}">Installment</option>

                                                               <option value="{{\App\ProjectAccount::possession}}">Possession</option>
                                                               @elseif(old('payment_head') == \App\ProjectAccount::installment)
                                                                <option value="{{\App\ProjectAccount::booking}}" >Booking</option>
                                                                <option  value='{{\App\ProjectAccount::confirmation}}'>Confirmation</option>
                                                                <option selected="" value="{{\App\ProjectAccount::installment}}">Installment</option>

                                                               <option value="{{\App\ProjectAccount::possession}}">Possession</option>
                                                               @elseif(old('payment_head') == \App\ProjectAccount::possession)
                                                               <option value="{{\App\ProjectAccount::booking}}" >Booking</option>
                                                                <option  value='{{\App\ProjectAccount::confirmation}}'>Confirmation</option>
                                                                <option  value="{{\App\ProjectAccount::installment}}">Installment</option>

                                                               <option selected="" value="{{\App\ProjectAccount::possession}}">Possession</option>

                                                               @else
                                                                <option value="{{\App\ProjectAccount::booking}}" >Booking</option>
                                                                <option  value='{{\App\ProjectAccount::confirmation}}'>Confirmation</option>
                                                                <option  value="{{\App\ProjectAccount::installment}}">Installment</option>

                                                               <option  value="{{\App\ProjectAccount::possession}}">Possession</option>
                                                               @endif
                                                            </select>
                                                            @if ($errors->has('payment_head'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('payment_head') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>
                            <div class="col-md-6">
                         <div class="form-group">
                           <label class="control-label col-md-4">Payment Type <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <select class="form-control chosen-select" name='payment_type' onchange="changeFunc(this.value)">
                                                                @if(old('payment_type') == \App\ProjectAccount::pay_order)
                                                                <option value="{{\App\ProjectAccount::pay_order}}" selected="">Pay Order</option>
                                                                <option value="{{\App\ProjectAccount::adjacement}}" >Adjacement</option>

                                                                @elseif(old('payment_type') == \App\ProjectAccount::adjacement)
                                                                <option value="{{\App\ProjectAccount::pay_order}}" >Pay Order</option>
                                                                <option value="{{\App\ProjectAccount::adjacement}}" selected="">Adjacement</option>

                                                                @else
                                                                <option selected='' value="{{\App\ProjectAccount::pay_order}}" selected="">Pay Order</option>
                                                                <option value="{{\App\ProjectAccount::adjacement}}">Adjacement</option>

                                                                @endif
                                                            </select>
                                                            @if ($errors->has('payment_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('payment_type') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>
                            <!--
                            Pay Order Div
                            -->
                            <div id="pay_order">
                              <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Pay Order Title<span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                           <input type="text" name="pay_order_title" value="{{old('pay_order_title')}}" class="form-control">
                                                        @if ($errors->has('pay_order_title'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('pay_order_title') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>

                            <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Pay Order Date<span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                           <input type="date" name="pay_order_date" value="{{old('pay_order_date')}}" class="form-control">
                                                        @if ($errors->has('pay_order_date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('pay_order_date') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>

                            <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Pay Order Bank<span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <select name="pay_order_bank_id" id='pay_order_bank_id' class="form-control chosen-select" >
                                                                <option value="" selected="">None</option>
                                                              @foreach($banks as $bank)
                                                              @if(old('pay_order_bank_id') == $bank->id)
                                                              <option selected="" value="{{$bank->id}}">{{$bank->name}}</option>
                                                              @else
                                                               <option value="{{$bank->id}}">{{$bank->name}}</option>
                                                              @endif
                                                              @endforeach
                                                            </select>

                                                        @if ($errors->has('pay_order_bank_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('pay_order_bank_id') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>

                        </div>



                            @if(old('payment_type') == \App\ProjectAccount::adjacement)
                              <div class="col-md-6" id='adjacement'  style="display: block;">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Ajacement Type <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                           <select class="form-control chosen-select" name='adjacement_type'>
                                                                @if(old('adjacement_type') == \App\ProjectAccount::property)
                                                                <option value="{{\App\ProjectAccount::property}}" selected="">Property</option>
                                                                <option value="{{\App\ProjectAccount::vehicle}}" >Vehicle</option>

                                                                @elseif(old('adjacement_type') == \App\ProjectAccount::property)
                                                                <option value="{{\App\ProjectAccount::property}}" >Property</option>
                                                                <option value="{{\App\ProjectAccount::vehicle}}" selected="">Vehicle</option>

                                                                @else
                                                                <option selected='' value="{{\App\ProjectAccount::property}}" selected="">Property</option>
                                                                <option value="{{\App\ProjectAccount::vehicle}}">Vehicle</option>

                                                                @endif
                                                            </select>
                                                        @if ($errors->has('adjacement_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('adjacement_type') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>
                            @else
                              <div class="col-md-6" id='adjacement'  style="display: none;">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Adjacement Type <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                           <select class="form-control chosen-select" name='adjacement_type'>
                                                                @if(old('adjacement_type') == \App\ProjectAccount::property)
                                                                <option value="{{\App\ProjectAccount::property}}" selected="">Property</option>
                                                                <option value="{{\App\ProjectAccount::vehicle}}" >Vehicle</option>

                                                                @elseif(old('adjacement_type') == \App\ProjectAccount::property)
                                                                <option value="{{\App\ProjectAccount::property}}" >Property</option>
                                                                <option value="{{\App\ProjectAccount::vehicle}}" selected="">Vehicle</option>

                                                                @else
                                                                <option selected='' value="{{\App\ProjectAccount::property}}" selected="">Property</option>
                                                                <option value="{{\App\ProjectAccount::vehicle}}">Vehicle</option>

                                                                @endif
                                                            </select>
                                                        @if ($errors->has('adjacement_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('adjacement_type') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>
                            @endif
                            <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4"> Images</label>
                                                        <div class="col-md-8">
                                                            <input type="file" name="images[]"  class="form-control" multiple="">
                                                        @if ($errors->has('images'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('images') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>


                            <div class="clearfix"></div>
                            <div class="col-md-6">
                                                    <div class="form-group">
                                                        <label class="control-label col-md-4">Amount <span style="color: red">*</span></label>
                                                        <div class="col-md-8">
                                                            <input type="number" name="amount" value="{{old('amount')}}" class="form-control" id="exampleInputEmail1" placeholder="Enter Amount">
                                                        @if ($errors->has('amount'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('amount') }}</strong>
                                    </span>
                                @endif
                                                        </div>
                                                    </div>
                            </div>

                <div class="col-md-6">
                    <div class="form-group">
                        <label class="control-label col-md-4">Depositor Name<span style="color: red">*</span></label>
                    <div class="col-md-8">
                        <input type="text" class="form-control" name='depositor_name' value="{{old('depositor_name')}}"  placeholder="Enter Depositor Name">
                    @if ($errors->has('depositor_name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('depositor_name') }}</strong>
                                    </span>
                                @endif
                    </div>
                    </div>
              </div>
              <div class="col-md-6">
                    <div class="form-group">
                        <label class="control-label col-md-4">Detail</label>
                    <div class="col-md-8">
                        <input type="text" class="form-control" name='description' value="{{old('description')}}"  placeholder="Enter Description">
                    @if ($errors->has('description'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('description') }}</strong>
                                    </span>
                                @endif
                    </div>
                    </div>
              </div>
              <input type="hidden" name="date" value="{{\Carbon\Carbon::now()}}">
              <!-- <div class="col-md-6">
                    <div class="form-group">
                        <label class="control-label col-md-4">Date<span style="color: red">*</span></label>
                    <div class="col-md-8">
                        <input type="date" class="form-control" name='date' value="{{old('date')}}"  placeholder="Enter date">
                    @if ($errors->has('date'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('date') }}</strong>
                                    </span>
                                @endif
                    </div>
                    </div>
              </div> -->
              <div class="form-group m-b-0 pull-right">
                    <div class="col-sm-offset-3 col-sm-9">
                        <button type="submit" class="btn btn-info  waves-effect waves-light ">Save</button>
                    </div>
              </div>
            </div>
        </div>
    </div>
    </form>
</div>


@stop

@section('js')
<script>
	function changeFunc(a){
        if(a == {{\App\ProjectAccount::pay_order}})
        {
            $('#pay_order').css('display', 'block');
            $('#adjacement').css('display', 'none');
        }
        else if(a == {{\App\ProjectAccount::adjacement}})
        {
            $('#pay_order').css('display', 'none');
            $('#adjacement').css('display', 'block');
        }

    }
</script>
@stop