@extends( 'layouts.app'  )

@section('title')
Project Account Detail 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
         <li ><a href="{{route('account.all')}}">Paradigm Account</a></li>
        <li class="active">Account Detail</li>
      </ol>
@stop
@section('content')
            <div class="container-fluid">

                <!-- /row -->
                <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">Payment Information</h3>
                            <hr>
                                    <div class="table-responsive">
                                        <table class="table">
                                            <tbody>
                                                <tr>
                                                    <td>Unit No</td>
                                                    <td>{{$amount->inventory->unit_number}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Payment Head</td>
                                                    @if($amount->payment_head == \App\ProjectAccount::booking)
                                                    <td>Booking</td>
                                                    @elseif($amount->payment_head == \App\ProjectAccount::confirmation)
                                                    <td>Confirmation</td>
                                                    @elseif($amount->payment_head == \App\ProjectAccount::installment)
                                                    <td>Installment</td>
                                                    @elseif($amount->payment_head == \App\ProjectAccount::possession)
                                                    <td>Possession</td>
                                                    @endif
                                                </tr>

                                               <tr>
                                                    <td>Payment Type</td>
                                                    @if($amount->payment_type == \App\ProjectAccount::pay_order)
                                                    <td>Pay Order</td>
                                                    @else
                                                    <td>Adjacement</td>
                                                    @endif
                                                </tr>
                                                @if($amount->payment_type == \App\ProjectAccount::pay_order)
                                                <tr><td>Pay Order Title</td>
                                                    <td>{{$amount->pay_order_title}}</td>
                                                </tr>
                                                <tr><td>Pay Order Bank</td>
                                                    <td>{{$amount->bank->name}}</td>
                                                </tr>
                                                <tr><td>Pay Order Date</td>
                                                    <td>{{date('d-m-Y', strtotime($amount->pay_order_date)) }}</td>
                                                </tr>
                                                @endif
                                                @if($amount->payment_type == \App\ProjectAccount::adjacement)
                                                <tr>
                                                    <td>Adjacement Type</td>
                                                    @if($amount->adjacement_type == \App\ProjectAccount::property)
                                                    <td>Property </td>
                                                    @elseif($amount->adjacement_type == \App\ProjectAccount::vehicle)
                                                    <td>Vehicle</td>
                                                    @else
                                                    <td></td>
                                                    @endif
                                                </tr>


                                                @endif
                                                <tr>
                                                    <td>Description
                                                    </td>
                                                    <td>
                                                        {{$amount->description}}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>Depositor Name</td>
                                                    <td> {{$amount->depositor_name}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Amount</td>
                                                    <td> {{$amount->amount}}</td>
                                                </tr>

                                            </tbody>
                                        </table>
                                    </div>

                        </div>
                    </div>
                </div>

                  <div class="row">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">Files</h3>
                            <hr>
                                    <div class="table-responsive">
                                        <table class="table">
                                            <tbody>
                                                <tr>
                                                    <td>Receipt Image</td>
                                                    @foreach($amount->files as $file)
                                                    <td>
                                                        <img src="{{asset('uploads/'.$file->file_url)}}" width="200px" height="200px">
                                                    </td>
                                                    @endforeach
                                                </tr>

                                                <!-- <tr>
                                                    <td>Deposit Date</td>
                                                    <td> {{date('d-m-Y', strtotime($amount->date)) }} </td>
                                                </tr> -->

                                                <tr>
                                                    <td>Updated at</td>
                                                    <td> {{$amount->updated_at}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Created at</td>
                                                    <td> {{$amount->created_at}}</td>
                                                </tr>

                                            </tbody>
                                        </table>
                                    </div>

                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop