@extends('layouts.app')

@section('title') Add Receipt @stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Add Receipt</li>
    </ol>
@stop

@section('content')
    <div class="container-fluid">
        <form method="post" action="{{ route('receipt.insert') }}" class="form-horizontal" id="receipt_form">
            {{ csrf_field() }}
            <div class="row">
                <div class="col-lg-12 col-sm-12 col-xs-12">
                    @if ($errors->any())
                        <div class="white-box">
                            <h2>Errors</h2>
                            <ul> {!! implode(
                                '',
                                $errors->all('
                                                                                                            <li><span class="help-block"><strong>:message</strong></span></li>'),
                            ) !!}
                            </ul>
                        </div>
                    @endif
                    <div class="white-box1">
                        <h3 class="box-title">Payment Information</h3>
                        <hr>

                        <input type="hidden" name="is_approved" value="0">
                        <div class="form-group">
                            <label for="address" class="col-sm-2 control-label">Customer Property </label>
                            <div class="col-sm-4">
                                <div class="input-group">
                                    
                                    <input type="radio" <?= (old('type') == 0)? 'checked' : "" ?>  name="type" value="0" style="zoom: 1.6;" onchange="check_customer(this)">
                                    @if ($errors->has('type'))
                                    <span class="help-block">
                                    <strong>{{ $errors->first('type') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            
                            
                            
                            <label for="address" class="col-sm-2 control-label">Dealer Package </label>
                            <div class="col-sm-4">
                                <div class="input-group">
                                    <input type="radio"  name="type" value="1" <?= (old('type') == 1)? 'checked' : "" ?> style="zoom: 1.6;" onchange="check_dealer(this)">
                                    @if ($errors->has('type'))
                                    <span class="help-block">
                                    <strong>{{ $errors->first('type') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            
                        </div>
                        <div class="col-md-6">
                            <div class="form-group" id='select_customer_or_dealer'>
                                <label class="control-label col-md-4">Select Customer <span
                                        style="color: red">*</span></label>
                                <div class="col-md-8">
                                    <select name="customer_id" id='customer_id' class="form-control chosen-select"
                                        onchange="updateProperty(this.value)">
                                        <option value="" selected="">None</option>

                                        @foreach ($customers as $customer)
                                            @if (old('customer_id') == $customer->id)
                                                <option selected="" value="{{ $customer->id }}">{{ $customer->name }} -
                                                    {{ $customer->cnic }} </option>
                                            @else
                                                <option value="{{ $customer->id }}">{{ $customer->name }} -
                                                    {{ $customer->cnic }}</option>
                                            @endif
                                        @endforeach
                                    </select>

                                    @if ($errors->has('customer_id'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('customer_id') }}</strong>
                                        </span>
                                    @endif

                                </div>
                            </div>
                        </div>
                        <div class="clearfix"></div>

                        <div class="col-md-12" id='property'> </div>
                        <div class="clearfix"></div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Payment Head <span style="color: red">*</span></label>
                                <div class="col-md-8">
                                    {{-- onchange="getAmount(this)" --}}
                                    <select class="form-control chosen-select" name="payment_head" id="payment_head"
                                        onchange="getAmountAgainstPaymentHead(this)">


                                        

                                    </select>

                                    @if ($errors->has('payment_head'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('payment_head') }}</strong>
                                        </span>
                                    @endif

                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group" id='specific_outstanding'>
                                <label class="control-label col-md-4">
                                    <span id="payment_head_label">Down Payment</span> Outstanding
                                </label>
                                <div class="col-md-8">
                                    <input readonly type="text" id="remain_amount" class="form-control">
                                </div>
                            </div>
                        </div>


                        <div class="col-md-6" id='cheque' style="display: none;">
                            <div class="form-group">
                                <label class="control-label col-md-4">Cheque Number</label>
                                <div class="col-md-8">

                                </div>
                            </div>
                        </div>

                        <div class="clearfix"></div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Amount <span style="color: red">*</span></label>
                                <div class="col-md-8">
                                    <span style="font-weight:bold;" id="surcharge_amount"></span>

                                    <input type="text" name="amount" value="{{ old('amount') }}" class="form-control"
                                        id="amount" onkeyup="toWords(this)" placeholder="Enter Amount">
                                    <span style="font-weight:bold;" id="total_amount"></span>
                                    @if ($errors->has('amount'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('amount') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id="due_head">
                            <div class="form-group">
                                <label class="control-label col-md-4">Total Outstanding</label>
                                <div class="col-md-8">
                                    <input readonly="" type="text" name="due" value="{{ old('due') }}"
                                        class="form-control" id="due">
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id="tax_amount_head">
                            <div class="form-group">
                                <label class="control-label col-md-4">Tax Amount</label>
                                <div class="col-md-8">
                                    <input readonly="" type="text" name="tax_amount" value="{{ old('tax_amount') }}"
                                        class="form-control" id="tax_amount">

                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id="tax_paid_by">
                            <div class="form-group">
                                <label class="control-label col-md-4">Tax Pay By</label>
                                <div class="col-md-8">
                                    <select class="form-control select2" name="tax_paid_by" id='tax_paid_by_option'
                                        onchange="changeTaxOption(this)">
                                        <option value="{{ \App\Receipt::customer }}"> Customer</option>
                                        <option value="{{ \App\Receipt::company }}"> Company</option>
                                    </select>

                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id="tax_option_head">
                            <div class="form-group">
                                <label class="control-label col-md-4">Tax Amount Received</label>
                                <div class="col-md-8">
                                    <select class="form-control select2" name="tax_payment_received" id="tax_option">
                                        <option value="0"> NO</option>
                                    </select>

                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Payment Method <span
                                        style="color: red">*</span></label>
                                <div class="col-md-8">
                                    <select class="form-control chosen-select" id="payment_method" name='payment_method'
                                        onchange="changeFunc(this.value)">

                                        @if (old('payment_method') == \App\Receipt::cash)
                                            <option selected value="{{ \App\Receipt::cash }}">Cash</option>
                                            <option value="{{ \App\Receipt::bank }}">Bank Transfer (IBFT)</option>
                                            <option value="{{ \App\Receipt::cheque }}">Cheque/ DD/ PO</option>
                                            <option value="{{ \App\Receipt::adjustment }}">Adjustment</option>
                                            <option value="{{ \App\Receipt::merging }}">Merging</option>
                                        @elseif(old('payment_method') == \App\Receipt::bank)
                                            <option value="{{ \App\Receipt::cash }}">Cash</option>
                                            <option selected value="{{ \App\Receipt::bank }}">Bank Transfer (IBFT)
                                            </option>
                                            <option value="{{ \App\Receipt::cheque }}">Cheque/ DD/ PO</option>
                                            <option value="{{ \App\Receipt::adjustment }}">Adjustment</option>
                                            <option value="{{ \App\Receipt::merging }}">Merging</option>
                                        @elseif(old('payment_method') == \App\Receipt::cheque)
                                            <option value="{{ \App\Receipt::cash }}">Cash</option>
                                            <option value="{{ \App\Receipt::bank }}">Bank Transfer (IBFT)</option>
                                            <option selected value="{{ \App\Receipt::cheque }}">Cheque/ DD/ PO</option>
                                            <option value="{{ \App\Receipt::adjustment }}">Adjustment</option>
                                            <option value="{{ \App\Receipt::merging }}">Merging</option>
                                        @elseif(old('payment_method') == \App\Receipt::adjustment)
                                            <option value="{{ \App\Receipt::cash }}">Cash</option>
                                            <option value="{{ \App\Receipt::bank }}">Bank Transfer (IBFT)</option>
                                            <option value="{{ \App\Receipt::cheque }}">Cheque/ DD/ PO</option>
                                            <option selected value="{{ \App\Receipt::adjustment }}">Adjustment</option>
                                            <option value="{{ \App\Receipt::merging }}">Merging</option>
                                        @elseif(old('payment_method') == \App\Receipt::merging)
                                            <option value="{{ \App\Receipt::cash }}">Cash</option>
                                            <option value="{{ \App\Receipt::bank }}">Bank Transfer (IBFT)</option>
                                            <option value="{{ \App\Receipt::cheque }}">Cheque/ DD/ PO</option>
                                            <option value="{{ \App\Receipt::adjustment }}">Adjustment</option>
                                            <option selected value="{{ \App\Receipt::merging }}">Merging</option>
                                        @else
                                            <option value="{{ \App\Receipt::cash }}">Cash</option>
                                            <option value="{{ \App\Receipt::bank }}">Bank Transfer (IBFT)</option>
                                            <option value="{{ \App\Receipt::cheque }}">Cheque/ DD/ PO</option>
                                            <option value="{{ \App\Receipt::adjustment }}">Adjustment</option>
                                            <option value="{{ \App\Receipt::merging }}">Merging</option>
                                        @endif

                                    </select>
                                    @if ($errors->has('payment_method'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('payment_method') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>


                        <div class="col-md-6" id='merging_property' style="display: none;">
                            <div class="form-group">
                                <label class="control-label col-md-4">Merging Properties <span
                                        style="color:red;">*</span></label>
                                <div class="col-md-8">
                                    <select name="merging_properties" class="form-control chosen-select"
                                        onchange="getMergingProperty(this)">
                                        <option value="" selected="">None</option>

                                        @foreach ($merging_properties as $merging_property)
                                            @if (old('merging_properties') == $merging_property->id)
                                                <option selected="" value="{{ $merging_property->id }}">
                                                    {{ $merging_property->mrf_no }}</option>
                                            @else
                                                <option value="{{ $merging_property->id }}">
                                                    {{ $merging_property->mrf_no }}</option>
                                            @endif
                                        @endforeach
                                    </select>

                                    @if ($errors->has('merging_properties'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('merging_properties') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>


                        <div class="col-md-6" id='bank' style="display: none;">
                            <div class="form-group">
                                <label class="control-label col-md-4">Depositor Bank Name <span
                                        style="color:red;">*</span></label>
                                <div class="col-md-8">
                                    <select name="bank_name" class="form-control chosen-select">
                                        <option value="" selected="">None</option>

                                        @foreach ($banks as $bank)
                                            @if (old('bank_name') == $bank->id)
                                                <option selected="" value="{{ $bank->id }}">{{ $bank->name }}
                                                </option>
                                            @else
                                                <option value="{{ $bank->id }}">{{ $bank->name }}</option>
                                            @endif
                                        @endforeach
                                    </select>

                                    @if ($errors->has('bank_name'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('bank_name') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id='company-bank' style="display: none;">
                            <div class="form-group">
                                <label class="control-label col-md-4">Company Account <span
                                        style="color:red;">*</span></label>
                                <div class="col-md-8">
                                    <select name="company_account" class="form-control chosen-select">
                                        <option value="" selected="">None</option>

                                        @foreach ($cBanks as $bank)
                                            @if (old('company_account') == $bank->id)
                                                <option selected="" value="{{ $bank->id }}">{{ $bank->name }} -
                                                    {{ $bank->account_number }}</option>
                                            @else
                                                <option value="{{ $bank->id }}">{{ $bank->name }} -
                                                    {{ $bank->account_number }}</option>
                                            @endif
                                        @endforeach

                                    </select>

                                    @if ($errors->has('company_account'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('company_account') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id="cheque-dd-po-drawn-date" style="display: none;">
                            <div class="form-group">
                                <label class="control-label col-md-4"><span id="date_type"> Drawn Date</span> <span
                                        style="color:red;">*</span></label>
                                <div class="col-md-8">
                                    <input type="date" class="form-control" name='drawn_date' value=""
                                        id="exampleInputEmail1" placeholder="Enter Receipt Date">
                                    @if ($errors->has('drawn_date'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('drawn_date') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id="cheque-dd-po-instrument-no" style="display: none;">
                            <div class="form-group">
                                <label class="control-label col-md-4"> <span id="number_type">Instrument No </span> <span
                                        style="color:red;">*</span></label>
                                <div class="col-md-8">
                                    <input type="text" name='cheque_number' value="" class="form-control"
                                        id="exampleInputEmail1" placeholder="Enter Instrument Number">
                                    @if ($errors->has('cheque_number'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('cheque_number') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>


                        <div id='adjustment' style="display: none;">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-4">Adjustment Type <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-8">
                                        <select class="form-control chosen-select" onchange="checkAdjustmentType(this)"
                                            name='adjustment_type' id='adjustment_type'>
                                            
                                            @if (old('adjustment_type') == \App\Receipt::property)
                                                <option value="{{ \App\Receipt::property }}" selected="">Property
                                                </option>
                                                <option value="{{ \App\Receipt::roll_back }}">Roll Back</option>
                                                <option value="{{ \App\Receipt::vehicle }}">Vehicle</option>
                                                <option value="{{ \App\Receipt::rebate }}">Rebate</option>
                                                <option value="{{ \App\Receipt::vendor }}">Vendor</option>
                                                <option value="{{ \App\Receipt::token_receipt }}">Token Receipt</option>
                                                <option value="{{ \App\Receipt::others }}">Other</option>
                                            @elseif(old('adjustment_type') == \App\Receipt::vehicle)
                                                <option value="{{ \App\Receipt::property }}">Property</option>
                                                <option value="{{ \App\Receipt::roll_back }}">Roll Back</option>
                                                <option value="{{ \App\Receipt::vehicle }}" selected="">Vehicle
                                                </option>
                                                <option value="{{ \App\Receipt::rebate }}">Rebate</option>
                                                <option value="{{ \App\Receipt::vendor }}">Vendor</option>
                                                <option value="{{ \App\Receipt::token_receipt }}">Token Receipt</option>
                                                <option value="{{ \App\Receipt::others }}">Others</option>
                                            @elseif(old('adjustment_type') == \App\Receipt::rebate)
                                                <option value="{{ \App\Receipt::property }}">Property</option>
                                                <option value="{{ \App\Receipt::roll_back }}">Roll Back</option>
                                                <option value="{{ \App\Receipt::vehicle }}">Vehicle</option>
                                                <option value="{{ \App\Receipt::rebate }}" selected="">Rebate</option>
                                                <option value="{{ \App\Receipt::vendor }}">Vendor</option>
                                                <option value="{{ \App\Receipt::token_receipt }}">Token Receipt</option>
                                                <option value="{{ \App\Receipt::others }}">Others</option>
                                            @elseif(old('adjustment_type') == \App\Receipt::vendor)
                                                <option value="{{ \App\Receipt::property }}">Property</option>
                                                <option value="{{ \App\Receipt::roll_back }}">Roll Back</option>
                                                <option value="{{ \App\Receipt::vehicle }}">Vehicle</option>
                                                <option value="{{ \App\Receipt::rebate }}">Rebate</option>
                                                <option value="{{ \App\Receipt::vendor }}" selected="">Vendor</option>
                                                <option value="{{ \App\Receipt::token_receipt }}">Token Receipt</option>
                                                <option value="{{ \App\Receipt::others }}">Others</option>
                                            @elseif(old('adjustment_type') == \App\Receipt::token_receipt)
                                                <option value="{{ \App\Receipt::property }}">Property</option>
                                                <option value="{{ \App\Receipt::roll_back }}">Roll Back</option>
                                                <option value="{{ \App\Receipt::vehicle }}">Vehicle</option>
                                                <option value="{{ \App\Receipt::rebate }}">Rebate</option>
                                                <option value="{{ \App\Receipt::vendor }}">Vendor</option>
                                                <option value="{{ \App\Receipt::token_receipt }}" selected="">Token
                                                    Receipt</option>
                                                <option value="{{ \App\Receipt::others }}">Others</option>
                                            @elseif(old('adjustment_type') == \App\Receipt::others)
                                                <option value="{{ \App\Receipt::property }}">Property</option>
                                                <option value="{{ \App\Receipt::roll_back }}">Roll Back</option>
                                                <option value="{{ \App\Receipt::vehicle }}">Vehicle</option>
                                                <option value="{{ \App\Receipt::rebate }}">Rebate</option>
                                                <option value="{{ \App\Receipt::vendor }}">Vendor</option>
                                                <option value="{{ \App\Receipt::token_receipt }}">Token Receipt</option>
                                                <option value="{{ \App\Receipt::others }}" selected="">Others
                                                </option>
                                            @elseif(old('adjustment_type') == \App\Receipt::roll_back)
                                                <option value="{{ \App\Receipt::property }}">Property</option>
                                                <option value="{{ \App\Receipt::roll_back }}" selected="">Roll Back
                                                </option>
                                                <option value="{{ \App\Receipt::vehicle }}">Vehicle</option>
                                                <option value="{{ \App\Receipt::rebate }}">Rebate</option>
                                                <option value="{{ \App\Receipt::vendor }}">Vendor</option>
                                                <option value="{{ \App\Receipt::token_receipt }}">Token Receipt</option>
                                                <option value="{{ \App\Receipt::others }}" selected="">Others
                                                </option>
                                            @else
                                                <option selected='' value="{{ \App\Receipt::property }}"
                                                    selected="">Property</option>
                                                <option value="{{ \App\Receipt::roll_back }}">Roll Back</option>
                                                <option value="{{ \App\Receipt::vehicle }}">Vehicle</option>

                                                <option value="{{ \App\Receipt::rebate }}">Rebate</option>
                                                <option value="{{ \App\Receipt::vendor }}">Vendor</option>
                                                <option value="{{ \App\Receipt::token_receipt }}">Token Receipt</option>
                                                <option value="{{ \App\Receipt::others }}">Others</option>
                                            @endif
                                        </select>

                                        @if ($errors->has('adjustment_type'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('adjustment_type') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-6" style="display:none;" id="procuremnt_bills">
                                <div class="form-group">
                                    <label class="control-label col-md-4"> Vendor Pending Bill </label>
                                    <div class="col-md-8">
                                        <select class="form-control chosen-select" name="vendor_purchase_order_id"
                                            id="vendor_purchase_order_id" onchange="return getPoPayment(this)">
                                            <option value="">None</option>
                                            @foreach ($vendor_pos as $b)
                                                <optgroup label="Vendor Purchase Orders">
                                                    @foreach ($b->receipts as $list)
                                                        <option value="{{ $list->purchase_order_id }}">
                                                            PO-{{ ucfirst($list->purchase_order_id) }}</option>
                                                    @endforeach
                                                </optgroup>
                                            @endforeach
                                        </select>
                                        @if ($errors->has('vendor_purchase_order_id'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('vendor_purchase_order_id') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>



                            <div class="col-md-6" style="display:none;" id="token_amount_div">
                                <div class="form-group">
                                    <label class="control-label col-md-4"> Unit Token </label>
                                    <div class="col-md-8">
                                        <select class="form-control chosen-select" name="token_amount" id="token_amount"
                                            onchange="return getUnitToken(this)">
                                            <option value="">None</option>
                                            @foreach ($unitNumbers as $u)
                                                <optgroup label="Unit Token">

                                                    <option value="{{ $u->inventory->id }}">
                                                        {{ $u->inventory->unit_number }} -
                                                        {{ number_format($u->token_amount) }} </option>

                                                </optgroup>
                                            @endforeach
                                        </select>
                                        @if ($errors->has('token_amount'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('token_amount') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>



                            <div class="col-md-6" id="adjustment_detail_head">
                                <div class="form-group">
                                    <label class="control-label col-md-4">Adjustment Detail <span
                                            style="color: red">*</span></label>
                                    <div class="col-md-8">
                                        <textarea name="adjustment_detail" class="form-control"></textarea>
                                        @if ($errors->has('adjustment_detail'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('adjustment_detail') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6" style="display:none;" id="dealers_rebarts">
                                <div class="form-group">
                                    <label class="control-label col-md-4"> Dealer Payable Rebates </label>
                                    <div class="col-md-8">
                                        <select class="form-control chosen-select" name="dealer_adjustment_unit_id">
                                            <option value="">None</option>
                                            @foreach ($dealersRecord as $d)
                                                <optgroup label="{{ $d['info']->name }}">
                                                    @foreach ($d['rebate'] as $key => $val)
                                                        <option value="{{ $key }}">{{ $val }}
                                                        </option>
                                                    @endforeach
                                                </optgroup>
                                            @endforeach
                                        </select>
                                        @if ($errors->has('dealer_adjustment_unit_id'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('dealer_adjustment_unit_id') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id="cheque-dd-po-roll-back" style="display:none;">
                            <div class="form-group">
                                <label class="control-label col-md-4"> <span id="number_type">Roll Back/Adjust Properties
                                    </span> <span style="color:red;">*</span></label>
                                <div class="col-md-8">
                                    <select class="form-control chosen-select" name='roll_back_properties'
                                        id='roll_back_properties' >

                                        @foreach ($adjusted_properties as $adjusted_property)
                                        @php
                                        $value_='';
                                        $amount_value='';
                                            if( $adjusted_property->customerAdjustHistory){
                                                $amount_value =$adjusted_property->customerAdjustHistory->total_received_amount - $adjusted_property->includeInReceipt->sum('amount');
                                                $value_=     $adjusted_property->customerAdjustHistory->ua_no . ' ---- Remaining Amount: ' . ( $amount_value);
                                            }
                                            
                                       
                                      
                                      @endphp
                                            @if (old('roll_back_properties') == $adjusted_property->id)
                                                <option selected="" value="{{ $adjusted_property->id }}" data-amount='{{$amount_value}}'>
                                                   {{$value_}}
                                                </option>
                                            @else
                                                <option value="{{ $adjusted_property->id }}" data-amount='{{$amount_value}}'>
                                                    {{$value_}}
                                                </option>
                                            @endif
                                        @endforeach
                                    </select>
                                    @if ($errors->has('roll_back_properties'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('roll_back_properties') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <br>
                        <div class="col-md-12" id='merging-property'> </div>
                        <div class="clearfix"></div>
                        <hr>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Receipt Number <span
                                        style="color: red">*</span></label>
                                <div class="col-md-8">
                                    @if (old('receipt_no'))
                                        <input type="text" class="form-control" name='receipt_no' id='receipt_no'
                                            value="{{ old('receipt_no') }}"  
                                            placeholder="Enter Receipt Number">
                                    @else
                                        <input type="text" class="form-control" name='receipt_no'
                                            value="{{ $receipt_no }}"  
                                            placeholder="Enter Receipt Number"  id='receipt_no'>
                                    @endif
                                    @if ($errors->has('receipt_no'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('receipt_no') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Receipt Date <span
                                        style="color: red">*</span></label>
                                <div class="col-md-8">
                                    <input type="date" class="form-control" name='receipt_date'
                                        value="{{ date('Y-m-d') }}" id="exampleInputEmail1"
                                        placeholder="Enter Receipt Date">
                                    @if ($errors->has('receipt_date'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('receipt_date') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Notes</label>
                                <div class="col-md-8">
                                    <textarea class="form-control" name="notes"></textarea>
                                    @if ($errors->has('notes'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('notes') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-md-8">
                            <input type="checkbox" name="notify_sms" value="1"> Sms Notification
                            <br>
                            <input type="checkbox" name="notify_email" value="1"> Email Notification
                        </div>
                        <div class="col-md-4">
                            <div class="form-group m-b-0 pull-right">
                                <input type="submit" class="btn btn-info btn-sm waves-effect waves-light "
                                    id="saveBtn" disabled onclick="return validateAmount(this)" value="Save">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>

@stop

@section('js')
    <script>
        function getMergingAmount(self) {
            $('#amount').val(0);
            $('#amount').val($('input[name=merging_property_id]:checked').data("amount"));

        }



        function getAmount(self) {

            //  $(".chosen-select").chosen('destroy');


            // var dataAttri = $('input[name="customer_property_id"]:checked').data("booking_type");

            // if (dataAttri != '' && dataAttri == '{{ \App\CustomerProperty::full_payment }}') {
            //     $('#payment_head option:contains("Down Payment")').text('Full Payment');
            // } else {
            //     $('#payment_head option:contains("Full Payment")').text('Down Payment');
            // }

            // if ($(self).val() == '{{ \App\Receipt::surcharge }}') {
            //     $('#due_head').hide();
            //     $('#tax_paid_by').hide();
            //     $('#tax_amount_head').hide();
            //     $('#adjustment').hide();
            //     $('#adjustment_detail_head').hide();
            //     $('#surcharge_amount').html('Put Zero To Waive Off Surcharge.')
            //     $('#surcharge_amount').show()
            //     $('#tax_option_head').hide();
            //     $("#payment_method").html(
            //         '<option selected value="{{ \App\Receipt::cash }}">Cash</option><option value="{{ \App\Receipt::bank }}">Bank Transfer (IBFT)</option><option value="{{ \App\Receipt::cheque }}">Cheque/ DD/ PO</option><option  value="{{ \App\Receipt::merging }}">Merging</option>'
            //         )
            // } else {
            //     $('#due_head').show();
            //     $('#tax_paid_by').show();
            //     $('#tax_amount_head').show();
            //     $('#tax_option_head').show();
            //     $('#surcharge_amount').hide()
            //     $("#payment_method").html(
            //         '<option selected value="{{ \App\Receipt::cash }}">Cash</option><option value="{{ \App\Receipt::bank }}">Bank Transfer (IBFT)</option><option value="{{ \App\Receipt::cheque }}">Cheque/ DD/ PO</option><option value="{{ \App\Receipt::adjustment }}">Adjustment</option><option  value="{{ \App\Receipt::merging }}">Merging</option>'
            //         )
            // }

            //  $(".chosen-select").chosen();

            $('#amount').val(0);
            let property_id = $('input[name=customer_property_id]:checked').val();
            // let entered_amount = $('#amount').val();
            // let payment_head = $('#payment_head').val();



            var data = {
                'property_id': property_id,
                // 'entered_amount': entered_amount,
                // 'payment_head': payment_head
            };

            $.get('/validate/receipt/amount', data, function(data) {
                $('#remain_amount').val(Number(0));
                $("#payment_head").chosen('destroy');
                $('#payment_head').empty();
                $('#payment_head').append('<option selected="selected" disabled>Select an option </option>');
                for (i = 0; i < data.array_property_payment_head.payment_head_name.length; i++) {
                    $('#payment_head').append('<option value="' + data.array_property_payment_head.payment_head_val[
                        i] + '">' + data.array_property_payment_head.payment_head_name[i] + '</option>');
                }
                $("#payment_head").chosen();
                //    if (data.response == '1') 
                //    {
                //         // $('#invalid_amount').html('Invalid Amount!');
                //         // $('#invalid_amount').show()
                //         // $('#payment_head').empty();

                //         // $('#payment_head_label').html(data.payment_head)
                //         // $('#remain_amount').val(Math.round(data.remaining))

                //    }
                //    else
                //    {

                //     //  $('#payment_head').empty();

                //         // $('#invalid_amount').html('');
                //         // $('#invalid_amount').hide()
                //         // $('#payment_head_label').html(data.payment_head)
                //         // $('#remain_amount').val(Math.round(data.remaining))

                //    }



            }, 'json');


            changeTotalRemaining()

        }


        function getPackageAmount(self) {

 

$('#amount').val(0);


let dealerpackage_id = $('input[name=dealerpackage_id]:checked').val();

$('#remain_amount').val(Number(0));
    $("#payment_head").chosen('destroy');
    $('#payment_head').empty();
    $('#payment_head').append('<option value="' + 
            {{\App\Receipt::package_payment}} + '"> Package Payment </option>');
            $("#payment_head").chosen();



 

 
    

    


 


            changeTotalRemainingPackage();

}




        function getAmountAgainstPaymentHead(self) {

            //  $(".chosen-select").chosen('destroy');

       var type=     $('input[name="type"]:checked').val();
         if(type==0){
        var dataAttri = $('input[name="customer_property_id"]:checked').data("booking_type");

if (dataAttri != '' && dataAttri == '{{ \App\CustomerProperty::full_payment }}') {
    $('#payment_head option:contains("Down Payment")').text('Full Payment');
} else {
    $('#payment_head option:contains("Full Payment")').text('Down Payment');
}

if ($(self).val() == '{{ \App\Receipt::surcharge }}') {
    $('#due_head').hide();
    $('#tax_paid_by').hide();
    $('#tax_amount_head').hide();
    $('#adjustment').hide();
    $('#adjustment_detail_head').hide();
    $('#surcharge_amount').html('Put Zero To Waive Off Surcharge.')
    $('#surcharge_amount').show()
    $('#tax_option_head').hide();
    $("#payment_method").html(
        '<option selected value="{{ \App\Receipt::cash }}">Cash</option><option value="{{ \App\Receipt::bank }}">Bank Transfer (IBFT)</option><option value="{{ \App\Receipt::cheque }}">Cheque/ DD/ PO</option><option  value="{{ \App\Receipt::merging }}">Merging</option>'
    )
} else {
    $('#due_head').show();
    $('#tax_paid_by').show();
    $('#tax_amount_head').show();
    $('#tax_option_head').show();
    $('#surcharge_amount').hide()
    $("#payment_method").html(
        '<option selected value="{{ \App\Receipt::cash }}">Cash</option><option value="{{ \App\Receipt::bank }}">Bank Transfer (IBFT)</option><option value="{{ \App\Receipt::cheque }}">Cheque/ DD/ PO</option><option value="{{ \App\Receipt::adjustment }}">Adjustment</option><option  value="{{ \App\Receipt::merging }}">Merging</option>'
    )
}

//  $(".chosen-select").chosen();

$('#amount').val(0);
let property_id = $('input[name=customer_property_id]:checked').val();
let entered_amount = $('#amount').val();
let payment_head = $('#payment_head').val();



var data = {
    'property_id': property_id,
    'entered_amount': entered_amount,
    'payment_head': payment_head
};

$.get('/get/payment_head/amount', data, function(data) {
    if (data.response == '1') {
        // $('#invalid_amount').html('Invalid Amount!');
        // $('#invalid_amount').show()
        //  

        $('#payment_head_label').html(data.payment_head)
        $('#remain_amount').val(Math.round(data.remaining))

    } else {

        // $('#invalid_amount').html('');
        // $('#invalid_amount').hide()
        $('#payment_head_label').html(data.payment_head)
        $('#remain_amount').val(Math.round(data.remaining))

    }



}, 'json');




changeTotalRemaining()

       }
           
        }



        function validateAmount(argument) {



            if ($('#adjustment_type').val() == '{{ \App\Receipt::vendor }}') {
                var data_1 = {
                    'vendor_purchase_order_id': $('#vendor_purchase_order_id').val(),
                    'entered_amount': $('#amount').val()
                };
                $.get('/validate/purchase-order/amount', data_1, function(data_2) {
                    console.log('Invalid::', data_2);
                    if (data_2.response == 'invalid') {
                        $('#invalid_amount').html('<strong>Invalid Amount!</strong> <span>valid amount of ' + data_2
                            .amount + '</span>');
                        $('#invalid_amount').show()
                        return false;
                    } else {
                        $('#invalid_amount').html('');
                        $('#invalid_amount').hide()
                        $('#receipt_form').submit()
                    }

                }, 'json');

            } else {
                $('#receipt_form').submit()
            }

            return false;
        }

        function getPoPayment(self) {

            var po = $(self).val();

            var data = {
                'purchase_order': po
            };

            $.get('/purchase-order/payment', data, function(data) {

                $('#amount').val(data.response);
            }, 'json');

            return false;
        }


        function getUnitToken(self) {
            var unit_id = $(self).val();

            var data = {
                'unit_id': unit_id
            };

            $.get('/unit-token', data, function(data) {

                $('#amount').val(data.response);
            }, 'json');

            return false;
        }

        function checkAdjustmentType(self) {

            if ($(self).val() == '{{ \App\Receipt::rebate }}') {
                $('#dealers_rebarts').show()
                $('#token_amount_div').hide()
                $('#procuremnt_bills').hide()
                $('#cheque-dd-po-roll-back').hide()
            } else if ($(self).val() == '{{ \App\Receipt::vendor }}') {
                $('#dealers_rebarts').hide()
                $('#token_amount_div').hide()
                $('#procuremnt_bills').show()
                $('#cheque-dd-po-roll-back').hide()
            } else if ($(self).val() == '{{ \App\Receipt::token_receipt }}') {
                $('#dealers_rebarts').hide()
                $('#procuremnt_bills').hide()
                $('#token_amount_div').show()
                $('#cheque-dd-po-roll-back').hide()
            } else if ($(self).val() == '{{ \App\Receipt::roll_back }}') {
                $('#cheque-dd-po-roll-back').show()
                $('#dealers_rebarts').hide()
                $('#procuremnt_bills').hide()
                $('#token_amount_div').hide()
            } else {
                $('#dealers_rebarts').hide()
                $('#procuremnt_bills').hide()
                $('#token_amount_div').hide()
                $('#cheque-dd-po-roll-back').hide()
            }



        }


        function changeTaxOption(self) {
            if ($(self).val() == "{{ \App\Receipt::company }}") {
                $('#tax_option').html('<option value="1"> YES</option>');
            } else if ($(self).val() == "{{ \App\Receipt::customer }}") {
                $('#tax_option').html('<option value="0"> NO</option>');
            } else {
                $('#tax_option').html('<option value="1"> YES</option><option value="0"> NO</option>');
            }
        }

        function toWords(self) {

            // payment_method
            // 
          val=  $('#payment_method').find(":selected").val();
           console.log(val,{{ \App\Receipt::adjustment }});
          if(val == {{ \App\Receipt::adjustment }})
          {
            
            check_again=  $('#adjustment_type').find(":selected").val();
            if(check_again == {{ \App\Receipt::roll_back }}){
                
           amount=     $('#roll_back_properties').find(":selected").data('amount');
           if($(self).val() > amount){
           
           
            $("#amount").val(amount);
           }
            }
            
          }
            var total_amount = inWords($(self).val())
            $('#total_amount').text(total_amount)

            let property_id = $('input[name=customer_property_id]:checked').val();
            let entered_amount = $(self).val();
            let payment_head = $('#payment_head').val();

            var data = {
                'property_id': property_id,
                'entered_amount': entered_amount,
                'payment_head': payment_head
            };
           
            if (isNaN(data.entered_amount)) {
                return false;
            } else {
                $.get('/get/payment_head/amount', data, function(data) {

                    if (data.response == '1') {
                        // $('#invalid_amount').html('Invalid Amount!');
                        // $('#invalid_amount').show()

                        $('#payment_head_label').html(data.payment_head)
                        $('#remain_amount').val(data.remaining)
                        // $('#saveBtn').prop('disabled' , true)
                    } else {
                        // $('#invalid_amount').html('');
                        // $('#invalid_amount').hide()
                        $('#payment_head_label').html(data.payment_head)
                        $('#remain_amount').val(data.remaining)
                        // $('#saveBtn').prop('disabled' , false)
                    }



                }, 'json');
            }





        }


        setInterval(function() {

            property = $('input[name="customer_property_id"]:checked').val();


            if (property) {
                id = "#rem" + property;

                remaining_amount = parseInt($(id).val());
            } else {
                remaining_amount = 0;
            }


            if ($('#payment_head').val() === '{{ \App\Receipt::installment }}' && ($('#amount').val() >
                    remaining_amount)) {

                $('#saveBtn').prop('disabled', true)
            } else if ($('#payment_head').val() === '{{ \App\Receipt::surcharge }}' && ($('#amount').val() >
                    remaining_amount)) {
                $('#saveBtn').prop('disabled', true)

            } else {
                if ($('#payment_head').val() !== '{{ \App\Receipt::surcharge }}' && $('#due').val() < 0) {

                    $('#saveBtn').prop('disabled', true)
                } else {

                    $('#saveBtn').prop('disabled', false)
                }
            }





            $('#remain_amount').val(Number($('#remain_amount').val()).toFixed(2))


        }, 500);


        var a = ['', 'one ', 'two ', 'three ', 'four ', 'five ', 'six ', 'seven ', 'eight ', 'nine ', 'ten ', 'eleven ',
            'twelve ', 'thirteen ', 'fourteen ', 'fifteen ', 'sixteen ', 'seventeen ', 'eighteen ', 'nineteen '
        ];
        var b = ['', '', 'twenty', 'thirty', 'forty', 'fifty', 'sixty', 'seventy', 'eighty', 'ninety'];

        function inWords(num) {

            if ((num = num.toString()).length > 9) return 'overflow';
            n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
            if (!n) return;
            var str = '';
            str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
            str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lakh ' : '';
            str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
            str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
            str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + '' : '';
            return 'Rupees ' + str + ' Only';
        }



        function changeFunc(a) {
            if (a == {{ \App\Receipt::cash }}) {
                $('#bank').css('display', 'none');
                $('#company-bank').css('display', 'none');
                $('#cheque').css('display', 'none');
                $('#adjustment').css('display', 'none');
                $('#cheque-dd-po-drawn-date').css('display', 'none');
                $('#cheque-dd-po-instrument-no').css('display', 'none');
                $('#merging_property').hide();
                $('#cheque-dd-po-roll-back').hide()
            } else if (a == {{ \App\Receipt::bank }}) {
                $('#bank').css('display', 'block');
                $('#company-bank').css('display', 'block');
                $('#cheque').css('display', 'none');
                $('#adjustment').css('display', 'none');
                $('#cheque-dd-po-drawn-date').css('display', 'block');
                $('#cheque-dd-po-instrument-no').css('display', 'block');
                $('#merging_property').hide();
                $('#cheque-dd-po-roll-back').hide()
            } else if (a == {{ \App\Receipt::cheque }}) {
                $('#bank').css('display', 'block');
                $('#company-bank').css('display', 'block');
                $('#cheque').css('display', 'none');
                $('#adjustment').css('display', 'none');
                $('#cheque-dd-po-drawn-date').css('display', 'block');
                $('#cheque-dd-po-instrument-no').css('display', 'block');
                $('#merging_property').hide();
                $('#cheque-dd-po-roll-back').hide()
            } else if (a == {{ \App\Receipt::adjustment }}) {
                $('#bank').css('display', 'none');
                $('#company-bank').css('display', 'none');
                $('#cheque').css('display', 'none');
                $('#adjustment').css('display', 'block');
                $('#cheque-dd-po-drawn-date').css('display', 'none');
                $('#cheque-dd-po-instrument-no').css('display', 'none');
                $('#merging_property').hide();
                $('#cheque-dd-po-roll-back').hide()
            } else if (a == {{ \App\Receipt::merging }}) {
                $('#bank').css('display', 'none');
                $('#company-bank').css('display', 'none');
                $('#cheque').css('display', 'none');
                $('#adjustment').css('display', 'none');
                $('#cheque-dd-po-drawn-date').css('display', 'none');
                $('#cheque-dd-po-instrument-no').css('display', 'none');
                $('#merging_property').show();
                $('#cheque-dd-po-roll-back').hide()

            }

        }


        function getMergingProperty(self) {
            var mer_pro = $(self).val();

            $('.preloader').fadeIn();

            var customer_id = $('#customer_id').val();

            var data = {
                'customer_id': customer_id,
                'mer_pro': mer_pro
            };

            $.get('/update-merging-properties', data, function(data) {

                document.getElementById('merging-property').innerHTML = data;

                $('.preloader').fadeOut();
            });
        }


        function updateProperty() {

            $('#remain_amount').val(Number(0));
            $("#payment_head").chosen('destroy');
            $('#payment_head').empty();
            $("#payment_head").chosen();
            $('.preloader').fadeIn();

            var customer_id = $('#customer_id').val();


            var data = {
                'customer_id': customer_id
            }; 
       
            $.get('/add/receipt/update-properties', data, function(data) {

                document.getElementById('property').innerHTML = data;

                $('#myTable').DataTable({
                    "paging": false,
                    "ordering": false,
                    "info": false
                });
            });

            //  $('#wait').hide();
            $('.preloader').fadeOut();

        }

        function updatePackage() {

$('#remain_amount').val(Number(0));
$("#payment_head").chosen('destroy');
$('#payment_head').empty();
$("#payment_head").chosen();
$('.preloader').fadeIn();

var dealer_id = $('#dealer_id').val();


var data = {
    'dealer_id': dealer_id
};

// $('#property').empty();
$.get('/add/receipt/update-package', data, function(data) {

    document.getElementById('property').innerHTML = data;

    $('#myTable').DataTable({
        "paging": false,
        "ordering": false,
        "info": false
    });
});

//  $('#wait').hide();
$('.preloader').fadeOut();

}
function changeTotalRemainingPackage() {

amount = parseInt($('#amount').val());

if (amount) {
    var pack = $('input[name="dealerpackage_id"]:checked').val();

    id = "#rem-package" + pack;

    remaining_amount = parseInt($(id).val());

    $('#due').val(remaining_amount - amount);


    // isFiler = parseInt($('#is_filer').val());

    // if (isFiler == 1)
        // $('#tax_amount').val(amount * 0.01);
    // else
        $('#tax_amount').val(amount * 0.02);

} else {
    pack = $('input[name="dealerpackage_id"]:checked').val();

    id = "#rem-package" + pack;
    remaining_amount = parseInt($(id).val());

    $('#due').val(remaining_amount);
}

if ($('#due').val() < 0) {
    $('#saveBtn').prop('disabled', true)
} else {
    $('#saveBtn').prop('disabled', false)
}
}








        function changeTotalRemaining() {

            amount = parseInt($('#amount').val());

            if (amount) {
                property = $('input[name="customer_property_id"]:checked').val();

                id = "#rem" + property;

                remaining_amount = parseInt($(id).val());

                $('#due').val(remaining_amount - amount);


                isFiler = parseInt($('#is_filer').val());

                if (isFiler == 1)
                    $('#tax_amount').val(amount * 0.01);
                else
                    $('#tax_amount').val(amount * 0.02);

            } else {
                property = $('input[name="customer_property_id"]:checked').val();

                id = "#rem" + property;
                remaining_amount = parseInt($(id).val());

                $('#due').val(remaining_amount);
            }

            if ($('#due').val() < 0) {
                $('#saveBtn').prop('disabled', true)
            } else {
                $('#saveBtn').prop('disabled', false)
            }
        }

        $('#amount').keyup(function() {

            amount = parseInt($('#amount').val());
       var type=     $('input[name="type"]:checked').val();
            if(type == 1){
                
                if (amount) {
    var pack = $('input[name="dealerpackage_id"]:checked').val();

    id = "#rem-package" + pack;

    remaining_amount = parseInt($(id).val());

    $('#due').val(remaining_amount - amount);


    // isFiler = parseInt($('#is_filer').val());

    // if (isFiler == 1)
        // $('#tax_amount').val(amount * 0.01);
    // else
        $('#tax_amount').val(amount * 0.02);

} else {
    pack = $('input[name="dealerpackage_id"]:checked').val();

    id = "#rem-package" + pack;
    remaining_amount = parseInt($(id).val());

    $('#due').val(remaining_amount);
}

if ($('#due').val() < 0) {
    $('#saveBtn').prop('disabled', true)
} else {
    $('#saveBtn').prop('disabled', false)
}

            }
            else if(type == 0)
            {
                if (amount) {
                property = $('input[name="customer_property_id"]:checked').val();

                id = "#rem" + property;

                remaining_amount = parseInt($(id).val());

                $('#due').val(remaining_amount - amount);


                isFiler = parseInt($('#is_filer').val());

                if (isFiler == 1)
                    $('#tax_amount').val(amount * 0.01);
                else
                    $('#tax_amount').val(amount * 0.02);

            } else {
                property = $('input[name="customer_property_id"]:checked').val();

                id = "#rem" + property;
                remaining_amount = parseInt($(id).val());

                $('#due').val(remaining_amount);
            }

            }
           


        });

        function check_customer(){
            $('#select_customer_or_dealer').empty();
            var customer =` <label class="control-label col-md-4">Select Customer <span
                                        style="color: red">*</span></label>
                                <div class="col-md-8">
                                    <select name="customer_id" id='customer_id' class="form-control chosen-select"
                                        onchange="updateProperty(this.value)">
                                        <option value="" selected="">None</option>

                                        @foreach ($customers as $customer)
                                            @if (old('customer_id') == $customer->id)
                                                <option selected="" value="{{ $customer->id }}">{{ $customer->name }} -
                                                    {{ $customer->cnic }} </option>
                                            @else
                                                <option value="{{ $customer->id }}">{{ $customer->name }} -
                                                    {{ $customer->cnic }}</option>
                                            @endif
                                        @endforeach
                                    </select>

                                    @if ($errors->has('customer_id'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('customer_id') }}</strong>
                                        </span>
                                    @endif

                                </div>`;

                                $('#select_customer_or_dealer').append(customer);
                                $('#specific_outstanding').show();
                                $("#tax_paid_by_option").append("<option value='{{\App\Receipt::customer}}'>Customer</option>");
        
                                $("#tax_paid_by_option option[value='{{\App\Receipt::dealer}}']").remove();
                                $("#receipt_no").val({{$receipt_no}});
                                  $("#payment_method").append("<option value='{{ \App\Receipt::adjustment }}''>Adjustment</option>");

  $("#payment_method").append('<option value="{{ \App\Receipt::merging }}">Merging</option>');

  $("#payment_method").chosen("destroy");
  $("#payment_method").trigger("chosen:updated");
                            }


       function check_dealer(){

        $('#select_customer_or_dealer').empty();

        var dealer = `  <label class="control-label col-md-4">Select Dealer <span
                                        style="color: red">*</span></label>
                                <div class="col-md-8">
                                    <select name="dealer_id" id='dealer_id' class="form-control chosen-select"
                                        onchange="updatePackage(this.value)">
                                        <option value="" selected="">None</option>

                                        @foreach ($dealers as $d)
                                       
                                            @if (old('dealer_id') == $d->id)
                                                <option selected="" value="{{ $d->id }}">
                                                    {{ $d->code }} -- {{ $d->name }}  </option>
                                            @else
                                            <option  value="{{ $d->id }}">
                                                    {{ $d->code }} -- {{ $d->name }} </option>
                                            @endif
                                        @endforeach
                                    </select>

                                    @if ($errors->has('dealer_id'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('dealer_id') }}</strong>
                                        </span>
                                    @endif

                                </div>`;
        $('#select_customer_or_dealer').append(dealer);
        $('#specific_outstanding').hide();

        $("#tax_paid_by_option").append("<option value='{{\App\Receipt::dealer}}'>Dealer</option>");

        $("#tax_paid_by_option option[value='{{\App\Receipt::customer}}']").remove();
$("#receipt_no").val('{{$delaer_package_receipt_no}}');
 
$("#payment_method").chosen("destroy");
$("#payment_method option[value='{{\App\Receipt::adjustment}}']").remove();
$("#payment_method option[value='{{\App\Receipt::merging}}']").remove();

                                            
        
       }



    </script>

@stop

@if ($errors->any())
    <script>
        window.onload = function() {

            updateProperty('{{ old('customer_id') }}');

            var payment_method = $('#payment_method').val();
            changeFunc(payment_method)
        }
    </script>
@endif
