@extends('layouts.app')

@section('title')
All Receipts 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Receipts</li>
      </ol>
@stop

@section('content')


            <div class="container-fluid">


                <!-- /row -->
                <div class="row" id="update-table">
                    <div class="col-sm-12">
                        <div class="white-box">

                            <div class="pull-right">


                            </div>
                            
                            <h3 class="box-title">All Cancel Receipts ({{number_format($totalAmount)}})</h3>

                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Receipt No.</th>
                                            <th>Unit No. </th>
                                            <th>Payment Method</th>
                                            <th>Payment Head</th>
                                            <th>Received Amount </th>
                                            <th>Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                

                                        @foreach($receipts as $receipt)
                            <tr>
                            <td>{{$receipt->receipt_no}}</td>


                            <td>{{$receipt->property ?  $receipt->property->inventory ? $receipt->property->inventory->unit_number : '' : ''}}</td>


                            @if($receipt->payment_method == \App\Receipt::cash)
                            <td>Cash</td>
                            @elseif($receipt->payment_method == \App\Receipt::bank)
                            <td>Bank</td>
                            @elseif($receipt->payment_method == \App\Receipt::adjustment)
                            <td>Adjustment</td>
                            @elseif($receipt->payment_method == \App\Receipt::cheque)
                            <td>Cheque</td>
                            @else
                            <td></td>
                            @endif


                            @if($receipt->payment_head == \App\Receipt::down_payment)
                            <td>Down Payment</td>
                            @elseif($receipt->payment_head == \App\Receipt::possession_fee)
                            <td>Possession Fee</td>
                            @elseif($receipt->payment_head == \App\Receipt::installment)
                            <td>Installment</td>
                            @elseif($receipt->payment_head == \App\Receipt::other)
                            <td>Other</td>
                            @else
                            <td></td>
                            @endif
                            @if($receipt->tax_paid_by == \App\Receipt::company)
                            <td>{{number_format($receipt->amount + $receipt->tax_amount)}} PKR</td>
                            @else
                            <td>{{number_format($receipt->amount)}} PKR</td>
                            @endif
                            <td> {{date('d-m-Y', strtotime($receipt->receipt_date)) }}</td>
                            <td class="text-nowrap">

                            <a href="{{route('receipt.detail',['id'=>$receipt->id])}}" class="btn btn-default">View</a>


                            <a href="{{route('receipt.delete',['id'=>$receipt->id])}}" class="btn btn-danger" data-toggle="confirmation" data-placement="left" data-title="Are you sure to delete?" >Delete </a>


                            </td>
                            </tr>
                                        @endforeach


                                    </tbody>
                                </table>
                                
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
              </div>
            <!-- /.container-fluid -->

@stop

@section('js')
<script>
    $(function() {
        $('#myTable').DataTable({
            'pageLength':25,
            'paging':true,
            'searching':true,
            'info':true,
            'ordering':false
        });
    });
        $('.search-customer').on('click',function(){
            $('.preloader').fadeIn();
            plot = $('#plot').val();
            customer = $('#customer').val();
            dealer = $('#dealer').val();
            payment_head = $('#payment_head').val();
            payment_mode = $('#payment_mode').val();
            receipt_no= $('#receipt_no').val();

            if(plot == 0  && customer== 0 && dealer == 0 && payment_head == 0 && payment_mode == 0 && receipt_no ==0) {
                toastr.warning("please select any option.");
                return false;
            }

            var data = {'plot':plot,'customer':customer,'dealer':dealer,'payment_mode':payment_mode,'payment_head':payment_head,'receipt_no':receipt_no};
            $.get('/receipt/updateTable',data,function(data){
                document.getElementById('update-table').innerHTML = data;

                $('#myTable').DataTable({
                    'pageLength':50,
                    'paging':false,
                    'searching':false,
                    'info':true
                });
                toastr.success("Search updated.");

                
                $('.preloader').fadeOut();
            });
        });
    </script>
@stop