@extends('layouts.app') 

@section('title') Payment Receipt @stop 

@section('css')
<style type="text/css">

/*.page-wrapper {
    margin-top: -55px;
    padding-bottom: 0px;
}*/

/*Old css starts here*/
/*.container-fluid {
    padding: 3px 30px 0;
}

@media print {
    
    .page-wrapper {
        font-size: 12px !important;
        font-family: "time-new-roman", Arial, sans-serif !important;
        padding-top: 0px !important;
        padding-bottom: 0;
    }
    
    h3 {
        margin: 0;
        line-height: 1;
    }
    
    .white-box {
        border: none !important;
    }

    
}*/
/*Old css ends here*/

.container-fluid {
    padding: 3px 30px 0;
}

.qr-code {
    display: inline-block;
    border: 1px solid black;
    margin-top: 5px;
}

.payment {
    font-size: 16px;
    text-transform: capitalize;
}

h1 strong, h3 strong {
    color: black !important;
}

@media print {
    
    .page-wrapper {
        font-size: 10.5px !important;
        font-family: "time-new-roman", Arial, sans-serif !important;
        padding-top: 0px !important;
        padding-bottom: 0;
    }
    
    p {
        margin-bottom: 5px;
    }
    
    h3 {
        margin: 0;
        line-height: 1;
        font-size: 14px;
    }
    
    /*.white-box {
        border: none !important;
    }*/
    
    .margin-less {
        margin-left: -4px;
        margin-right: -4px;
    }
    
    .sperator {
        margin-top: 5px;
        margin-bottom: 5px;
    }
    
    .payment {
        font-size: 14px;
    }
}


strong {
    color: #000000 !important;
}

body, p {
    color: black;
}

</style> 
@stop 

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
    <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li> @permission('list-dealer')
    <li><a href="#">Payment Receipt</a></li> 
    @endpermission
    <li class="active">Receipt Detail</li>
</ol> 
@stop 

@section('content')

@php
	$size=  '';

	if($projectType->id == \App\ProjectType::society){
                                               
      		$size=        \App\ProjectType::society_size;
	}

	else
	{
		$size=   \App\ProjectType::high_rise_size;
	}
                                            
@endphp

@php
    $map= ' ';

    if($projectType->id == \App\ProjectType::society){

        $map= \App\ProjectType::society_map;
    }

    else
    { 
        $map= \App\ProjectType::high_rise_map;
    }

@endphp
<div class="container-fluid">
    <div class="row printableArea" id="content">
        <!-- /row -->
        <br>
        <div class="row no-print">
            <div class="col-sm-12">
                <div class="white-box">
                    <h3 class="box-title">

                        <div class="row">
                            <div class="col-sm-6" style="margin-top: 1rem;">
                                  <span> Receipt Information</span>
                            </div>

                           
                            <div class="col-sm-6">
                                <form class="d-flex" style="padding-left: 15rem;" method="post" onsubmit="return upload_receipt_docs(this , '{{$receipt->id}}')">
                                    <div class="row">
                                        <input type='hidden' id='unit_type' name="unit_type" value="{{\App\RefundReceiptDocument::open_file}}">
                                        <div class="col-sm-8">
                                            <span id="error_message" style="color: red;display: none;"></span>
                                            <span id="success_message" style="color: green;display: none;"></span>

                                            <label>Upload Multiple docx <small>(image, pdf, word)</small></label>
                                            <input name="files[]" id="files" class="form-control me-2" multiple type="file" aria-label="Search">
                                        </div>
                                        <div class="col-sm-4" style="margin-top: 3.5rem;">
                                            <button id="upload_btn" class="btn btn-outline-success" type="submit">Upload</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                         
                    </h3>
                    
                    <hr>
                    
                    <div class="table-responsive">
                        <table class="table">
                            <tbody>
                                <tr>
                                    <td>Receipt #</td>
                                    <td>{{$receipt->receipt_no}}</td>
                                </tr>
                                <tr>
                                    <td>Date</td>
                                    <td>{{date('d-m-Y',strtotime($receipt->receipt_date))}}</td>
                                </tr>
                                <tr>
                                    <td>Dealer</td>
                                    <td>{{$receipt->dealer->name}} </td>
                                </tr>
                                <tr>
                                    <td>Unit No.</td>
                                    <td> {{$receipt->openFileDealerInfo->inventory ? $receipt->openFileDealerInfo->inventory->unit_number : ''}} </td>
                                </tr>
                               
                                <tr>
                                    <td>Payment Mode</td> 

                                    <td>
                                        
                                        @if(!empty($receipt->payment_method))
                                        
                                            @if($receipt->payment_method == \App\Receipt::cash) Cash 
                                            @elseif($receipt->payment_method == \App\Receipt::bank) Bank 
                                            @elseif($receipt->payment_method == \App\Receipt::cheque) Cheque/ DD/ PO 
                                            @else 
                                            Adjustment 
                                            @endif 
                                        
                                        @else
                                        
                                            @if($receipt->payment_mode == \App\Receipt::cash) Cash 
    
                                            @elseif($receipt->payment_mode == \App\Receipt::bank) Bank 
    
                                            @elseif($receipt->payment_mode == \App\Receipt::cheque) Cheque/ DD/ PO 
    
                                            @else 
                                            
                                            Adjustment 
    
                                            @endif 
                                        
                                        
                                        @endif
                                        
                                        
                                        
                                    </td>
                                </tr>

                                @if(!empty($receipt->cheque_number))
                                <tr>
                                    <td>Instrument No.</td>
                                    <td> {{$receipt->cheque_number}} </td>
                                </tr>
                                @endif

                                @if($receipt->payment_method == \App\Receipt::bank || $receipt->payment_method == \App\Receipt::cheque)
                                <tr>
                                    <td>Company Account</td>
                                    <td>
                                        
                                        @foreach($cBanks as $company_bank)
                                        
                                        @if($company_bank->id == $receipt->company_account)
                                        {{$company_bank->name}}
                                        @endif

                                        @endforeach

                                    </td>
                                </tr>
                                <tr>
                                    <td>Depositor Bank Account</td>
                                    <td>
                                        
                                        @foreach($banks as $depositor_bank)
                                        
                                        @if($depositor_bank->id == $receipt->bank_name)
                                        {{$depositor_bank->name}}
                                        @endif

                                        @endforeach

                                    </td>
                                </tr>
                                @endif


                                <tr>
                                    <td>Deduction Amount</td>
                                    <td>{{number_format($receipt->amount)}}</td>
                                </tr>
                               
                                <tr>
                                    <td>Tax Amount</td>
                                    <td>
                                        @if($receipt->tax_paid_by == \App\Receipt::company)
                                        {{number_format($receipt->tax_amount)}}
                                        @else
                                        {{number_format(0)}}
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td>Net Amount</td>
                                    @if($receipt->tax_paid_by == \App\Receipt::company)
                                    <td>{{number_format($receipt->amount + $receipt->tax_amount)}}</td>
                                    @else
                                    <td>{{number_format($receipt->amount)}}</td>
                                    @endif
                                </tr>

                                <tr>
                                    <td>Tax Pay By</td>
                                    <td>
                                        @if($receipt->tax_paid_by == \App\Receipt::customer)
                                        Customer
                                        @else
                                        Company
                                        @endif
                                    </td>
                                </tr>

                                <tr>
                                    <td>Tax Payment Received</td>
                                    <td>
                                        @if($receipt->tax_payment_received)
                                        YES
                                        @else
                                        NO
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td>Notes</td>
                                    <td>{{$receipt->notes}}</td>
                                </tr> 

                                @if($receipt->payment_method == \App\Receipt::adjustment)
                                <tr>
                                    <td>Adjustment Detail</td>
                                    <td>{{$receipt->adjustment_detail}}</td>
                                </tr> 

                                @if($receipt->dealer_adjustment_unit_id)
                                <tr>
                                    <td>Rebate Detail</td>
                                    <td>Adjust againt {{$receipt->rebate->property->inventory->unit_number}}</td>
                                </tr> 
                                @endif 
                                
                                @endif 

                            </tbody>
                        
                        </table> 

                        @if(count($receipt->documents) > 0)
                        <h3 style="margin-top: 5rem;margin-bottom: 3rem;">Receipt Documents</h3> 

                        @php 

                        $images = json_decode($receipt->documents , true); 

                        $file_ext = array('docx','pdf'); 


                        echo '<div class="row">'; 

                        for($img = 0; $img < count($images); $img++) 
                        { 
                            
                            $url = asset( 'storage/receipt_documents/'.$images[$img][ 'document_path']); 

                            $urlExt = pathinfo($url, PATHINFO_EXTENSION); 

                            if (!in_array($urlExt, $file_ext)) 
                            { 

                                echo '<div class="col-md-2" >
                                        <a target="_blank" href="'.url( 'storage/receipt_documents/'.$images[$img][ 'document_path']). '">
                                            <img  title="Image" style="height: 100px;border-radius: 10px;" class="img-responsive" src="'.url( 'storage/receipt_documents/'.$images[$img][ 'document_path']). '">
                                        </a>
                                        <a href="'.route( 'receipt-refundopenfile.document.delete' , [$images[$img][ 'id']]) . '" style="margin-left: 4rem; color: red;" data-toggle="confirmation" data-title="Are you sure to delete?" >
                                            <i class="fa fa-trash" aria-hidden="true"></i>
                                        </a>
                                    </div>'; 
                            } 

                            if (in_array($urlExt, $file_ext)) 
                            { 

                                echo '<div class="col-md-2" >
                                    <a target="_blank" href="'.url( 'storage/receipt_documents/'.$images[$img][ 'document_path']). '">
                                        <img title="'.ucfirst($urlExt). ' File" style="height: 100px;border-radius: 10px;" class="img-responsive" src="'.url( 'storage/file.jpg'). '">
                                    </a>
                                    <a href="'.route( 'receipt-refundopenfile.document.delete' , [$images[$img][ 'id']]) . '" style="margin-left: 4rem; color: red;" data-toggle="confirmation" data-title="Are you sure to delete?" >
                                        <i class="fa fa-trash" aria-hidden="true"></i>
                                    </a>
                                </div>'; 
                            } 
                        } 

                        echo '</div>'; 

                        @endphp 

                        @endif 

                    </div>
            
                </div>
            
            </div>
        </div>
        
        <?php 
        
        $application_no =  ' APPLICATION NO : '.  0; 
        
        $membership_no =  ' MEMEBERSHIP NO : '. 0; 
        
        $name = ' NAME :  '.$receipt->dealer->name;  
        
        $receipt_amount =  ' TOTAL RECEIVED AMOUNT : '. $receipt->amount;
            
        $qrCodeOutput =  $membership_no.$name.$receipt_amount;
            
        ?>
           
        <div class="col-lg-12">
            
            
            <div class="white-box" style="border: 1px solid black; margin-top:5px;">
                <div class="row margin-less" style="font-weight: 600; text-transform: uppercase;">
	                <div class="col-sm-2 col-xs-3"> 
	                    @if($receipt->property)
                            @if($receipt->property->inventory->multiProject)
                                <img id="blah" class='circle'
                                    src="{{ asset('images/'.$receipt->property->inventory->multiProject->image) }}"
                                    style="width:60%; margin:15px auto 0; display:block;" alt="your image" />
                            @endif
                        @endif 
	                </div>
	                <div class="col-sm-8 col-xs-6 text-center">
		                <h1 style="margin-top: 5px; font-weight: 800;"><strong>
                            @if($receipt->property)
                                @if($receipt->property->inventory->multiProject)
                                    {{ $property->inventory->multiProject->name }}
                                @endif
                            @endif
                        </strong></h1>
		                
		                <h3 style="margin-top:15px; font-size:23px;"><strong>Receipt of Payment</strong></h3> 
		            </div>
                    <div class="col-sm-2 col-xs-3" style="text-align: right;">
                        <div style="margin-top:-1px; margin-right:-15px; padding:10px 15px; background:#DAE1F3; border-bottom-left-radius:30px;"> 
                            <span class="payment" style="color: #000000;">Office Copy</span> 
                        </div> 
                        <!--<span class="qr-code">
                            {!! QrCode::size(100)->generate($qrCodeOutput); !!}
                        </span> -->
                    </div>
                </div>
                <!--<br>-->
            	<div class="row" style="font-weight: 600; padding: 0 40px;">
            		<div class="col-sm-1 col-xs-1"></div>
            		<div class="col-sm-3 col-xs-3">
            			<div class="col-sm-12 col-xs-12"><center>Date: &nbsp;&nbsp;<strong style="color:black !important">{{date('d-m-Y',strtotime($receipt->receipt_date))}}</strong></center></div>

            		</div>
            		<div class="col-sm-4 col-xs-4"></div>
            		<div class="col-sm-3 col-xs-3">
            			<div class="col-sm-12 col-xs-12"> <center>Receipt No: &nbsp;&nbsp;<strong style="color:black !important">{{$receipt->receipt_no}}</strong> </center> </div>
            		</div>
            		<div class="col-sm-1 col-xs-1"></div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:0px 40px 4px; padding-top:10px; background:#DAE1F3; color:#000000;">
            		<div class="col-sm-4 col-xs-5" style="padding-left: 5px;">
            			<p style="color:#000000;">Received with thanks from Mr./Ms./Mrs.</p>
            		</div>
            		<div class="col-sm-4 col-xs-3">
            			<p><strong>{{$receipt->dealer->name}} </strong></p>
            		</div>
            		<div class="col-sm-4 col-xs-4">
            			<p style="color:#000000;"> Membership # <strong style=" font-weight:800; ">{{$openfile_refund->membership_no}}</strong></p>
            		</div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:0px 40px 4px; padding-top:10px; background:#DAE1F3; color:#000000;">
            		<div class="col-sm-4 col-xs-5" style="padding-left: 5px;">
            			<p style="color:#000000;">
            			    On account of payment head: &nbsp;&nbsp;
                            
                            <strong style="font-weight:800;color:#000000;">
            		       Refund Unit 
                            </strong>
            		    </p>
            		</div>
            		<div class="col-sm-4 col-xs-3">
            			<p style="color:#000000;">Unit Size: &nbsp;&nbsp;{{$receipt->openFileDealerInfo->inventory ? $receipt->openFileDealerInfo->inventory->size->name : ''}}  {{$size}}</p>
            		</div>
                   
            		<div class="col-sm-4 col-xs-4">
            			<p style="color:#000000;">Type: &nbsp;&nbsp;{{$receipt->openFileDealerInfo->inventory ? $receipt->openFileDealerInfo->inventory->type->name : ''}} Unit</p>
            		</div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:0px 40px; background:#DAE1F3; color:#000000;">
            		<div class="col-sm-4 col-xs-5" style="padding-left: 5px;">
            			<p style="color:#000000;">
            			    
            			    Payment Method: &nbsp;&nbsp;
            			    
            			    
            			    @if($receipt->payment_method == \App\Receipt::cash) 
                            Cash
                            @elseif($receipt->payment_method == \App\Receipt::bank) 
                            Bank
                            @elseif($receipt->payment_method == \App\Receipt::cheque) 
                            Cheque 
                            @elseif($receipt->payment_method == \App\Receipt::adjustment) 
                            Adjustment
                            @endif
                            
            			</p>
            		</div>
            		<div class="col-sm-4 col-xs-3">
            			<p style="color:#000000;">Instrument/STN# &nbsp;&nbsp;
            			@if($receipt->payment_method == \App\Receipt::bank || $receipt->payment_method == \App\Receipt::cheque) 
            			{{$receipt->cheque_number}}
            			@else
            			N/A
            			@endif
            			</p>
            		</div>
            		<div class="col-sm-4 col-xs-4">
            			@if($receipt->payment_method == \App\Receipt::cash) 
                        <p style="color:#000000;">Drawn/Transaction Date: &nbsp;&nbsp;<strong>{{date('d-m-Y')}}</strong></p>
                        @else
                        <p style="color:#000000;">Drawn/Transaction Date: &nbsp;&nbsp;<strong>{{date('d-m-Y',strtotime($receipt->receipt_date))}}</strong></p>
                        @endif
            		</div>
            	</div>
                 
            	<div class="row" style="font-weight: 600; margin: 0px 40px; border: 1px solid #ababab;">
            		<div class="col-sm-4 col-xs-4" style="padding-top: 10px;">
            			<p>The Sum of Rupees: <strong style="color:black !important; text-transform:capitalize;"> {{$words}} only</strong></p>
            		</div>
                    <div class="col-sm-2 col-xs-2" style="padding-top: 10px;">
                        <p><strong>Paid Amount</strong></p>
                    </div>
                    <div class="col-sm-2 col-xs-2" style="padding-top: 10px; text-align: right; background: #DAE1F3;">
                        <p>
                            <strong style="color: white;">
                                Rs.
                                @if($receipt->tax_paid_by == \App\Receipt::company)
                                    {{ number_format($receipt->amount + $receipt->tax_amount) }}
                                @else
                                    {{ number_format($receipt->amount) }}
                                @endif
                            </strong>
                        </p>
                    </div>
            		<div class="col-sm-2 col-xs-2" style="padding-top: 10px;">
            			<p><strong>Balance Amount</strong></p>
            		</div>
            		<div class="col-sm-2 col-xs-2" style="padding-top: 10px; text-align: right; background: #DAE1F3;">
            			<p> 
            			    <strong style="color: white;">
                                Rs. {{number_format($balance)}}
                            </strong> 
                        </p>
            		</div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:0px 40px; display:flex;">
            	    <div class="col-sm-2 col-xs-2 p-0">
            			<p>
            			    <span class="qr-code" style="border:none;">
                                {!! QrCode::size(100)->generate($qrCodeOutput); !!}
                            </span>
                        </p>
            		</div>
            		
            		<div class="col-sm-10 col-xs-10" style="align-self: flex-end;margin-bottom: 20px;text-align: right;">
            		    <p
            		        style="border-top: 1px solid black;text-align: right;margin-bottom: 0;font-size:16px;display: inline-block;">
            		        &nbsp;&nbsp;&nbsp;Signature&nbsp;&nbsp;&nbsp;</p>
            		</div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:-15px 25px 0">
            	    
                    
            		
            	</div>
            	
            	<?php
                    echo '<div style="page-break-after: always;"></div>';
                ?>
            	
             
                
            
            
            </div>
            
           
        </div>
        

        <div class="col-lg-12">
            
            <div class="white-box" style="border: 1px solid black; margin-top:5px;">
                <div class="row margin-less" style="font-weight: 600; text-transform: uppercase;">
	                <div class="col-sm-2 col-xs-3"> 
	                    @if($receipt->property)
                            @if($receipt->property->inventory->multiProject)
                                <img id="blah" class='circle'
                                    src="{{ asset('images/'.$receipt->property->inventory->multiProject->image) }}"
                                    style="width:60%; margin:15px auto 0; display:block;" alt="your image" />
                            @endif
                        @endif 
	                </div>
	                <div class="col-sm-8 col-xs-6 text-center">
		                <h1 style="margin-top: 5px; font-weight: 800;"><strong>
                            @if($receipt->property)
                                @if($receipt->property->inventory->multiProject)
                                    {{ $property->inventory->multiProject->name }}
                                @endif
                            @endif
                        </strong></h1>
		                
		                <h3 style="margin-top:15px; font-size:23px;"><strong>Receipt of Payment</strong></h3> 
		            </div>
                    <div class="col-sm-2 col-xs-3" style="text-align: right;">
                        <div style="margin-top:-1px; margin-right:-15px; padding:10px 15px; background:#DAE1F3; border-bottom-left-radius:30px;"> 
                            <span class="payment" style="color: #000000;">Accounts Copy</span> 
                        </div> 
                        <!--<span class="qr-code">
                            {!! QrCode::size(100)->generate($qrCodeOutput); !!}
                        </span> -->
                    </div>
                </div>
                <!--<br>-->
            	<div class="row" style="font-weight: 600; padding: 0 40px;">
            		<div class="col-sm-1 col-xs-1"></div>
            		<div class="col-sm-3 col-xs-3">
            			<div class="col-sm-12 col-xs-12"><center>Date: &nbsp;&nbsp;<strong style="color:black !important">{{date('d-m-Y',strtotime($receipt->receipt_date))}}</strong></center></div>

            		</div>
            		<div class="col-sm-4 col-xs-4"></div>
            		<div class="col-sm-3 col-xs-3">
            			<div class="col-sm-12 col-xs-12"> <center>Receipt No: &nbsp;&nbsp;<strong style="color:black !important">{{$receipt->receipt_no}}</strong> </center> </div>
            		</div>
            		<div class="col-sm-1 col-xs-1"></div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:0px 40px 3px; padding-top:10px; background:#DAE1F3; color:#000000;">
            		<div class="col-sm-4 col-xs-5" style="padding-left: 5px;">
            			<p style="color:#000000;">Received with thanks from Mr./Ms./Mrs.</p>
            		</div>
            		<div class="col-sm-4 col-xs-3">
            			<p><strong>{{$receipt->dealer->name}} </strong></p>
            		</div>
            		<div class="col-sm-4 col-xs-4">
            			<p style="color:#000000;"> Membership # <strong style="font-weight:800;">{{$openfile_refund->membership_no}}</strong></p>
            		</div>
                     
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:0px 40px 4px; padding-top:10px; background:#DAE1F3; color:#000000;">
            		<div class="col-sm-4 col-xs-5" style="padding-left: 5px;">
            			<p style="color:#000000;">
            			    On account of payment head: &nbsp;&nbsp;
                            
                            <strong style="font-weight:800;">
                                Refund Unit 
            		        
                            </strong>
            		    </p>
            		</div>
            		<div class="col-sm-4 col-xs-3">
            			<p style="color:#000000;">Unit Size: &nbsp;&nbsp;{{$receipt->openFileDealerInfo->inventory ? $receipt->openFileDealerInfo->inventory->size->name : ''}}  {{$size}}</p>
            		</div>
            		<div class="col-sm-4 col-xs-4">
            			<p style="color:#000000;">Type: &nbsp;&nbsp;{{$receipt->openFileDealerInfo->inventory ? $receipt->openFileDealerInfo->inventory->type->name : ''}} Unit</p>
            		</div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:0px 40px; background:#DAE1F3; color:#000000;">
            		<div class="col-sm-4 col-xs-5" style="padding-left: 5px;">
            			<p style="color:#000000;">
            			    
            			    Payment Method: &nbsp;&nbsp;
            			    
            			    
            			    @if($receipt->payment_method == \App\Receipt::cash) 
                            Cash
                            @elseif($receipt->payment_method == \App\Receipt::bank) 
                            Bank
                            @elseif($receipt->payment_method == \App\Receipt::cheque) 
                            Cheque 
                            @elseif($receipt->payment_method == \App\Receipt::adjustment) 
                            Adjustment
                            @endif
                            
            			</p>
            		</div>
            		<div class="col-sm-4 col-xs-3">
            			<p style="color:#000000;">Instrument/STN# &nbsp;&nbsp;
            			@if($receipt->payment_method == \App\Receipt::bank || $receipt->payment_method == \App\Receipt::cheque) 
            			{{$receipt->cheque_number}}
            			@else
            			N/A
            			@endif
            			</p>
            		</div>
            		<div class="col-sm-4 col-xs-4">
            			@if($receipt->payment_method == \App\Receipt::cash) 
                        <p style="color:#000000;">Drawn/Transaction Date: &nbsp;&nbsp;<strong>{{date('d-m-Y')}}</strong></p>
                        @else
                        <p style="color:#000000;">Drawn/Transaction Date: &nbsp;&nbsp;<strong>{{date('d-m-Y',strtotime($receipt->receipt_date))}}</strong></p>
                        @endif
            		</div>
            	</div>
            	 
                <div class="row" style="font-weight: 600; margin: 0px 40px; border: 1px solid #ababab;">
            	    <div class="col-sm-4 col-xs-4" style="padding-top: 10px;">
            	        <p>The Sum of Rupees: <strong style="color:black !important; text-transform:capitalize;">
            	                {{ $words }} only</strong></p>
            	    </div>
            	    <div class="col-sm-2 col-xs-2" style="padding-top: 10px;">
            	        <p><strong>Paid Amount</strong></p>
            	    </div>
            	    <div class="col-sm-2 col-xs-2" style="padding-top: 10px; text-align: right; background: #DAE1F3;">
            	        <p>
            	            <strong style="color: white;">
            	                Rs.
            	                @if($receipt->tax_paid_by == \App\Receipt::company)
            	                    {{ number_format($receipt->amount + $receipt->tax_amount) }}
        	                    @else
            	                    {{ number_format($receipt->amount) }}
            	                @endif
            	            </strong>
            	        </p>
            	    </div>
            	    <div class="col-sm-2 col-xs-2" style="padding-top: 10px;">
            	        <p><strong>Balance Amount</strong></p>
            	    </div>
            	    <div class="col-sm-2 col-xs-2" style="padding-top: 10px; text-align: right; background: #DAE1F3;">
            	        <p>
            	            <strong style="color: white;">
            	                Rs. {{ number_format($balance) }}
            	            </strong>
            	        </p>
            	    </div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:0px 40px; display:flex;">
            	    <div class="col-sm-2 col-xs-2 p-0">
            			<p>
            			    <span class="qr-code" style="border:none;">
                                {!! QrCode::size(100)->generate($qrCodeOutput); !!}
                            </span>
                        </p>
            		</div>
            		
            		<div class="col-sm-10 col-xs-10" style="align-self: flex-end;margin-bottom: 20px;text-align: right;">
            		    <p
            		        style="border-top: 1px solid black;text-align: right;margin-bottom: 0;font-size:16px;display: inline-block;">
            		        &nbsp;&nbsp;&nbsp;Signature&nbsp;&nbsp;&nbsp;</p>
            		</div>


            	</div>
            	
            	<div class="row" style="font-weight:600; margin:-15px 25px 0">
            	    
            	    <!-- <div class="col-sm-4 col-xs-4">
            	        <p class="m-0">
            	            <span style="font-size: 15px;"><i class="fa fa-phone" aria-hidden="true"></i> (051) 611 2368
            	                <br>
            	                <i class="fa fa-phone" aria-hidden="true"></i> 0311-111 0272</span>
            	        </p>
            	    </div>
            	    <div class="col-sm-4 col-xs-4">
            	        <p class="m-0">
            	            <span style="font-size: 15px;"><i class="fa fa-globe" aria-hidden="true"></i>
            	                info@bluearc.com.pk <br>
            	                <i class="fa fa-globe" aria-hidden="true"></i> www.bluearc.com .pk</span>
            	        </p>
            	    </div>
            	    <div class="col-sm-4 col-xs-4">
            	        <p class="m-0">
            	            <span style="font-size: 15px;"><i class="fa fa-map-marker" aria-hidden="true"></i> Plaza # 4,
            	                Eiffel
            	                Tower Commercial,
            	                Main Expressway, Phase 8, Bahria Town, Rwp</span>
            	        </p>
            	    </div>
            		
            	</div> -->

                <div class="row" style="font-weight:600; margin:-15px 25px 0">


                </div>
            	
            	<?php
                    echo '<div style="page-break-after: always;"></div>';
                ?>
            	
              
            
            
            </div>
            
        </div>
        

        <div class="col-lg-12">
            
            <div class="white-box" style="border: 1px solid black; margin-top:5px;">
                <div class="row margin-less" style="font-weight: 600; text-transform: uppercase;">
	                <div class="col-sm-2 col-xs-3"> 
	                    @if($receipt->property)
                            @if($receipt->property->inventory->multiProject)
                                <img id="blah" class='circle'
                                    src="{{ asset('images/'.$receipt->property->inventory->multiProject->image) }}"
                                    style="width:60%; margin:15px auto 0; display:block;" alt="your image" />
                            @endif
                        @endif 
	                </div>
	                <div class="col-sm-8 col-xs-6 text-center">
		                <h1 style="margin-top: 5px; font-weight: 800;"><strong>
                            @if($receipt->property)
                                @if($receipt->property->inventory->multiProject)
                                    {{ $property->inventory->multiProject->name }}
                                @endif
                            @endif
                        </strong></h1>
		                
		                <h3 style="margin-top:15px; font-size:23px;"><strong>Receipt of Payment</strong></h3> 
		            </div>
                    <div class="col-sm-2 col-xs-3" style="text-align: right;">
                        <div style="margin-top:-1px; margin-right:-15px; padding:10px 15px; background:#DAE1F3; border-bottom-left-radius:30px;"> 
                            <span class="payment" style="color:#000000;">Customer Copy</span> 
                        </div> 
                        <!--<span class="qr-code">
                            {!! QrCode::size(100)->generate($qrCodeOutput); !!}
                        </span> -->
                    </div>
                </div>
                <!--<br>-->
            	<div class="row" style="font-weight: 600; padding: 0 40px;">
            		<div class="col-sm-1 col-xs-1"></div>
            		<div class="col-sm-3 col-xs-3">
            			<div class="col-sm-12 col-xs-12"><center>Date: &nbsp;&nbsp;<strong style="color:black !important">{{date('d-m-Y',strtotime($receipt->receipt_date))}}</strong></center></div>

            		</div>
            		<div class="col-sm-4 col-xs-4"></div>
            		<div class="col-sm-3 col-xs-3">
            			<div class="col-sm-12 col-xs-12"> <center>Receipt No: &nbsp;&nbsp;<strong style="color:black !important">{{$receipt->receipt_no}}</strong> </center> </div>
            		</div>
            		<div class="col-sm-1 col-xs-1"></div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:0px 40px 4px; padding-top:10px; background:#DAE1F3; color:#000000;">
            		<div class="col-sm-4 col-xs-5" style="padding-left: 5px;">
            			<p style="color:#000000;">Received with thanks from Mr./Ms./Mrs.</p>
            		</div>
            		<div class="col-sm-4 col-xs-3">
            			<p><strong>{{$receipt->dealer->name}} </strong></p>
            		</div>
            		<div class="col-sm-4 col-xs-4">
            			<p style="color:#000000;"> Membership # <strong style="font-weight:800;">{{$openfile_refund->membership_no}}</strong></p>
            		</div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:0px 40px 4px; padding-top:10px; background:#DAE1F3; color:#000000;">
            		<div class="col-sm-4 col-xs-5" style="padding-left: 5px;">
            			<p style="color:#000000;">
            			    On account of payment head: &nbsp;&nbsp;
                            
                            <strong style="font-weight:800;">
            		        Refund Unit
                            </strong>
            		    </p>
            		</div>
            		<div class="col-sm-4 col-xs-3">
            			<p style="color:#000000;">Unit Size: &nbsp;&nbsp;{{$receipt->openFileDealerInfo->inventory ? $receipt->openFileDealerInfo->inventory->size->name : ''}}   {{$size}}</p>
            		</div>
            		<div class="col-sm-4 col-xs-4">
            			<p style="color:#000000;">Type: &nbsp;&nbsp;{{$receipt->openFileDealerInfo->inventory ? $receipt->openFileDealerInfo->inventory->type->name : ''}} Unit</p>
            		</div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:0px 40px; background:#DAE1F3; color:#000000;">
            		<div class="col-sm-4 col-xs-5" style="padding-left: 5px;">
            			<p style="color:#000000;">
            			    
            			    Payment Method: &nbsp;&nbsp;
            			    
            			    
            			    @if($receipt->payment_method == \App\Receipt::cash) 
                            Cash
                            @elseif($receipt->payment_method == \App\Receipt::bank) 
                            Bank
                            @elseif($receipt->payment_method == \App\Receipt::cheque) 
                            Cheque 
                            @elseif($receipt->payment_method == \App\Receipt::adjustment) 
                            Adjustment
                            @endif
                            
            			</p>
            		</div>
            		<div class="col-sm-4 col-xs-3">
            			<p style="color:#000000;">Instrument/STN# &nbsp;&nbsp;
            			@if($receipt->payment_method == \App\Receipt::bank || $receipt->payment_method == \App\Receipt::cheque) 
            			{{$receipt->cheque_number}}
            			@else
            			N/A
            			@endif
            			</p>
            		</div>
            		<div class="col-sm-4 col-xs-4">
            			@if($receipt->payment_method == \App\Receipt::cash) 
                        <p style="color:#000000;">Drawn/Transaction Date: &nbsp;&nbsp;<strong>{{date('d-m-Y')}}</strong></p>
                        @else
                        <p style="color:#000000;">Drawn/Transaction Date: &nbsp;&nbsp;<strong>{{date('d-m-Y',strtotime($receipt->receipt_date))}}</strong></p>
                        @endif
            		</div>
            	</div>
                
            	<div class="row" style="font-weight: 600; margin: 0px 40px; border: 1px solid #ababab;">
            	    <div class="col-sm-4 col-xs-4" style="padding-top: 10px;">
            	        <p>The Sum of Rupees: <strong style="color:black !important; text-transform:capitalize;">
            	                {{ $words }} only</strong></p>
            	    </div>
            	    <div class="col-sm-2 col-xs-2" style="padding-top: 10px;">
            	        <p><strong>Paid Amount</strong></p>
            	    </div>
            	    <div class="col-sm-2 col-xs-2" style="padding-top: 10px; text-align: right; background: #DAE1F3;">
            	        <p>
            	            <strong style="color: white;">
            	                Rs.
            	                @if($receipt->tax_paid_by == \App\Receipt::company)
            	                    {{ number_format($receipt->amount + $receipt->tax_amount) }}
        	                    @else
            	                    {{ number_format($receipt->amount) }}
            	                @endif
            	            </strong>
            	        </p>
            	    </div>
            	    <div class="col-sm-2 col-xs-2" style="padding-top: 10px;">
            	        <p><strong>Balance Amount</strong></p>
            	    </div>
            	    <div class="col-sm-2 col-xs-2" style="padding-top: 10px; text-align: right; background: #DAE1F3;">
            	        <p>
            	            <strong style="color: white;">
            	                Rs. {{ number_format($balance) }}
            	            </strong>
            	        </p>
            	    </div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:0px 40px; display:flex;">
            	    <div class="col-sm-2 col-xs-2 p-0">
            			<p>
            			    <span class="qr-code" style="border:none;">
                                {!! QrCode::size(100)->generate($qrCodeOutput); !!}
                            </span>
                        </p>
            		</div>
            		
            		<div class="col-sm-10 col-xs-10" style="align-self: flex-end;margin-bottom: 20px;text-align: right;">
            		    <p
            		        style="border-top: 1px solid black;text-align: right;margin-bottom: 0;font-size:16px;display: inline-block;">
            		        &nbsp;&nbsp;&nbsp;Signature&nbsp;&nbsp;&nbsp;</p>
            		</div>
            	</div>
            	
            	<div class="row" style="font-weight:600; margin:-15px 25px 0">
            	    

            	</div>
            	
            	
            	
                
            
            
            </div>
                
        </div>
            
            
        </div>
                
    </div>
    
    <div style="display: inline-block; ">
        <div class="text-right no-print" style="display:inline-block; margin-bottom:95px">
            <button class="btn btn-default btn-outline" onclick="window.print(); return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
        </div>
    </div>

</div>
<!-- /.container-fluid -->

@stop

@section('js')

<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
<script>


function upload_receipt_docs(self , receipt_id) 
{
$('#upload_btn').html('Uploading...')
$('#upload_btn').prop('disabled' , true)

 var form_data = new FormData();

       // Read selected files
   var totalfiles = document.getElementById('files').files.length;

    for (var index = 0; index < totalfiles; index++) 
    {
      form_data.append("files[]", document.getElementById('files').files[index]);
    }

   unit_type= $('#unit_type').val();
    form_data.append("receipt_id", receipt_id);
    form_data.append("unit_type", unit_type);
    


   $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });

   // AJAX request
   $.ajax({
     url:"{{ route('receipt-refund.document') }}",
     type: 'post',
     data: form_data,
     dataType: 'json',
     contentType: false,
     processData: false,
     success: function (data) {

        if (data.response == 'yes') 
        {
            $('#success_message').html('Uploaded')
            $('#success_message').show()
            $('#error_message').hide()
            location.reload(true);
        }
        else if (data.response == 'invalid_document') 
        {
            $('#upload_btn').html('Upload')
            $('#upload_btn').prop('disabled' , false)
              $('#error_message').html(data.message)
              $('#error_message').show()
        }
        else
        {
            alert('Error! sonething went wrong.')
              location.reload(true);
        }

     }
   });



    return false;
}

$(function () {
    $("#print").on("click", function () {
        var mode = 'iframe'; //popup
        var close = mode == "popup";
        var options = {
            mode: mode,
            popClose: close
        };
        $("div.printableArea").printArea(options);
    });
});
</script>
<script>
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
</script>


@stop