@extends('layouts.app')

@section('title')
    All Pending Receipts
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Pending Receipts</li>
    </ol>
@stop

@section('content')
@permission('print-receipt')
<?php $print_receipt = true; ?>
@else
<?php $print_receipt = false; ?>
@endpermission

@permission('view-receipt')
<?php $view_receipt = true; ?>
@else
<?php $view_receipt = false; ?>
@endpermission

@permission('edit-receipt')
<?php $edit_receipt = true; ?>
@else
<?php $edit_receipt = false; ?>
@endpermission

@permission('download-receipt')
<?php $download_receipt = true; ?>
@else
<?php $download_receipt = false; ?>
@endpermission

@permission('delete-receipt')
<?php $delete_receipt = true; ?>
@else
<?php $delete_receipt = false; ?>
@endpermission

    <div class="container-fluid">


        <!-- /row -->
        <div class="row" id="update-table">
            <div class="col-sm-12">
                <div class="white-box">

                    <div class="pull-right">


                        {{-- <a href="{{route('receipt.approve.all')}}" class="btn  btn-primary">
                                    <i class="fa fa-plus-square"></i>&nbsp; Approve All 
                                </a> --}}
                    </div>

                    <h3 class="box-title">All Cancel Pending Receipts  </h3>

                    <ul class="nav customtab nav-tabs" role="tablist">

                        <li role="presentation" class="active"><a href="#close_file" aria-controls="home" role="tab"
                                data-toggle="tab" aria-expanded="true"><span class="visible-xs"><i
                                        class="ti-home"></i></span><span class="hidden-xs">Close Unit  
                                        <span class="label label-rounded pull-right"
                                            style="line-height: 1.8;    min-width: 0px;font-size: 14px;padding: 0px 8px;background-color: rgb(204 2 2);">{{ number_format($totalAmount) }}</span>
                                   
                                </span>
                            </a></li>

                            @if ($projectType->id == \App\ProjectType::society)    
                        <li role="presentation" class=""><a href="#open_file" aria-controls="profile"
                                role="tab" data-toggle="tab" aria-expanded="false"><span class="visible-xs"><i
                                        class="ti-user"></i></span> <span class="hidden-xs">Open File  
                                        <span class="label label-rounded pull-right"
                                            style="line-height: 1.8;    min-width: 0px;font-size: 14px;padding: 0px 8px;background-color: rgb(204 2 2);">{{number_format($openfile_count)}} </span>
                                    
                                </span></a></li>
                                @endif

                    </ul>




                    <div class="tab-content">
                        <div id="close_file" class="tab-pane fade in active">
                    <div class="table-responsive">
                        <table id="myTable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Receipt No.</th>
                                    <th>Project</th>
                                    <th>Unit No. </th>
                                    <th>Payment Method</th>

                                    <th>Received Amount </th>
                                    <th>Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>



                                @foreach ($receipts as $receipt)
                                    <tr>
                                        <td>{{ $receipt->receipt_no }}</td>
                                        <td>{{ $receipt->multiProject ? $receipt->multiProject->name : 'None' }}</td>

                                        <td>{{ $receipt->property ? ($receipt->property->inventory ? $receipt->property->inventory->unit_number : '') : '' }}
                                        </td>


                                        @if ($receipt->payment_method == \App\Receipt::cash)
                                            <td>Cash</td>
                                        @elseif($receipt->payment_method == \App\Receipt::bank)
                                            <td>Bank</td>
                                        @elseif($receipt->payment_method == \App\Receipt::adjustment)
                                            <td>Adjustment</td>
                                        @elseif($receipt->payment_method == \App\Receipt::cheque)
                                            <td>Cheque</td>
                                        @elseif($receipt->payment_method == \App\Receipt::merging)
                                            <td>Merging</td>
                                        @else
                                            <td></td>
                                        @endif





                                        @if ($receipt->tax_paid_by == \App\Receipt::company)
                                            <td>{{ number_format($receipt->amount + $receipt->tax_amount) }} PKR</td>
                                        @else
                                            <td>{{ number_format($receipt->amount) }} PKR</td>
                                        @endif
                                        <td> {{ date('d-m-Y', strtotime($receipt->receipt_date)) }}</td>
                                        <td class="text-nowrap">

                                            <a href="{{ route('receipt.cancel-closeunit.detail', ['id' => $receipt->id]) }}"
                                                class="btn btn-default">View</a>



                                            <a href="{{ route('receipt-cancel-closefile.editView', ['id' => $receipt->id]) }}"
                                                class="btn btn-success"> Edit </a>

                                            <a href="{{ route('receipt-cancel-closeunit.approved', ['id' => $receipt->id]) }}"
                                                class="btn btn-success"
                                                style="background: #4aa200; border: 1px solid #4aa200;">
                                                Approve
                                            </a>

                                            {{-- @if ($receipt->payment_method == \App\Receipt::cheque)
                                                <a href="{{ route('receipt.cancelled', ['id' => $receipt->id]) }}"
                                                    class="btn btn-warning" data-toggle="confirmation" data-placement="left"
                                                    data-title="Are you sure to Cancel?">
                                                    Cancel
                                                </a>
                                            @endif --}}


                                            <a href="{{ route('receipt-cancel.delete', ['id' => $receipt->id]) }}"
                                                class="btn btn-danger" data-toggle="confirmation" data-placement="left"
                                                data-title="Are you sure to delete?">Delete </a>


                                        </td>
                                    </tr>
                                @endforeach


                            </tbody>
                        </table>

                    </div>
                        </div>

                        @if ($projectType->id == \App\ProjectType::society)  
                        <div id="open_file" class="tab-pane fade  ">
                            <div class="table-responsive">
                                <div class="table-responsive">
                                    <table id="myTable" class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th>Receipt No.</th>
                                                <th>Project</th>
                                                <th>Unit No. </th>
                                                <th>Payment Method</th>
            
                                                <th>Received Amount </th>
                                                <th>Date</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
            
            
            
                                            @foreach ($openfile_receipts as $open_filereceipt)
                                                <tr>
                                                    <td>{{ $open_filereceipt->receipt_no }}</td>
                                                    <td>{{ $open_filereceipt->multiProject ? $open_filereceipt->multiProject->name : 'None' }}</td>
            
                                                    <td>{{ $open_filereceipt->openFileDealerInfo ? ($open_filereceipt->openFileDealerInfo->inventory ? $open_filereceipt->openFileDealerInfo->inventory->unit_number : '') : '' }}
                                                    </td>
            
            
                                                    @if ($open_filereceipt->payment_method == \App\Receipt::cash)
                                                        <td>Cash</td>
                                                    @elseif($open_filereceipt->payment_method == \App\Receipt::bank)
                                                        <td>Bank</td>
                                                    @elseif($open_filereceipt->payment_method == \App\Receipt::adjustment)
                                                        <td>Adjustment</td>
                                                    @elseif($open_filereceipt->payment_method == \App\Receipt::cheque)
                                                        <td>Cheque</td>
                                                    @elseif($open_filereceipt->payment_method == \App\Receipt::merging)
                                                        <td>Merging</td>
                                                    @else
                                                        <td></td>
                                                    @endif
            
            
            
            
            
                                                    @if ($open_filereceipt->tax_paid_by == \App\Receipt::company)
                                                        <td>{{ number_format($open_filereceipt->amount + $open_filereceipt->tax_amount) }} PKR</td>
                                                    @else
                                                        <td>{{ number_format($open_filereceipt->amount) }} PKR</td>
                                                    @endif
                                                    <td> {{ date('d-m-Y', strtotime($open_filereceipt->receipt_date)) }}</td>
                                                    <td class="text-nowrap">
                                                        @if ($view_receipt)
                                                        <a href="{{ route('receipt.cancel-openunit.detail', ['id' => $open_filereceipt->id]) }}"
                                                            class="btn btn-default">View</a>
            
                                                        @endif
                                                        @if ($edit_receipt)
                                                        <a href="{{ route('property.cancel-openfile-edit.receipt', ['id' => $open_filereceipt->id]) }}"
                                                            class="btn btn-success"> Edit </a>
                                                        @endif
                                                        
                                                        @if ($edit_receipt)
                                                        <a href="{{ route('receipt-cancel-openfile.approved', ['id' => $open_filereceipt->id]) }}"
                                                            class="btn btn-success"
                                                            style="background: #4aa200; border: 1px solid #4aa200;">
                                                            Approve
                                                        </a>
                                                       
                                                        @endif
            
                                                        @if ($delete_receipt)
                                                        <a href="{{ route('receipt-cancel-openfile.delete', ['id' => $open_filereceipt->id]) }}"
                                                            class="btn btn-danger" data-toggle="confirmation" data-placement="left"
                                                            data-title="Are you sure to delete?">Delete </a>
            @endif
            
                                                    </td>
                                                </tr>
                                            @endforeach
            
            
                                        </tbody>
                                    </table>
            
                                </div>
                                <div style="float: right;"></div>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

@stop

@section('js')
    <script>
        $(function() {
            $('#myTable').DataTable({
                'pageLength': 25,
                'paging': false,
                'searching': false,
                'info': false,
                'sorting': false,
                'ordering': false,
                'dom': 'Bfrtip',
                'buttons': [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ]
            });
        });
        $('.search-customer').on('click', function() {
            $('.preloader').fadeIn();
            plot = $('#plot').val();
            customer = $('#customer').val();
            dealer = $('#dealer').val();
            payment_head = $('#payment_head').val();
            payment_mode = $('#payment_mode').val();
            receipt_no = $('#receipt_no').val();

            if (plot == 0 && customer == 0 && dealer == 0 && payment_head == 0 && payment_mode == 0 && receipt_no ==
                0) {
                toastr.warning("please select any option.");
                return false;
            }

            var data = {
                'plot': plot,
                'customer': customer,
                'dealer': dealer,
                'payment_mode': payment_mode,
                'payment_head': payment_head,
                'receipt_no': receipt_no
            };
            $.get('/receipt/updateTable', data, function(data) {
                document.getElementById('update-table').innerHTML = data;

                $('#myTable').DataTable({
                    'pageLength': 50,
                    'paging': true,
                    'searching': false,
                    'info': true,
                    'dom': 'Bfrtip',
                    'sorting': false,
                    'ordering': false,
                    "aaSorting": [
                        [5, "asc"]
                    ],
                    'buttons': [
                        'copy', 'csv', 'excel', 'pdf', 'print'
                    ]
                });
                toastr.success("Search updated.");


                $('.preloader').fadeOut();
            });
        });
    </script>
@stop
