@extends('layouts.app') 

@section('title') Payment Receipt @stop 

@section('css')
<style type="text/css">
/*.page-wrapper {
    margin-top: -55px;
    padding-bottom: 0px;
}*/

.container-fluid {
    padding: 3px 30px 0;
}

@media print {
    .page-wrapper {
        font-size: 12px !important;
        font-family: "time-new-roman", Arial, sans-serif !important;
        padding-top: 0px !important;
        padding-bottom: 0;
    }
    h3 {
        margin: 0;
        line-height: 1;
    }
    .white-box {
        border: none !important;
    }
}
</style> 
@stop 

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
    <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li> @permission('list-dealer')
    <li><a href="#">Payment Receipt</a></li> 
    @endpermission
    <li class="active">Receipt Detail</li>
</ol> 
@stop 

@section('content')
<div class="container-fluid">
    <div class="row printableArea" id="content">
        <!-- /row -->
        <br>
       
                
      <div class="col-lg-12">
            <div class="white-box">
                
                <div class="row " style="text-transform: uppercase; font-weight: 600;">
                    
                    <div class="col-sm-12 col-xs-12 text-center">
                        <h3><strong>{{env('APP_NAME')}}</strong></h3>
                        <h3><strong>Tax Payment Receipt</strong></h3> <span class="payment">Office Copy</span> 
                    </div>
                            
                    <div class="col-sm-12 col-xs-12">
                                
                        <div class="row">
                            
                            <div class="col-sm-4 col-xs-4">
                                <div class="col-sm-5 col-xs-5 p-0">Receipt No.</div>
                                <div class="col-sm-7 col-xs-7" style="border-bottom: 1px dotted">&nbsp; {{$receipt->statement->rcpt_no}}</div>
                            </div>
                            
                            <div class="col-sm-4 col-xs-4"> &nbsp; </div>
                            
                            <div class="col-sm-4 col-xs-4">
                                <div class="col-sm-2 col-xs-2"><b>&nbsp;</b></div>
                                <div class="col-sm-10 col-xs-10">&nbsp; </div>
                                <br>
                                <div class="col-sm-2 col-xs-2"><b>Date:</b></div>
                                <div class="col-sm-10 col-xs-10">
                                    <strong>{{date('d-m-Y',strtotime($receipt->statement->rcpt_date))}}</strong> 
                                </div>
                            </div>
                            
                            <div class="col-sm-4 col-xs-6"> Received with thanks from Mr./Ms./Mrs. </div>
                                    
                            <div class="col-sm-8 col-xs-6" style="border-bottom: 1px dotted">&nbsp; {{$receipt->statement->receipt->customer->name}}</div>
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                            
                            <div class="col-sm-7 col-xs-5">
                                <div class="col-sm-2 col-xs-2 p-0">CNIC#</div>
                                <div class="col-sm-10 col-xs-10" style="border-bottom: 1px dotted">&nbsp;
                                    
                                    <?php $c = str_split($receipt->statement->receipt->customer->cnic, 1);?>
                                    
                                    <?php 
                                    
                                    for($i =0;$i<count($c) ; $i++) { 

                                    ?> 

                                        @if($i == 5 || $i == 12) - @endif {{$c[$i]}}
                                    
                                    <?php } ?>

                                </div>
                            </div>
                            
                           
                            
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                    
                            <div class="col-xs-6 col-sm-6">Payment Mode: 

                                @if($receipt->statement->receipt->payment_method == \App\Receipt::cash) 
                                Cash  

                                @elseif($receipt->statement->receipt->payment_method == \App\Receipt::bank) 
                                Bank  

                                @elseif($receipt->statement->receipt->payment_method == \App\Receipt::cheque) 
                                Cheque 

                                @elseif($receipt->statement->receipt->payment_method == \App\Receipt::adjustment) 
                                Adjustment 
                                @endif

                            </div>

                            @if($receipt->tax_paid_by == \App\Receipt::company) 
                            <div class="col-xs-6 col-sm-6">
                            Tax Amount: &nbsp;&nbsp;&nbsp;{{number_format($receipt->tax_amount)}}

                            </div>
                            @endif


                            @if($receipt->payment_method == \App\Receipt::bank || $receipt->payment_method == \App\Receipt::cheque)
                            <div class="col-xs-4 col-sm-4"> 
                                <span class="pull-left">Instruement No.&nbsp;</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                    {{$receipt->instrument_no}} 
                                    <strong></strong>
                                </div>
                            </div>

                            <div class="col-xs-2 col-sm-2"> 
                                <b>Drawn ON:</b>
                                <strong>{{$receipt->drawn_date}}</strong>
                            </div>
                            @endif
                            
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                    
                            <div class="col-sm-1 col-xs-1">PKR</div>
                            <div class="col-xs-11 col-sm-11" style="border-bottom: 1px dotted; text-align: center;">&nbsp;<strong>
                                @if($receipt->tax_paid_by == \App\Receipt::company)
                                {{number_format($receipt->tax)}}
                                @else
                                {{number_format($receipt->tax)}}
                            @endif
                        </strong></div>
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                            
                            <div class="col-xs-4 col-sm-3">Amount in words (PKR)</div>
                            <div class="col-sm-9 col-xs-8"><b>{{$words}} only</b></div>
                            <div class="clearfix" style="margin-bottom: 70px"></div>
                            
                            <div class="col-xs-8 col-sm-8"> 
                                <b style="border-top: 1px solid;">Payment Received By</b> 
                            </div>
                            <div class="col-sm-4 col-xs-4"> 
                                <b style="border-top: 1px solid;">Payment Approved By</b> 
                            </div>
                                
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="sperator"></div>

          <div class="col-lg-12">
            <div class="white-box">
                
                <div class="row " style="text-transform: uppercase; font-weight: 600;">
                    
                    <div class="col-sm-12 col-xs-12 text-center">
                        <h3><strong>{{env('APP_NAME')}}</strong></h3>
                        <h3><strong>Tax Payment Receipt</strong></h3> <span class="payment">Accounts Copy</span> 
                    </div>
                            
                    <div class="col-sm-12 col-xs-12">
                                
                        <div class="row">
                            
                            <div class="col-sm-4 col-xs-4">
                                <div class="col-sm-5 col-xs-5 p-0">Receipt No.</div>
                                <div class="col-sm-7 col-xs-7" style="border-bottom: 1px dotted">&nbsp; {{$receipt->statement->rcpt_no}}</div>
                            </div>
                            
                            <div class="col-sm-4 col-xs-4"> &nbsp; </div>
                            
                            <div class="col-sm-4 col-xs-4">
                                <div class="col-sm-2 col-xs-2"><b>&nbsp;</b></div>
                                <div class="col-sm-10 col-xs-10">&nbsp; </div>
                                <br>
                                <div class="col-sm-2 col-xs-2"><b>Date:</b></div>
                                <div class="col-sm-10 col-xs-10">
                                    <strong>{{date('d-m-Y',strtotime($receipt->statement->rcpt_date))}}</strong> 
                                </div>
                            </div>
                            
                            <div class="col-sm-4 col-xs-6"> Received with thanks from Mr./Ms./Mrs. </div>
                                    
                            <div class="col-sm-8 col-xs-6" style="border-bottom: 1px dotted">&nbsp; {{$receipt->statement->receipt->customer->name}}</div>
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                            
                            <div class="col-sm-7 col-xs-5">
                                <div class="col-sm-2 col-xs-2 p-0">CNIC#</div>
                                <div class="col-sm-10 col-xs-10" style="border-bottom: 1px dotted">&nbsp;
                                    
                                    <?php $c = str_split($receipt->statement->receipt->customer->cnic, 1);?>
                                    
                                    <?php 
                                    
                                    for($i =0;$i<count($c) ; $i++) { 

                                    ?> 

                                        @if($i == 5 || $i == 12) - @endif {{$c[$i]}}
                                    
                                    <?php } ?>

                                </div>
                            </div>
                            
                           
                            
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                    
                            <div class="col-xs-6 col-sm-6">Payment Mode: 

                                @if($receipt->statement->receipt->payment_method == \App\Receipt::cash) 
                                Cash  

                                @elseif($receipt->statement->receipt->payment_method == \App\Receipt::bank) 
                                Bank  

                                @elseif($receipt->statement->receipt->payment_method == \App\Receipt::cheque) 
                                Cheque 

                                @elseif($receipt->statement->receipt->payment_method == \App\Receipt::adjustment) 
                                Adjustment 
                                @endif

                            </div>

                            @if($receipt->tax_paid_by == \App\Receipt::company) 
                            <div class="col-xs-6 col-sm-6">
                            Tax Amount: &nbsp;&nbsp;&nbsp;{{number_format($receipt->tax_amount)}}

                            </div>
                            @endif


                            @if($receipt->payment_method == \App\Receipt::bank || $receipt->payment_method == \App\Receipt::cheque)
                            <div class="col-xs-4 col-sm-4"> 
                                <span class="pull-left">Instruement No.&nbsp;</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                    {{$receipt->instrument_no}} 
                                    <strong></strong>
                                </div>
                            </div>

                            <div class="col-xs-2 col-sm-2"> 
                                <b>Drawn ON:</b>
                                <strong>{{$receipt->drawn_date}}</strong>
                            </div>
                            @endif
                            
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                    
                            <div class="col-sm-1 col-xs-1">PKR</div>
                            <div class="col-xs-11 col-sm-11" style="border-bottom: 1px dotted; text-align: center;">&nbsp;<strong>
                                @if($receipt->tax_paid_by == \App\Receipt::company)
                                {{number_format($receipt->tax)}}
                                @else
                                {{number_format($receipt->tax)}}
                            @endif
                        </strong></div>
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                            
                            <div class="col-xs-4 col-sm-3">Amount in words (PKR)</div>
                            <div class="col-sm-9 col-xs-8"><b>{{$words}} only</b></div>
                            <div class="clearfix" style="margin-bottom: 70px"></div>
                            
                            <div class="col-xs-8 col-sm-8"> 
                                <b style="border-top: 1px solid;">Payment Received By</b> 
                            </div>
                            <div class="col-sm-4 col-xs-4"> 
                                <b style="border-top: 1px solid;">Payment Approved By</b> 
                            </div>
                                
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="sperator"></div>

          <div class="col-lg-12">
            <div class="white-box">
                
                <div class="row " style="text-transform: uppercase; font-weight: 600;">
                    
                    <div class="col-sm-12 col-xs-12 text-center">
                        <h3><strong>{{env('APP_NAME')}}</strong></h3>
                        <h3><strong>Tax Payment Receipt</strong></h3> <span class="payment">Client Copy</span> 
                    </div>
                            
                    <div class="col-sm-12 col-xs-12">
                                
                        <div class="row">
                            
                            <div class="col-sm-4 col-xs-4">
                                <div class="col-sm-5 col-xs-5 p-0">Receipt No.</div>
                                <div class="col-sm-7 col-xs-7" style="border-bottom: 1px dotted">&nbsp; {{$receipt->statement->rcpt_no}}</div>
                            </div>
                            
                            <div class="col-sm-4 col-xs-4"> &nbsp; </div>
                            
                            <div class="col-sm-4 col-xs-4">
                                <div class="col-sm-2 col-xs-2"><b>&nbsp;</b></div>
                                <div class="col-sm-10 col-xs-10">&nbsp; </div>
                                <br>
                                <div class="col-sm-2 col-xs-2"><b>Date:</b></div>
                                <div class="col-sm-10 col-xs-10">
                                    <strong>{{date('d-m-Y',strtotime($receipt->statement->rcpt_date))}}</strong> 
                                </div>
                            </div>
                            
                            <div class="col-sm-4 col-xs-6"> Received with thanks from Mr./Ms./Mrs. </div>
                                    
                            <div class="col-sm-8 col-xs-6" style="border-bottom: 1px dotted">&nbsp; {{$receipt->statement->receipt->customer->name}}</div>
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                            
                            <div class="col-sm-7 col-xs-5">
                                <div class="col-sm-2 col-xs-2 p-0">CNIC#</div>
                                <div class="col-sm-10 col-xs-10" style="border-bottom: 1px dotted">&nbsp;
                                    
                                    <?php $c = str_split($receipt->statement->receipt->customer->cnic, 1);?>
                                    
                                    <?php 
                                    
                                    for($i =0;$i<count($c) ; $i++) { 

                                    ?> 

                                        @if($i == 5 || $i == 12) - @endif {{$c[$i]}}
                                    
                                    <?php } ?>

                                </div>
                            </div>
                            
                           
                            
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                    
                            <div class="col-xs-6 col-sm-6">Payment Mode: 

                                @if($receipt->statement->receipt->payment_method == \App\Receipt::cash) 
                                Cash  

                                @elseif($receipt->statement->receipt->payment_method == \App\Receipt::bank) 
                                Bank  

                                @elseif($receipt->statement->receipt->payment_method == \App\Receipt::cheque) 
                                Cheque 

                                @elseif($receipt->statement->receipt->payment_method == \App\Receipt::adjustment) 
                                Adjustment 
                                @endif

                            </div>

                            @if($receipt->tax_paid_by == \App\Receipt::company) 
                            <div class="col-xs-6 col-sm-6">
                            Tax Amount: &nbsp;&nbsp;&nbsp;{{number_format($receipt->tax_amount)}}

                            </div>
                            @endif


                            @if($receipt->payment_method == \App\Receipt::bank || $receipt->payment_method == \App\Receipt::cheque)
                            <div class="col-xs-4 col-sm-4"> 
                                <span class="pull-left">Instruement No.&nbsp;</span>
                                <div style="border-bottom: 1px dotted;display: flex;">
                                    {{$receipt->instrument_no}} 
                                    <strong></strong>
                                </div>
                            </div>

                            <div class="col-xs-2 col-sm-2"> 
                                <b>Drawn ON:</b>
                                <strong>{{$receipt->drawn_date}}</strong>
                            </div>
                            @endif
                            
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                                    
                            <div class="col-sm-1 col-xs-1">PKR</div>
                            <div class="col-xs-11 col-sm-11" style="border-bottom: 1px dotted; text-align: center;">&nbsp;<strong>
                                @if($receipt->tax_paid_by == \App\Receipt::company)
                                {{number_format($receipt->tax)}}
                                @else
                                {{number_format($receipt->tax)}}
                            @endif
                        </strong></div>
                            <div class="clearfix" style="margin-bottom: 8px"></div>
                            
                            <div class="col-xs-4 col-sm-3">Amount in words (PKR)</div>
                            <div class="col-sm-9 col-xs-8"><b>{{$words}} only</b></div>
                            <div class="clearfix" style="margin-bottom: 70px"></div>
                            
                            <div class="col-xs-8 col-sm-8"> 
                                <b style="border-top: 1px solid;">Payment Received By</b> 
                            </div>
                            <div class="col-sm-4 col-xs-4"> 
                                <b style="border-top: 1px solid;">Payment Approved By</b> 
                            </div>
                                
                        </div>
                    </div>
                </div>
            </div>
        </div>
                
    </div>
    <div style="display: inline-block; ">
        <div class="text-right no-print" style="display: inline-block; margin-bottom: 95px">
            <button class="btn btn-default btn-outline" onclick="window.print();return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>
        </div>
    </div>

</div>
<!-- /.container-fluid -->



@stop

@section('js')

<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
<script>


function upload_receipt_docs(self , receipt_id) 
{
$('#upload_btn').html('Uploading...')
$('#upload_btn').prop('disabled' , true)

 var form_data = new FormData();

       // Read selected files
   var totalfiles = document.getElementById('files').files.length;

    for (var index = 0; index < totalfiles; index++) 
    {
      form_data.append("files[]", document.getElementById('files').files[index]);
    }

    form_data.append("receipt_id", receipt_id);


   $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });

   // AJAX request
   $.ajax({
     url:"{{ route('receipt.document') }}",
     type: 'post',
     data: form_data,
     dataType: 'json',
     contentType: false,
     processData: false,
     success: function (data) {

        if (data.response == 'yes') 
        {
            $('#success_message').html('Uploaded')
            $('#success_message').show()
            $('#error_message').hide()
            location.reload(true);
        }
        else if (data.response == 'invalid_document') 
        {
            $('#upload_btn').html('Upload')
            $('#upload_btn').prop('disabled' , false)
              $('#error_message').html(data.message)
              $('#error_message').show()
        }
        else
        {
            alert('Error! sonething went wrong.')
              location.reload(true);
        }

     }
   });



    return false;
}

$(function () {
    $("#print").on("click", function () {
        var mode = 'iframe'; //popup
        var close = mode == "popup";
        var options = {
            mode: mode,
            popClose: close
        };
        $("div.printableArea").printArea(options);
    });
});
</script>
<script>
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
</script>


@stop