@extends('layouts.app') 

@section('title') Payment Receipt @stop 

@section('css')
<style type="text/css">
/*.page-wrapper {
    margin-top: -55px;
    padding-bottom: 0px;
}*/

.container-fluid {
    padding: 3px 30px 0;
}

@media print {
    .page-wrapper {
        font-size: 12px !important;
        font-family: "time-new-roman", Arial, sans-serif !important;
        padding-top: 0px !important;
        padding-bottom: 0;
    }
    h3 {
        margin: 0;
        line-height: 1;
    }
    .white-box {
        border: none !important;
    }
}
</style> 
@stop 

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
    <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li> @permission('list-dealer')
    <li><a href="#">Payment Receipt</a></li> 
    @endpermission
    <li class="active">Receipt Detail</li>
</ol> 
@stop 

@section('content')
<div class="container-fluid">
    <div class="row printableArea" id="content">
        <!-- /row -->
        <br>
       
                
        <div class="col-lg-12">
            
            
            
            
            
             <div class="row no-print">
                    <div class="col-sm-12">
                        <div class="white-box">
                            <h3 class="box-title">Receipt Information</h3>
                            <hr>
                                    <div class="table-responsive">
                                        <table class="table">
                                            <tbody>
                                                <tr>
                                                    <td>Receipt #</td>
                                                    <td>{{$receipt->receipt_no}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Date</td>
                                                    <td>{{date('d-m-Y',strtotime($receipt->receipt_date))}}</td>
                                                </tr>
                                                <tr>
                                                    <td>Customer</td>
                                                    <td>{{$receipt->customerPropertyTax->statement->receipt->customer->name}} </td>
                                                </tr>
                                                <tr>
                                                    <td>Unit No.</td>
                                                    <td> {{$receipt->customerPropertyTax->statement->receipt->property->inventory->unit_number}} </td>
                                                </tr>

                                                <tr>
                                                    <td>Payment Head</td>
                                                        <td>
                                                        @if($receipt->customerPropertyTax->statement->receipt->payment_head == \App\Receipt::down_payment)
                                                        Down Payment
                                                        @elseif($receipt->customerPropertyTax->statement->receipt->payment_head == \App\Receipt::installment)
                                                        Installment
                                                        @elseif($receipt->customerPropertyTax->statement->receipt->payment_head == \App\Receipt::others)
                                                        Others
                                                        @endif
                                                        </td>
                                                </tr>

                                               <tr>
                                                    <td>Payment Mode</td>
                                                    @if($receipt->payment_method == \App\Receipt::cash)
                                                    <td>Cash</td>
                                                    @elseif($receipt->payment_method == \App\Receipt::bank)
                                                    <td>Bank transfer
                                                    <br>
                                                    <b>Depositor bank:</b> 

                                                    {{$receipt->DepositorBank ? $receipt->DepositorBank->name : ''}}

                                                    <br>
                                                    <b>Company bank:</b> 

                                                    {{$receipt->companyAccount ? $receipt->companyAccount->name : ''}}


                                                    </td>
                                                    @elseif($receipt->payment_method == \App\Receipt::cheque)
                                                    <td>Cheque</td>
                                                    @elseif($receipt->payment_method == \App\Receipt::adjustment)
                                                    <td>Adjustment</td>
                                                    @endif
                                                </tr>

                                                @if($receipt->payment_method == \App\Receipt::cheque || $receipt->payment_method == \App\Receipt::bank)
                                                 <tr>
                                                    <td>Instrument No </td>
                                                    <td>{{$receipt->instrument_no}}</td>
                                                </tr>
                                                @endif
                                              
                                        

                                                 <tr>
                                                    <td>Net Amount</td>
                                                    @if($receipt->tax_paid_by == \App\Receipt::company)
                                                    <td>{{number_format($receipt->receipt_amount )}}</td>

                                                    @else

                                                    <td>{{number_format($receipt->receipt_amount)}}</td>

                                                    @endif
                                                </tr>

                                               

                                                <tr>
                                                    <td>Tax Payment Received</td>
                                                    <td>@if($receipt->customerPropertyTax->statement->receipt->tax_payment_received)
                                                        YES
                                                        @else
                                                        NO
                                                    @endif
                                                </td>
                                                </tr>

                                                <tr>
                                                    <td>Notes</td>
                                                    <td>{{$receipt->note}}</td>
                                                </tr>
                                                

                                              
                                            
                                            </tbody>
                                        </table>
                                    </div>

                        </div>
                    </div>
                </div>
                
                
                   <div style="display: inline-block; ">



    <div class="text-right no-print" style="display: inline-block; margin-bottom: 95px">
            <button class="btn btn-default btn-outline" onclick="window.print();return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>

        @permission('create-voucher')

        <a onclick="$('#voucher-form').submit()" href="#"><button  class="btn btn-default btn-outline"  type="button"> <span><i class="fa fa-money"></i> Make Receipt Voucher</span> </button></a>

        @endpermission

        

        <form id="voucher-form" method="post" action="{{route('create-voucher')}}">
            {{csrf_field()}}
        <input type="hidden" name="type" value="{{\App\GeneralJournalEntry::receipt}}">
        <input type="hidden" name="id" value="{{$receipt->id}}">
         <input type="hidden" name="receipt_type" value="{{\App\GeneralJournalEntry::customer_tax_receipt}}">
        <input type="hidden" name="control" value="{{\App\ControlAccount::CUSTOMER}}">

        </form>

    </div>
    
</div>
         
        </div>
       

    </div>
 

</div>
<!-- /.container-fluid -->



@stop

@section('js')

<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
<script>


function upload_receipt_docs(self , receipt_id) 
{
$('#upload_btn').html('Uploading...')
$('#upload_btn').prop('disabled' , true)

 var form_data = new FormData();

       // Read selected files
   var totalfiles = document.getElementById('files').files.length;

    for (var index = 0; index < totalfiles; index++) 
    {
      form_data.append("files[]", document.getElementById('files').files[index]);
    }

    form_data.append("receipt_id", receipt_id);


   $.ajaxSetup({
        headers: {
        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
        });

   // AJAX request
   $.ajax({
     url:"{{ route('receipt.document') }}",
     type: 'post',
     data: form_data,
     dataType: 'json',
     contentType: false,
     processData: false,
     success: function (data) {

        if (data.response == 'yes') 
        {
            $('#success_message').html('Uploaded')
            $('#success_message').show()
            $('#error_message').hide()
            location.reload(true);
        }
        else if (data.response == 'invalid_document') 
        {
            $('#upload_btn').html('Upload')
            $('#upload_btn').prop('disabled' , false)
              $('#error_message').html(data.message)
              $('#error_message').show()
        }
        else
        {
            alert('Error! sonething went wrong.')
              location.reload(true);
        }

     }
   });



    return false;
}

$(function () {
    $("#print").on("click", function () {
        var mode = 'iframe'; //popup
        var close = mode == "popup";
        var options = {
            mode: mode,
            popClose: close
        };
        $("div.printableArea").printArea(options);
    });
});
</script>
<script>
    $('#example23').DataTable({
        dom: 'Bfrtip',
        buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
    });
</script>


@stop