@extends('layouts.app')

@section('title') Payment Receipt @stop

@section('css')
    <style type="text/css">
        /*.page-wrapper {
        margin-top: -55px;
        padding-bottom: 0px;
    }*/

        .container-fluid {
            padding: 3px 30px 0;
        }

        @media print {
            .page-wrapper {
                font-size: 12px !important;
                font-family: "time-new-roman", Arial, sans-serif !important;
                padding-top: 0px !important;
                padding-bottom: 0;
            }

            h3 {
                margin: 0;
                line-height: 1;
            }

            .white-box {
                border: none !important;
            }
        }
    </style>
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right no-print">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li> @permission('list-dealer')
            <li><a href="#">Payment Receipt</a></li>
        @endpermission
        <li class="active">Receipt Detail</li>
    </ol>
@stop

@section('content')
    <div class="container-fluid">
        <div class="row printableArea" id="content">
            <!-- /row -->
            <br>
            <div class="row no-print">
                <div class="col-sm-12">
                    <div class="white-box">
                        <h3 class="box-title">

                            <div class="row">
                                <div class="col-sm-6" style="margin-top: 1rem;">
                                    <span> Receipt Information</span>
                                </div>

                                <div class="col-sm-6">
                                    <form class="d-flex" style="padding-left: 15rem;" method="post"
                                        onsubmit="return upload_receipt_docs(this , '{{ $receipt->id }}')">
                                        <div class="row">
                                            <div class="col-sm-8">
                                                <span id="error_message" style="color: red;display: none;"></span>

                                                <span id="success_message" style="color: green;display: none;"></span>

                                                <label>Upload Multiple docx <small>(image, pdf, word)</small></label>
                                                <input name="files[]" id="files" class="form-control me-2" multiple
                                                    type="file" aria-label="Search">
                                            </div>

                                            <div class="col-sm-4" style="margin-top: 3.5rem;">
                                                <button id="upload_btn" class="btn btn-outline-success"
                                                    type="submit">Upload</button>
                                            </div>
                                        </div>


                                    </form>
                                </div>
                            </div>

                        </h3>
                        <hr>

                        <div class="table-responsive">
                            <table class="table">
                                <tbody>
                                    <tr>
                                        <td>Receipt #</td>
                                        <td>{{ $receipt->receipt_no }}</td>
                                    </tr>
                                    <tr>
                                        <td>Date</td>
                                        <td>{{ date('d-m-Y', strtotime($receipt->receipt_date)) }}</td>
                                    </tr>
                                    <tr>
                                        <td>Customer</td>
                                        <td>{{ $receipt->customer->name }} </td>
                                    </tr>
                                    <tr>
                                        <td>Unit No.</td>
                                        <td> {{ $receipt->property->inventory ? $receipt->property->inventory->unit_number : '' }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Payment Head</td>
                                        <td>

                                            @if ($receipt->payment_head == \App\CustomerStatement::down_payment)


                                                @if ($receipt->property->booking_type == \App\CustomerProperty::full_payment)
                                                    {{ 'Full Payment' }}
                                                @else
                                                    {{ 'Down Payment' }}
                                                @endif
                                            @elseif($receipt->payment_head == \App\CustomerStatement::possession)
                                                Possession Fee
                                            @elseif($receipt->payment_head == \App\CustomerStatement::installment)
                                                Installment
                                            @elseif($receipt->payment_head == \App\CustomerStatement::other)
                                                Other
                                            @elseif($receipt->payment_head == \App\CustomerStatement::allotment)
                                                Allotment
                                            @elseif($receipt->payment_head == \App\CustomerStatement::confirmation)
                                                Confirmation
                                            @elseif($receipt->payment_head == \App\CustomerStatement::booking)
                                                Booking
                                            @elseif($receipt->payment_head == \App\CustomerStatement::development)
                                                Development
                                            @elseif($receipt->payment_head == \App\CustomerStatement::file_processing)
                                                File Processing
                                            @elseif($receipt->payment_head == \App\CustomerStatement::registration)
                                                Registration
                                            @elseif($receipt->payment_head == \App\CustomerStatement::transfer_fee)
                                                Transfer Fee
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Payment Mode</td>

                                        <td>

                                            @if (!empty($receipt->payment_method))

                                                @if ($receipt->payment_method == \App\Receipt::cash)
                                                    Cash
                                                @elseif($receipt->payment_method == \App\Receipt::bank)
                                                    Bank
                                                @elseif($receipt->payment_method == \App\Receipt::cheque)
                                                    Cheque/ DD/ PO
                                                @else
                                                    Adjustment
                                                @endif
                                            @else
                                                @if ($receipt->payment_mode == \App\Receipt::cash)
                                                    Cash
                                                @elseif($receipt->payment_mode == \App\Receipt::bank)
                                                    Bank
                                                @elseif($receipt->payment_mode == \App\Receipt::cheque)
                                                    Cheque/ DD/ PO
                                                @else
                                                    Adjustment
                                                @endif


                                            @endif



                                        </td>
                                    </tr>

                                    @if (!empty($receipt->cheque_number))
                                        <tr>
                                            <td>Instrument No.</td>
                                            <td> {{ $receipt->cheque_number }} </td>
                                        </tr>
                                    @endif

                                    @if ($receipt->payment_method == \App\Receipt::bank || $receipt->payment_method == \App\Receipt::cheque)
                                        <tr>
                                            <td>Company Account</td>
                                            <td>

                                                @foreach ($cBanks as $company_bank)
                                                    @if ($company_bank->id == $receipt->company_account)
                                                        {{ $company_bank->name }}
                                                    @endif
                                                @endforeach

                                            </td>
                                        </tr>
                                        <tr>
                                            <td>Depositor Bank Account</td>
                                            <td>

                                                @foreach ($banks as $depositor_bank)
                                                    @if ($depositor_bank->id == $receipt->bank_name)
                                                        {{ $depositor_bank->name }}
                                                    @endif
                                                @endforeach

                                            </td>
                                        </tr>
                                    @endif


                                    <tr>
                                        <td>Gross Amount</td>
                                        <td>{{ number_format($receipt->amount) }}</td>
                                    </tr>
                                    <tr>
                                        <td>Tax Amount</td>
                                        <td>
                                            @if ($receipt->tax_paid_by == \App\Receipt::company)
                                                {{ number_format($receipt->tax_amount) }}
                                            @else
                                                {{ number_format(0) }}
                                            @endif
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>Net Amount</td>
                                        @if ($receipt->tax_paid_by == \App\Receipt::company)
                                            <td>{{ number_format($receipt->amount + $receipt->tax_amount) }}</td>
                                        @else
                                            <td>{{ number_format($receipt->amount) }}</td>
                                        @endif
                                    </tr>

                                    <tr>
                                        <td>Tax Pay By</td>
                                        <td>
                                            @if ($receipt->tax_paid_by == \App\Receipt::customer)
                                                Customer
                                            @else
                                                Company
                                            @endif
                                        </td>
                                    </tr>

                                    <tr>
                                        <td>Tax Payment Received</td>
                                        <td>
                                            @if ($receipt->tax_payment_received)
                                                YES
                                            @else
                                                NO
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Notes</td>
                                        <td>{{ $receipt->notes }}</td>
                                    </tr>

                                    @if ($receipt->payment_method == \App\Receipt::adjustment)
                                        <tr>
                                            <td>Adjustment Detail</td>
                                            <td>{{ $receipt->adjustment_detail }}</td>
                                        </tr>

                                        @if ($receipt->dealer_adjustment_unit_id)
                                            <tr>
                                                <td>Rebate Detail</td>
                                                <td>Adjust againt {{ $receipt->rebate->property->inventory->unit_number }}
                                                </td>
                                            </tr>
                                        @endif

                                    @endif

                                </tbody>

                            </table>

                            @if (count($receipt->documents) > 0)
                                <h3 style="margin-top: 5rem;margin-bottom: 3rem;">Receipt Documents</h3>

                                @php
                                    
                                    $images = json_decode($receipt->documents, true);
                                    
                                    $file_ext = ['docx', 'pdf'];
                                    
                                    echo '<div class="row">';
                                    
                                    for ($img = 0; $img < count($images); $img++) {
                                        $url = asset('storage/receipt_documents/' . $images[$img]['document_path']);
                                    
                                        $urlExt = pathinfo($url, PATHINFO_EXTENSION);
                                    
                                        if (!in_array($urlExt, $file_ext)) {
                                            echo '<div class="col-md-2" >
                                        <a target="_blank" href="' .
                                                url('storage/receipt_documents/' . $images[$img]['document_path']) .
                                                '">
                                            <img  title="Image" style="height: 100px;border-radius: 10px;" class="img-responsive" src="' .
                                                url('storage/receipt_documents/' . $images[$img]['document_path']) .
                                                '">
                                        </a>
                                        <a href="' .
                                                route('receipt.document.delete', [$images[$img]['id']]) .
                                                '" style="margin-left: 4rem; color: red;" data-toggle="confirmation" data-title="Are you sure to delete?" >
                                            <i class="fa fa-trash" aria-hidden="true"></i>
                                        </a>
                                    </div>';
                                        }
                                    
                                        if (in_array($urlExt, $file_ext)) {
                                            echo '<div class="col-md-2" >
                                    <a target="_blank" href="' .
                                                url('storage/receipt_documents/' . $images[$img]['document_path']) .
                                                '">
                                        <img title="' .
                                                ucfirst($urlExt) .
                                                ' File" style="height: 100px;border-radius: 10px;" class="img-responsive" src="' .
                                                url('storage/file.jpg') .
                                                '">
                                    </a>
                                    <a href="' .
                                                route('receipt.document.delete', [$images[$img]['id']]) .
                                                '" style="margin-left: 4rem; color: red;" data-toggle="confirmation" data-title="Are you sure to delete?" >
                                        <i class="fa fa-trash" aria-hidden="true"></i>
                                    </a>
                                </div>';
                                        }
                                    }
                                    
                                    echo '</div>';
                                    
                                @endphp
                            @endif

                        </div>

                    </div>

                </div>
            </div>

            <div class="col-lg-12">
                <div class="white-box">

                    <div class="row " style="text-transform: uppercase; font-weight: 600;">

                        <div class="col-sm-12 col-xs-12 text-center">
                            <h3><strong>
                                @if($receipt->property)
                                    @if($receipt->property->inventory->multiProject)
                                        {{ $property->inventory->multiProject->name }}
                                    @endif
                                @endif
                            </strong></h3>
                            <h3><strong>Payment Receipt</strong></h3> <span class="payment">Office Copy</span>
                        </div>

                        <div class="col-sm-12 col-xs-12">

                            <div class="row">

                                <div class="col-sm-4 col-xs-4">
                                    <div class="col-sm-5 col-xs-5 p-0">Receipt No.</div>
                                    <div class="col-sm-7 col-xs-7" style="border-bottom: 1px dotted">&nbsp;
                                        {{ $receipt->receipt_no }}</div>
                                </div>

                                <div class="col-sm-4 col-xs-4"> &nbsp; </div>

                                <div class="col-sm-4 col-xs-4">
                                    <div class="col-sm-2 col-xs-2"><b>Ref.No.</b></div>
                                    <div class="col-sm-10 col-xs-10">{{$receipt->property->membership_no}}</div>
                                    <br>
                                    <div class="col-sm-2 col-xs-2"><b>Date:</b></div>
                                    <div class="col-sm-10 col-xs-10">
                                        <strong>{{ date('d-m-Y', strtotime($receipt->receipt_date)) }}</strong>
                                    </div>
                                </div>

                                <div class="col-sm-4 col-xs-6"> Received with thanks from Mr./Ms./Mrs. </div>

                                <div class="col-sm-8 col-xs-6" style="border-bottom: 1px dotted">&nbsp;
                                    {{ $receipt->customer->name }}</div>
                                <div class="clearfix" style="margin-bottom: 8px"></div>

                                <div class="col-sm-7 col-xs-5">
                                    <div class="col-sm-2 col-xs-2 p-0">CNIC#</div>
                                    <div class="col-sm-10 col-xs-10" style="border-bottom: 1px dotted">&nbsp;

                                        <?php $c = str_split($receipt->customer->cnic, 1); ?>

                                        <?php 
                                    
                                    for($i =0;$i<count($c) ; $i++) { 

                                    ?>

                                        @if ($i == 5 || $i == 12)
                                            -
                                        @endif {{ $c[$i] }}

                                        <?php } ?>

                                    </div>
                                </div>

                                <div class="col-sm-5 col-xs-7">
                                    <div class="col-sm-9 col-xs-9"> On account of Unit No. </div>
                                    <div class="col-sm-3 col-xs-3" style="border-bottom: 1px dotted">
                                        &nbsp;{{ $receipt->property ? ($receipt->property->inventory ? $receipt->property->inventory->unit_number : '') : '' }}
                                    </div>
                                </div>
                                <div class="clearfix" style="margin-bottom: 8px"></div>

                                <div class="col-xs-6 col-sm-6">
                                    Payment Head:

                                    @if ($receipt->payment_head == \App\CustomerStatement::down_payment)


                                        @if ($receipt->property->booking_type == \App\CustomerProperty::full_payment)
                                            {{ 'Full Payment' }}
                                        @else
                                            {{ 'Down Payment' }}
                                        @endif
                                    @elseif($receipt->payment_head == \App\CustomerStatement::possession)
                                        Possession Fee
                                    @elseif($receipt->payment_head == \App\CustomerStatement::installment)
                                        Installment
                                    @elseif($receipt->payment_head == \App\CustomerStatement::other)
                                        Other
                                    @elseif($receipt->payment_head == \App\CustomerStatement::allotment)
                                        Allotment
                                    @elseif($receipt->payment_head == \App\CustomerStatement::confirmation)
                                        Confirmation
                                    @elseif($receipt->payment_head == \App\CustomerStatement::booking)
                                        Booking
                                    @elseif($receipt->payment_head == \App\CustomerStatement::development)
                                        Development
                                    @elseif($receipt->payment_head == \App\CustomerStatement::file_processing)
                                        File Processing
                                    @elseif($receipt->payment_head == \App\CustomerStatement::registration)
                                        Registration
                                    @elseif($receipt->payment_head == \App\CustomerStatement::transfer_fee)
                                        Transfer Fee
                                    @endif


                                </div>


                                <div class="col-xs-6 col-sm-6">
                                    Payment Mode:


                                    @if (!empty($receipt->payment_method))

                                        @if ($receipt->payment_method == \App\Receipt::cash)
                                            Cash
                                        @elseif($receipt->payment_method == \App\Receipt::bank)
                                            Bank
                                        @elseif($receipt->payment_method == \App\Receipt::cheque)
                                            Cheque/ DD/ PO
                                        @else
                                            Adjustment
                                        @endif
                                    @else
                                        @if ($receipt->payment_mode == \App\Receipt::cash)
                                            Cash
                                        @elseif($receipt->payment_mode == \App\Receipt::bank)
                                            Bank
                                        @elseif($receipt->payment_mode == \App\Receipt::cheque)
                                            Cheque/ DD/ PO
                                        @else
                                            Adjustment
                                        @endif


                                    @endif

                                </div>

                                @if ($receipt->payment_method == \App\Receipt::adjustment)


                                    <div class="col-xs-6 col-sm-6" style="margin-top: 1rem;">

                                        Adjustment Type:

                                        @if ($receipt->adjustment_type == \App\Receipt::property)
                                            Property
                                        @elseif($receipt->adjustment_type == \App\Receipt::vehicle)
                                            Vehicle
                                        @elseif($receipt->adjustment_type == \App\Receipt::rebate)
                                            Rebate &nbsp;&nbsp;<span>(
                                                {{ $receipt->rebate->property->inventory->unit_number }} )</span>
                                        @elseif($receipt->adjustment_type == \App\Receipt::vendor)
                                            Vendor bill &nbsp;&nbsp;<span>( PO-{{ $receipt->vendor_purchase_order_id }}
                                                )</span>
                                        @elseif($receipt->adjustment_type == \App\Receipt::token_receipt)
                                            Token
                                        @elseif($receipt->adjustment_type == \App\Receipt::others)
                                            Others
                                        @endif


                                    </div>


                                    <div class="col-xs-6 col-sm-6" style="margin-top: 1rem;">

                                        Adjustment Details .
                                        <span>{{ $receipt->adjustment_detail }}</span>

                                    </div>


                                @endif


                                @if ($receipt->tax_paid_by == \App\Receipt::company)
                                    <div class="col-xs-6 col-sm-6" style="margin-top: 1rem;">
                                        Tax Amount: &nbsp;&nbsp;&nbsp;{{ number_format($receipt->tax_amount) }}

                                    </div>
                                @endif


                                @if ($receipt->payment_method == \App\Receipt::bank || $receipt->payment_method == \App\Receipt::cheque)
                                    <div class="col-xs-4 col-sm-4">
                                        <span class="pull-left">Instruement No.&nbsp;</span>
                                        <div style="border-bottom: 1px dotted;display: flex;">
                                            {{ $receipt->cheque_number }}
                                            <strong></strong>
                                        </div>
                                    </div>

                                    <div class="col-xs-2 col-sm-2">
                                        <b>Drawn ON:</b>
                                        <strong>{{ date('d-m-Y', strtotime($receipt->drawn_date)) }}</strong>
                                    </div>
                                @endif

                                <div class="clearfix" style="margin-bottom: 8px"></div>

                                <div class="col-sm-1 col-xs-1">PKR</div>
                                <div class="col-xs-11 col-sm-11" style="border-bottom: 1px dotted; text-align: center;">
                                    &nbsp;<strong>
                                        @if ($receipt->tax_paid_by == \App\Receipt::company)
                                            {{ number_format($receipt->amount + $receipt->tax_amount) }}
                                        @else
                                            {{ number_format($receipt->amount) }}
                                        @endif
                                    </strong></div>
                                <div class="clearfix" style="margin-bottom: 8px"></div>

                                <div class="col-xs-4 col-sm-3">Amount in words (PKR)</div>
                                <div class="col-sm-9 col-xs-8"><b>{{ $words }} only</b></div>
                                <div class="clearfix" style="margin-bottom: 70px"></div>

                                <div class="col-xs-8 col-sm-8">
                                    <b style="border-top: 1px solid;">Payment Received By</b>
                                </div>
                                <div class="col-sm-4 col-xs-4">
                                    <b style="border-top: 1px solid;">Payment Approved By</b>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="sperator"></div>

            <div class="col-lg-12">
                <div class="white-box">

                    <div class="row " style="text-transform: uppercase; font-weight: 600;">

                        <div class="col-sm-12 col-xs-12 text-center">
                            <h3><strong>
                                @if($receipt->property)
                                    @if($receipt->property->inventory->multiProject)
                                        {{ $property->inventory->multiProject->name }}
                                    @endif
                                @endif
                            </strong></h3>
                            <h3><strong>Payment Receipt</strong></h3> <span class="payment">Accounts Copy</span>
                        </div>

                        <div class="col-sm-12 col-xs-12">

                            <div class="row">

                                <div class="col-sm-4 col-xs-4">
                                    <div class="col-sm-5 col-xs-5 p-0">Receipt No.</div>
                                    <div class="col-sm-7 col-xs-7" style="border-bottom: 1px dotted">&nbsp;
                                        {{ $receipt->receipt_no }}</div>
                                </div>

                                <div class="col-sm-4 col-xs-4"> &nbsp; </div>

                                <div class="col-sm-4 col-xs-4">
                                    <div class="col-sm-2 col-xs-2"><b>Ref.No.</b></div>
                                    <div class="col-sm-10 col-xs-10">{{ $receipt->property->membership_no }}</div>
                                    <br>
                                    <div class="col-sm-2 col-xs-2"><b>Date:</b></div>
                                    <div class="col-sm-10 col-xs-10">
                                        <strong>{{ date('d-m-Y', strtotime($receipt->receipt_date)) }}</strong>
                                    </div>
                                </div>

                                <div class="col-sm-4 col-xs-6"> Received with thanks from Mr./Ms./Mrs. </div>

                                <div class="col-sm-8 col-xs-6" style="border-bottom: 1px dotted">&nbsp;
                                    {{ $receipt->customer->name }}</div>
                                <div class="clearfix" style="margin-bottom: 8px"></div>

                                <div class="col-sm-7 col-xs-5">
                                    <div class="col-sm-2 col-xs-2 p-0">CNIC#</div>
                                    <div class="col-sm-10 col-xs-10" style="border-bottom: 1px dotted">&nbsp;

                                        <?php $c = str_split($receipt->customer->cnic, 1); ?>

                                        <?php 
                                    
                                    for($i =0;$i<count($c) ; $i++) { 

                                    ?>

                                        @if ($i == 5 || $i == 12)
                                            -
                                        @endif {{ $c[$i] }}

                                        <?php } ?>

                                    </div>
                                </div>

                                <div class="col-sm-5 col-xs-7">
                                    <div class="col-sm-9 col-xs-9"> On account of Unit No. </div>
                                    <div class="col-sm-3 col-xs-3" style="border-bottom: 1px dotted">
                                        &nbsp;{{ $receipt->property ? ($receipt->property->inventory ? $receipt->property->inventory->unit_number : '') : '' }}
                                    </div>
                                </div>
                                <div class="clearfix" style="margin-bottom: 8px"></div>

                                <div class="col-xs-6 col-sm-6">
                                    Payment Head:

                                    @if ($receipt->payment_head == \App\CustomerStatement::down_payment)


                                        @if ($receipt->property->booking_type == \App\CustomerProperty::full_payment)
                                            {{ 'Full Payment' }}
                                        @else
                                            {{ 'Down Payment' }}
                                        @endif
                                    @elseif($receipt->payment_head == \App\CustomerStatement::possession)
                                        Possession Fee
                                    @elseif($receipt->payment_head == \App\CustomerStatement::installment)
                                        Installment
                                    @elseif($receipt->payment_head == \App\CustomerStatement::other)
                                        Other
                                    @elseif($receipt->payment_head == \App\CustomerStatement::allotment)
                                        Allotment
                                    @elseif($receipt->payment_head == \App\CustomerStatement::confirmation)
                                        Confirmation
                                    @elseif($receipt->payment_head == \App\CustomerStatement::booking)
                                        Booking
                                    @elseif($receipt->payment_head == \App\CustomerStatement::development)
                                        Development
                                    @elseif($receipt->payment_head == \App\CustomerStatement::file_processing)
                                        File Processing
                                    @elseif($receipt->payment_head == \App\CustomerStatement::registration)
                                        Registration
                                    @elseif($receipt->payment_head == \App\CustomerStatement::transfer_fee)
                                        Transfer Fee
                                    @endif


                                </div>


                                <div class="col-xs-6 col-sm-6">
                                    Payment Mode:


                                    @if (!empty($receipt->payment_method))

                                        @if ($receipt->payment_method == \App\Receipt::cash)
                                            Cash
                                        @elseif($receipt->payment_method == \App\Receipt::bank)
                                            Bank
                                        @elseif($receipt->payment_method == \App\Receipt::cheque)
                                            Cheque/ DD/ PO
                                        @else
                                            Adjustment
                                        @endif
                                    @else
                                        @if ($receipt->payment_mode == \App\Receipt::cash)
                                            Cash
                                        @elseif($receipt->payment_mode == \App\Receipt::bank)
                                            Bank
                                        @elseif($receipt->payment_mode == \App\Receipt::cheque)
                                            Cheque/ DD/ PO
                                        @else
                                            Adjustment
                                        @endif


                                    @endif
                                </div>

                                @if ($receipt->payment_method == \App\Receipt::adjustment)


                                    <div class="col-xs-6 col-sm-6" style="margin-top: 1rem;">

                                        Adjustment Type:

                                        @if ($receipt->adjustment_type == \App\Receipt::property)
                                            Property
                                        @elseif($receipt->adjustment_type == \App\Receipt::vehicle)
                                            Vehicle
                                        @elseif($receipt->adjustment_type == \App\Receipt::rebate)
                                            Rebate &nbsp;&nbsp;<span>(
                                                {{ $receipt->rebate->property->inventory->unit_number }} )</span>
                                        @elseif($receipt->adjustment_type == \App\Receipt::vendor)
                                            Vendor bill &nbsp;&nbsp;<span>( PO-{{ $receipt->vendor_purchase_order_id }}
                                                )</span>
                                        @elseif($receipt->adjustment_type == \App\Receipt::token_receipt)
                                            Token
                                        @elseif($receipt->adjustment_type == \App\Receipt::others)
                                            Others
                                        @endif


                                    </div>


                                    <div class="col-xs-6 col-sm-6" style="margin-top: 1rem;">


                                        Adjustment Details .
                                        <span>{{ $receipt->adjustment_detail }}</span>

                                    </div>


                                @endif


                                @if ($receipt->tax_paid_by == \App\Receipt::company)
                                    <div class="col-xs-6 col-sm-6" style="margin-top: 1rem;">
                                        Tax Amount: &nbsp;&nbsp;&nbsp;{{ number_format($receipt->tax_amount) }}

                                    </div>
                                @endif


                                @if ($receipt->payment_method == \App\Receipt::bank || $receipt->payment_method == \App\Receipt::cheque)
                                    <div class="col-xs-4 col-sm-4">
                                        <span class="pull-left">Instruement No.&nbsp;</span>
                                        <div style="border-bottom: 1px dotted;display: flex;">
                                            {{ $receipt->cheque_number }}
                                            <strong></strong>
                                        </div>
                                    </div>

                                    <div class="col-xs-2 col-sm-2">
                                        <b>Drawn ON:</b>
                                        <strong>{{ date('d-m-Y', strtotime($receipt->drawn_date)) }}</strong>
                                    </div>
                                @endif

                                <div class="clearfix" style="margin-bottom: 8px"></div>

                                <div class="col-sm-1 col-xs-1">PKR</div>
                                <div class="col-xs-11 col-sm-11" style="border-bottom: 1px dotted; text-align: center;">
                                    &nbsp;<strong>
                                        @if ($receipt->tax_paid_by == \App\Receipt::company)
                                            {{ number_format($receipt->amount + $receipt->tax_amount) }}
                                        @else
                                            {{ number_format($receipt->amount) }}
                                        @endif
                                    </strong></div>
                                <div class="clearfix" style="margin-bottom: 8px"></div>

                                <div class="col-xs-4 col-sm-3">Amount in words (PKR)</div>
                                <div class="col-sm-9 col-xs-8"><b>{{ $words }} only</b></div>
                                <div class="clearfix" style="margin-bottom: 70px"></div>

                                <div class="col-xs-8 col-sm-8">
                                    <b style="border-top: 1px solid;">Payment Received By</b>
                                </div>
                                <div class="col-sm-4 col-xs-4">
                                    <b style="border-top: 1px solid;">Payment Approved By</b>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="sperator"></div>

            <div class="col-lg-12">
                <div class="white-box">

                    <div class="row " style="text-transform: uppercase; font-weight: 600;">

                        <div class="col-sm-12 col-xs-12 text-center">
                            <h3><strong>
                                @if($receipt->property)
                                    @if($receipt->property->inventory->multiProject)
                                        {{ $property->inventory->multiProject->name }}
                                    @endif
                                @endif
                            </strong></h3>
                            <h3><strong>Payment Receipt</strong></h3> <span class="payment">Client Copy</span>
                        </div>

                        <div class="col-sm-12 col-xs-12">

                            <div class="row">

                                <div class="col-sm-4 col-xs-4">
                                    <div class="col-sm-5 col-xs-5 p-0">Receipt No.</div>
                                    <div class="col-sm-7 col-xs-7" style="border-bottom: 1px dotted">&nbsp;
                                        {{ $receipt->receipt_no }}</div>
                                </div>

                                <div class="col-sm-4 col-xs-4"> &nbsp; </div>

                                <div class="col-sm-4 col-xs-4">
                                    <div class="col-sm-2 col-xs-2"><b>Ref.No.</b></div>
                                    <div class="col-sm-10 col-xs-10">{{ $receipt->property->membership_no }}</div>
                                    <br>
                                    <div class="col-sm-2 col-xs-2"><b>Date:</b></div>
                                    <div class="col-sm-10 col-xs-10">
                                        <strong>{{ date('d-m-Y', strtotime($receipt->receipt_date)) }}</strong>
                                    </div>
                                </div>

                                <div class="col-sm-4 col-xs-6"> Received with thanks from Mr./Ms./Mrs. </div>

                                <div class="col-sm-8 col-xs-6" style="border-bottom: 1px dotted">&nbsp;
                                    {{ $receipt->customer->name }}</div>
                                <div class="clearfix" style="margin-bottom: 8px"></div>

                                <div class="col-sm-7 col-xs-5">
                                    <div class="col-sm-2 col-xs-2 p-0">CNIC#</div>
                                    <div class="col-sm-10 col-xs-10" style="border-bottom: 1px dotted">&nbsp;

                                        <?php $c = str_split($receipt->customer->cnic, 1); ?>

                                        <?php 
                                    
                                    for($i =0;$i<count($c) ; $i++) { 

                                    ?>

                                        @if ($i == 5 || $i == 12)
                                            -
                                        @endif {{ $c[$i] }}

                                        <?php } ?>

                                    </div>
                                </div>

                                <div class="col-sm-5 col-xs-7">
                                    <div class="col-sm-9 col-xs-9"> On account of Unit No. </div>
                                    <div class="col-sm-3 col-xs-3" style="border-bottom: 1px dotted">
                                        &nbsp;{{ $receipt->property ? ($receipt->property->inventory ? $receipt->property->inventory->unit_number : '') : '' }}
                                    </div>
                                </div>
                                <div class="clearfix" style="margin-bottom: 8px"></div>

                                <div class="col-xs-6 col-sm-6">
                                    Payment Head:


                                    @if ($receipt->payment_head == \App\CustomerStatement::down_payment)


                                        @if ($receipt->property->booking_type == \App\CustomerProperty::full_payment)
                                            {{ 'Full Payment' }}
                                        @else
                                            {{ 'Down Payment' }}
                                        @endif
                                    @elseif($receipt->payment_head == \App\CustomerStatement::possession)
                                        Possession Fee
                                    @elseif($receipt->payment_head == \App\CustomerStatement::installment)
                                        Installment
                                    @elseif($receipt->payment_head == \App\CustomerStatement::other)
                                        Other
                                    @elseif($receipt->payment_head == \App\CustomerStatement::allotment)
                                        Allotment
                                    @elseif($receipt->payment_head == \App\CustomerStatement::confirmation)
                                        Confirmation
                                    @elseif($receipt->payment_head == \App\CustomerStatement::booking)
                                        Booking
                                    @elseif($receipt->payment_head == \App\CustomerStatement::development)
                                        Development
                                    @elseif($receipt->payment_head == \App\CustomerStatement::file_processing)
                                        File Processing
                                    @elseif($receipt->payment_head == \App\CustomerStatement::registration)
                                        Registration
                                    @elseif($receipt->payment_head == \App\CustomerStatement::transfer_fee)
                                        Transfer Fee
                                    @endif





                                </div>


                                <div class="col-xs-6 col-sm-6">
                                    Payment Mode:


                                    @if (!empty($receipt->payment_method))

                                        @if ($receipt->payment_method == \App\Receipt::cash)
                                            Cash
                                        @elseif($receipt->payment_method == \App\Receipt::bank)
                                            Bank
                                        @elseif($receipt->payment_method == \App\Receipt::cheque)
                                            Cheque/ DD/ PO
                                        @else
                                            Adjustment
                                        @endif
                                    @else
                                        @if ($receipt->payment_mode == \App\Receipt::cash)
                                            Cash
                                        @elseif($receipt->payment_mode == \App\Receipt::bank)
                                            Bank
                                        @elseif($receipt->payment_mode == \App\Receipt::cheque)
                                            Cheque/ DD/ PO
                                        @else
                                            Adjustment
                                        @endif


                                    @endif

                                </div>

                                @if ($receipt->payment_method == \App\Receipt::adjustment)


                                    <div class="col-xs-6 col-sm-6" style="margin-top: 1rem;">

                                        Adjustment Type:

                                        @if ($receipt->adjustment_type == \App\Receipt::property)
                                            Property
                                        @elseif($receipt->adjustment_type == \App\Receipt::vehicle)
                                            Vehicle
                                        @elseif($receipt->adjustment_type == \App\Receipt::rebate)
                                            Rebate &nbsp;&nbsp;<span>(
                                                {{ $receipt->rebate->property->inventory->unit_number }} )</span>
                                        @elseif($receipt->adjustment_type == \App\Receipt::vendor)
                                            Vendor bill &nbsp;&nbsp;<span>( PO-{{ $receipt->vendor_purchase_order_id }}
                                                )</span>
                                        @elseif($receipt->adjustment_type == \App\Receipt::token_receipt)
                                            Unit Token
                                        @elseif($receipt->adjustment_type == \App\Receipt::others)
                                            Others
                                        @endif


                                    </div>


                                    <div class="col-xs-6 col-sm-6" style="margin-top: 1rem;">


                                        Adjustment Details .
                                        <span>{{ $receipt->adjustment_detail }}</span>

                                    </div>


                                @endif


                                @if ($receipt->tax_paid_by == \App\Receipt::company)
                                    <div class="col-xs-6 col-sm-6" style="margin-top: 1rem;">
                                        Tax Amount: &nbsp;&nbsp;&nbsp;{{ number_format($receipt->tax_amount) }}

                                    </div>
                                @endif


                                @if ($receipt->payment_method == \App\Receipt::bank || $receipt->payment_method == \App\Receipt::cheque)
                                    <div class="col-xs-4 col-sm-4">
                                        <span class="pull-left">Instruement No.&nbsp;</span>
                                        <div style="border-bottom: 1px dotted;display: flex;">
                                            {{ $receipt->cheque_number }}
                                            <strong></strong>
                                        </div>
                                    </div>

                                    <div class="col-xs-2 col-sm-2">
                                        <b>Drawn ON:</b>
                                        <strong>{{ date('d-m-Y', strtotime($receipt->drawn_date)) }}</strong>
                                    </div>
                                @endif

                                <div class="clearfix" style="margin-bottom: 8px"></div>

                                <div class="col-sm-1 col-xs-1">PKR</div>
                                <div class="col-xs-11 col-sm-11" style="border-bottom: 1px dotted; text-align: center;">
                                    &nbsp;<strong>
                                        @if ($receipt->tax_paid_by == \App\Receipt::company)
                                            {{ number_format($receipt->amount + $receipt->tax_amount) }}
                                        @else
                                            {{ number_format($receipt->amount) }}
                                        @endif
                                    </strong></div>
                                <div class="clearfix" style="margin-bottom: 8px"></div>

                                <div class="col-xs-4 col-sm-3">Amount in words (PKR)</div>
                                <div class="col-sm-9 col-xs-8"><b>{{ $words }} only</b></div>
                                <div class="clearfix" style="margin-bottom: 70px"></div>

                                <div class="col-xs-8 col-sm-8">
                                    <b style="border-top: 1px solid;">Payment Received By</b>
                                </div>
                                <div class="col-sm-4 col-xs-4">
                                    <b style="border-top: 1px solid;">Payment Approved By</b>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <div style="display: inline-block; ">
            <div class="text-right no-print" style="display: inline-block; margin-bottom: 95px">
                <button class="btn btn-default btn-outline" onclick="window.print();return false;" type="button">
                    <span><i class="fa fa-print"></i> Print</span> </button>
            </div>
        </div>

    </div>
    <!-- /.container-fluid -->



@stop

@section('js')

    <script src="{{ asset('js/jquery.PrintArea.js') }}" type="text/JavaScript"></script>
    <script>
        function upload_receipt_docs(self, receipt_id) {
            $('#upload_btn').html('Uploading...')
            $('#upload_btn').prop('disabled', true)

            var form_data = new FormData();

            // Read selected files
            var totalfiles = document.getElementById('files').files.length;

            for (var index = 0; index < totalfiles; index++) {
                form_data.append("files[]", document.getElementById('files').files[index]);
            }

            form_data.append("receipt_id", receipt_id);


            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            // AJAX request
            $.ajax({
                url: "{{ route('receipt.document') }}",
                type: 'post',
                data: form_data,
                dataType: 'json',
                contentType: false,
                processData: false,
                success: function(data) {

                    if (data.response == 'yes') {
                        $('#success_message').html('Uploaded')
                        $('#success_message').show()
                        $('#error_message').hide()
                        location.reload(true);
                    } else if (data.response == 'invalid_document') {
                        $('#upload_btn').html('Upload')
                        $('#upload_btn').prop('disabled', false)
                        $('#error_message').html(data.message)
                        $('#error_message').show()
                    } else {
                        alert('Error! sonething went wrong.')
                        location.reload(true);
                    }

                }
            });



            return false;
        }

        $(function() {
            $("#print").on("click", function() {
                var mode = 'iframe'; //popup
                var close = mode == "popup";
                var options = {
                    mode: mode,
                    popClose: close
                };
                $("div.printableArea").printArea(options);
            });
        });
    </script>
    <script>
        $('#example23').DataTable({
            dom: 'Bfrtip',
            buttons: [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ]
        });
    </script>


@stop
