@extends('layouts.app')

@section('title')
    Edit Receipt
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Edit Receipt</li>
    </ol>
@stop

@section('content')

    <div class="container-fluid">
        <form method="post" action="{{ route('receipt.update') }}" class="form-horizontal">
            {{ csrf_field() }}
            <input type='hidden' name='id' value="{{ $receipt->id }}">
            <input type='hidden' name='statement_id' value="{{ $receipt->statement ? $receipt->statement->id : null }}">
            <div class="row">
                <div class="col-lg-12 col-sm-12 col-xs-12">
                    @if ($errors->any())
                        <div class="white-box">
                            <h2>Errors</h2>
                            <ul>
                                {!! implode('', $errors->all('<li><span class="help-block"><strong>:message</strong></span></li>')) !!}
                            </ul>
                        </div>
                    @endif
                    <div class="white-box">
                        <h3 class="box-title">Payment Information</h3>
                        <hr>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Select Customer <span
                                        style="color: red">*</span></label>
                                <div class="col-md-8">
                                    <select name="customer_id" id='customer_id' class="form-control chosen-select">
                                        <option value="" selected="">None</option>
                                        @foreach ($customers as $customer)
                                            @if ($receipt->customer_id == $customer->id)
                                                <option selected="" value="{{ $customer->id }}">{{ $customer->name }} -
                                                    {{ $customer->cnic }}</option>
                                            @else
                                                <option value="{{ $customer->id }}">{{ $customer->name }} -
                                                    {{ $customer->cnic }}</option>
                                            @endif
                                        @endforeach

                                    </select>
                                    @if ($errors->has('customer_id'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('customer_id') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="clearfix"></div>
                        <div class="col-md-12" id='property'>
                            <b>Pick one unit</b>
                            <div class="table-responsive">
                                <table id="myTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th></th>
                                            <th>Unit No.</th>
                                            <th>Net Amount of unit</th>
                                            <th>Received Amount</th>
                                            <th>Remaining Amount</th>
                                            <th>Last Payment Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        @foreach ($properties as $property)
                                            <tr>
                                                @if ($receipt->customer_property_id == $property->id)
                                                    <td><input type="radio" checked="" style="zoom: 1.4;" required
                                                            name='customer_property_id' value='{{ $property->id }}'></td>
                                                    <td>{{ $property->inventory->unit_number }}</td>
                                                    <td>{{ number_format($property->net_pay) }} PKR</td>
                                                    <td>{{ number_format($receivedAmount[$property->id]) }} PKR</td>
                                                    <td>{{ number_format($remainingAmount[$property->id]) }} PKR</td>
                                                    <td> {{ $lastDate[$property->id] ? date('d-m-Y', strtotime($lastDate[$property->id]->receipt_date)) : '' }}
                                                    </td>
                                                @else
                                                    <!--                                            <td><input type="radio" disabled="" required name='customer_property_id' value='{{ $property->id }}' ></td>

                                               <td>{{ $property->floor . ' ' . $property->unit_no }}</td>
                                                <td>{{ number_format($property->net_pay) }} PKR</td>
                                                <td>{{ number_format($receivedAmount[$property->id]) }} PKR</td>
                                                <td>{{ number_format($remainingAmount[$property->id]) }} PKR</td>
                                                 <td> {{ $lastDate[$property->id] ? date('d-m-Y', strtotime($lastDate[$property->id]->receipt_date)) : '' }}</td>
                                              -->
                                                @endif
                                            </tr>
                                        @endforeach


                                    </tbody>
                                </table>
                            </div>

                        </div>

                        <div class="clearfix"></div>
                        <br>
                        <br>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Payment Head <span style="color: red">*</span></label>
                                <div class="col-md-8">
                                    <select class="form-control chosen-select" name="payment_head">

                                        <option
                                            <?= $receipt->payment_head == \App\Receipt::down_payment ? 'selected' : '' ?>
                                            value="{{ \App\Receipt::down_payment }}">Down Payment</option>

                                        <option <?= $receipt->payment_head == \App\Receipt::installment ? 'selected' : '' ?>
                                            value="{{ \App\Receipt::installment }}">Installment</option>

                                        <option
                                            <?= $receipt->payment_head == \App\Receipt::possession_fee ? 'selected' : '' ?>
                                            value="{{ \App\Receipt::possession_fee }}">Possession</option>

                                        <option <?= $receipt->payment_head == \App\Receipt::allotment ? 'selected' : '' ?>
                                            value="{{ \App\Receipt::allotment }}">Allotment</option>

                                        <option
                                            <?= $receipt->payment_head == \App\Receipt::confirmation ? 'selected' : '' ?>
                                            value="{{ \App\Receipt::confirmation }}">Confirmation</option>

                                        <option <?= $receipt->payment_head == \App\Receipt::booking ? 'selected' : '' ?>
                                            value="{{ \App\Receipt::booking }}">Booking</option>


                                        <option <?= $receipt->payment_head == \App\Receipt::development ? 'selected' : '' ?>
                                            value="{{ \App\Receipt::development }}">Development</option>

                                        <option
                                            <?= $receipt->payment_head == \App\Receipt::file_processing ? 'selected' : '' ?>
                                            value="{{ \App\Receipt::file_processing }}">File Processing</option>

                                        <option
                                            <?= $receipt->payment_head == \App\Receipt::registration ? 'selected' : '' ?>
                                            value="{{ \App\Receipt::registration }}">Registration</option>

                                        <option <?= $receipt->payment_head == \App\Receipt::other ? 'selected' : '' ?>
                                            value="{{ \App\Receipt::other }}">Other</option>

                                    </select>

                                    @if ($errors->has('payment_head'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('payment_head') }}</strong>
                                        </span>
                                    @endif

                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Payment Method <span
                                        style="color: red">*</span></label>
                                <div class="col-md-8">
                                    <select class="form-control chosen-select" id='payment_mode' name='payment_mode'
                                        onchange="changeFunc(this.value)">
                                        @if ($receipt->payment_method == \App\Receipt::cash)
                                            <option value="{{ \App\Receipt::cash }}" selected="">Cash</option>
                                            <option value="{{ \App\Receipt::bank }}">Bank Transfer</option>
                                            <option value="{{ \App\Receipt::cheque }}">Cheque</option>
                                            <!-- <option value="{{ \App\Receipt::adjustment }}" >Adjustment</option> -->
                                        @elseif($receipt->payment_method == \App\Receipt::bank)
                                            <option value="{{ \App\Receipt::cash }}">Cash</option>
                                            <option value="{{ \App\Receipt::bank }}" selected="">Bank Transfer</option>
                                            <option value="{{ \App\Receipt::cheque }}">Cheque</option>
                                            <!-- <option value="{{ \App\Receipt::adjustment }}" >Adjustment</option> -->
                                        @elseif($receipt->payment_method == \App\Receipt::cheque)
                                            <option value="{{ \App\Receipt::cash }}">Cash</option>
                                            <option value="{{ \App\Receipt::bank }}">Bank Transfer</option>
                                            <option value="{{ \App\Receipt::cheque }}" selected="">Cheque</option>
                                            <option value="{{ \App\Receipt::adjustment }}">Adjustment</option>
                                        @elseif($receipt->payment_method == \App\Receipt::adjustment)
                                            <option value="{{ \App\Receipt::cash }}">Cash</option>
                                            <option value="{{ \App\Receipt::bank }}">Bank Transfer</option>
                                            <option value="{{ \App\Receipt::cheque }}">Cheque</option>
                                            <option value="{{ \App\Receipt::adjustment }}" selected="">Adjustment
                                            </option>
                                        @else
                                            <option selected='' value="{{ \App\Receipt::cash }}" selected="">Cash
                                            </option>
                                            <option value="{{ \App\Receipt::bank }}">Bank Transfer</option>
                                            <option value="{{ \App\Receipt::cheque }}">Cheque</option>
                                            <!-- <option value="{{ \App\Receipt::adjustment }}" >Adjustment</option> -->
                                        @endif
                                    </select>
                                    @if ($errors->has('payment_mode'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('payment_mode') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        @if ($receipt->payment_mode == \App\Receipt::adjustment)
                            <div id='adjustment'>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">Adjustment Type <span
                                                style="color: red">*</span></label>
                                        <div class="col-md-8">
                                            <select class="form-control chosen-select" name='adjustment_type'>
                                                @if ($receipt->adjustment_type == \App\ProjectAccount::property)
                                                    <option value="{{ \App\ProjectAccount::property }}" selected="">
                                                        Property</option>
                                                    <option value="{{ \App\ProjectAccount::vehicle }}">Vehicle</option>
                                                @elseif($receipt->adjustment_type == \App\ProjectAccount::property)
                                                    <option value="{{ \App\ProjectAccount::property }}">Property</option>
                                                    <option value="{{ \App\ProjectAccount::vehicle }}" selected="">
                                                        Vehicle</option>
                                                @else
                                                    <option selected='' value="{{ \App\ProjectAccount::property }}"
                                                        selected="">Property</option>
                                                    <option value="{{ \App\ProjectAccount::vehicle }}">Vehicle</option>
                                                @endif
                                            </select>
                                            @if ($errors->has('adjustment_type'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('adjustment_type') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">Adjustment Detail <span
                                                style="color: red">*</span></label>
                                        <div class="col-md-8">
                                            <textarea name="adjustment_detail" class="form-control">{{ $receipt->adjustment_detail }}</textarea>

                                            @if ($errors->has('adjustment_detail'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('adjustment_detail') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @else
                            <div id='adjustment' style="display: none;">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">Adjustment Type <span
                                                style="color: red">*</span></label>
                                        <div class="col-md-8">
                                            <select class="form-control chosen-select" name='adjustment_type'>
                                                @if (old('adjustment_type') == \App\ProjectAccount::property)
                                                    <option value="{{ \App\ProjectAccount::property }}" selected="">
                                                        Property</option>
                                                    <option value="{{ \App\ProjectAccount::vehicle }}">Vehicle</option>
                                                @elseif(old('adjustment_type') == \App\ProjectAccount::property)
                                                    <option value="{{ \App\ProjectAccount::property }}">Property</option>
                                                    <option value="{{ \App\ProjectAccount::vehicle }}" selected="">
                                                        Vehicle</option>
                                                @else
                                                    <option selected='' value="{{ \App\ProjectAccount::property }}"
                                                        selected="">Property</option>
                                                    <option value="{{ \App\ProjectAccount::vehicle }}">Vehicle</option>
                                                @endif
                                            </select>
                                            @if ($errors->has('adjustment_type'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('adjustment_type') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="control-label col-md-4">Adjustment Detail <span
                                                style="color: red">*</span></label>
                                        <div class="col-md-8">
                                            <textarea name="adjustment_detail" class="form-control"></textarea>

                                            @if ($errors->has('adjustment_detail'))
                                                <span class="help-block">
                                                    <strong>{{ $errors->first('adjustment_detail') }}</strong>
                                                </span>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>

                        @endif

                        @if ($receipt->payment_mode !== \App\Receipt::cash && $receipt->payment_mode !== \App\Receipt::adjustment)
                            <div class="col-md-6" id='bank'>
                                <div class="form-group">
                                    <label class="control-label col-md-4">Depositor Bank Name <span
                                        style="color:red;">*</span></label>
                                    <div class="col-md-8">
                                        <select name="bank_name" class="form-control chosen-select">
                                            <option value="" selected="">None</option>
                                            @foreach ($banks as $bank)
                                                @if ($receipt->bank_name == $bank->id)
                                                    <option selected="" value="{{ $bank->id }}">
                                                        {{ $bank->name }}</option>
                                                @else
                                                    <option value="{{ $bank->id }}">{{ $bank->name }}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                        @if ($errors->has('bank_name'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('bank_name') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6" id="cheque-dd-po-drawn-date"  >
                                <div class="form-group">
                                    <label class="control-label col-md-4"><span id="date_type"> Drawn Date</span> <span
                                            style="color:red;">*</span></label>
                                    <div class="col-md-8">
                                        <input type="date" class="form-control" name='drawn_date' value="{{$receipt->drawn_date}}"
                                            id="exampleInputEmail1" placeholder="Enter Receipt Date">
                                        @if ($errors->has('drawn_date'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('drawn_date') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                            
                        @else
                        <div class="col-md-6" id="cheque-dd-po-drawn-date"  style="display: none;">
                            <div class="form-group">
                                <label class="control-label col-md-4"><span id="date_type"> Drawn Date</span> <span
                                        style="color:red;">*</span></label>
                                <div class="col-md-8">
                                    <input type="date" class="form-control" name='drawn_date' 
                                        id="exampleInputEmail1" placeholder="Enter Receipt Date">
                                    @if ($errors->has('drawn_date'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('drawn_date') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                            <div class="col-md-6" id='bank' style="display: none;">
                                <div class="form-group">
                                    <label class="control-label col-md-4">Depositor Bank Name <span
                                        style="color:red;">*</span></label>
                                    <div class="col-md-8">
                                        <select name="bank_name" class="form-control chosen-select">
                                            <option value="" selected="">None</option>
                                            @foreach ($banks as $bank)
                                                @if ($receipt->bank_name == $bank->id)
                                                    <option selected="" value="{{ $bank->id }}">
                                                        {{ $bank->name ? $bank->name : '' }}</option>
                                                @else
                                                    <option value="{{ $bank->id }}">
                                                        {{ $bank->name ? $bank->name : '' }}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                        @if ($errors->has('bank_name'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('bank_name') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if ($receipt->payment_mode !== \App\Receipt::cash && $receipt->payment_mode !== \App\Receipt::adjustment)
                            <div class="col-md-6" id='company-bank'>
                                <div class="form-group">
                                    <label class="control-label col-md-4">Company Account <span
                                        style="color:red;">*</span></label>
                                    <div class="col-md-8">
                                        <select name="company_account" class="form-control chosen-select">
                                            <option value="" selected="">None</option>
                                            @foreach ($cBanks as $bank)
                                                @if ($receipt->company_account == $bank->id)
                                                    <option selected="" value="{{ $bank->id }}">
                                                        {{ $bank->name }} - {{ $bank->account_number }}</option>
                                                @else
                                                    <option value="{{ $bank->id }}">{{ $bank->name }} -
                                                        {{ $bank->account_number }}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                        @if ($errors->has('company_account'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('company_account') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @else
                            <div class="col-md-6" id='bank' style="display: none;">
                                <div class="form-group">
                                    <label class="control-label col-md-4">Company Account <span
                                        style="color:red;">*</span></label>
                                    <div class="col-md-8">
                                        <select name="company_account" class="form-control chosen-select">
                                            <option value="" selected="">None</option>
                                            @foreach ($cBanks as $bank)
                                                @if ($receipt->company_account == $bank->id)
                                                    <option selected="" value="{{ $bank->id }}">
                                                        {{ $bank->bank ? $bank->bank->name : '' }} -
                                                        {{ $bank->account_number }}</option>
                                                @else
                                                    <option value="{{ $bank->id }}">
                                                        {{ $bank->name ? $bank->name : '' }} - {{ $bank->account_number }}
                                                    </option>
                                                @endif
                                            @endforeach
                                        </select>
                                        @if ($errors->has('company_account'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('company_account') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @endif

                        @if ($receipt->payment_mode == \App\Receipt::cheque)
                            <div class="col-md-6" id='cheque'>
                                <div class="form-group">
                                    <label class="control-label col-md-4"><span id='number_type_inst'>Instrument No</span><span
                                        style="color:red;">*</span> </label>
                                    <div class="col-md-8">
                                        <input type="text" name='cheque_number' value="{{ $receipt->cheque_number }}"
                                            class="form-control" id="exampleInputEmail1"
                                            placeholder="Enter Check Number">
                                        @if ($errors->has('cheque_number'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('cheque_number') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @else
                            <div class="col-md-6" id='cheque' style="display: none;">
                                <div class="form-group">
                                    <label class="control-label col-md-4">Cheque Number</label>
                                    <div class="col-md-8">
                                        <input type="text" name='cheque_number' value="{{ $receipt->cheque_number }}"
                                            class="form-control" id="exampleInputEmail1"
                                            placeholder="Enter Check Number">
                                        @if ($errors->has('cheque_number'))
                                            <span class="help-block">
                                                <strong>{{ $errors->first('cheque_number') }}</strong>
                                            </span>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @endif

                        <div class="clearfix"></div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Amount <span style="color: red">*</span></label>
                                <div class="col-md-8">
                                    <input type="text" name="amount" value="{{ $receipt->amount }}"
                                        onkeyup="toWords(this)" class="form-control" id="exampleInputEmail1"
                                        placeholder="Enter Amount">
                                    <span style="font-weight:bold;" id="total_amount"></span>
                                    @if ($errors->has('amount'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('amount') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="clearfix"></div>
                        <h3 class="box-title">Receipt Information</h3>
                        <hr>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Receipt Number <span
                                        style="color: red">*</span></label>
                                <div class="col-md-8">
                                    <input type="text" class="form-control" name='receipt_no'
                                        value="{{ $receipt->receipt_no }}" id="exampleInputEmail1"
                                        placeholder="Enter Receipt Number">
                                    @if ($errors->has('receipt_no'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('receipt_no') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>



                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Receipt Date <span
                                        style="color: red">*</span></label>
                                <div class="col-md-8">
                                    <input type="date" class="form-control" name='receipt_date'
                                        value="{{ $receipt->receipt_date }}" id="exampleInputEmail1"
                                        placeholder="Enter Receipt Date">
                                    @if ($errors->has('receipt_date'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('receipt_date') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="form-group m-b-15  m-r-25 m-t-15 pull-right">
                            <div class="col-sm-offset-3 col-sm-9">
                                <button type="submit" class="btn btn-info  waves-effect waves-light ">Save</button>
                            </div>
                        </div>

                        <div class="clearfix"></div>

                    </div>
                </div>
            </div>
        </form>
    </div>


@stop

@section('js')
    <script>
        function toWords(self) {
            var total_amount = inWords($(self).val())
            $('#total_amount').text(total_amount)
        }


        var a = ['', 'one ', 'two ', 'three ', 'four ', 'five ', 'six ', 'seven ', 'eight ', 'nine ', 'ten ', 'eleven ',
            'twelve ', 'thirteen ', 'fourteen ', 'fifteen ', 'sixteen ', 'seventeen ', 'eighteen ', 'nineteen '
        ];
        var b = ['', '', 'twenty', 'thirty', 'forty', 'fifty', 'sixty', 'seventy', 'eighty', 'ninety'];

        function inWords(num) {

            if ((num = num.toString()).length > 9) return 'overflow';
            n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
            if (!n) return;
            var str = '';
            str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
            str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lakh ' : '';
            str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
            str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
            str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + '' : '';
            return 'Rupees ' + str + ' Only';
        }



        window.onload = function() {


            var payment_method = $('#payment_mode').val();
            changeFunc(payment_method)
        }



        function changeFunc(a) {

            $("#date_type").text("Drawn Date");
                $("#number_type_inst").text("Instrument No");
            if (a == {{ \App\Receipt::cash }}) {
                $('#bank').css('display', 'none');
                $('#company-bank').css('display', 'none');
                $('#cheque').css('display', 'none');
                $('#adjustment').css('display', 'none');
            } else if (a == {{ \App\Receipt::bank }}) {
                $('#bank').css('display', 'block');
                $('#company-bank').css('display', 'block');
                $('#cheque').css('display', 'block');
                $('#adjustment').css('display', 'none');
                $("#date_type").text("Transaction Date");
                $("#number_type_inst").text("STAN No");
            } else if (a == {{ \App\Receipt::cheque }}) {
                $('#bank').css('display', 'block');
                $('#company-bank').css('display', 'block');
                $('#cheque').css('display', 'block');
                $('#adjustment').css('display', 'none');
            } else if (a == {{ \App\Receipt::adjustment }}) {
                $('#bank').css('display', 'none');
                $('#company-bank').css('display', 'none');
                $('#cheque').css('display', 'none');
                $('#ament').css('display', 'block');
            }
        }

        function updateProperty() {
            $('.preloader').fadeIn();

            var customer_id = $('#customer_id').val();


            var data = {
                'customer_id': customer_id
            };

            $.get('/add/receipt/update-properties', data, function(data) {

                document.getElementById('property').innerHTML = data;
                $('#myTable').DataTable({
                    "paging": false,
                    "ordering": false,
                    "info": false
                });
            });

            //  $('#wait').hide();
            $('.preloader').fadeOut();
        }
    </script>
@stop
