@extends('layouts.app')

@section('title') Add Refund Receipt @stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>
        <li class="active">Add Refund Receipt</li>
    </ol>
@stop

@section('content')
    <div class="container-fluid">
        <form method="post" action="{{ route('receipt-refund.update') }}" class="form-horizontal" id="receipt_form">
            {{ csrf_field() }}
            <input type='hidden' name='id' value="{{ $receipt->id }}">
           
            <input type='hidden' id='receipt_id' name='receipt_id' value="{{ $receipt->id}}">
            <div class="row">
                <div class="col-lg-12 col-sm-12 col-xs-12">
                    @if ($errors->any())
                        <div class="white-box">
                            <h2>Errors</h2>
                            <ul> {!! implode(
                                '',
                                $errors->all('
                                                                                                                                        <li><span class="help-block"><strong>:message</strong></span></li>'),
                            ) !!}
                            </ul>
                        </div>
                    @endif
                    <div class="white-box1">
                        <h3 class="box-title">Payment Information</h3>
                        <hr>

                        <input type="hidden" name="is_approved" value="0">
                        <div class="form-group">

                            <div class="col-sm-4">
                                <div class="input-group">

                                    <input type="radio" checked name="type" value="0" style="zoom: 1.6;" hidden>
                                    @if ($errors->has('type'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('type') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>




                        </div>
                        <div class="col-md-6">
                            <div class="form-group" id='select_customer_or_dealer'>
                                <label class="control-label col-md-4">Select Customer <span
                                        style="color: red">*</span></label>
                                <div class="col-md-8">
                                    <select name="customer_id" id='customer_id' class="form-control chosen-select"
                                        onchange="updateProperty(this.value)">
                                        <option value="" selected="">None</option>

                                        @foreach ($customers as $customer)
                                        @if ($receipt->customer_id == $customer->id)
                                            <option selected="" value="{{ $customer->id }}">{{ $customer->name }} -
                                                {{ $customer->cnic }}</option>
                                        @else
                                            <option value="{{ $customer->id }}">{{ $customer->name }} -
                                                {{ $customer->cnic }}</option>
                                        @endif
                                    @endforeach
                                    </select>

                                    @if ($errors->has('customer_id'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('customer_id') }}</strong>
                                        </span>
                                    @endif

                                </div>
                            </div>
                        </div>
                        <div class="clearfix"></div>

                        <div class="col-md-12" id='property'> </div>
                        <div class="clearfix"></div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Total Refund <span style="color: red">*</span></label>
                                <div class="col-md-8">
                                   

                                    <input readonly type="text" id="total_refund" class="form-control">




                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group" id='specific_outstanding'>
                                <label class="control-label col-md-4">
                                    <span id="payment_head_label"></span> Outstanding
                                </label>
                                <div class="col-md-8">
                                    <input readonly type="text" id="remain_amount" class="form-control">
                                </div>
                            </div>
                        </div>


                        <div class="col-md-6" id='cheque' style="display: none;">
                            <div class="form-group">
                                <label class="control-label col-md-4">Cheque Number</label>
                                <div class="col-md-8">

                                </div>
                            </div>
                        </div>

                        <div class="clearfix"></div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Amount <span style="color: red">*</span></label>
                                <div class="col-md-8">
                                    <span style="font-weight:bold;" id="surcharge_amount"></span>

                                    <input type="text" name="amount" value="{{ $receipt->amount }}" class="form-control"
                                        id="amount" onkeyup="toWords(this)" placeholder="Enter Amount">
                                    <span style="font-weight:bold;" id="total_amount"></span>
                                    @if ($errors->has('amount'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('amount') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id="due_head">
                            <div class="form-group">
                                <label class="control-label col-md-4">Total Outstanding</label>
                                <div class="col-md-8">
                                    <input readonly="" type="text" name="total_deduction" class="form-control"
                                    id="total_deduction">
                                    <input  type="hidden"   
                                    id="total_ded">
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id="tax_amount_head">
                            <div class="form-group">
                                <label class="control-label col-md-4">Tax Amount</label>
                                <div class="col-md-8">
                                    <input readonly="" type="text" name="tax_amount"
                                        value="{{ $receipt->tax_amount }}" class="form-control" id="tax_amount">

                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id="tax_paid_by">
                            <div class="form-group">
                                <label class="control-label col-md-4">Tax Pay By</label>
                                <div class="col-md-8">
                                    <select class="form-control select2" name="tax_paid_by" id='tax_paid_by_option'
                                        onchange="changeTaxOption(this)">
                                        
                                        <option value="{{ \App\Receipt::customer }}" {{ ($receipt->tax_paid_by ==  \App\Receipt::customer)? 'selected':'' }}> Customer</option>
                                        <option value="{{ \App\Receipt::company }}" {{ ($receipt->tax_paid_by ==  \App\Receipt::company)? 'selected':'' }}> Company</option>
                                   
                                    </select>

                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id="tax_option_head">
                            <div class="form-group">
                                <label class="control-label col-md-4">Tax Amount Received</label>
                                <div class="col-md-8">
                                    <select class="form-control select2" name="tax_payment_received" id="tax_option">
                                      
                                        <option value="1" {{($receipt->tax_payment_received == 1)?'selected':''}}> Yes</option>
                                        <option value="0" {{($receipt->tax_payment_received == 0)?'selected':''}}> NO</option>
                                    </select>

                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Payment Method <span
                                        style="color: red">*</span></label>
                                <div class="col-md-8">
                                    <select class="form-control chosen-select" id="payment_method" name='payment_method'
                                        onchange="changeFunc(this.value)">
                                      
                                        @if ($receipt->payment_method == \App\Receipt::cash)
                                            <option selected value="{{ \App\Receipt::cash }}">Cash</option>
                                            <option value="{{ \App\Receipt::bank }}">Bank Transfer (IBFT)</option>
                                            <option value="{{ \App\Receipt::cheque }}">Cheque/ DD/ PO</option>
                                           
                                        @elseif($receipt->payment_method ==  \App\Receipt::bank)
                                            <option value="{{ \App\Receipt::cash }}">Cash</option>
                                            <option selected value="{{ \App\Receipt::bank }}">Bank Transfer (IBFT)
                                            </option>
                                            <option value="{{ \App\Receipt::cheque }}">Cheque/ DD/ PO</option>
                                           
                                        @elseif($receipt->payment_method ==  \App\Receipt::cheque)
                                            <option value="{{ \App\Receipt::cash }}">Cash</option>
                                            <option value="{{ \App\Receipt::bank }}">Bank Transfer (IBFT)</option>
                                            <option selected value="{{ \App\Receipt::cheque }}">Cheque/ DD/ PO</option>
                                            
                                       
                                        @else
                                            <option value="{{ \App\Receipt::cash }}">Cash</option>
                                            <option value="{{ \App\Receipt::bank }}">Bank Transfer (IBFT)</option>
                                            <option value="{{ \App\Receipt::cheque }}">Cheque/ DD/ PO</option>
                                            
                                        @endif

                                    </select>
                                    @if ($errors->has('payment_method'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('payment_method') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6" id='bank' style="display: none;">
                            <div class="form-group">
                                <label class="control-label col-md-4">Depositor Bank Name <span
                                        style="color:red;">*</span></label>
                                <div class="col-md-8">
                                    <select name="bank_name" class="form-control chosen-select">
                                        <option value="" selected="">None</option>

                                        @foreach ($banks as $bank)
                                        @if ($receipt->bank_name == $bank->id)
                                        <option selected="" value="{{ $bank->id }}">
                                            {{ $bank->name }}</option>
                                    @else
                                        <option value="{{ $bank->id }}">{{ $bank->name }}</option>
                                    @endif
                                        @endforeach
                                    </select>

                                    @if ($errors->has('bank_name'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('bank_name') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id='company-bank' style="display: none;">
                            <div class="form-group">
                                <label class="control-label col-md-4">Company Account <span
                                        style="color:red;">*</span></label>
                                <div class="col-md-8">
                                    <select name="company_account" class="form-control chosen-select">
                                        <option value="" selected="">None</option>

                                        @foreach ($cBanks as $bank)
                                        @if ($receipt->company_account == $bank->id)
                                        <option selected="" value="{{ $bank->id }}">
                                            {{ $bank->name }} - {{ $bank->account_number }}</option>
                                    @else
                                        <option value="{{ $bank->id }}">{{ $bank->name }} -
                                            {{ $bank->account_number }}</option>
                                    @endif
                                        @endforeach

                                    </select>

                                    @if ($errors->has('company_account'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('company_account') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id="cheque-dd-po-drawn-date" style="display: none;">
                            <div class="form-group">
                                <label class="control-label col-md-4"><span id="date_type"> Drawn Date</span> <span
                                        style="color:red;">*</span></label>
                                <div class="col-md-8">
                                    <input type="date" class="form-control" name='drawn_date' value="{{$receipt->drawn_date}}"
                                        id="exampleInputEmail1" placeholder="Enter Receipt Date">
                                    @if ($errors->has('drawn_date'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('drawn_date') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6" id="cheque-dd-po-instrument-no" style="display: none;">
                            <div class="form-group">
                                <label class="control-label col-md-4"> <span id="number_type_inst">Instrument No </span>
                                    <span style="color:red;">*</span></label>
                                <div class="col-md-8">
                                    <input type="text" name='cheque_number' value="{{ $receipt->cheque_number }}" class="form-control"
                                        id="exampleInputEmail1" placeholder="Enter Instrument Number">
                                    @if ($errors->has('cheque_number'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('cheque_number') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <br>
                        <div class="col-md-12" id='merging-property'> </div>
                        <div class="clearfix"></div>
                        <hr>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Receipt Number <span
                                        style="color: red">*</span></label>
                                <div class="col-md-8">
                                    
                                        <input type="text" class="form-control" name='receipt_no' id='receipt_no'
                                        value="{{ $receipt->receipt_no }}" placeholder="Enter Receipt Number">
                                    
                                         
                                    @if ($errors->has('receipt_no'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('receipt_no') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Receipt Date <span
                                        style="color: red">*</span></label>
                                <div class="col-md-8">
                                    <input type="date" class="form-control" name='receipt_date'
                                    value="{{ $receipt->receipt_date }}" id="exampleInputEmail1"
                                        placeholder="Enter Receipt Date">
                                    @if ($errors->has('receipt_date'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('receipt_date') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4">Notes</label>
                                <div class="col-md-8">
                                    <textarea class="form-control" name="notes">{{$receipt->notes}}</textarea>
                                    @if ($errors->has('notes'))
                                        <span class="help-block">
                                            <strong>{{ $errors->first('notes') }}</strong>
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                       
                        <input type='hidden' id='edit_data' value='0'>
                        <div class="col-md-4">
                            <div class="form-group m-b-0 pull-right">
                                <input type="submit" class="btn btn-info btn-sm waves-effect waves-light "
                                    id="saveBtn" disabled onclick="return validateAmount(this)" value="Save">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>

@stop

@section('js')
    <script>
        changeFunc({{$receipt->payment_method}});
        function getMergingAmount(self) {
            $('#amount').val(0);
            $('#amount').val($('input[name=merging_property_id]:checked').data("amount"));

        }



        function getAmount(self) {




            if($('#edit_data').val() != 1){
            $('#amount').val(0);
            }
           
            let property_id = $('input[name=customer_property_id]:checked').val();;



            var data = {
                'property_id': property_id,

            };

            $.get('{{ route('validate.refund-unit') }}', data, function(data) {
                


                $('#total_refund').val(data.data.total_refund);
               
                $('#total_deduction').val(data.data.total_deduct);

                $('#total_ded').val(data.data.total_deduct);

                if($('#edit_data').val() !== 1){
                  amount=  $('#amount').val();
              res=    data.data.total_deduct - amount;
               
                    $('#remain_amount').val(res);
            }
               
                   
                $('#edit_data').val(0);
            



            }, 'json');


            changeTotalRemaining()

        }


        function getPackageAmount(self) {



            $('#amount').val(0);


            let dealerpackage_id = $('input[name=dealerpackage_id]:checked').val();

            $('#remain_amount').val(Number(0));
            $("#payment_head").chosen('destroy');
            $('#payment_head').empty();
            $('#payment_head').append('<option value="' +
                {{ \App\Receipt::package_payment }} + '"> Package Payment </option>');
            $("#payment_head").chosen();














            changeTotalRemainingPackage();

        }




        function getAmountAgainstPaymentHead(self) {

            //  $(".chosen-select").chosen('destroy');

            var type = $('input[name="type"]:checked').val();
            if (type == 0) {
                var dataAttri = $('input[name="customer_property_id"]:checked').data("booking_type");

                if (dataAttri != '' && dataAttri == '{{ \App\CustomerProperty::full_payment }}') {
                    $('#payment_head option:contains("Down Payment")').text('Full Payment');
                } else {
                    $('#payment_head option:contains("Full Payment")').text('Down Payment');
                }

                if ($(self).val() == '{{ \App\Receipt::surcharge }}') {
                    $('#due_head').hide();
                    $('#tax_paid_by').hide();
                    $('#tax_amount_head').hide();
                    $('#adjustment').hide();
                    $('#adjustment_detail_head').hide();
                    $('#surcharge_amount').html('Put Zero To Waive Off Surcharge.')
                    $('#surcharge_amount').show()
                    $('#tax_option_head').hide();
                    $("#payment_method").html(
                        '<option selected value="{{ \App\Receipt::cash }}">Cash</option><option value="{{ \App\Receipt::bank }}">Bank Transfer (IBFT)</option><option value="{{ \App\Receipt::cheque }}">Cheque/ DD/ PO</option><option  value="{{ \App\Receipt::merging }}">Merging</option>'
                    )
                } else {
                    $('#due_head').show();
                    $('#tax_paid_by').show();
                    $('#tax_amount_head').show();
                    $('#tax_option_head').show();
                    $('#surcharge_amount').hide()
                    $("#payment_method").html(
                        '<option selected value="{{ \App\Receipt::cash }}">Cash</option><option value="{{ \App\Receipt::bank }}">Bank Transfer (IBFT)</option><option value="{{ \App\Receipt::cheque }}">Cheque/ DD/ PO</option><option value="{{ \App\Receipt::adjustment }}">Adjustment</option><option  value="{{ \App\Receipt::merging }}">Merging</option>'
                    )
                }

                //  $(".chosen-select").chosen();

                $('#amount').val(0);
                let property_id = $('input[name=customer_property_id]:checked').val();
                let entered_amount = $('#amount').val();
                let payment_head = $('#payment_head').val();



                var data = {
                    'property_id': property_id,
                    'entered_amount': entered_amount,
                    'payment_head': payment_head
                };

                $.get('/get/payment_head/amount', data, function(data) {
                    if (data.response == '1') {
                        // $('#invalid_amount').html('Invalid Amount!');
                        // $('#invalid_amount').show()
                        //  

                        $('#payment_head_label').html(data.payment_head)
                        $('#remain_amount').val(Math.round(data.remaining))

                    } else {

                        // $('#invalid_amount').html('');
                        // $('#invalid_amount').hide()
                        $('#payment_head_label').html(data.payment_head)
                        $('#remain_amount').val(Math.round(data.remaining))

                    }



                }, 'json');




                changeTotalRemaining()

            }

        }



        function validateAmount(argument) {



            if ($('#adjustment_type').val() == '{{ \App\Receipt::vendor }}') {
                var data_1 = {
                    'vendor_purchase_order_id': $('#vendor_purchase_order_id').val(),
                    'entered_amount': $('#amount').val()
                };
                $.get('/validate/purchase-order/amount', data_1, function(data_2) {
                    console.log('Invalid::', data_2);
                    if (data_2.response == 'invalid') {
                        $('#invalid_amount').html('<strong>Invalid Amount!</strong> <span>valid amount of ' + data_2
                            .amount + '</span>');
                        $('#invalid_amount').show()
                        return false;
                    } else {
                        $('#invalid_amount').html('');
                        $('#invalid_amount').hide()
                        $('#receipt_form').submit()
                    }

                }, 'json');

            } else {
                $('#receipt_form').submit()
            }

            return false;
        }

    


        
       


        function changeTaxOption(self) {
            if ($(self).val() == "{{ \App\Receipt::company }}") {
                $('#tax_option').html('<option value="1"> YES</option>');
            } else if ($(self).val() == "{{ \App\Receipt::customer }}") {
                $('#tax_option').html('<option value="0"> NO</option>');
            } else {
                $('#tax_option').html('<option value="1"> YES</option><option value="0"> NO</option>');
            }
        }

        function toWords(self) {

            // payment_method
            // 
            
            var total_amount = inWords($(self).val())
            $('#total_amount').text(total_amount)

           
    
       if(!isNaN(parseInt($(self).val()))){

        if($(self).val() != 0){
        val=     $('#total_ded').val();
       $('#remain_amount').val(val)
               num1=   $(self).val();
               num2=            $('#remain_amount').val();
                

               result = num2-num1;
               $('#remain_amount').val(result);
       }
       else{
        val=     $('#total_ded').val();
       $('#remain_amount').val(val)
       }
    }
    else{
        val=     $('#total_ded').val();
       $('#remain_amount').val(val)
       }




        }


        setInterval(function() {

            property = $('input[name="customer_property_id"]:checked').val();


            if (property) {
                id = "#rem" + property;

                remaining_amount = parseInt($(id).val());
            } else {
                remaining_amount = 0;
            }


            if ($('#payment_head').val() === '{{ \App\Receipt::installment }}' && ($('#amount').val() >
                    remaining_amount)) {

                $('#saveBtn').prop('disabled', true)
            } else if ($('#payment_head').val() === '{{ \App\Receipt::surcharge }}' && ($('#amount').val() >
                    remaining_amount)) {
                $('#saveBtn').prop('disabled', true)

            } else {
                if ($('#payment_head').val() !== '{{ \App\Receipt::surcharge }}' && $('#due').val() < 0) {

                    $('#saveBtn').prop('disabled', true)
                } else {

                    $('#saveBtn').prop('disabled', false)
                }
            }





            $('#remain_amount').val(Number($('#remain_amount').val()).toFixed(2))


        }, 500);


        var a = ['', 'one ', 'two ', 'three ', 'four ', 'five ', 'six ', 'seven ', 'eight ', 'nine ', 'ten ', 'eleven ',
            'twelve ', 'thirteen ', 'fourteen ', 'fifteen ', 'sixteen ', 'seventeen ', 'eighteen ', 'nineteen '
        ];
        var b = ['', '', 'twenty', 'thirty', 'forty', 'fifty', 'sixty', 'seventy', 'eighty', 'ninety'];

        function inWords(num) {

            if ((num = num.toString()).length > 9) return 'overflow';
            n = ('000000000' + num).substr(-9).match(/^(\d{2})(\d{2})(\d{2})(\d{1})(\d{2})$/);
            if (!n) return;
            var str = '';
            str += (n[1] != 0) ? (a[Number(n[1])] || b[n[1][0]] + ' ' + a[n[1][1]]) + 'crore ' : '';
            str += (n[2] != 0) ? (a[Number(n[2])] || b[n[2][0]] + ' ' + a[n[2][1]]) + 'lakh ' : '';
            str += (n[3] != 0) ? (a[Number(n[3])] || b[n[3][0]] + ' ' + a[n[3][1]]) + 'thousand ' : '';
            str += (n[4] != 0) ? (a[Number(n[4])] || b[n[4][0]] + ' ' + a[n[4][1]]) + 'hundred ' : '';
            str += (n[5] != 0) ? ((str != '') ? 'and ' : '') + (a[Number(n[5])] || b[n[5][0]] + ' ' + a[n[5][1]]) + '' : '';
            return 'Rupees ' + str + ' Only';
        }



        function changeFunc(a) {
            $("#date_type").text("Drawn Date");
            $("#number_type_inst").text("Instrument No");
            if (a == {{ \App\Receipt::cash }}) {
                $('#bank').css('display', 'none');
                $('#company-bank').css('display', 'none');
                $('#cheque').css('display', 'none');
                $('#adjustment').css('display', 'none');
                $('#cheque-dd-po-drawn-date').css('display', 'none');
                $('#cheque-dd-po-instrument-no').css('display', 'none');
                $('#merging_property').hide();
                $('#cheque-dd-po-roll-back').hide()
            } else if (a == {{ \App\Receipt::bank }}) {


                $('#bank').css('display', 'block');
                $('#company-bank').css('display', 'block');
                $('#cheque').css('display', 'none');
                $('#adjustment').css('display', 'none');
                $('#cheque-dd-po-drawn-date').css('display', 'block');
                $('#cheque-dd-po-instrument-no').css('display', 'block');
                $('#merging_property').hide();
                $('#cheque-dd-po-roll-back').hide();
                $("#date_type").text("Transaction Date");
                $("#number_type_inst").text("STAN No");


            } else if (a == {{ \App\Receipt::cheque }}) {
                $('#bank').css('display', 'block');
                $('#company-bank').css('display', 'block');
                $('#cheque').css('display', 'none');
                $('#adjustment').css('display', 'none');
                $('#cheque-dd-po-drawn-date').css('display', 'block');
                $('#cheque-dd-po-instrument-no').css('display', 'block');
                $('#merging_property').hide();
                $('#cheque-dd-po-roll-back').hide()
            } else if (a == {{ \App\Receipt::adjustment }}) {
                $('#bank').css('display', 'none');
                $('#company-bank').css('display', 'none');
                $('#cheque').css('display', 'none');
                $('#adjustment').css('display', 'block');
                $('#cheque-dd-po-drawn-date').css('display', 'none');
                $('#cheque-dd-po-instrument-no').css('display', 'none');
                $('#merging_property').hide();
                $('#cheque-dd-po-roll-back').hide()
            } else if (a == {{ \App\Receipt::merging }}) {
                $('#bank').css('display', 'none');
                $('#company-bank').css('display', 'none');
                $('#cheque').css('display', 'none');
                $('#adjustment').css('display', 'none');
                $('#cheque-dd-po-drawn-date').css('display', 'none');
                $('#cheque-dd-po-instrument-no').css('display', 'none');
                $('#merging_property').show();
                $('#cheque-dd-po-roll-back').hide()

            }

        }


        function getMergingProperty(self) {
            var mer_pro = $(self).val();

            $('.preloader').fadeIn();

            var customer_id = $('#customer_id').val();

            var data = {
                'customer_id': customer_id,
                'mer_pro': mer_pro
            };

            $.get('/update-merging-properties', data, function(data) {

                document.getElementById('merging-property').innerHTML = data;

                $('.preloader').fadeOut();
            });
        }


        function updateProperty() {

            $('#remain_amount').val(Number(0));
            $("#payment_head").chosen('destroy');
            $('#payment_head').empty();
            $("#payment_head").chosen();
            $('.preloader').fadeIn();

            var customer_id = $('#customer_id').val();
            var receipt_id = $('#receipt_id').val();
            

            var data = {
                'customer_id': customer_id,
                'receipt_id': receipt_id
            };
            $.get('{{ route("receipt-refund.updatetable") }}', data, function(data) {

                document.getElementById('property').innerHTML = data;

                $('#myTable').DataTable({
                    "paging": false,
                    "ordering": false,
                    "info": false
                });
                $('#edit_data').val(1);
                getAmount();

            });

            //  $('#wait').hide();
            $('.preloader').fadeOut();

        }
        updateProperty();
        function updatePackage() {

            $('#remain_amount').val(Number(0));
            $("#payment_head").chosen('destroy');
            $('#payment_head').empty();
            $("#payment_head").chosen();
            $('.preloader').fadeIn();

            var dealer_id = $('#dealer_id').val();


            var data = {
                'dealer_id': dealer_id
            };

            // $('#property').empty();
            $.get('/add/receipt/update-package', data, function(data) {

                document.getElementById('property').innerHTML = data;

                $('#myTable').DataTable({
                    "paging": false,
                    "ordering": false,
                    "info": false
                });
            });

            //  $('#wait').hide();
            $('.preloader').fadeOut();

        }

        function changeTotalRemainingPackage() {

            amount = parseInt($('#amount').val());

            if (amount) {
                var pack = $('input[name="dealerpackage_id"]:checked').val();

                id = "#rem-package" + pack;

                remaining_amount = parseInt($(id).val());

                $('#due').val(remaining_amount - amount);


                // isFiler = parseInt($('#is_filer').val());

                // if (isFiler == 1)
                // $('#tax_amount').val(amount * 0.01);
                // else
                $('#tax_amount').val(amount * 0.02);

            } else {
                pack = $('input[name="dealerpackage_id"]:checked').val();

                id = "#rem-package" + pack;
                remaining_amount = parseInt($(id).val());

                $('#due').val(remaining_amount);
            }

            if ($('#due').val() < 0) {
                $('#saveBtn').prop('disabled', true)
            } else {
                $('#saveBtn').prop('disabled', false)
            }
        }








        function changeTotalRemaining() {

            amount = parseInt($('#amount').val());

            if (amount) {
                property = $('input[name="customer_property_id"]:checked').val();

                id = "#rem" + property;

                remaining_amount = parseInt($(id).val());

                $('#due').val(remaining_amount - amount);


                isFiler = parseInt($('#is_filer').val());

                if (isFiler == 1)
                    $('#tax_amount').val(amount * 0.01);
                else
                    $('#tax_amount').val(amount * 0.02);

            } else {
                property = $('input[name="customer_property_id"]:checked').val();

                id = "#rem" + property;
                remaining_amount = parseInt($(id).val());

                $('#due').val(remaining_amount);
            }

            if ($('#due').val() < 0) {
                $('#saveBtn').prop('disabled', true)
            } else {
                $('#saveBtn').prop('disabled', false)
            }
        }

        $('#amount').keyup(function() {

            amount = parseInt($('#amount').val());
            var type = $('input[name="type"]:checked').val();
            if (type == 1) {

                if (amount) {
                    var pack = $('input[name="dealerpackage_id"]:checked').val();

                    id = "#rem-package" + pack;

                    remaining_amount = parseInt($(id).val());

                    $('#due').val(remaining_amount - amount);


                    // isFiler = parseInt($('#is_filer').val());

                    // if (isFiler == 1)
                    // $('#tax_amount').val(amount * 0.01);
                    // else
                    $('#tax_amount').val(amount * 0.02);

                } else {
                    pack = $('input[name="dealerpackage_id"]:checked').val();

                    id = "#rem-package" + pack;
                    remaining_amount = parseInt($(id).val());

                    $('#due').val(remaining_amount);
                }

                if ($('#due').val() < 0) {
                    $('#saveBtn').prop('disabled', true)
                } else {
                    $('#saveBtn').prop('disabled', false)
                }

            } else if (type == 0) {
                if (amount) {
                    property = $('input[name="customer_property_id"]:checked').val();

                    id = "#rem" + property;

                    remaining_amount = parseInt($(id).val());

                    $('#due').val(remaining_amount - amount);


                    isFiler = parseInt($('#is_filer').val());

                    if (isFiler == 1)
                        $('#tax_amount').val(amount * 0.01);
                    else
                        $('#tax_amount').val(amount * 0.02);

                } else {
                    property = $('input[name="customer_property_id"]:checked').val();

                    id = "#rem" + property;
                    remaining_amount = parseInt($(id).val());

                    $('#due').val(remaining_amount);
                }

            }



        });
    </script>

@stop

@if ($errors->any())
    <script>
        window.onload = function() {

            updateProperty('{{ old('customer_id') }}');

            var payment_method = $('#payment_method').val();
            changeFunc(payment_method)
        }
    </script>
@endif
