@extends('layouts.app')

@section('title')
    All Receipts
@stop

@section('breadcrumb')
    <ol class="breadcrumb pull-right">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">All Receipts</li>
    </ol>
@stop

@section('css')

    <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css" rel="stylesheet">

    <style>
        table.dataTable thead .sorting_asc {
            background-image: none !important;
        }

        .table.dataTable,
        table.dataTable {
            width: 99.8% !important;
        }
    </style>

@stop

@section('content')


    <div class="container-fluid">

        <!--.row-->
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-info">
                    <div class="panel-heading">Search Receipt</div>
                    <div class="panel-wrapper collapse in" aria-expanded="true">
                        <div class="panel-body">
                            <form>
                                <div class="form-body">
                                    <div class="row">

                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Unit No.</label>

                                                <select id="unit" class="form-control chosen-select">
                                                    <option value="0">None</option>
                                                    @foreach ($unitNumbers as $p)
                                                        <option value="{{ $p->id }}">{{ $p->unit_number }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->
                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Customer</label>

                                                <select id="customer" class="form-control chosen-select">
                                                    <option value="0">None</option>
                                                    @foreach ($customers as $c)
                                                        <option value="{{ $c->id }}">{{ $c->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->

                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Dealer</label>

                                                <select id="dealer" class="form-control chosen-select">
                                                    <option value="0">None</option>
                                                    @foreach ($dealers as $d)
                                                        <option value="{{ $d->id }}">
                                                            {{ $d->name }}-{{ $d->code }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->

                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Receipt No</label>
                                                <select id="receipt_no" class="form-control chosen-select">
                                                    <option value="0">None</option>

                                                    @foreach ($receiptNo as $r)
                                                        <option value="{{ $r->id }}">{{ $r->receipt_no }}</option>
                                                    @endforeach

                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->

                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Payment Mode</label>
                                                <select id="payment_mode" class="form-control chosen-select">

                                                    <option value="all">All</option>
                                                    @if (old('payment_method') == \App\Receipt::cash)
                                                        <option selected value="{{ \App\Receipt::cash }}">Cash</option>
                                                        <option value="{{ \App\Receipt::bank }}">Bank Transfer (IBFT)
                                                        </option>
                                                        <option value="{{ \App\Receipt::cheque }}">Cheque/ DD/ PO</option>
                                                        <option value="{{ \App\Receipt::adjustment }}">Adjustment</option>
                                                    @elseif(old('payment_method') == \App\Receipt::bank)
                                                        <option value="{{ \App\Receipt::cash }}">Cash</option>
                                                        <option selected value="{{ \App\Receipt::bank }}">Bank Transfer
                                                            (IBFT)</option>
                                                        <option value="{{ \App\Receipt::cheque }}">Cheque/ DD/ PO</option>
                                                        <option value="{{ \App\Receipt::adjustment }}">Adjustment</option>
                                                    @elseif(old('payment_method') == \App\Receipt::cheque)
                                                        <option value="{{ \App\Receipt::cash }}">Cash</option>
                                                        <option value="{{ \App\Receipt::bank }}">Bank Transfer (IBFT)
                                                        </option>
                                                        <option selected value="{{ \App\Receipt::cheque }}">Cheque/ DD/ PO
                                                        </option>
                                                        <option value="{{ \App\Receipt::adjustment }}">Adjustment</option>
                                                    @elseif(old('payment_method') == \App\Receipt::adjustment)
                                                        <option value="{{ \App\Receipt::cash }}">Cash</option>
                                                        <option value="{{ \App\Receipt::bank }}">Bank Transfer (IBFT)
                                                        </option>
                                                        <option value="{{ \App\Receipt::cheque }}">Cheque/ DD/ PO</option>
                                                        <option selected value="{{ \App\Receipt::adjustment }}">Adjustment
                                                        </option>
                                                    @else
                                                        <option value="{{ \App\Receipt::cash }}">Cash</option>
                                                        <option value="{{ \App\Receipt::bank }}">Bank Transfer (IBFT)
                                                        </option>
                                                        <option value="{{ \App\Receipt::cheque }}">Cheque/ DD/ PO</option>
                                                        <option value="{{ \App\Receipt::adjustment }}">Adjustment</option>
                                                    @endif
                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->

                                        <!--/span-->
                                        <div class="col-md-3">
                                            <div class="form-group has-success" style="margin-bottom: 15px">
                                                <label class="control-label">By Payment Head</label>
                                                <select id="payment_head" class="form-control chosen-select">
                                                    <option value="0">None</option>


                                                    <option value="{{ \App\Receipt::down_payment }}">Down Payment</option>
                                                    <option value="{{ \App\Receipt::installment }}">Installment</option>

                                                    <option value="{{ \App\Receipt::possession_fee }}">Possession Fee
                                                    </option>



                                                    <option value="{{ \App\Receipt::allotment }}">Allotment</option>
                                                    <option value="{{ \App\Receipt::confirmation }}">Confirmation</option>

                                                    <option value="{{ \App\Receipt::booking }}">Booking</option>



                                                    <option value="{{ \App\Receipt::development }}">Development</option>
                                                    <option value="{{ \App\Receipt::file_processing }}">File Processing
                                                    </option>

                                                    <option value="{{ \App\Receipt::registration }}">Registration</option>



                                                    <option value="{{ \App\Receipt::other }}">Other</option>

                                                </select>
                                            </div>
                                        </div>
                                        <!--/span-->

                                        <div class="col-md-3">
                                            <div class="form-actions" style="margin-top: 26px">
                                                <button type="button" class="btn btn-success search-customer"> <i
                                                        class="fa fa-check"></i> Search</button>

                                            </div>
                                        </div>
                                    </div>


                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--./row-->

        <!-- /row -->
        <div class="row" id="update-table">
            <div class="col-sm-12">
                <div class="white-box">

                    <h3 class="box-title">All Receipts ({{ number_format($totalAmount) }})</h3>

                    <div class="table-responsive">
                        <table id="myTable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Project</th>
                                    <th>Receipt No.</th>
                                    <th>Unit No. </th>
                                    <th>Payment Mode</th>
                                    <th>Payment Head</th>
                                    <th>Received Amount </th>
                                    <th>Date</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>

                                @permission('print-receipt')
                                    <?php $print_receipt = true; ?>
                                @else
                                    <?php $print_receipt = false; ?>
                                @endpermission

                                @permission('view-receipt')
                                    <?php $view_receipt = true; ?>
                                @else
                                    <?php $view_receipt = false; ?>
                                @endpermission

                                @permission('edit-receipt')
                                    <?php $edit_receipt = true; ?>
                                @else
                                    <?php $edit_receipt = false; ?>
                                @endpermission

                                @permission('download-receipt')
                                    <?php $download_receipt = true; ?>
                                @else
                                    <?php $download_receipt = false; ?>
                                @endpermission

                                @permission('delete-receipt')
                                    <?php $delete_receipt = true; ?>
                                @else
                                    <?php $delete_receipt = false; ?>
                                @endpermission

                                @foreach ($receipts as $receipt)
                                    <tr>
                                        <td>{{ $receipt->multiProject ? $receipt->multiProject->name : 'None' }}</td>
                                        <td>{{ $receipt->receipt_no }}</td>

                                        <td>{{ $receipt->property ? ($receipt->property->inventory ? $receipt->property->inventory->unit_number : '') : '' }}
                                        </td>




                                        @if (!empty($receipt->payment_method))
                                            @if ($receipt->payment_method == \App\Receipt::cash)
                                                <td>Cash</td>
                                            @elseif($receipt->payment_method == \App\Receipt::bank)
                                                <td>Bank</td>
                                            @elseif($receipt->payment_method == \App\Receipt::adjustment)
                                                <td>Adjustment</td>
                                            @elseif($receipt->payment_method == \App\Receipt::cheque)
                                                <td>Cheque/ DD/ PO</td>
                                            @elseif($receipt->payment_method == \App\Receipt::merging)
                                                <td>Merging</td>
                                            @else
                                                <td></td>
                                            @endif
                                        @else
                                            @if ($receipt->payment_mode == \App\Receipt::cash)
                                                <td>Cash</td>
                                            @elseif($receipt->payment_mode == \App\Receipt::bank)
                                                <td>Bank</td>
                                            @elseif($receipt->payment_mode == \App\Receipt::adjustment)
                                                <td>Adjustment</td>
                                            @elseif($receipt->payment_mode == \App\Receipt::cheque)
                                                <td>Cheque/ DD/ PO</td>
                                            @else
                                                <td></td>
                                            @endif
                                        @endif





                                        @if ($receipt->payment_head == \App\CustomerStatement::down_payment)
                                            <td class="printFV">

                                                @if ($receipt->property->booking_type == \App\CustomerProperty::full_payment)
                                                    {{ 'Full Payment' }}
                                                @else
                                                    {{ 'Down Payment' }}
                                                @endif

                                            </td>
                                        @elseif($receipt->payment_head == \App\CustomerStatement::possession)
                                            <td class="printFV">Possession Fee</td>
                                        @elseif($receipt->payment_head == \App\CustomerStatement::installment)
                                            <td class="printFV">Installment </td>
                                        @elseif($receipt->payment_head == \App\CustomerStatement::other)
                                            <td class="printFV">Other</td>
                                        @elseif($receipt->payment_head == \App\CustomerStatement::allotment)
                                            <td class="printFV">Allotment</td>
                                        @elseif($receipt->payment_head == \App\CustomerStatement::confirmation)
                                            <td class="printFV">Confirmation</td>
                                        @elseif($receipt->payment_head == \App\CustomerStatement::booking)
                                            <td class="printFV">Booking</td>
                                        @elseif($receipt->payment_head == \App\CustomerStatement::development)
                                            <td class="printFV">Development</td>
                                        @elseif($receipt->payment_head == \App\CustomerStatement::file_processing)
                                            <td class="printFV">File Processing</td>
                                        @elseif($receipt->payment_head == \App\CustomerStatement::registration)
                                            <td class="printFV">Registration</td>
                                        @elseif($receipt->payment_head == \App\CustomerStatement::transfer_fee)
                                            <td class="printFV">Transfer Fee</td>
                                        @else
                                            <td class="printFV"></td>
                                        @endif





                                        <td>{{ number_format($receipt->amount) }} PKR</td>

                                        <td> {{ date('d-m-Y', strtotime($receipt->receipt_date)) }}</td>

                                        @if ($receipt->property->status == \App\CustomerProperty::cancel)
                                            <td>
                                                <span class="label label-danger">Canceled</span>
                                            </td>
                                        @else
                                            @if ($receipt->is_approved == \App\Receipt::approve)
                                                <td>
                                                    <span class="label label-success">
                                                        Approved
                                                    </span>
                                                </td>
                                            @else
                                                @if ($receipt->cheaque_status == \App\Receipt::cancel)
                                                    <td>
                                                        <span class="label label-danger">
                                                            Cheaque Cancel
                                                        </span>
                                                    </td>
                                                @else
                                                    <td>
                                                        <span class="label label-warning">
                                                            Pending
                                                        </span>
                                                    </td>
                                                @endif
                                            @endif
                                        @endif

                                        <td class="text-nowrap">

                                            <!-- @if ($print_receipt)
    @if ($receipt->print_count > 0)
    <a style="color: #ff9800;" target="_blank" href="{{ route('receipt.print', ['id' => $receipt->id]) }}" data-toggle="tooltip" data-original-title="Print - {{ $receipt->print_count }}"> <i class="fa fa-print text-inverse m-r-10"></i>&nbsp;&nbsp;&nbsp;  </a>
@else
    <a target="_blank" href="{{ route('receipt.print', ['id' => $receipt->id]) }}" data-toggle="tooltip" data-original-title="Print"> <i class="fa fa-print text-inverse m-r-10"></i>&nbsp;&nbsp;&nbsp;  </a>
    @endif
    @endif -->

                                            @if ($view_receipt)
                                                <a href="{{ route('receipt.detail', ['id' => $receipt->id]) }}"
                                                    data-toggle="tooltip" data-original-title="View"> <i
                                                        class="fa fa-eye text-inverse m-r-10"></i>&nbsp;&nbsp;&nbsp; </a>
                                            @endif

                                            <!--   @if ($edit_receipt)
    <a href="{{ route('receipt.editView', ['id' => $receipt->id]) }}" data-toggle="tooltip" data-original-title="Edit"> <i class="fa fa-pencil text-inverse m-r-10"></i>&nbsp;&nbsp;&nbsp;  </a>
    @endif -->

                                            <!-- @if ($download_receipt)
    @if ($receipt->download_count > 0)
    <a style="color: #ff9800;" target="_blank" href="{{ route('receipt.download', ['id' => $receipt->id]) }}" data-toggle="tooltip" data-original-title="Download - {{ $receipt->download_count }}"> <i class="fa fa-download text-inverse m-r-10"></i> &nbsp;&nbsp;&nbsp; </a>
@else
    <a target="_blank" href="{{ route('receipt.download', ['id' => $receipt->id]) }}" data-toggle="tooltip" data-original-title="Download"> <i class="fa fa-download text-inverse m-r-10"></i> &nbsp;&nbsp;&nbsp; </a>
    @endif
    @endif -->

                                            @if ($delete_receipt)
                                                <a href="{{ route('receipt.delete', ['id' => $receipt->id]) }}"
                                                    data-toggle="confirmation" data-placement="left"
                                                    data-title="Are you sure to delete?"> <i
                                                        class="fa fa-close text-danger"></i> </a>
                                            @endif
                                        </td>
                                    </tr>
                                @endforeach


                            </tbody>
                        </table>
                        <div style="float: right;">{{ $receipts->links() }}</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->

@stop

@section('js')

    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>


    <script>
        $(function() {
            $('#myTable').DataTable({
                'pageLength': 25,
                'paging': false,
                'searching': false,
                'info': false,
                'sorting': false,
                'ordering': false,
                'dom': 'Bfrtip',
                'buttons': [
                    'copy', 'csv', 'excel', 'pdf', 'print'
                ]
            });
        });
        $('.search-customer').on('click', function() {
            $('.preloader').fadeIn();
            unit = $('#unit').val();
            customer = $('#customer').val();
            dealer = $('#dealer').val();
            payment_head = $('#payment_head').val();
            payment_mode = $('#payment_mode').val();
            receipt_no = $('#receipt_no').val();

            if (unit == 0 && customer == 0 && dealer == 0 && payment_head == 0 && payment_mode == 0 && receipt_no ==
                0) {
                toastr.warning("please select any option.");
                return false;
            }

            var data = {
                'unit': unit,
                'customer': customer,
                'dealer': dealer,
                'payment_mode': payment_mode,
                'payment_head': payment_head,
                'receipt_no': receipt_no
            };
            $.get('/receipt/updateTable', data, function(data) {
                document.getElementById('update-table').innerHTML = data;

                $('#myTable').DataTable({
                    'pageLength': 50,
                    'paging': true,
                    'searching': false,
                    'info': true,
                    'dom': 'Bfrtip',
                    'sorting': false,
                    'ordering': false,
                    "aaSorting": [
                        [5, "asc"]
                    ],
                    'buttons': [
                        'copy', 'csv', 'excel', 'pdf', 'print'
                    ]
                });

                toastr.success("Search updated.");


                $('.preloader').fadeOut();
            });
        });
    </script>
@stop
