@extends('layouts.app') 

@section('title') 

@if($block == 'summary' ) SUMMARY OF BOOKING, RECOVERY AND RECEIVABLES&nbsp;&nbsp; From {{date('d/m/Y' , strtotime($from_date))}}&nbsp;&nbsp;To&nbsp;&nbsp;{{date('d/m/Y' , strtotime($to_date))}} @else Account Statement & Recovery Sheet &nbsp;&nbsp;&nbsp;&nbsp; From {{date('d/m/Y' , strtotime($from_date))}}&nbsp;&nbsp;To&nbsp;&nbsp;{{date('d/m/Y' , strtotime($to_date))}} @endif 

@stop 

@section('css')
<style type="text/css" media="print">
@page {
	size: landscape;
}
</style>
<style>
.us_table_bdr>td,
.us_table_bdr>th,
.us_table_bdr>td,
.us_table_bdr>th {
	border: 1px solid black !important;
}
</style>
<!-- <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet"> -->
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css" rel="stylesheet"> 
@stop 

@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
	<li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>
	<li class="active">Account Statement</li>
</ol> 
@stop 

@section('content')
<div class="container-fluid">
	<div class="row ">
		<div class="col-lg-12  ">
			<div class="white-box">
				<div class="text-center">
					<h3><strong>
					

						@foreach($project_names as $key => $project_name)
						{{ $project_name }}
						@if($key < count($project_names) - 1)
							, 
						@endif
					@endforeach
						 
					
					</strong></h3>
					<h4><strong>Account Statement & Recovery Sheet</strong></h4> 
				</div>
				<div class="pull-left"> 
				    <span>Recovery Sheet(Due, Received & OS As On)</span>
					<br> 
					<span><b>FROM&nbsp;&nbsp;{{date('d/m/Y', strtotime($from_date))}}&nbsp;&nbsp;To&nbsp;&nbsp;{{date('d/m/Y', strtotime($to_date))}}</b></span> 
				</div>
				<div class="pull-right" style="margin-bottom:2rem; padding-right:3rem;"> 
				    <span>Date: <b>{{date('d/m/Y')}}</b></span>
					<br>
					<!--<span>Report No: &nbsp;202030</span><br>-->
					<span>User ID: &nbsp; {{Auth::user()->name}}</span> 
				</div>
				<div class="table-responsive" style="clear: both;position: relative;bottom: 10rem;">
					<div style="overflow-y: scroll;height: 565px;">
						<form method="post" style="margin-bottom:2rem; margin-top:5rem; width:60%; z-index:999; left:35rem; top:5.5rem; position:relative;" action="{{route('report.account-statement.generate')}}"> 
						    {{ csrf_field() }}
							<div class="row">
								<div class="col-lg-5">
									<input type="hidden" value="{{$selected_period}}" name="period">
									<input type="hidden" value="{{$selected_date_range}}" name="date_range">
									
									 
									<input type="hidden" value="{{$req_id}}" name="multipro_id">
									 
									<select class="form-control chosen-select" name="block">
										<optgroup label="Options">
											<option <?=( $block=='summary' ) ? 'selected' : '' ?> value="summary" >Summary</option>
											<option <?=( $block=='combined' ) ? 'selected' : '' ?> value="combined" >Combined</option>
										</optgroup>
										<optgroup label="Blocks">
											<option value="" <?=( $block=='0' ) ? 'selected' : '' ?>>All Blocks</option> 
											@foreach($unit_blocks as $unit_block)
											<option <?=( $block==$unit_block->id) ? 'selected' : '' ?> value="{{$unit_block->id}}">{{$unit_block->name}}</option> 
											@endforeach 
										</optgroup>
									</select>
								</div>
								<div class="col-lg-2">
									<input type="submit" value="Filter" class="btn btn-success"> </div>
							</div>
						</form>
						<table id="example1" class="table bdr table-responsive table-bordered" style="border: 1px solid black;">
							<thead>
								<tr class="us_table_bdr">
									<th class="text-center" style="border-bottom: none !important;border: 1px solid #e5ebec;"><strong> </strong></th>
									<th class="text-center" style="border-bottom: none !important;border: 1px solid #e5ebec;"><strong> </strong></th>
									<th style="border-right:none !important;border: 1px solid #e5ebec;"></th>
									<th style="border-left:none !important;border-right: none !important;border: 1px solid #e5ebec;text-align: center;"><strong>NO. OF UNITS</strong></th>
									<th style="border-left:none !important;border: 1px solid #e5ebec;"></th>
									<th style="border-right:none !important;border: 1px solid #e5ebec;"></th>
									<th style="border-left:none !important;border-right: none !important;border: 1px solid #e5ebec;text-align: center;min-width:20rem;"><strong>TOTAL AREA  (In {{env('SIZE')}})</strong></th>
									<th style="border-left:none !important;border: 1px solid #e5ebec;"></th>
									<th style="border-right:none !important;border: 1px solid #e5ebec;"></th>
									<th style="border-right:none !important;border: 1px solid #e5ebec;border-left: none !important;"></th>
									<th style="border-left:none !important;border-right: none !important;border: 1px solid #e5ebec;text-align: center;min-width:20rem;"><strong>TOTAL SALES VALUE (In Rs.)</strong></th>
									<th style="border-right:none !important;border-left:none !important;border: 1px solid #e5ebec;"></th>
									<th style="border-left:none !important;border: 1px solid #e5ebec;"></th>
									<th style="border-right:none !important;border-left:none !important;border: 1px solid #e5ebec;"></th>
									<th style="border-left:none !important;border-right: none !important;border: 1px solid #e5ebec;min-width:35rem;text-align: center;"><strong>RECOVERY AND  RECEIVEABLE AG.  BOOKED UNITS</strong></th>
									<th style="border-right:none !important;border-left:none !important;border: 1px solid #e5ebec;"></th>
									<th style="border-left:none !important;border: 1px solid #e5ebec;"></th> 
									@foreach ($period as $key=> $dt)
									<th style="border-left:none !important;border-right:none !important;border-top: 1px solid #e5ebec;"></th> 
									@endforeach 
								</tr>
								<tr class="us_table_bdr">
									<th class="text-center" style="border-top: none !important;">Sr.</th>
									<th class="text-center" style="border-top: none !important;">Block</th>
									<th class="text-center"><strong>Total</strong></th>
									<th class="text-center"><strong>Booked</strong></th>
									<th class="text-center"><strong>Unbooked</strong></th>
									<th class="text-center"><strong>All Units</strong></th>
									<th class="text-center"><strong>Booked </strong></th>
									<th class="text-center"><strong>Un-Booked</strong></th>
									<th class="text-center"><strong>Booked</strong></th>
									<th class="text-center"><strong>Discount</strong></th>
									<th class="text-center"><strong>Booked(Net)</strong></th>
									<th class="text-center"><strong>Un-Booked</strong></th>
									<th class="text-center"><strong>Total</strong></th>
									<th class="text-center"><strong>Recovery </strong></th>
									<th class="text-center"><strong>Balance Receivables </strong></th>
									<th class="text-center"><strong>Overdues </strong></th>
									<th class="text-center"><strong>Future Ins.</strong></th> 
									@foreach ($period as $key=> $dt)
									<th style="border-left:none;border-right:none;"> {{$dt->format("M Y")}}</th> 
									@endforeach 
								</tr>
							</thead>
							<tbody>
								<?php 
                                $grand_block_total_units_count = 0; 
                                $grand_block_booked_units_count = 0; 
                                $grand_block_un_booked_units_count = 0; 
                                $grand_block_total_units_area = 0; 
                                $grand_block_booked_units_area = 0; 
                                $grand_block_un_booked_units_area = 0; 
                                $grand_block_total_units_amount = 0;
                                $grand_block_booked_units_amount = 0;
                                $grand_block_un_booked_units_amount = 0;
                                $grand_block_discount = 0;
                                $grand_block_recovery = 0; 
                                $grand_block_receivable = 0;
                                $grand_block_overdue = 0; 
                                $grand_block_future = 0; 
                                $total_amount = 0;
                                ?>
								
								<?php 
                                $grand_count = 1; 
                                $grand_cost = 0; 
                                $grand_discount = 0; 
                                $grand_balance_receivables = 0;
                                $grand_overdue = 0;
                                $grand_future_installments = 0; 
                                $grand_discount = 0; $grand_net_pay = 0; 
                                $grand_booked_price = 0; 
                                $grand_received = 0;
                                $grand_due = 0; 
                                $grand_total_sqrt = 0; 
                                $serial_no = 1; 
                                $grand_total = array();
                                ?> 
                                
                                @foreach($unit_blocks as $unit_blook)
    								<?php 
                                    $block_total_units_count = 0; 
                                    $block_booked_units_count = 0; 
                                    $block_un_booked_units_count = 0; 
                                    $block_total_units_area = 0; 
                                    $block_booked_units_area = 0; 
                                    $block_un_booked_units_area = 0; 
                                    $block_total_units_amount = 0;
                                    $block_booked_units_amount = 0;
                                    $block_un_booked_units_amount = 0;
                                    $block_discount = 0;
                                    $block_recovery = 0; 
                                    $block_receivable = 0; 
                                    $block_overdue = 0; 
                                    $block_future = 0; 
                                    ?> 
                                    
                                    @foreach($floor_data as $f) 
                                    
                                        @if($unit_blook->name == $f['block'])
                                            <?php $block_total_units_count += $f['total_units'];?>
                                            <?php $block_booked_units_count +=$f['booked_units'];?>
                                            <?php $block_un_booked_units_count +=$f['un_booked_units'];?>
                                            <?php $block_total_units_area +=$f['total_units_area'];?>
                                            <?php $block_booked_units_area += $f['booked_units_area'];?>
                                            <?php $block_un_booked_units_area +=$f['un_booked_units_area'];?>
                                            <?php $block_booked_units_amount +=$f['booked_units_amount'];?>
                                            <?php $block_un_booked_units_amount +=$f['un_booked_units_amount'];?>
                                            <?php $block_total_units_amount +=$f['total_units_amount'];?>
                                            <?php $block_recovery +=$f['recovery'];?>
                                            <?php $block_receivable += ( $f['receivable']); ?>
                                            <?php $block_overdue +=$f['overdue'];?>
    										<?php $block_future += $f['future'];?> 
    									@endif 
    								
    								@endforeach 
    								
    								@php 
    								
    								if(($block_total_units_amount - $block_booked_units_amount) > 0 ) { 
    								
    								    $block_discount = $block_total_units_amount - $block_booked_units_amount; 
    								
    								} 
    								
    								@endphp
    								
    								<tr class="us_table_bdr">
    									<th class="text-center">{{$serial_no++}}</th>
    									<th class="text-center">{{ $unit_blook->name }}</th>
    									<th class="text-right">{{number_format($block_total_units_count)}}</th>
    									<th class="text-right">{{number_format($block_booked_units_count)}}</th>
    									<th class="text-right">{{number_format($block_un_booked_units_count)}}</th>
    									<th class="text-right">{{number_format($block_total_units_area)}}</th>
    									<th class="text-right">{{number_format($block_booked_units_area)}}</th>
    									<th class="text-right">{{number_format($block_un_booked_units_area)}}</th>
    									<th class="text-right yyd">{{number_format($block_total_units_amount)}}</th>
    									<th class="text-right">{{number_format($block_discount)}}</th>
    									<th class="text-right">{{number_format($block_booked_units_amount)}}</th>
    									<th class="text-right">{{number_format($block_un_booked_units_amount)}}</th>
    									<th class="text-right ">{{number_format( ($block_total_units_amount + $block_un_booked_units_amount) - $block_discount )}}</th>
    									<th class="text-right">{{number_format($block_recovery)}}</th>
    									<th class="text-right">{{number_format($block_receivable)}}</th>
    									<th class="text-right ">{{number_format($block_overdue)}}</th>
    									<th class="text-right">{{number_format($block_future)}}</th> 
    									
    									@foreach ($period as $key=> $dt)
    									<th style="border-left:none;border-right:none;" id='{{str_replace(" " , "_" , $unit_blook->name ) }}_{{str_replace(" " , "_" , $dt->format("M Y") )}}' class="text-right"></th> 
    									@endforeach 
    								</tr>
    								
    								<?php 
                                    $grand_block_total_units_count += $block_total_units_count; 
                                    $grand_block_booked_units_count += $block_booked_units_count; 
                                    $grand_block_un_booked_units_count += $block_un_booked_units_count; 
                                    $grand_block_total_units_area += $block_total_units_area; 
                                    $grand_block_booked_units_area  += $block_booked_units_area; 
                                    $grand_block_un_booked_units_area += $block_un_booked_units_area; 
                                    $grand_block_booked_units_amount += $block_total_units_amount;
                                    $grand_block_discount +=$block_discount;
                                    $grand_block_total_units_amount += ($block_booked_units_amount);
                                    $grand_block_un_booked_units_amount += $block_un_booked_units_amount;
                                    $total_amount += ($block_total_units_amount + $block_un_booked_units_amount );
                                    $grand_block_recovery += $block_recovery; 
                                    $grand_block_receivable += $block_receivable;
                                    $grand_block_overdue += $block_overdue; 
                                    $grand_block_future +=$block_future; 
                                    ?> 
                                    
                                @endforeach
                                
								{{-- <tr class="us_table_bdr">
									<th style="border-left: none;border-right:none !important;"><strong>Total.</strong></th>
									<td style="border-left: none !important;"></td>
									<th style="border-right: none;text-align:right;"><b>{{number_format($grand_block_total_units_count)}}</b></th>
									<th style="border-right: none;border-left: none;text-align:right;"><b>{{number_format($grand_block_booked_units_count)}}</b></th>
									<th style="border-right: none;border-left: none;text-align:right;"><b>{{number_format($grand_block_un_booked_units_count)}}</b></th>
									<th style="border-right: none;border-left: none;text-align:right;"><b>{{number_format($grand_block_total_units_area)}}</b></th>
									<th style="border-right: none;border-left: none;text-align:right;"><b>{{number_format($grand_block_booked_units_area)}}</b></th>
									<th style="border-right: none;border-left: none;text-align:right;"><b>{{number_format($grand_block_un_booked_units_area)}}</b></th>
									<th style="border-right: none;border-left: none;text-align:right;"><b>{{number_format($grand_block_booked_units_amount)}}</b></th>
									<th style="border-right: none;border-left: none;text-align:right;"><b>{{number_format($grand_block_discount)}}</b></th>
									<th style="border-right: none;border-left: none;text-align:right;"><b>{{number_format($grand_block_total_units_amount)}}</b></th>
									<th style="border-right: none;border-left: none;text-align:right;"><b>{{number_format($grand_block_un_booked_units_amount)}}</b></th>
									<th style="border-right: none;border-left: none;text-align:right;"><b>{{number_format($grand_block_total_units_amount + $grand_block_un_booked_units_amount)}}</b></th>
									<th style="border-right: none;border-left: none;text-align:right;"><b>{{number_format($grand_block_recovery)}}</b></th>
									<th style="border-right: none;border-left: none;text-align:right;"><b>{{number_format($grand_block_overdue + $grand_block_future)}}</b></th>
									<th style="border-right: none;border-left: none;text-align:right;"><b>{{number_format($grand_block_overdue)}}</b></th>
									<th style="border-right: none;border-left: none;text-align:right;"><b>{{number_format($grand_block_future)}}</b></th> 
									
									@foreach ($period as $key=> $dt)
									<th style="border-left:none ;border-right:none;" id='grand_{{str_replace(" " , "_" , $dt->format("M Y") ) }}' class="text-right"></th> 
									@endforeach 
								
								</tr> --}}
								
								<tr style="display:<?php if($block == 'summary' ){echo 'none';} ?>">
									<th style="border-right: none;">&nbsp;</th>
									<th style="border-right: none;border-left: none;">&nbsp;</th>
									<th style="border-right: none;border-left: none;">&nbsp;</th>
									<th style="border-right: none;border-left: none;">&nbsp;</th>
									<th style="border-right: none;border-left: none;">&nbsp;</th>
									<th style="border-right: none;border-left: none;">&nbsp;</th>
									<th style="border-right: none;border-left: none;">&nbsp;</th>
									<th style="border-right: none;border-left: none;">&nbsp;</th>
									<th style="border-right: none;border-left: none;">&nbsp;</th>
									<th style="border-right: none;border-left: none;">&nbsp;</th>
									<th style="border-right: none;border-left: none;">&nbsp;</th>
									<th style="border-right: none;border-left: none;">&nbsp;</th>
									<th style="border-right: none;border-left: none;">&nbsp;</th>
									<th style="border-right: none;border-left: none;">&nbsp;</th>
									<th style="border-left: none;">&nbsp;</th> 
									@foreach ($period as $dt)
									<th style="border-left:none;border-right:none;"></th> 
									@endforeach
									<th style="border-left:none;border-right:none;"></th>
									<th style="border-left:none;border-right:none;"></th>
								</tr> 
								
								@if($block == 'combined')
								<tr style="display:<?php if($block == 'summary' ){echo  'none';} ?>">
									<th style="border-top: 1px solid;border-bottom: 1px solid;">Sr No.</th>
									<th style="border-top: 1px solid;border-bottom: 1px solid;">Unit No.</th>
									<th style="border-top: 1px solid;border-bottom: 1px solid;">Client Name</th>
									<th style="border-top: 1px solid;border-bottom: 1px solid;">Dealer</th>
									<th style="border-top: 1px solid;border-bottom: 1px solid;">Booking Date</th>
									<th style="border-top: 1px solid;border-bottom: 1px solid;">Unit Floor</th>
									<th style="border-top: 1px solid;border-bottom: 1px solid;">Area(Sft.)</th>
									<th style="border-top: 1px solid;border-bottom: 1px solid;">Unit Block</th>
									<th style="border-top: 1px solid;border-bottom: 1px solid;">Booked Price</th>
									<th style="border-top: 1px solid;border-bottom: 1px solid;">Discount</th>
									<th style="border-top: 1px solid;border-bottom: 1px solid;">Booked (Net)</th>
									<th style="border-top: 1px solid;border-bottom: 1px solid;">Total Received</th>
									<th style="border-top: 1px solid;border-bottom: 1px solid;">Balance Receivables</th>
									<th style="border-top: 1px solid;border-bottom: 1px solid;">Overdue</th>
									<th style="border-top: 1px solid;border-bottom: 1px solid;">Future Installments</th> 
									
									@foreach ($period as $dt)
									<th style="border-top:1px solid  #e9e9e9;border-top: 1px solid;border-bottom: 1px solid;"> {{$dt->format("M Y")}} </th> 
									@endforeach
									
									<th style="border-top:1px solid  #e9e9e9;border-top: 1px solid;border-bottom: 1px solid;"></th>
									<th style="border-top:1px solid  #e9e9e9;border-top: 1px solid;border-bottom: 1px solid;"></th>
								</tr> 
								@endif 
								
								@foreach($unit_blocks as $unit_block)
									<?php 
									$count =1; 
									$cost = 0; 
									$discount = 0; 
									$sqrt = 0; 
									$balance_receivables= 0;
									$overdue=0;
									$future_installments = 0; 
									$discount = 0; 
									$net_pay = 0; 
									$booked_price = 0; 
									$received = 0; 
									$due = 0; 
									$totalArray = array();
									?> 
									
									@foreach($properties as $property) 
									
									    @if($loop->first && $block != 'combined')
											<tr style="display:<?php if($block == 'summary' ){echo  'none';} ?>">
												<th style="border-right: none;text-align: left;min-width: 10rem;background: #e5e5e5;"> {{$unit_block->name}} </th>
												<th style="border-left:none;border-right:none;min-width: 20rem;background: #e5e5e5;"></th>
												<th style="border-left:none;border-right:none;min-width: 15rem;"></th>
												<th style="border-left:none;border-right:none;min-width: 15rem;"></th>
												<th style="border-left:none;border-right:none;min-width: 15rem;"></th>
												<th style="border-left:none;border-right:none;min-width: 15rem;"></th>
												<th style="border-left:none;border-right:none;min-width: 15rem;"></th>
												<th style="border-left:none;border-right:none;min-width: 15rem;"></th>
												<th style="border-left:none;border-right:none;min-width: 15rem;"></th>
												<th style="border-left:none;border-right:none;min-width: 15rem;"></th>
												<th style="border-left:none;border-right:none;min-width: 15rem;"></th>
												<th style="border-left:none;border-right:none;min-width: 15rem;"></th>
												<th style="border-left:none;border-right:none;min-width: 15rem;"></th>
												<th style="border-left:none;border-right:none;min-width: 15rem;"></th>
												<th style="border-left:none;border-right:none;min-width: 15rem;"></th> 
												@foreach ($period as $dt)
												<th style="border-left:none;border-right:none;"></th> 
												@endforeach
												<th style="border:none !important;"></th>
												<th style="border:none !important;"></th>
											</tr>
            								<tr style="display:<?php if($block == 'summary' ){echo  'none';} ?>">
            									<th tabindex="0" class="no-print" aria-controls="myTable1" rowspan="1" colspan="1" aria-sort="ascending" style="width: 10px; font-size: x-large; border-top: 1px solid;border-bottom: 1px solid;">
            										<input type="checkbox" name="select_all[]" style="zoom: 3; margin-left:10px;" value="" id="select_all">
            									</th>
            									<th style="border-top: 1px solid;border-bottom: 1px solid;">Sr No.</th>
            									<th style="border-top: 1px solid;border-bottom: 1px solid;">Unit No.</th>
            									<th style="border-top: 1px solid;border-bottom: 1px solid;">Client Name</th>
            									<th style="border-top: 1px solid;border-bottom: 1px solid;">Dealer</th>
            									<th style="border-top: 1px solid;border-bottom: 1px solid;">Booking Date</th>
            									<th style="border-top: 1px solid;border-bottom: 1px solid;">Unit Floor</th>
            									<th style="border-top: 1px solid;border-bottom: 1px solid;">Area(Sft.)</th>
            									<th style="border-top: 1px solid;border-bottom: 1px solid;">Unit Block</th>
            									<th style="border-top: 1px solid;border-bottom: 1px solid;">Booked Price</th>
            									<th style="border-top: 1px solid;border-bottom: 1px solid;">Discount</th>
            									<th style="border-top: 1px solid;border-bottom: 1px solid;">Booked (Net)</th>
            									<th style="border-top: 1px solid;border-bottom: 1px solid;">Total Received</th>
            									<th style="border-top: 1px solid;border-bottom: 1px solid;">Balance Receivables</th>
            									<th style="border-top: 1px solid;border-bottom: 1px solid;">Overdue</th>
            									<th style="border-top: 1px solid;border-bottom: 1px solid;">Future Installments</th> @foreach ($period as $dt)
            									<th style="border-top:1px solid  #e9e9e9;border-top: 1px solid;border-bottom: 1px solid;"> {{$dt->format("M Y")}} </th> @endforeach
            									<th style="border:none !important;"></th>
            									<th style="border:none !important;"></th>
            								</tr> 
            							@endif 
											
										@if(!empty($property->inventory->floor->unit_block))
										@if(( ($filter_type == 'filter' && $block > 0 && $block == $property->inventory->floor->unit_block->id) || $filter_type == 'all' ) && $unit_block->id == $property->inventory->floor->unit_block->id)
										<tr style="display:<?php if($block == 'summary' ){echo  'none';} ?>">
											<td class="no-print">
												<input type="checkbox" style="zoom: 1.8; margin-left:21px;" class="checkbox chlid_checkbox" name="chlid_checkbox[]" value="{{$property->id}}">
											</td>
											<td style="min-width: 15rem;">{{$count++}}</td>
											<td style="min-width: 15rem;"> 
											    <a href="{{route('statement.detail',[ 'id'=>$property->id ])}}" data-toggle="tooltip" data-original-title="View" target="_blank">  
                                                    {{$property->inventory ?   $property->inventory->unit_number  : ''}}
                                                </a>
												<!--<a href="#" style="float: right;" onclick="openReminderModal({{$property->id}})" data-toggle="tooltip" data-original-title="Follow up History"> <i class="fa fa-bell text-inverse m-r-10"></i>&nbsp;&nbsp;</a>-->
											</td>
											<td style="min-width: 20rem;"> {{$property->customer ? $property->customer->name : ''}} </td>
											<td style="min-width: 15rem;"> @if($property->dealer) {{$property->dealer ? $property->dealer->name:''}} @endif </td>
											<td style="min-width: 15rem;"> {{date('d/m/Y', strtotime($property->booking_date)) }} </td>
											<td style="min-width: 15rem;"> {{$property->inventory ? $property->inventory->floor->name : ''}} </td>
											<td style="min-width: 15rem;"> {{$property->inventory ? number_format($property->inventory->size->name) : ''}}
												<?php $sqrt += $property->inventory->size->name; ?>
											</td>
											<td style="min-width: 15rem;"> {{$property->inventory ? $property->inventory->floor->unit_block->name : ''}} </td>
											<td class="printFV text-right" style="min-width: 15rem;"> {{number_format($property->inventory->total_price)}}
												<?php $booked_price += $property->inventory->total_price; ?>
											</td>
											<td class="printFV text-right" style="min-width: 15rem;"> @if(($property->inventory->total_price - $property->net_pay) > 0 ) {{ number_format( $property->inventory->total_price - $property->net_pay ) }} @else {{'-'}} @endif
												<?php $discount +=($property->inventory->total_price - $property->net_pay);?>
											</td>
											<td class="printFV text-right" style="min-width: 15rem;"> {{number_format($property->net_pay)}}
												<?php $net_pay +=$property->net_pay;?>
											</td>
											<td class="printFV text-right" style="min-width: 15rem;"> {{number_format($receivedAmt[$property->id])}}
												<?php $received += $receivedAmt[$property->id];?>
											</td>
											<td class="printFV text-right" style="min-width: 15rem;"> {{number_format(($property->net_pay - $receivedAmt[$property->id] ) )}}
												<?php $balance_receivables +=($property->net_pay - $receivedAmt[$property->id]);?>
											</td>
											<td class="printFV text-right abc" style="min-width: 15rem;"> {{number_format($overDueAmt[$property->id])}}
												<?php $overdue +=$overDueAmt[$property->id];?>
											</td>
											<td class="printFV text-right" style="min-width: 15rem;"> {{number_format(($property->net_pay - $outStandingAmount[$property->id]) - $overDueAmt[$property->id] )}}
												<?php $future_installments += (($property->net_pay - $outStandingAmount[$property->id]) - $overDueAmt[$property->id] );?>
											</td> 
											@php 
											
											foreach ($period as $dt) { 
											    $output = '-'; 
											    $totalAmount = 0; 
											    $de_date = ''; 
											    
											    $sumOfDueAmount = array_reduce($dueMonth[$property->id], function ($a, $b) { 
											        isset($a[$b['due_date']]) ? $a[$b['due_date']]['due'] += $b['due'] : $a[$b['due_date']] = $b; 
											        return $a; 
											    }); 
											    
											    if(!empty($sumOfDueAmount)) { 
											        foreach($sumOfDueAmount as $s) { 
											            if ($dt->format("M Y") == date('M Y', strtotime($s['due_date']))) { 
											                
											                $output = ' ('.number_format($s['due']).')'; 
											                
											                $totalAmount = $s['due']; 
											                
											                $de_date = date('M Y', strtotime($s['due_date'])); 
											            } 
											        } 
											    } 
											    
											    $totalArray[] = array('date' => $de_date, 'amount' => $totalAmount); 
											    
											    echo '<td style="border-top:1px solid  #e9e9e9;" class="printFV text-right">'.$output.'</td>'; 
										    } 
										    
										    @endphp
											
											<td style="border:none !important;" class="printFV text-right"></td>
											<td style="border:none !important;" class="printFV text-right"></td>
										</tr> 
										@endif 
										@endif

									@endforeach 
									
									@php 
									
									$sum = array_reduce($totalArray, function ($a, $b) { 
									    isset($a[$b['date']]) ? $a[$b['date']]['amount'] += $b['amount'] : $a[$b['date']] = $b; return $a;
								    }); 
								    
								    @endphp
									
									<tr style="font-weight: bold; display:<?php if($block == 'summary' ){echo  'none';} ?>">
										<td class="text-left" style="border-right: none;border-top: 1px solid;border-bottom: 1px solid;"></td>
										<td style="border-right: none;border-left: none;border-top: 1px solid;border-bottom: 1px solid;"><b>Sub Total- {{$unit_block->name}}</b></td>
										<td style="border-right: none;border-left: none;border-top: 1px solid;border-bottom: 1px solid;"></td>
										<td style="border-right: none;border-left: none;border-top: 1px solid;border-bottom: 1px solid;"></td>
										<td style="border-right: none;border-left: none;border-top: 1px solid;border-bottom: 1px solid;"></td>
										<td style="border-right: none;border-left: none;border-top: 1px solid;border-bottom: 1px solid;"></td>
										<td style="border-right: none;border-left: none;border-top: 1px solid;border-bottom: 1px solid;"></td>
										<td style="border-right: none;border-left: none;border-top: 1px solid;border-bottom: 1px solid;">{{number_format($sqrt)}}</td>
										<td style="border-right: none;border-left: none;border-top: 1px solid;border-bottom: 1px solid;"></td>
										<td class="text-right" style="border-top: 1px solid;border-bottom: 1px solid;">{{number_format($booked_price)}}</td>
										<td class="text-right" style="border-top: 1px solid;border-bottom: 1px solid;">{{number_format($discount)}}</td>
										<td class="text-right" style="border-right: none;border-top: 1px solid;border-bottom: 1px solid;"> {{number_format($net_pay)}}</td>
										<td class="text-right" style="border-right: none;border-left: none;border-top: 1px solid;border-bottom: 1px solid;">{{number_format($received)}}</td>
										<td class="text-right" style="border-right: none;border-left: none;border-top: 1px solid;border-bottom: 1px solid;">{{number_format($balance_receivables)}}</td>
										<td class="text-right" style="border-right: none;border-left: none;border-top: 1px solid;border-bottom: 1px solid;">{{number_format($overdue)}}</td>
										<td class="text-right" style="border-right: none;border-left: none;border-top: 1px solid;border-bottom: 1px solid;">{{number_format($future_installments)}}</td>
										
										<?php 
                                        $grand_balance_receivables +=$balance_receivables;
                                        $grand_overdue +=$overdue;
                                        $grand_future_installments += $future_installments; 
                                        $grand_discount += $discount; 
                                        $grand_net_pay +=$net_pay; 
                                        $grand_booked_price +=$booked_price; 
                                        $grand_received += $received; 
                                        $grand_total_sqrt += $sqrt;
                                        ?> 
                                        
                                        @foreach ($period as $dt) 
                                        
                                            @php 
                                            $totalOutput = 0; 
                                            $grandTotalAmount = 0; 
                                            $grand_de_date = ''; 
                                            @endphp 
                                            
                                            @if(!empty($sum) ) 
                                            
                                                @foreach($sum as $month) 
                                                
                                                    @if ($dt->format("M Y") == $month['date']) 
                                                    
                                                        @php 
                                                        
                                                        $totalOutput = number_format($month['amount']); 
                                                        
                                                        $grandTotalAmount = $month['amount']; 
                                                        
                                                        $grand_de_date = $month['date']; 
                                                        
                                                        @endphp 
                                                        
                                                    @endif 
                                                    
                                                @endforeach 
                                                
                                            @endif 
                                            
                                            @php 
                                            
                                            $grand_total[] = array('date' => $grand_de_date, 'amount' => $grandTotalAmount); 
                                            
                                            @endphp
										
										<td style="border-top: 1px solid;border-bottom: 1px solid;" class="us_hack" data-month='{{str_replace(" " , "_" , $dt->format("M Y") ) }}' data-amount="({{number_format($grandTotalAmount)}})" data-block="{{str_replace(' ' , '_' , $unit_block->name) }}">({{$totalOutput}})</td> @endforeach
										<td style="border:none !important;" class="printFV text-right"></td>
										<td style="border:none !important;" class="printFV text-right"></td>
								</tr> 
								@endforeach 
								
								@php 
								
								$grand_sum = array_reduce($grand_total, function ($a, $b) { 
								    isset($a[$b['date']]) ? $a[$b['date']]['amount'] += $b['amount'] : $a[$b['date']] = $b; return $a; }); 
								
								@endphp
        						<tr style="font-weight: bold; display:<?php if($block == 'summary' ){echo  'none';} ?>">
        							<td class="text-left" style="border-right: none;border-top: 1px solid;border-bottom: 1px solid;"></td>
        							<td style="border-right: none;border-left: none;border-top: 1px solid;border-bottom: 1px solid;"><b>Grand Total</b></td>
        							<td style="border-right: none;border-left: none;border-top: 1px solid;border-bottom: 1px solid;"></td>
        							<td style="border-right: none;border-left: none;border-top: 1px solid;border-bottom: 1px solid;"></td>
        							<td style="border-right: none;border-left: none;border-top: 1px solid;border-bottom: 1px solid;"></td>
        							<td style="border-right: none;border-left: none;border-top: 1px solid;border-bottom: 1px solid;"></td>
        							<td style="border-right: none;border-left: none;border-top: 1px solid;border-bottom: 1px solid;"></td>
        							<td style="border-right: none;border-left: none;border-top: 1px solid;border-bottom: 1px solid;">{{number_format($grand_total_sqrt)}}</td>
        							<td style="border-right: none;border-left: none;border-top: 1px solid;border-bottom: 1px solid;"></td>
        							<td class="text-right" style="border-top: 1px solid;border-bottom: 1px solid;">{{number_format($grand_booked_price)}}</td>
        							<td class="text-right" style="border-top: 1px solid;border-bottom: 1px solid;">{{number_format($grand_discount)}}</td>
        							<td class="text-right" style="border-right: none;border-top: 1px solid;border-bottom: 1px solid;"> {{number_format($grand_net_pay)}}</td>
        							<td class="text-right" style="border-right: none;border-left: none;border-top: 1px solid;border-bottom: 1px solid;">{{number_format($grand_received)}}</td>
        							<td class="text-right" style="border-right: none;border-left: none;border-top: 1px solid;border-bottom: 1px solid;">{{number_format($grand_balance_receivables)}}</td>
        							<td class="text-right" style="border-right: none;border-left: none;border-top: 1px solid;border-bottom: 1px solid;">{{number_format($grand_overdue)}}</td>
        							<td class="text-right" style="border-right: none;border-left: none;border-top: 1px solid;border-bottom: 1px solid;">{{number_format($grand_future_installments)}}</td> @foreach ($period as $dt) @php $totalOutput = 0; @endphp @if(!empty($grand_sum) ) @foreach($grand_sum as $month) @if ($dt->format("M Y") == $month['date']) @php $totalOutput = number_format($month['amount']); @endphp @endif @endforeach @endif
        							<td style="border-top: 1px solid;border-bottom: 1px solid;" class="us_grand_hack" data-month='{{str_replace(" " , "_" , $dt->format("M Y") ) }}' data-amount="({{$totalOutput}})">({{$totalOutput}})</td> @endforeach
        							<td style="border:none !important;"></td>
        							<td style="border:none !important;"></td>
        						</tr>
							</tbody>
						</table>
					</div> 
					<a href="#" style="float: right; margin-top: 1rem;" onclick="openReminderModal2(this)" class="btn btn-success" data-toggle="tooltip" data-original-title="Assign Units"> Assign&nbsp;&nbsp; <i class="fa fa-bell text-inverse m-r-10"></i> </a> 
				</div>
			</div>
		</div>
		<!-- /.container-fluid -->
		<div class="modal fade" id="exampleModal1" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true"> </div> @stop @section('js')
		<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>
		<!-- <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script> -->
		<script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
		<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
		<script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
		<script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>
		<script>
		// A $( document ).ready() block.
		$(document).ready(function() {
			$(".us_hack").each(function() {
				$month = $(this).data("month");
				$block = $(this).data("block");
				$amount = $(this).data("amount");
				$('#' + $block + '_' + $month).html($amount)
			});
			$(".us_grand_hack").each(function() {
				$month = $(this).data("month");
				$amount = $(this).data("amount");
				$('#grand_' + $month).html($amount)
			});
			$('#example1').DataTable({
				sorting: false,
				paging: false,
				ordering: false,
				dom: 'Bfrtip',
				buttons: ['copy', 'csv', 'excel', 'print', {
					extend: 'pdfHtml5',
					title: function() {
						return "{{env('APP_NAME')}}\nAccount Statement & Recovery Sheet";
					},
					orientation: 'landscape',
					pageSize: 'A0', // You can also use "A1","A2" or "A3", most of the time "A3" works the best.
					text: '<i class=""> PDF</i>',
					titleAttr: 'PDF'
				}]
			});
		});
		$(function() {
			$("#print").on("click", function() {
				var mode = 'iframe'; //popup
				var close = mode == "popup";
				var options = {
					mode: mode,
					popClose: close
				};
				$("div.printableArea").printArea(options);
			});
		});
		</script>
		<script>
		function openReminderModal(property_id) {
			var data = {
				'property_id': property_id
			};
			$.get('/update_chat_history', data, function(data) {
				document.getElementById('exampleModal1').innerHTML = data;
				$('#exampleModal1').modal();
			});
		}

		function updateChat() {
			var property_id = [];
			$.each($(".chlid_checkbox:checked"), function() {
				property_id.push(Number($(this).val()));
			});
			data = {
				'property_id': property_id,
				'remarks': $('#remarks').val(),
				'next_follow_up': $('#next_follow_up').val(),
				'status': $('#status').val(),
				'user_assign': $('#user_assign').val()
			};
			$.get('/update_history', data, function(data) {
				if(data.remarks || data.next_follow_up || data.status || data.user_assign) {
					$("#remarks_eror").text(data.remarks);
					$("#next_follow_up_error").text(data.next_follow_up);
					$("#status_error").text(data.status);
					$("#user_error").text(data.user_assign);
				} else if(data.success == true) {
					toastr.success(data.message);
					$("#exampleModal1").click();
				}
			}, 'json');
		}

		function deleteFollowup(id) {
			data = {
				'id': id
			};
			$.get('/delete_followup', data, function(data) {
				document.getElementById('exampleModal1').innerHTML = data;
				toastr.success("Follow up Deleted Successfully.");
			});
		}
		$(document).ready(function() {
			$('#select_all').on('click', function() {
				if(this.checked) {
					$('.checkbox').each(function() {
						this.checked = true;
					});
				} else {
					$('.checkbox').each(function() {
						this.checked = false;
					});
				}
			});
			$('.checkbox').on('click', function() {
				if($('.checkbox:checked').length == $('.checkbox').length) {
					$('#select_all').prop('checked', true);
				} else {
					$('#select_all').prop('checked', false);
				}
			});
		});

		function openReminderModal2(self) {
			var property_id = [];
			$.each($(".chlid_checkbox:checked"), function() {
				property_id.push(Number($(this).val()));
			});
			var data = {
				'property_id': property_id
			};
			$.get('/update_chat_historyy', data, function(data) {
				document.getElementById('exampleModal1').innerHTML = data;
				$('#exampleModal1').modal();
			});
		}
		</script> 
		@stop