@extends('layouts.app')

@section('title')
Aging Receivable
@stop
@section('css')
<style type="text/css" media="print">
  @page {
    size: landscape;
   }
</style>

<style>

    .us_table_bdr>td, .us_table_bdr>th, .us_table_bdr>td, .us_table_bdr>th {
        border: 1px solid black !important;
    }
</style>

<!-- <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet"> -->
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">
@stop


@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Account Statement</li>
      </ol>
@stop
@section('content')

<div class="container-fluid">
                <div class="row ">
                  <div class="col-lg-12  ">
                    <div class="white-box">
                        <div class="text-center">
                            <h3><strong>{{env('APP_NAME')}}</strong></h3>
                            <h4><strong>Aging And Receivable Sheet</strong></h4>
                        </div>
                        

                        <div class="pull-right" style="    margin-bottom: 2rem;padding-right: 3rem;" >
                            <span>Date: <b>{{date('d/m/Y')}}</b></span><br>
                        <!--<span>Report No: &nbsp;202030</span><br>-->
                            <span>User ID: &nbsp; {{Auth::user()->name}}</span>
                        </div>

                
                        <div class="table-responsive" style="clear: both;position: relative;bottom: 10rem;">
                            
                                <div style="overflow-y: scroll;height: 565px;    margin-top: 10rem;">
                                    
                                <table id="example1"  class="table bdr table-responsive table-bordered" style="border: 1px solid black;">
                                    <thead>
                                        
                                        <tr class="us_table_bdr">
                                           
                                            <th class="text-center" style="border-bottom: none !important;border: 1px solid #e5ebec;min-width: 10rem;"><strong> FGI</strong></th>
                                            <th class="text-center" style="border-bottom: none !important;border: 1px solid #e5ebec;min-width: 10rem;"><strong> </strong></th>
                                            
                                            <th class="text-center" style="border-bottom: none !important;border: 1px solid #e5ebec;min-width: 10rem;"><strong> </strong></th>
                                            <th class="text-center" style="border-bottom: none !important;border: 1px solid #e5ebec;min-width: 15rem;"><strong> </strong></th>
                                            
                                            <th class="text-center" style="border-bottom: none !important;border: 1px solid #e5ebec;min-width: 10rem;"><strong> </strong></th>
                                            <th class="text-center" style="border-bottom: none !important;border: 1px solid #e5ebec;min-width: 15rem;"><strong> </strong></th>
                                            <th class="text-center" style="border-bottom: none !important;border: 1px solid #e5ebec;min-width: 15rem;"><strong> </strong></th>
                                            
                                            <?php $counter = 0; for($i=0; $i<36; $i++): ?>
                                            <th class="text-center" style="border-right: none !important;border: 1px solid #e5ebec;min-width: 15rem;"><strong> </strong></th>
                                            
                                            <th  style="border-right: none !important;border-left: none !important;border: 1px solid #e5ebec;text-align: center;min-width: 20rem;"><strong> 
                                                RECOVERY &nbsp;&nbsp;&nbsp;& 
                                            </strong></th>

                                            <th  style="border-left: none !important;border-right: none !important;border: 1px solid #e5ebec;text-align: center;min-width: 20rem;"><strong> 
                                                RECEIVABLE
                                            </strong></th>
                                            
                                            <th  style="border-left:none !important;border: 1px solid #e5ebec;text-align: center;min-width: 20rem;"><strong> 
                                                STATUS
                                            </strong></th>

                                            <?php endfor ?>
                                            
                                         </tr>
                                        
                                    </thead>
                                    <tbody>
                                        
                                        
                                         <tr class="us_table_bdr">
                                           
                                            <th class="text-center" style="border-bottom: none !important;border: 1px solid #e5ebec;min-width: 10rem;"><strong> </strong></th>
                                            
                                            <th class="text-center" style="border-bottom: none !important;border: 1px solid #e5ebec;min-width: 10rem;"><strong> </strong></th>
                                            
                                            <th class="text-center" style="border-bottom: none !important;border: 1px solid #e5ebec;min-width: 10rem;"><strong> </strong></th>
                                            
                                            <th class="text-center" style="border-bottom: none !important;border: 1px solid #e5ebec;min-width: 15rem;"><strong> </strong></th>
                                            
                                            <th class="text-center" style="border-bottom: none !important;border: 1px solid #e5ebec;min-width: 10rem;"><strong> </strong></th>
                                            
                                            <th class="text-center" style="border-bottom: none !important;border: 1px solid #e5ebec;min-width: 15rem;"><strong> </strong></th>
                                            
                                             <th class="text-center" style="border-bottom: none !important;border: 1px solid #e5ebec;min-width: 15rem;"><strong> </strong></th>
                                            
                                            <?php $counter = 0; for($i=0; $i<20; $i++): ?>
                                            
                                            <th style="border-right:none !important;border: 1px solid #e5ebec;"></th>
                                              <th  style="border-left:none !important;border-right: none !important;border: 1px solid #e5ebec;text-align: center;min-width: 20rem;">
                                            <th  style="border-left:none !important;border-right: none !important;border: 1px solid #e5ebec;text-align: center;min-width: 20rem;">
                                                <strong> 
                                                    <?php 
                                                    if($counter == 0) 
                                                    { echo '25 %  Down Payment'; } 
                                                    else if($counter == 1) 
                                                    { echo 'Advance Tax - Downpayment'; } 
                                                    else if($counter == 18) 
                                                    { echo 'Possession'; } 
                                                    else if($counter == 19) 
                                                    { echo 'Advance Tax - Possession'; } 
                                                    else 
                                                    { echo ($counter-1).' Installment'; }  
                                                    
                                                    ?>
                                                </strong>
                                            </th>
                                            
                                            <th style="border-left:none !important;border: 1px solid #e5ebec;"></th>
                                            
                                            
                                            
                                            <?php
                                            if($counter > 1 && $counter < 18)
                                            {
                                             ?>
                                                 <th  style="border-left:none !important;border-right: none !important;border: 1px solid #e5ebec;text-align: center;min-width: 22rem;">
                                                <th  style="border-left:none !important;border-right: none !important;border: 1px solid #e5ebec;text-align: center;min-width: 22rem;">
                                                <th  style="border-left:none !important;border-right: none !important;border: 1px solid #e5ebec;text-align: center;min-width: 22rem;">
                                                <strong> 
                                                <?php echo ' Advance Tax ' .($counter-1). ' - Installment'; ?>
                                                </strong>
                                                </th>
                                            
                                            <th style="border-left:none !important;border: 1px solid #e5ebec;"></th>
                                                
                                            <?php
                                            }
                                            $counter++;
                                            ?>
                                            

                                            <?php endfor ?>
                                            
                                         </tr>

                                         <tr class="us_table_bdr">
                                             <th class="text-center" style="border-top: none !important;">Sr. No</th>
                                             
                                            <th class="text-center" style="border-top: none !important;">Floor No</th>
                                            
                                            <th class="text-center" style="border-top: none !important;">Appt. No</th>
                                    
                                            <th class="text-center" style="border-top: none !important;">Allotee Name</th>
                                            
                                            <th class="text-center" style="border-top: none !important;">Net Price</th>
                                            
                                            <th class="text-center" style="border-top: none !important;">Booking / DP Date</th>
                                            
                                             <th class="text-center" style="border-top: none !important;">Total Received</th>
                                            
                                            <?php for($i=0; $i<36; $i++): ?>
                                            
                                            <th class="text-center"><strong>Due </strong></th>
                                            
                                            <th class="text-center"><strong>Received</strong></th>
                                            
                                            <th class="text-center"><strong>Receivable</strong></th>
                                            
                                            <th class="text-center"><strong>Days Overdue</strong></th>
                                            
                                            <?php endfor ?>
                                            
                                            
                                         </tr>
                                         
                                         
                                        <?php 
                                        $downpayment_due_grand_total = 0; $downpayment_received_grand_total = 0; $downpayment_receaviable_grand_total = 0; 
                                        $possession_due_grand_total = 0; $possession_received_grand_total = 0; $possession_receaviable_grand_total = 0;
                                        $possession_tax_due_grand_total = 0; $possession_tax_received_grand_total = 0; $possession_tax_receaviable_grand_total = 0;
                                        $downpayment_tax_received_grand_total = 0; $downpayment_tax_due_grand_total = 0; $downpayment_tax_receaviable_grand_total = 0; 
                                        $net_grand_total = 0; $grand_total_received = 0;
                                        ?>
                                  
                                        @foreach($blocks as $b)
                                        <?php 
                                            $downpayment_due_total = 0; $downpayment_received_total = 0; $downpayment_receaviable_total = 0; 
                                            $possession_due_total = 0; $possession_received_total = 0; $possession_receaviable_total = 0;
                                            $possession_tax_due_total = 0; $possession_tax_received_total = 0; $possession_tax_receaviable_total = 0;
                                            $downpayment_tax_received_total = 0; $downpayment_tax_due_total = 0; $downpayment_tax_receaviable_total = 0; 
                                            $serial_no = 1;
                                            $net_price = 0;
                                            $total_received = 0;
                                        ?>
                                          
                                        <tr >
                                        <th  style="border-right: none;border-left: none;" >{{$b->name}}</th>
                                        <th style="border-right: none;">&nbsp;</th>
                                        <th style="border-right: none;border-left: none;">&nbsp;</th>
                                        <th  style="border-right: none;border-left: none;">&nbsp;</th>
                                        
                                        <th  style="border-right: none;border-left: none;">&nbsp;</th>
                                        
                                        <th  style="border-right: none;border-left: none;">&nbsp;</th>
                                        
                                        <th  style="border-right: none;border-left: none;">&nbsp;</th>
                                      
                                        <?php for($i=0; $i<36; $i++): ?>
                                        
                                         <th  style="border-right: none;border-left: none;">&nbsp;</th>
                                        
                                        <th  style="border-right: none;border-left: none;">&nbsp;</th>
                                        
                                        <th  style="border-right: none;border-left: none;">&nbsp;</th>
                                        
                                        <th  style="border-right: none;border-left: none;">&nbsp;</th>
                                        
                                        <?php endfor ?>
                                        
                                        </tr>
                                        
                                            @foreach($due as $statement)
                                            
                                        
                                                @if($b->id == \App\UnitBlock::find($statement->inventory->floor->unit_block_id)->id)
                                                
                                                <tr >
                                                    <th   class="text-center">{{$serial_no++}}</th>
                                                    <th  class="text-center">{{$statement->inventory ? $statement->inventory->floor->name : ''}}</th>
                                                    <th  class="text-center">{{$statement->inventory ? $statement->inventory->unit_number : ''}}</th>
                                                    <th   class="text-center">{{$statement->customer ? $statement->customer->name: ''}}</th>
                                                    <th   class="text-center">{{number_format($statement->net_pay)}} </th>
                                                    <th   class="text-center">{{date('d/m/Y' , strtotime($statement->booking_date))}} </th>
                                                     <th   class="text-center">{{number_format($receivedAmt[$statement->id])}} </th>
                                                    
                                                    
                                                    <th  class="text-center">{{number_format($downPayment_dueAmt[$statement->id])}} </th>
                                                    <th   class="text-center">{{number_format($downPayment_receivedAmt[$statement->id])}} </th>
                                                    <th   class="text-center">{{number_format($downPayment_receaviable[$statement->id])}} </th>
                                                    <th   class="text-center">{{$downPayment_latedays[$statement->id]}} </th>
                                                    
                                                    
                                                    
                                                    <th  class="text-center">{{number_format($downpayment_tax_due[$statement->id])}} </th>
                                                    <th   class="text-center">{{number_format($downpayment_tax_received[$statement->id])}} </th>
                                                    <th   class="text-center">{{number_format($downpayment_tax_receaviable[$statement->id])}} </th>
                                                    <th   class="text-center">{{$downPayment_tax_due_latedays[$statement->id]}} </th>
                                                    
                                                    <?php for($i=1; $i<=16; $i++): ?>
                                                    
                                                     
                                                     
                                                    <th class="text-center due"  data-due="due_{{$i}}"  data-block="{{$b->id}}">{{($installment_dueAmt[$i][$statement->id])}} </th>
                                                    
                                                    <th class="text-center received" data-received="received_{{$i}}" data-block="{{$b->id}}">{{($installment_receivedAmt[$i][$statement->id])}}</th>
                                                    
                                                    <th class="text-center receaviable" data-receaviable="receaviable_{{$i}}" data-block="{{$b->id}}">{{($installment_receaviable[$i][$statement->id])}}</th>
                                                    
                                                    <th   class="text-center">{{$installment_latedays[$i][$statement->id]}} </th>
                                                    
                                                    
                                                    
                                                    <th class="text-center tax_due"  data-due="due_{{$i}}"  data-block="{{$b->id}}">{{($installment_tax_due[$i][$statement->id])}}  </th>
                                                    
                                                    <th class="text-center tax_received" data-received="received_{{$i}}" data-block="{{$b->id}}">{{($installment_tax_received[$i][$statement->id])}}</th>
                                                    
                                                    <th class="text-center tax_receaviable" data-receaviable="receaviable_{{$i}}" data-block="{{$b->id}}">{{($installment_tax_receaviable[$i][$statement->id])}}</th>
                                                    
                                                    <th   class="text-center">{{$installment_tax_due_latedays[$i][$statement->id]}} </th>
                                                    
                                                    
                                                    <?php endfor ?>
                                                    
                                                   
                                                    <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($possession_dueAmt[$statement->id])}}  </th>
                                                    <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($possession_receivedAmt[$statement->id])}} </th>
                                                    <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($possession_receaviable[$statement->id])}} </th>
                                                    
                                                     <th   class="text-center">{{$possession_latedays[$statement->id]}} </th>
                                                    
                                                    
                                                    <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($possession_tax_due[$statement->id])}}   </th>
                                                    <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($possession_tax_received[$statement->id])}} </th>
                                                    <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($possession_tax_receaviable[$statement->id])}} </th>
                                                    
                                                    <th   class="text-center">{{$possession_tax_due_latedays[$statement->id]}} </th>
                                                    
                                                </tr>
                                                    <?php 
                                                        $net_price +=$statement->net_pay;
                                                        $total_received += $receivedAmt[$statement->id];
                                                        $downpayment_due_total+=$downPayment_dueAmt[$statement->id]; 
                                                        $downpayment_received_total+=$downPayment_receivedAmt[$statement->id]; 
                                                        $downpayment_receaviable_total+=$downPayment_receaviable[$statement->id]; 
                                                        $possession_due_total+=$possession_dueAmt[$statement->id]; 
                                                        $possession_received_total+=$possession_receivedAmt[$statement->id]; 
                                                        $possession_receaviable_total+=$possession_receaviable[$statement->id]; 
                                                        $downpayment_tax_due_total+=$downpayment_tax_due[$statement->id]; 
                                                        $downpayment_tax_received_total+=$downpayment_tax_received[$statement->id]; 
                                                        $downpayment_tax_receaviable_total+=$downpayment_tax_receaviable[$statement->id]; 
                                                        $possession_tax_due_total+=$possession_tax_due[$statement->id]; 
                                                        $possession_tax_received_total+=$possession_tax_received[$statement->id]; 
                                                        $possession_tax_receaviable_total+=$possession_tax_receaviable[$statement->id]; 
                                                    ?>
                                                @endif
                                                
                                                
                                            @endforeach
                                            
                                         
                                            <tr >
                                            <th  style="border-right: none;border-left: none;">Sub Total</th>
                                            <th style="border-right: none;">&nbsp;</th>
                                            <th style="border-right: none;border-left: none;">&nbsp;</th>
                                            <th style="border-right: none;border-left: none;">&nbsp;</th>
                                            
                                            
                                            <th style="border-right: none;border-left: none;" class="text-center">{{number_format($net_price)}}</th>
                                            <th style="border-right: none;border-left: none;">&nbsp;</th>
                                            <th style="border-right: none;border-left: none;" class="text-center">{{number_format($total_received)}}</th>
                                            
                                            
                                            <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($downpayment_due_total)}}</th>
                                            
                                            <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($downpayment_received_total)}}</th>
                                            
                                            <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($downpayment_receaviable_total)}}</th>
                                            
                                            <th style="border-right: none;border-left: none;">&nbsp;</th>
                                            
                                            
                                            <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($downpayment_tax_due_total)}}</th>
                                            
                                            <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($downpayment_tax_received_total)}}</th>
                                            
                                            <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($downpayment_tax_receaviable_total)}}</th>
                                            
                                            <th style="border-right: none;border-left: none;">&nbsp;</th>
                                            
                                            <?php for($i=1; $i<=16; $i++): ?>
                                            
                                            
                                            
                                            <th  style="border-right: none;border-left: none;" id="due_{{$i}}_block_{{$b->id}}"  class="text-center  due_{{$i}}">&nbsp;</th>
                                            
                                            <th  style="border-right: none;border-left: none;" id="received_{{$i}}_block_{{$b->id}}" class="text-center received_{{$i}}">&nbsp;</th>
                                            
                                            <th  style="border-right: none;border-left: none;" id="receaviable_{{$i}}_block_{{$b->id}}" class="text-center receaviable_{{$i}}">&nbsp;</th>
                                            
                                            <th style="border-right: none;border-left: none;">&nbsp;</th>
                                                                                        
                                            <th  style="border-right: none;border-left: none;" id="tax_due_{{$i}}_block_{{$b->id}}"  class="text-center tax_due_{{$i}}">&nbsp;</th>
                                            
                                            <th  style="border-right: none;border-left: none;" id="tax_received_{{$i}}_block_{{$b->id}}" class="text-center tax_received_{{$i}}">&nbsp;</th>
                                            
                                            <th  style="border-right: none;border-left: none;" id="tax_receaviable_{{$i}}_block_{{$b->id}}" class="text-center tax_receaviable_{{$i}}">&nbsp;</th>
                                            
                                            
                                            <th style="border-right: none;border-left: none;">&nbsp;</th>
                                            <?php endfor ?>
                                            
                                            
                                            
                                            <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($possession_due_total)}}</th>
                                            
                                            <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($possession_received_total)}}</th>
                                            
                                            <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($possession_receaviable_total)}}</th>
                                            
                                            <th style="border-right: none;border-left: none;">&nbsp;</th>
                                            
                                            <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($possession_tax_due_total)}}</th>
                                            
                                            <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($possession_tax_received_total)}}</th>
                                            
                                            <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($possession_tax_receaviable_total)}}</th>
                                            
                                            <th style="border-right: none;border-left: none;">&nbsp;</th>
                                            </tr>
                                            
                                            
                                            <?php 
                                            $net_grand_total +=  $net_price;
                                            $grand_total_received += $total_received;
                                            $downpayment_due_grand_total+=$downpayment_due_total; 
                                            $downpayment_received_grand_total+=$downpayment_received_total; 
                                            $downpayment_receaviable_grand_total+=$downpayment_receaviable_total; 
                                            $possession_due_grand_total+=$possession_due_total; 
                                            $possession_received_grand_total+=$possession_received_total; 
                                            $possession_receaviable_grand_total+=$possession_receaviable_total; 
                                            $downpayment_tax_due_grand_total+=$downpayment_tax_due_total; 
                                            $downpayment_tax_received_grand_total+=$downpayment_tax_received_total; 
                                            $downpayment_tax_receaviable_grand_total+=$downpayment_tax_receaviable_total; 
                                            $possession_tax_due_grand_total+=$possession_tax_due_total; 
                                            $possession_tax_received_grand_total+=$possession_tax_received_total; 
                                            $possession_tax_receaviable_grand_total+=$possession_tax_receaviable_total; 
                                            ?>
                                            
                                            @endforeach
                                            
                                            <tr >
                                        <th  style="border-right: none;border-left: none;">GRAND TOTAL</th>
                                        <th style="border-right: none;">&nbsp;</th>
                                        <th style="border-right: none;border-left: none;">&nbsp;</th>
                                        <th style="border-right: none;border-left: none;">&nbsp;</th>
                                        <th style="border-right: none;border-left: none;" class="text-center">{{number_format($net_grand_total)}}</th>
                                        <th style="border-right: none;border-left: none;">&nbsp;</th>
                                        <th style="border-right: none;border-left: none;" class="text-center">{{number_format($grand_total_received)}}</th>
                                         
                                         
                                        <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($downpayment_due_grand_total)}}</th>
                                        
                                        <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($downpayment_received_grand_total)}}</th>
                                        
                                        <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($downpayment_receaviable_grand_total)}}</th>
                                        
                                        <th style="border-right: none;border-left: none;">&nbsp;</th>
                                        
                                        <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($downpayment_tax_due_grand_total)}}</th>
                                        
                                        <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($downpayment_tax_received_grand_total)}}</th>
                                        
                                        <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($downpayment_tax_receaviable_grand_total)}}</th>
                                        
                                        <th style="border-right: none;border-left: none;">&nbsp;</th>
                                        
                                        <?php for($i=1; $i<=16; $i++): ?>
                                        
                                        
                                                                                    
                                        <th  style="border-right: none;border-left: none;" id="grand_due_{{$i}}"  class="text-center">&nbsp;</th>
                                        
                                        <th  style="border-right: none;border-left: none;" id="grand_received_{{$i}}" class="text-center">&nbsp;</th>
                                        
                                        <th  style="border-right: none;border-left: none;" id="grand_receaviable_{{$i}}" class="text-center">&nbsp;</th>
                                        
                                        
                                        <th style="border-right: none;border-left: none;">&nbsp;</th>
                                        
                                        <th  style="border-right: none;border-left: none;" id="grand_tax_due_{{$i}}"  class="text-center">&nbsp;</th>
                                        
                                        <th  style="border-right: none;border-left: none;" id="grand_tax_received_{{$i}}" class="text-center">&nbsp;</th>
                                        
                                        <th  style="border-right: none;border-left: none;" id="grand_tax_receaviable_{{$i}}" class="text-center">&nbsp;</th>
                                        
                                        <th style="border-right: none;border-left: none;">&nbsp;</th>
                                        
                                        <?php endfor ?>
                                        
                                        
                                        
                                         <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($possession_due_grand_total)}}</th>
                                        
                                        <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($possession_received_grand_total)}}</th>
                                        
                                        <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($possession_receaviable_grand_total)}}</th>
                                        
                                        <th style="border-right: none;border-left: none;">&nbsp;</th>
                                        
                                        <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($possession_tax_due_grand_total)}}</th>
                                        
                                        <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($possession_tax_received_grand_total)}}</th>
                                        
                                        <th  style="border-right: none;border-left: none;" class="text-center">{{number_format($possession_tax_receaviable_grand_total)}}</th>
                                        
                                        <th style="border-right: none;border-left: none;">&nbsp;</th>
                                        </tr>
                                        
                            
                    
                </tbody>
            </table>
            
            </div>
            

            </div>
            </div>
            
            </div>
      


@stop

@section('js')
<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>

<!-- <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script> -->
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

 <script>
     $( document ).ready(function() 
     {
         
         <?php
         foreach($blocks as $b)
         {
         ?>
                for($i=1; $i<=16; $i++)
                {
                    var inst_due_sum = 0;
                    var inst_received_sum = 0;
                    var inst_receaviable_sum = 0;
                    var inst_tax_due_sum = 0;
                    var inst_tax_received_sum = 0;
                    var inst_tax_receaviable_sum = 0;
                    
                    $('.due').each(function()
                    {
                        var due = $(this).attr("data-due");
                        var block = $(this).attr("data-block");
                        
                        if(due == 'due_'+$i && block == "{{$b->id}}")
                        {
                            inst_due_sum += parseFloat($(this).text());  
                        }
                    });
                    
                    
                    $('.tax_due').each(function()
                    {
                        var tax_due = $(this).attr("data-due");
                        var tax_block = $(this).attr("data-block");
                        
                        if(tax_due == 'due_'+$i && tax_block == "{{$b->id}}")
                        {
                            inst_tax_due_sum += parseFloat($(this).text());  
                        }
                    });
                    
                    
                    $('.received').each(function()
                    {
                        var received = $(this).attr("data-received");
                        var block = $(this).attr("data-block");
                        
                        if(received == 'received_'+$i && block == "{{$b->id}}")
                        {
                            inst_received_sum += parseFloat($(this).text());  
                        }
                    });
                    
                    
                    $('.tax_received').each(function()
                    {
                        var tax_received = $(this).attr("data-received");
                        var tax_block = $(this).attr("data-block");
                        
                        if(tax_received == 'received_'+$i && tax_block == "{{$b->id}}")
                        {
                            inst_tax_received_sum += parseFloat($(this).text());  
                        }
                    });
                    
                    
                    $('.receaviable').each(function()
                    {
                        var receaviable = $(this).attr("data-receaviable");
                        var block = $(this).attr("data-block");
                        
                        if(receaviable == 'receaviable_'+$i && block == "{{$b->id}}")
                        {
                            inst_receaviable_sum += parseFloat($(this).text());  
                        }
                    });
                    
                    
                    $('.tax_receaviable').each(function()
                    {
                        var tax_receaviable = $(this).attr("data-receaviable");
                        var tax_block = $(this).attr("data-block");
                        
                        if(tax_receaviable == 'receaviable_'+$i && tax_block == "{{$b->id}}")
                        {
                            inst_tax_receaviable_sum += parseFloat($(this).text());  
                        }
                    });
                    
                    $('#due_'+$i+'_block_{{$b->id}}').html(Math.round(inst_due_sum));
                    $('#receaviable_'+$i+'_block_{{$b->id}}').html(Math.round(inst_receaviable_sum));
                    $('#received_'+$i+'_block_{{$b->id}}').html(Math.round(inst_received_sum));
                    $('#tax_due_'+$i+'_block_{{$b->id}}').html(Math.round(inst_tax_due_sum));
                    $('#tax_receaviable_'+$i+'_block_{{$b->id}}').html(Math.round(inst_tax_receaviable_sum));
                    $('#tax_received_'+$i+'_block_{{$b->id}}').html(Math.round(inst_tax_received_sum));
                }
        
         <?php
         }
         ?>
         
         
         
         
         
          for($i=1; $i<=16; $i++)
                {
                    var inst_due_sum = 0;
                    var inst_received_sum = 0;
                    var inst_receaviable_sum = 0;
                    var inst_tax_due_sum = 0;
                    var inst_tax_received_sum = 0;
                    var inst_tax_receaviable_sum = 0;
                    
                    $('.due_'+$i).each(function()
                    {
                        
                            inst_due_sum += parseFloat($(this).text());  
                        
                    });
                    
                    
                    $('.tax_due_'+$i).each(function()
                    {
                       
                            inst_tax_due_sum += parseFloat($(this).text());  
                      
                    });
                    
                    
                    $('.received_'+$i).each(function()
                    {
                        
                            inst_received_sum += parseFloat($(this).text());  
                        
                    });
                    
                    
                    $('.tax_received_'+$i).each(function()
                    {
                        
                            inst_tax_received_sum += parseFloat($(this).text());  
                        
                    });
                    
                    
                    $('.receaviable_'+$i).each(function()
                    {
                        
                            inst_receaviable_sum += parseFloat($(this).text());  
                        
                    });
                    
                    
                    $('.tax_receaviable_'+$i).each(function()
                    {
                        
                            inst_tax_receaviable_sum += parseFloat($(this).text());  
                        
                    });
                    
                    $('#grand_due_'+$i).html(Math.round(inst_due_sum));
                    $('#grand_receaviable_'+$i).html(Math.round(inst_receaviable_sum));
                    $('#grand_received_'+$i).html(Math.round(inst_received_sum));
                    $('#grand_tax_due_'+$i).html(Math.round(inst_tax_due_sum));
                    $('#grand_tax_receaviable_'+$i).html(Math.round(inst_tax_receaviable_sum));
                    $('#grand_tax_received_'+$i).html(Math.round(inst_tax_received_sum));
                }
                
                
                
            $('#example1').DataTable({
                paging:false,
                ordering:false,
                dom: 'Bfrtip',
                buttons: [
                    'copy', 'csv', 'excel', 'print',
                    {
                        extend : 'pdfHtml5',
                        title : function() 
                        {
                            return "{{env('APP_NAME')}}\n Aging Of Receivable Sheet";
                        },
                            orientation : 'landscape',
                            pageSize : 'A0', // You can also use "A1","A2" or "A3", most of the time "A3" works the best.
                            text : '<i class=""> PDF</i>',
                            titleAttr : 'PDF'
                    }
                ],
                
            });
                
    });
    
    
    
     
 </script>
@stop