<div class="row printableArea"  style="margin-top: 25px;">
    <div class="col-lg-12  ">
        <div class="white-box">
            <div class="text-center">
                <h3><strong>
                        @foreach ($project_names as $key => $project_name)
                            {{ $project_name }}
                            @if ($key < count($project_names) - 1)
                                ,
                            @endif
                        @endforeach

                    </strong></h3>
                <h4><strong>A/R Aging Report</strong></h4>
            </div>


            <div class="pull-right printFV">
                <span>Date: <b>{{ date('d/m/Y') }}</b></span><br>

                <span>User ID: &nbsp; {{ Auth::user()->name }}</span>
            </div>


            <div class="table-responsive" style="clear: both;">

                <form method="get" style="" action="{{ route('report.aging') }}" class="no-print">
                    <input type="hidden" value='{{ $multipro_id }}' name="multipro_id">
                    <input type="hidden" value='1' name="filter_data">
                    <div class="row">
                        <div class="col-lg-5">

                            <select class="form-control chosen-select" name="block">
                                <option value="">All Blocks</option>
                                @foreach ($unit_blocks as $unit_block)
                                    <option <?= $block == $unit_block->id ? 'selected' : '' ?>
                                        value="{{ $unit_block->id }}">{{ $unit_block->name }}</option>
                                @endforeach
                            </select>
                        </div>


                        <div class="col-lg-2">
                            <input type="submit" value="Filter" class="btn btn-success">
                        </div>


                    </div>
                </form>


                <table id="example1" class="table border bdr ">
                    <thead>
                        <tr>
                            <th>Client</th>
                            <th>Unit No. </th>
                            <th>Unit Floor. </th>
                            <th>Unit Block. </th>

                            <th class="text-center">0 - 30 Days</th>
                            <th class="text-center">31 - 60 Days</th>
                            <th class="text-center">61 - 90 Days</th>
                            <th class="text-center">90+ Days</th>
                            <th class="text-center">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $first = 0;
                        $second = 0;
                        $third = 0;
                        $fourth = 0;
                        $total = 0; ?>
                        @foreach ($allDueStatements as $statement)

                            @if ($statement->inventory->floor)
                                @if ($statement->inventory->floor->unitBlock)
                                    @if (
                                        ($filter_type == 'filter' && $block > 0 && $block == $statement->inventory->floor->unitBlock->id) ||
                                            $filter_type == 'all')
                                        <tr>
                                            <?php $totalAmount = $first_tenure[$statement->id] + $second_tenure[$statement->id] + $third_tenure[$statement->id] + $fourth_tenure[$statement->id]; ?>

                                            <td class="printFV"> {{ $statement->customer->name }}</td>

                                            <td class="printFV">
                                                {{ $statement->inventory ? $statement->inventory->unit_number : '' }}
                                            </td>

                                            <td class="printFV">
                                                {{ $statement->inventory->floor ? $statement->inventory->floor->name : '' }}
                                            </td>

                                            <td class="printFV">
                                                @if ($statement->inventory)
                                                    @if ($statement->inventory->floor)
                                                        {{ $statement->inventory->floor->unitBlock ? $statement->inventory->floor->unitBlock->name : '' }}
                                                    @endif
                                                @endif

                                            </td>

                                            <td class="printFV text-right">
                                                {{ number_format($first_tenure[$statement->id]) }}
                                                @if ($totalAmount > 0)
                                                    ({{ round(($first_tenure[$statement->id] / $totalAmount) * 100) }}
                                                    %)
                                                @endif

                                            </td>
                                            <td class="printFV text-right">
                                                {{ number_format($second_tenure[$statement->id]) }}
                                                @if ($totalAmount > 0)
                                                    ({{ round(($second_tenure[$statement->id] / $totalAmount) * 100) }}
                                                    %)
                                                @endif
                                            </td>
                                            <td class="printFV text-right">
                                                {{ number_format($third_tenure[$statement->id]) }}
                                                @if ($totalAmount > 0)
                                                    ({{ round($third_tenure[$statement->id] / $totalAmount) * 100 }}
                                                    %)
                                                @endif
                                            </td>
                                            <td class="printFV text-right">
                                                {{ number_format($fourth_tenure[$statement->id]) }}
                                                @if ($totalAmount > 0)
                                                    ({{ round(($fourth_tenure[$statement->id] / $totalAmount) * 100) }}
                                                    %)
                                                @endif
                                            </td>
                                            <td class="printFV text-right">
                                                {{ number_format($first_tenure[$statement->id] + $second_tenure[$statement->id] + $third_tenure[$statement->id] + $fourth_tenure[$statement->id]) }}
                                            </td>

                                        </tr>
                                        <?php $first += $first_tenure[$statement->id]; ?>
                                        <?php $second += $second_tenure[$statement->id]; ?>
                                        <?php $third += $third_tenure[$statement->id]; ?>
                                        <?php $fourth += $fourth_tenure[$statement->id]; ?>
                                        <?php $total += $first_tenure[$statement->id] + $second_tenure[$statement->id] + $third_tenure[$statement->id] + $fourth_tenure[$statement->id]; ?>
                                    @endif
                                @endif
                            @endif
                        @endforeach()

                        <tr>
                            <td colspan="4" class="text-right"><b> Summary</b> </td>
                            <td class="text-right"><b>{{ number_format($first) }}</b></td>
                            <td class="text-right"><b>{{ number_format($second) }}</b></td>
                            <td class="text-right"><b>{{ number_format($third) }}</b></td>
                            <td class="text-right"><b>{{ number_format($fourth) }}</b></td>
                            <td class="text-right"><b>{{ number_format($total) }}</b></td>
                        </tr>

                    </tbody>
                </table>


            </div>
        </div>
    </div>

</div>
<!-- /.container-fluid -->

<div class="text-right" style="height:70px;">
    <button class="btn btn-default btn-outline no-print" onclick="window.print();return false;" type="button">
        <span><i class="fa fa-print"></i> Print</span> </button>
</div>