@extends('layouts.app')

@section('title')
    Aging Report
@stop


@section('breadcrumb')
    <ol class="breadcrumb pull-right no-print">
        <li><a href="{{ route('home') }}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Aging Report</li>
    </ol>
@stop

@section('css')
    <style type="text/css">
        @media print {
            .page-wrapper {
                font-size: 12px !important;
                font-family: "time-new-roman", Arial, sans-serif !important;
                padding-top: 0px !important;
                color: black;
            }

            .printableArea {
                color: black;
            }

            strong {
                color: black;
            }

            .pd-5 {
                padding: 5px;
            }

            .br-btm {
                border-bottom: 1px solid #e6e3e3;
            }

            /*.br-right {
                 border-right: 1px solid #e6e3e3;
                }*/
            .txt-c {
                text-align: center;
            }

            .white-box {
                border: none !important;
                padding: 0 3px 0 0px;
            }

            .dataTables_info {
                display: none;
            }

            .dataTables_filter {
                display: none;
            }

            div.dt-buttons {
                display: none;
            }

            table.dataTable thead th {
                border: 1px solid #f2f2f2 !important;
            }

            .table>tbody>tr>td {
                border: 1px solid #f2f2f2 !important;
            }

            .bor .border-d {
                border-bottom: double !important;
                border-top: 1px solid !important;
            }

            h3 strong {
                text-transform: uppercase;
            }

            h4 strong {
                text-transform: uppercase;
            }

            h3 {
                margin-bottom: -10px;
            }

            table.dataTable.no-footer {
                border-bottom: none !important;
            }

            .table>tbody>tr>td,
            .table>tbody>tr>th {
                font-size: 12px;
            }

            .page-wrapper {
                padding-top: 0px;
            }

            .white-box1 {
                padding: 0;
            }

            .bdr thead tr th {
                border: 1px solid #2e3233 !important;
                background: #eee;
            }

            .table>thead:first-child>tr:first-child>th {
                border-top: 1px solid !important;
            }
        }
    </style>

    <!-- <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet"> -->
    <link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css" rel="stylesheet">
@stop

@section('content')

    <div class="container-fluid">
        @can('isSuperAdmin')
            @include('partial.multiproject_select')
        @endcan
        <div id='updatecontent'>
            <div class="row printableArea" style="margin-top: 25px;">
                <div class="col-lg-12  ">
                    <div class="white-box">
                        <div class="text-center">
                            <h3><strong>
                                    @foreach ($project_names as $key => $project_name)
                                        {{ $project_name }}
                                        @if ($key < count($project_names) - 1)
                                            ,
                                        @endif
                                    @endforeach

                                </strong></h3>
                            <h4><strong>A/R Aging Report</strong></h4>
                        </div>


                        <div class="pull-right printFV">
                            <span>Date: <b>{{ date('d/m/Y') }}</b></span><br>

                            <span>User ID: &nbsp; {{ Auth::user()->name }}</span>
                        </div>


                        <div class="table-responsive" style="clear: both;">

                            <form method="get" style="" action="{{ route('report.aging') }}" class="no-print">
                                <input type="hidden" value='{{ $multipro_id }}' name="multipro_id">
                                <input type="hidden" value='1' name="filter_data">
                                <div class="row">
                                    <div class="col-lg-5">

                                        <select class="form-control chosen-select" name="block">
                                            <option value="">All Blocks</option>
                                            @foreach ($unit_blocks as $unit_block)
                                                <option <?= $block == $unit_block->id ? 'selected' : '' ?>
                                                    value="{{ $unit_block->id }}">{{ $unit_block->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>


                                    <div class="col-lg-2">
                                        <input type="submit" value="Filter" class="btn btn-success">
                                    </div>


                                </div>
                            </form>


                            <table id="example1" class="table border bdr ">
                                <thead>
                                    <tr>
                                        <th>Client</th>
                                        <th>Unit No. </th>
                                        <th>Unit Floor. </th>
                                        <th>Unit Block. </th>

                                        <th class="text-center">0 - 30 Days</th>
                                        <th class="text-center">31 - 60 Days</th>
                                        <th class="text-center">61 - 90 Days</th>
                                        <th class="text-center">90+ Days</th>
                                        <th class="text-center">Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $first = 0;
                                    $second = 0;
                                    $third = 0;
                                    $fourth = 0;
                                    $total = 0; ?>
                                    @foreach ($allDueStatements as $statement)

                                        @if ($statement->inventory->floor)
                                            @if ($statement->inventory->floor->unitBlock)
                                                @if (
                                                    ($filter_type == 'filter' && $block > 0 && $block == $statement->inventory->floor->unitBlock->id) ||
                                                        $filter_type == 'all')
                                                    <tr>
                                                        <?php $totalAmount = $first_tenure[$statement->id] + $second_tenure[$statement->id] + $third_tenure[$statement->id] + $fourth_tenure[$statement->id]; ?>

                                                        <td class="printFV"> {{ $statement->customer->name }}</td>

                                                        <td class="printFV">
                                                            {{ $statement->inventory ? $statement->inventory->unit_number : '' }}
                                                        </td>

                                                        <td class="printFV">
                                                            {{ $statement->inventory->floor ? $statement->inventory->floor->name : '' }}
                                                        </td>

                                                        <td class="printFV">
                                                            @if ($statement->inventory)
                                                                @if ($statement->inventory->floor)
                                                                    {{ $statement->inventory->floor->unitBlock ? $statement->inventory->floor->unitBlock->name : '' }}
                                                                @endif
                                                            @endif

                                                        </td>

                                                        <td class="printFV text-right">
                                                            {{ number_format($first_tenure[$statement->id]) }}
                                                            @if ($totalAmount > 0)
                                                                ({{ round(($first_tenure[$statement->id] / $totalAmount) * 100) }}
                                                                %)
                                                            @endif

                                                        </td>
                                                        <td class="printFV text-right">
                                                            {{ number_format($second_tenure[$statement->id]) }}
                                                            @if ($totalAmount > 0)
                                                                ({{ round(($second_tenure[$statement->id] / $totalAmount) * 100) }}
                                                                %)
                                                            @endif
                                                        </td>
                                                        <td class="printFV text-right">
                                                            {{ number_format($third_tenure[$statement->id]) }}
                                                            @if ($totalAmount > 0)
                                                                ({{ round($third_tenure[$statement->id] / $totalAmount) * 100 }}
                                                                %)
                                                            @endif
                                                        </td>
                                                        <td class="printFV text-right">
                                                            {{ number_format($fourth_tenure[$statement->id]) }}
                                                            @if ($totalAmount > 0)
                                                                ({{ round(($fourth_tenure[$statement->id] / $totalAmount) * 100) }}
                                                                %)
                                                            @endif
                                                        </td>
                                                        <td class="printFV text-right">
                                                            {{ number_format($first_tenure[$statement->id] + $second_tenure[$statement->id] + $third_tenure[$statement->id] + $fourth_tenure[$statement->id]) }}
                                                        </td>

                                                    </tr>
                                                    <?php $first += $first_tenure[$statement->id]; ?>
                                                    <?php $second += $second_tenure[$statement->id]; ?>
                                                    <?php $third += $third_tenure[$statement->id]; ?>
                                                    <?php $fourth += $fourth_tenure[$statement->id]; ?>
                                                    <?php $total += $first_tenure[$statement->id] + $second_tenure[$statement->id] + $third_tenure[$statement->id] + $fourth_tenure[$statement->id]; ?>
                                                @endif
                                            @endif
                                        @endif
                                    @endforeach()

                                    <tr>
                                        <td colspan="4" class="text-right"><b> Summary</b> </td>
                                        <td class="text-right"><b>{{ number_format($first) }}</b></td>
                                        <td class="text-right"><b>{{ number_format($second) }}</b></td>
                                        <td class="text-right"><b>{{ number_format($third) }}</b></td>
                                        <td class="text-right"><b>{{ number_format($fourth) }}</b></td>
                                        <td class="text-right"><b>{{ number_format($total) }}</b></td>
                                    </tr>

                                </tbody>
                            </table>


                        </div>
                    </div>
                </div>

            </div>
            <!-- /.container-fluid -->

            <div class="text-right" style="height:70px;">
                <button class="btn btn-default btn-outline no-print" onclick="window.print();return false;" type="button">
                    <span><i class="fa fa-print"></i> Print</span> </button>
            </div>
        </div>
    </div>
@stop

@section('js')
    <script src="{{ asset('js/jquery.PrintArea.js') }}" type="text/JavaScript"></script>

    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

    <script>
        function callItBack() {
            $(function() {
                $("#print").on("click", function() {
                    var mode = 'iframe'; //popup
                    var close = mode == "popup";
                    var options = {
                        mode: mode,
                        popClose: close
                    };
                    $("div.printableArea").printArea(options);
                });
            });
            // $('#example1').DataTable({
            //     sorting: false,
            //     paging: false,
            //     ordering: false,
            //     dom: 'Bfrtip',
            //     buttons: [
            //         'copy', 'csv', 'excel', 'pdf', 'print'
            //     ]
            // });
        }
        callItBack();

        function updateStatus(value) {
            $('.preloader').fadeIn();

            if (value === 'search') {

                $('.preloader').fadeOut();
                return false;
            }
            var data = {
                'multipro_id': value,
            };
            $.get('{{ route('report.aging') }}', data, function(data) {
                $('.preloader').fadeOut();
                $('#myTable tbody').empty();




                document.getElementById('updatecontent').innerHTML = data;
                callItBack();
                toastr.success("Search updated.");


                $('.preloader').fadeOut();
            });

        }
    </script>
@stop
