
@extends('layouts.app')

@section('title')

Report 
@stop

@section('breadcrumb')
<ol class="breadcrumb pull-right">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Balance Sheet</li>
      </ol>
@stop

@section('content')
    <!-- Main content -->
    <section class="container-fluid">
       <!--.row-->
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-info">
                            <div class="panel-heading">Generate Balance Sheet</div>
                            <div class="panel-wrapper collapse in" aria-expanded="true">
                                <div class="panel-body">
                                      <form class="form-horizontal" method='post' action="{{route('report.balance-sheet.generate')}}">
                                        {{ csrf_field() }}
                                        <div class="form-body">
                                            <div class="row">

                                                @can('isSuperAdmin')
                                                @include('partial.multiproject_forsomereport')
                                                  @endcan
    
                                                <!--/span-->
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="form-group has-success" style="margin-bottom: 15px">
                                                      <label class="control-label">As Of</label>
                                                        <div class="input-group">
                                                          <div class="input-group-addon">
                                                            <i class="fa fa-calendar"></i>
                                                          </div>
                                                        <input type="date" class="form-control " placeholder="dd/mm/yyyy"  name='date'>
                                                        @if($errors->has('date_range'))
                                                            <span class="help-block" >
                                                                <strong>{{ $errors->first('date_range') }}</strong>
                                                            </span>
                                                        @endif

                                                      </div>
                                                         </div>
                                                </div>
                                                <!--/span-->
                                                <div class="clearfix"></div>

                                                <div class="col-md-6">
                                                    <div class="form-group has-success" style="margin-bottom: 15px">
                                                      <label class="control-label">Type</label>
                                                        <div class="input-group">
                                                          <div class="input-group-addon">
                                                            <i class="fa fa-calendar"></i>
                                                          </div>
                                                        <select class="form-control chosen-select" name="level">
                                                            <option value="1" selected=""> Level 1</option>
                                                            <option value="2"> Level 2</option>
                                                            <option value="3"> Level 3</option>
                                                            
                                                        </select>
                                                        @if($errors->has('level'))
                                                            <span class="help-block" >
                                                                <strong>{{ $errors->first('level') }}</strong>
                                                            </span>
                                                        @endif

                                                      </div>
                                                         </div>
                                                </div>
                                                <!--/span-->
                                            </div>
                                            
                                        </div>
                                        <div class="form-actions">
                                            <button type="submit" class="btn btn-success search-customer"> <i class="fa fa-check" ></i> Generate</button>
                                            </form>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!--./row-->
                @stop

    @section('js')
<script>
// Date Picker
    jQuery('.mydatepicker, #datepicker').datepicker();
    jQuery('#datepicker-autoclose').datepicker({
        autoclose: true,
        todayHighlight: true
    });
</script>
   @stop



