@extends('layouts.app')

@section('title')
Statement of Financial Position
@stop
@section('breadcrumb')
<ol class="breadcrumb pull-right no-print">
        <li><a href="{{route('home')}}"><i class="fa fa-dashboard"></i> Home</a></li>

        <li class="active">Balance Sheet</li>
      </ol>
@stop
@section('css')
<link href="{{asset('plugins/components/bootstrap-daterangepicker/daterangepicker.css')}}" rel="stylesheet">

<style type="text/css">
    .btm-margin{
        border-bottom: 1px solid white;
    }
    .bg-grey {
        background-color: #d9d9d9;
    }
    .bg-grey-light {
        background-color: #f6f6f6;
    }
    .bg-green {
        background-color: #ecf5eb;
    }
    
    .br-btm {
           border-bottom: 1px solid #e6e3e3;
    }
    .br-right {
         border-right: 1px solid #e6e3e3;
    }
    .txt-c {
        text-align: center;
    }

    @media print {
        .btm-margin{
        border-bottom: 3px solid white;
    }
    table.dataTable thead td, table.dataTable thead th {
    border-bottom: none;
    }
    .bg-grey {
        background-color: #b9b9b9;
    }
    .bg-green {
        background-color: #ecf5eb;
    }
    
    .br-btm {
           border-bottom: 1px solid #e6e3e3;
    }
    .br-right {
         border-right: 1px solid #e6e3e3;
    }
    .txt-c {
        text-align: center;
    }
    .white-box{
        border: none!important;
        padding: 0 3px 0 0px;
    }
     .dataTables_info{
        display: none;
    }
    .dataTables_filter{
        display: none;
    }
    div.dt-buttons{
        display: none;
    }

        .panel .panel-body{
        font-size: 12px !important;
        font-family: "time-new-roman",Arial,sans-serif;
        color: black !important
        }
      .box-title {
         background-color: none !important;
      }
      table.dataTable tbody td, table.dataTable tbody th {
    padding: 2px 4px;
    font-size: 12px;
    }
    table.dataTable{
        border:none;
    }
     h3 strong{
        text-transform: uppercase;
        color: black !important
    }
    h4 strong{
        text-transform: uppercase;
        color: black !important
    }
    h3{
        margin-bottom: -10px;
    }
    table.dataTable.no-footer {
    border-bottom: none !important;
    }
    .table>tbody>tr>td, .table>tbody>tr>th {
    font-size: 12px;
    }
    a{
        color: black !important
    }
    .page-wrapper {
    padding-top: 0px;
    }
    }
</style>

<!-- <link href="https://cdn.datatables.net/1.10.24/css/jquery.dataTables.min.css" rel="stylesheet"> -->
<link href="https://cdn.datatables.net/buttons/1.7.0/css/buttons.dataTables.min.css"  rel="stylesheet">
@stop
@section('content')

<div class="container-fluid">

    <div class="white-box  printableArea" >
        <div class="text-center">
        <h3><strong>@foreach($project_names as $key => $project_name)
            {{ $project_name }}
            @if($key < count($project_names) - 1)
                , 
            @endif
        @endforeach</strong></h5>
        <h4><strong>Statement of Financial Position</strong></h4>
        <h6>As of {{date('d/m/Y', strtotime($date))}}</h6>
        </div>
        <div class="row">
        

        <div class="col-md-12 pro-cart">
            <table id="example1" width="100%" cellpadding="3" cellspacing="3" >
                     <thead>
                        <th></th>
                        <th width="100"></th>
                     </thead>
                     <tbody>
                     <tr class="bg-grey">
                            <th class="pd-5"><b>ASSETS</b></th> 
                            <th></th>
                         </tr>
                         <tr class="bg-grey-light ">
                            <th class="pd-5"><b>CURRENT ASSETS</b></th> 
                            <th></th>
                         </tr>
                         <?php $asset = 0;$total = 0;?>

                         @foreach($currentAsset as $acc)
                         @if($acc['sum'] != 0)

                         <tr >
                            <td class="pd-5">{{$acc['account']->name}}</td> 
                            <td style="text-align:right;padding-right: 20px;"><a target="_blank" href="{{route('report.trial-balance-detail',['id'=>$acc['account']->id])}}">
                                @if($acc['sum'] < 0)
                                ({{number_format(abs($acc['sum']))}})
                                @else
                                {{$acc['sum'] > 0? number_format($acc['sum']) : '-'}}
                                @endif

                            </a></td>
                            <?php $total += $acc['sum'];?>
                         </tr>

                         @endif
                         @endforeach

                         

                         @foreach($bank as $acc)
                         @if($acc['sum'] != 0)

                         <tr >
                            <td class="pd-5"  >{{$acc['account']->name}}</td> 
                            <td style="text-align:right;padding-right: 20px;"><a target="_blank" href="{{route('report.trial-balance-detail',['id'=>$acc['account']->id])}}">@if($acc['sum'] < 0)
                                ({{number_format(abs($acc['sum']))}})
                                @else
                                {{$acc['sum'] > 0? number_format($acc['sum']) : '-'}}
                                @endif</a></td>
                            <?php $total += $acc['sum'];?>
                         </tr>
                         @endif
                         @endforeach

                         

                         @foreach($accountReceivable as $acc)
                         @if($acc['sum'] != 0)

                         <tr >
                            <td class="pd-5">{{$acc['account']->name}}</td> 
                            <td style="text-align:right;padding-right: 20px;"><a target="_blank" href="{{route('report.trial-balance-detail',['id'=>$acc['account']->id])}}">@if($acc['sum'] < 0)
                                ({{number_format(abs($acc['sum']))}})
                                @else
                                {{$acc['sum'] > 0? number_format($acc['sum']) : '-'}}
                                @endif</a></td>
                            <?php $total += $acc['sum'];?>
                         </tr>
                         @endif
                         @endforeach

                         

                         @foreach($otherCurrentAsset as $acc)
                         @if($acc['sum'] != 0)

                         <tr >
                            <td class="pd-5"  >{{$acc['account']->name}}</td> 
                            <td style="text-align:right;padding-right: 20px;"><a target="_blank" href="{{route('report.trial-balance-detail',['id'=>$acc['account']->id])}}">@if($acc['sum'] < 0)
                                ({{number_format(abs($acc['sum']))}})
                                @else
                                {{$acc['sum'] > 0? number_format($acc['sum']) : '-'}}
                                @endif</a></td>
                            <?php $total += $acc['sum'];?>
                         </tr>
                         @endif
                         @endforeach

                         
                         <?php $asset += $total;$total = 0;?>

                         <tr class="bg-green btm-margin">
                            <td class="pd-5"  ></td> 
                            <td style="border-top:1px solid;text-align:right;padding-right: 20px;"><b>@if($asset < 0)
                                ({{number_format(abs($asset))}})
                                @else
                                {{$asset > 0? number_format($asset) : '-'}}
                                @endif</b></td>
                            
                         </tr>

                         <tr class="bg-grey-light btm-margin">
                            <th class="pd-5"  ><b>NON CURRENT ASSETS</b></th> 
                            <th></th>
                         </tr>

                         @foreach($fixedAsset as $acc)
                         @if($acc['sum'] != 0)

                         <tr >
                            <td class="pd-5"  >{{$acc['account']->name}}</td> 
                            <td style="text-align:right;padding-right: 20px;"><a target="_blank" href="{{route('report.trial-balance-detail',['id'=>$acc['account']->id])}}">@if($acc['sum'] < 0)
                                ({{number_format(abs($acc['sum']))}})
                                @else
                                {{$acc['sum'] > 0? number_format($acc['sum']) : '-'}}
                                @endif</a></td>
                            <?php $total += $acc['sum'];?>
                         </tr>
                         @endif
                         @endforeach

                         

                         

                         <tr class="bg-green btm-margin">
                            <td class="pd-5"></td> 
                            <td style="border-top:1px solid;text-align:right;padding-right: 20px;"><b>@if($total < 0)
                                ({{number_format(abs($total))}})
                                @else
                                {{$total > 0? number_format($total) : '-'}}
                                @endif</b></td>
                            <?php $asset += $total;$total = 0;?>
                         </tr>



                          <tr class="bg-green btm-margin">
                            <td class="pd-5"><b>TOTAL ASSETS</b></td> 
                            <td style="border-top:1px solid;border-bottom: double;text-align:right;padding-right: 20px;"><strong>@if($asset < 0)
                                ({{number_format(abs($asset))}})
                                @else
                                {{$asset > 0? number_format($asset) : '-'}}
                                @endif</strong></td>
                            
                         </tr>


                         <tr class="bg-grey btm-margin">
                            <th class="pd-5"><b>EQUITY & LIABILITIES</b></th> 
                            <th></th>
                         </tr>

                         <tr class="bg-grey-light btm-margin">
                            <th class="pd-5"><b>EQUITY</b></th> 
                            <th></th>
                         </tr>

                         <?php $equities = 0;$total = 0;?>

                         @foreach($equity as $acc)
                         @if($acc['sum'] != 0)

                         <tr >
                            <td class="pd-5"  >{{$acc['account']->name}}</td> 
                            <td style="text-align:right;padding-right: 20px;"><a target="_blank" href="{{route('report.trial-balance-detail',['id'=>$acc['account']->id])}}">
                                @if($acc['sum'] > 0)
                                ({{number_format(abs($acc['sum']))}})
                                @else
                                {{number_format(abs($acc['sum']))}}
                                @endif
                            </a></td>
                            <?php $total += ($acc['sum'] * -1);?>
                         </tr>
                         @endif
                         @endforeach

                         <?php $equities +=$total;?>

                         <tr >
                            <td class="pd-5"><b>NET INCOME</b></td> 
                            @if($netIncome < 0)
                            <td style="text-align:right;padding-right: 20px;"><b>({{number_format(abs($netIncome))}})</b></td>
                            @else
                            <td style="text-align:right;padding-right: 20px;"><b> 
                                {{$netIncome > 0? number_format($netIncome) : '-'}}</b></td>
                            @endif
                        
                         </tr>

                         <?php $equities += $netIncome;?>

                          <tr class="bg-green btm-margin">
                            <td class="pd-5"><b></b></td>

                            @if($equities < 0) 
                            <td style="border-top:1px solid;text-align: right; padding-right: 20px;"><b>({{number_format(abs($equities))}})</b></td>
                            @else
                            <td style="border-top:1px solid;text-align:right;padding-right: 20px;"><b> {{$equities > 0? number_format($equities) : '-'}}</b></td>
                            @endif
                        
                         </tr>

                         <tr class="bg-grey-light btm-margin">
                            <th class="pd-5"><b>LIABILITIES</b></th> 
                            <th></th>
                         </tr>

                         <tr class="bg-grey-light btm-margin">
                            <th class="pd-5"><b>CURRENT LIABILITIES</b></th> 
                            <th></th>
                         </tr>

                         

                         <?php $liability = 0;$total = 0;?>

                         @foreach($accountPayable as $acc)
                         @if($acc['sum'] != 0)

                         <tr >
                            <td class="pd-5"  >{{$acc['account']->name}}</td> 
                            <td style="text-align:right;padding-right: 20px;"><a target="_blank" href="{{route('report.trial-balance-detail',['id'=>$acc['account']->id])}}">
                                @if($acc['sum'] > 0)
                                ({{number_format(abs($acc['sum']))}})
                                @else
                                {{number_format(abs($acc['sum']))}}
                                @endif
                            </a></td>
                            <?php $total += ($acc['sum'] * -1);?>
                         </tr>
                         @endif
                         @endforeach



                        

                         @foreach($otherCurrentLiability as $acc)
                         @if($acc['sum'] != 0)

                         <tr >
                            <td class="pd-5"  >{{$acc['account']->name}}</td> 
                            <td style="text-align:right;padding-right: 20px;"><a target="_blank" href="{{route('report.trial-balance-detail',['id'=>$acc['account']->id])}}">
                                @if($acc['sum'] > 0)
                                ({{number_format(abs($acc['sum']))}})
                                @else
                                {{number_format(abs($acc['sum']))}}
                                @endif
                            </a></td>
                            <?php $total += ($acc['sum'] * -1);?>
                         </tr>
                         @endif
                         @endforeach

                         <tr class=" btm-margin">
                            <td class="pd-5"></td> 
                            <td style="border-top:1px solid;text-align:right;padding-right: 20px;"><b>@if($total < 0)
                                ({{number_format(abs($total))}})
                                @else
                                {{$total > 0? number_format($total) : '-'}}
                                @endif</b></td>
                            <?php $liability += $total;$total = 0;?>
                         </tr>

                        

                         <tr class="bg-grey-light btm-margin">
                            <th class="pd-5"><b>NON CURRENT LIABILITIES</b></th> 
                            <th></th>
                         </tr>

                         @foreach($longTermLiability as $acc)
                         @if($acc['sum'] != 0)

                         <tr >
                            <td class="pd-5"  >{{$acc['account']->name}}</td> 
                            <td style="text-align:right;padding-right: 20px;"><a target="_blank" href="{{route('report.trial-balance-detail',['id'=>$acc['account']->id])}}">
                                @if($acc['sum'] > 0)
                                ({{number_format(abs($acc['sum']))}})
                                @else
                                {{number_format(abs($acc['sum']))}}
                                @endif
                            </a></td>
                            <?php $total += ($acc['sum'] * -1);?>
                         </tr>
                         @endif
                         @endforeach

                         <tr class=" btm-margin">
                            <td class="pd-5"></td> 
                            <td style="border-top:1px solid;text-align:right;padding-right: 20px;"><b>@if($total < 0)
                                ({{number_format(abs($total))}})
                                @else
                                {{$total > 0? number_format($total) : '-'}}
                                @endif</b></td>
                            <?php $liability += $total ;$total = 0;?>
                         </tr>


                         <tr class="bg-green btm-margin">
                            <td class="pd-5"></td> 
                            <td style="border-top:1px solid;text-align:right;padding-right: 20px;"><b>@if($liability < 0)
                                ({{number_format(abs($liability))}})
                                @else
                                {{$liability > 0? number_format($liability) : '-'}}
                                @endif</b></td>
                        
                         </tr>

                     

                         <tr class="bg-green btm-margin">
                            <td class="pd-5"><b>TOTAL EQUITY & LIABILITIES</b></td> 
                            <td style="border-top:1px solid;border-bottom: double;text-align:right;padding-right: 20px;"><strong>{{number_format($liability + $equities)}}</strong></td>
                            
                         </tr>

   

                 </tbody>
            </table>
            
           

        </div>
    </div>
    </div>
    <div class="text-right" style="height:70px">
    <button  class="btn btn-default btn-outline no-print" onclick="window.print();return false;" type="button"> <span><i class="fa fa-print"></i> Print</span> </button>                                    
    </div>
</div>



@stop

@section('js')

<script src="{{asset('js/jquery.PrintArea.js')}}" type="text/JavaScript"></script>

<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/dataTables.buttons.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
 <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
 <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.html5.min.js"></script>
  <script src="https://cdn.datatables.net/buttons/1.7.0/js/buttons.print.min.js"></script>

<script>

   $('#example1').DataTable( {
        sorting:false,
        paging:false,
        ordering:false,
        searching:false,
        dom: 'Bfrtip',
         buttons: [
            'copy', 'csv', 'excel', 'pdf', 'print'
        ]
        
    } );

    
     $("#print").on("click", function() {
            var mode = 'iframe'; //popup
            var close = mode == "popup";
            var options = {
                mode: mode,
                popClose: close
            };
            $("div.printableArea").printArea(options);
        });
    </script>
@stop

